#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <alarmd/alarm_event.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include "large-statusbar-clock-alarm.h"

#define ICON_FILE "/usr/share/pixmaps/large-statusbar-clock-alarm.png"

void alarm_dialog(GtkMenuItem *item, gpointer data)
{
  GtkWidget* dialog;
  GtkWidget* treeView;
  GtkListStore* store;
  GtkTreeIter treeIter;
  cookie_t *list,*iter;
  GtkTreeViewColumn *col;
  GtkCellRenderer *renderer;
  GtkWidget *scroll;
  time_t now;
  gint result;

  dialog=gtk_dialog_new_with_buttons("Large Statusbar Clock Alarms",NULL,GTK_DIALOG_MODAL,"Add alarm",1,"Remove alarm",2,"Close",0,NULL);
  gtk_dialog_set_has_separator(GTK_DIALOG(dialog),FALSE);
  
  store=gtk_list_store_new(3,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_INT);
  now = time(NULL);
  list = alarm_event_query(now, now + 60*60*24*7*4, 0, 0);
  if (list == NULL) {
	  hildon_banner_show_information(NULL,NULL,"alarm_event_query() failed");
  }

  else if (list[0] == (cookie_t) 0) {
	  hildon_banner_show_information(NULL,NULL,"no alarms set");
  } else {
	  for (iter = list; *iter != (cookie_t) 0; iter++) {
		  alarm_event_t* alarm=alarm_event_get(*iter);
		  gchar timeString[256];
		  struct tm *locTime;
		  if (g_strcasecmp(alarm->icon,ICON_FILE)==0)
		  {
		    gtk_list_store_append(store,&treeIter);
		    locTime=localtime(&alarm->alarm_time);
		    strftime(timeString,256,"%x %X",locTime);
		    gtk_list_store_set(store,&treeIter,0,alarm->message,1,timeString,2,(unsigned int)*iter,-1);
		  }
	  }
  }
  free(list);

  treeView=gtk_tree_view_new();
  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "Alarm");
  gtk_tree_view_append_column(GTK_TREE_VIEW(treeView), col);
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_column_pack_start(col,renderer,TRUE);
  gtk_tree_view_column_add_attribute(col,renderer, "text", 0);

  col = gtk_tree_view_column_new();
  gtk_tree_view_column_set_title(col, "Time");
  gtk_tree_view_append_column(GTK_TREE_VIEW(treeView), col);
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_column_pack_start(col,renderer,TRUE);
  gtk_tree_view_column_add_attribute(col,renderer, "text", 1);
  g_signal_connect(treeView,"row-activated",G_CALLBACK(edit_alarm),dialog);
  
  gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeView), TRUE);

  gtk_tree_view_set_model(GTK_TREE_VIEW(treeView), GTK_TREE_MODEL(store));
  scroll=gtk_scrolled_window_new(NULL,NULL);
  gtk_container_add(GTK_CONTAINER(scroll),treeView);

  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),scroll);
  gtk_widget_show_all(scroll);

  gtk_widget_set_size_request(treeView,400,200);
  
  result=gtk_dialog_run(GTK_DIALOG(dialog));

  if (result==1)
  {
    gtk_widget_destroy(dialog);
    add_alarm();
  }
  if (result==2)
  {
    if (gtk_tree_selection_get_selected(gtk_tree_view_get_selection(GTK_TREE_VIEW(treeView)),NULL,&treeIter))
    {
      guint temp;
      gtk_tree_model_get(GTK_TREE_MODEL(store),&treeIter,2,&temp,-1);
      if ((cookie_t)temp!=0)
      {
	  alarm_event_del((cookie_t)temp);
      }
    }
    gtk_widget_destroy(dialog);
    alarm_dialog(NULL,NULL);
  }
  if (result==0)
  {
    gtk_widget_destroy(dialog);
  }
  gtk_widget_destroy(dialog);
}

void add_alarm(void)
{
  cookie_t newAlarm;
  alarm_event_t newEvent;
  time_t now=time(&now);
  struct tm* locTime=localtime(&now);
  GtkWidget *dialog;
  GtkWidget *caption;
  GtkWidget *time,*repeat,*date,*description;
  GtkWidget *sound,*openSound;
  GtkWidget *vbox,*hbox;
  gint result;
  GtkSizeGroup* group = GTK_SIZE_GROUP(gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL));

  dialog=gtk_dialog_new_with_buttons("Add alarm",NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_ACCEPT,GTK_STOCK_CANCEL,GTK_RESPONSE_REJECT,NULL);

  vbox=gtk_vbox_new(FALSE,0);
  time=hildon_time_editor_new();
  caption=hildon_caption_new(group,"Time",time,NULL,HILDON_CAPTION_MANDATORY);
  gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);

  repeat=gtk_combo_box_new_text();
  gtk_combo_box_append_text(GTK_COMBO_BOX(repeat),"Once only");
  gtk_combo_box_append_text(GTK_COMBO_BOX(repeat),"Daily");
  gtk_combo_box_append_text(GTK_COMBO_BOX(repeat),"Weekly");
  gtk_combo_box_set_active(GTK_COMBO_BOX(repeat),0);
  caption=hildon_caption_new(group,"Repeat",repeat,NULL,HILDON_CAPTION_MANDATORY);
  gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);

  date=hildon_date_editor_new();
  caption=hildon_caption_new(group,"Date",date,NULL,HILDON_CAPTION_MANDATORY);
  gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);

  description=gtk_entry_new();
  caption=hildon_caption_new(group,"Description",description,NULL,HILDON_CAPTION_MANDATORY);
  gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);

  hbox=gtk_hbox_new(FALSE,0);
  sound=gtk_combo_box_new_text();
  gtk_combo_box_append_text(GTK_COMBO_BOX(sound),"Tone 1");
  gtk_combo_box_append_text(GTK_COMBO_BOX(sound),"Tone 2");
  gtk_combo_box_append_text(GTK_COMBO_BOX(sound),"Tone 3");
  gtk_combo_box_set_active(GTK_COMBO_BOX(sound),0);
  openSound=gtk_button_new_with_label("Open sound");
  gtk_box_pack_start(GTK_BOX(hbox),sound,FALSE,FALSE,0);
  /*gtk_box_pack_start(GTK_BOX(hbox),openSound,FALSE,FALSE,0);*/
  caption=hildon_caption_new(group,"Sound",hbox,NULL,HILDON_CAPTION_MANDATORY);
  gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);

  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),vbox);
  gtk_widget_show_all(vbox);

  result=gtk_dialog_run(GTK_DIALOG(dialog));

  if (result==GTK_RESPONSE_ACCEPT)
  {
    guint h,m,s;
    guint year,month,day;
    gint index;
    hildon_time_editor_get_time(HILDON_TIME_EDITOR(time),&h,&m,&s);
    hildon_date_editor_get_date(HILDON_DATE_EDITOR(date),&year,&month,&day);
    memset(&newEvent,0,sizeof(alarm_event_t));
  
    locTime->tm_year=year-1900;
    locTime->tm_mon=month-1;
    locTime->tm_mday=day;
    locTime->tm_hour=h;
    locTime->tm_min=m;
    locTime->tm_sec=s;
    locTime->tm_isdst=-1;
    newEvent.alarm_time=mktime(locTime);

    index=gtk_combo_box_get_active(GTK_COMBO_BOX(repeat));
    switch (index)
    {
      case 0: newEvent.recurrence=0;
	  break;
      case 1: newEvent.recurrence=24*60;
	  break;
      case 2: newEvent.recurrence=7*24*60;
	  break;
    }
    newEvent.recurrence_count=-1;
    newEvent.snooze=6;
    newEvent.title="Large Statusbar Clock Alarm";
    newEvent.message=gtk_entry_get_text(GTK_ENTRY(description));
    index=gtk_combo_box_get_active(GTK_COMBO_BOX(sound));
    switch (index)
    {
      case 0: newEvent.sound="/usr/share/sounds/ui-clock_alarm.mp3";
	  break;
      case 1: newEvent.sound="/usr/share/sounds/ui-clock_alarm2.mp3";
	  break;
      case 2: newEvent.sound="/usr/share/sounds/ui-clock_alarm3.mp3";
	  break;
    }
    newEvent.icon=ICON_FILE;
    newEvent.dbus_interface=NULL;
    newEvent.dbus_service=NULL;
    newEvent.dbus_path=NULL;
    newEvent.dbus_name=NULL;
    newEvent.exec_name=NULL;
    newEvent.flags=(ALARM_EVENT_BOOT|ALARM_EVENT_RUN_DELAYED);
    
    newAlarm=alarm_event_add(&newEvent);
  
    if (newAlarm==0)
    {
      hildon_banner_show_information(NULL,NULL,"Error setting alarm event.");
    }
    else
    {
      hildon_banner_show_information(NULL,NULL,"Alarm set successfully.");
    }
  }
  gtk_widget_destroy(dialog);
  alarm_dialog(NULL,NULL);
}

void edit_alarm(GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data)
{
  GtkTreeModel* model;
  GtkTreeIter iter;
  cookie_t curAlarm;
  alarm_event_t *curEvent,newEvent;
  time_t now=time(&now);
  struct tm* locTime=localtime(&now);
  GtkWidget *dialog;
  GtkWidget *caption;
  GtkWidget *time,*repeat,*date,*description;
  GtkWidget *sound,*openSound;
  GtkWidget *vbox,*hbox;
  gint result;
  GtkSizeGroup* group = GTK_SIZE_GROUP(gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL));

  model=gtk_tree_view_get_model(tree_view);
  gtk_tree_model_get_iter(model,&iter,path);
  gtk_tree_model_get(model,&iter,2,(cookie_t)&curAlarm,-1);

  curEvent=alarm_event_get(curAlarm);
  if (curEvent!=0)
    {
  
    dialog=gtk_dialog_new_with_buttons("Edit alarm",NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_ACCEPT,GTK_STOCK_CANCEL,GTK_RESPONSE_REJECT,NULL);
  
    vbox=gtk_vbox_new(FALSE,0);
    time=hildon_time_editor_new();
    caption=hildon_caption_new(group,"Time",time,NULL,HILDON_CAPTION_MANDATORY);
    now=curEvent->alarm_time;
    locTime=localtime(&now);
    hildon_time_editor_set_time(HILDON_TIME_EDITOR(time),locTime->tm_hour,locTime->tm_min,locTime->tm_sec);
    gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);
  
    repeat=gtk_combo_box_new_text();
    gtk_combo_box_append_text(GTK_COMBO_BOX(repeat),"Once only");
    gtk_combo_box_append_text(GTK_COMBO_BOX(repeat),"Daily");
    gtk_combo_box_append_text(GTK_COMBO_BOX(repeat),"Weekly");
    if (curEvent->recurrence==0)
      gtk_combo_box_set_active(GTK_COMBO_BOX(repeat),0);
    else if (curEvent->recurrence==24*60)
      gtk_combo_box_set_active(GTK_COMBO_BOX(repeat),1);
    else if (curEvent->recurrence==7*24*60)
      gtk_combo_box_set_active(GTK_COMBO_BOX(repeat),2);
    caption=hildon_caption_new(group,"Repeat",repeat,NULL,HILDON_CAPTION_MANDATORY);
    gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);
  
    date=hildon_date_editor_new();
    caption=hildon_caption_new(group,"Date",date,NULL,HILDON_CAPTION_MANDATORY);
    hildon_date_editor_set_date(HILDON_DATE_EDITOR(date),locTime->tm_year+1900,locTime->tm_mon+1,locTime->tm_mday);
    gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);
  
    description=gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(description),curEvent->message);
    caption=hildon_caption_new(group,"Description",description,NULL,HILDON_CAPTION_MANDATORY);
    gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);
  
    hbox=gtk_hbox_new(FALSE,0);
    sound=gtk_combo_box_new_text();
    gtk_combo_box_append_text(GTK_COMBO_BOX(sound),"Tone 1");
    gtk_combo_box_append_text(GTK_COMBO_BOX(sound),"Tone 2");
    gtk_combo_box_append_text(GTK_COMBO_BOX(sound),"Tone 3");
    if (g_strcasecmp(curEvent->sound,"/usr/share/sounds/ui-clock_alarm.mp3")==0)
    {
      gtk_combo_box_set_active(GTK_COMBO_BOX(sound),0);
    }
    else if (g_strcasecmp(curEvent->sound,"/usr/share/sounds/ui-clock_alarm2.mp3")==0)
    {
      gtk_combo_box_set_active(GTK_COMBO_BOX(sound),1);
    }
    else if (g_strcasecmp(curEvent->sound,"/usr/share/sounds/ui-clock_alarm3.mp3")==0)
    {
      gtk_combo_box_set_active(GTK_COMBO_BOX(sound),2);
    }
    openSound=gtk_button_new_with_label("Open sound");
    gtk_box_pack_start(GTK_BOX(hbox),sound,FALSE,FALSE,0);
    /*gtk_box_pack_start(GTK_BOX(hbox),openSound,FALSE,FALSE,0);*/
    caption=hildon_caption_new(group,"Sound",hbox,NULL,HILDON_CAPTION_MANDATORY);
    gtk_box_pack_start(GTK_BOX(vbox),caption,FALSE,FALSE,0);
  
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),vbox);
    gtk_widget_show_all(vbox);
  
    result=gtk_dialog_run(GTK_DIALOG(dialog));
  
    if (result==GTK_RESPONSE_ACCEPT)
    {
      cookie_t newAlarm;
      guint h,m,s;
      guint year,month,day;
      gint index;
      hildon_time_editor_get_time(HILDON_TIME_EDITOR(time),&h,&m,&s);
      hildon_date_editor_get_date(HILDON_DATE_EDITOR(date),&year,&month,&day);
      memset(&newEvent,0,sizeof(alarm_event_t));
    
      locTime->tm_year=year-1900;
      locTime->tm_mon=month-1;
      locTime->tm_mday=day;
      locTime->tm_hour=h;
      locTime->tm_min=m;
      locTime->tm_sec=s;
      locTime->tm_isdst=-1;
      newEvent.alarm_time=mktime(locTime);
  
      index=gtk_combo_box_get_active(GTK_COMBO_BOX(repeat));
      switch (index)
      {
	case 0: newEvent.recurrence=0;
	    break;
	case 1: newEvent.recurrence=24*60;
	    break;
	case 2: newEvent.recurrence=7*24*60;
	    break;
      }
      newEvent.recurrence_count=-1;
      newEvent.snooze=6;
      newEvent.title="Large Statusbar Clock Alarm";
      newEvent.message=gtk_entry_get_text(GTK_ENTRY(description));
      index=gtk_combo_box_get_active(GTK_COMBO_BOX(sound));
      switch (index)
      {
	case 0: newEvent.sound="/usr/share/sounds/ui-clock_alarm.mp3";
	    break;
	case 1: newEvent.sound="/usr/share/sounds/ui-clock_alarm2.mp3";
	    break;
	case 2: newEvent.sound="/usr/share/sounds/ui-clock_alarm3.mp3";
	    break;
      }
      newEvent.icon=ICON_FILE;
      newEvent.dbus_interface=NULL;
      newEvent.dbus_service=NULL;
      newEvent.dbus_path=NULL;
      newEvent.dbus_name=NULL;
      newEvent.exec_name=NULL;
      newEvent.flags=(ALARM_EVENT_BOOT|ALARM_EVENT_RUN_DELAYED);
      
      newAlarm=alarm_event_add(&newEvent);
    
      if (newAlarm==0)
      {
	hildon_banner_show_information(NULL,NULL,"Error setting alarm event.");
      }
      else
      {
	hildon_banner_show_information(NULL,NULL,"Alarm set successfully.");
	alarm_event_del(curAlarm);
	row_changed(tree_view);
      }
    }
    gtk_widget_destroy(dialog);
  }
} 

void row_changed(GtkTreeView *tree_view)
{
  GtkTreeModel *model=gtk_tree_view_get_model(tree_view);
  cookie_t *list,*alarmIter;
  GtkTreeIter treeIter;
  time_t now;
  gtk_tree_view_set_model(tree_view,NULL);
  gtk_list_store_clear(GTK_LIST_STORE(model));
  now = time(NULL);
  list = alarm_event_query(now, now + 60*60*24*7*4, 0, 0);
  if (list == NULL) {
	  hildon_banner_show_information(NULL,NULL,"alarm_event_query() failed");
  }

  else if (list[0] == (cookie_t) 0) {
	  hildon_banner_show_information(NULL,NULL,"no alarms set");
  } else {
	  for (alarmIter = list; *alarmIter != (cookie_t) 0; alarmIter++) {
		  alarm_event_t* alarm=alarm_event_get(*alarmIter);
		  gchar timeString[256];
		  struct tm *locTime;
		  if (g_strcasecmp(alarm->icon,ICON_FILE)==0)
		  {
		    gtk_list_store_append(GTK_LIST_STORE(model),&treeIter);
		    locTime=localtime(&alarm->alarm_time);
		    strftime(timeString,256,"%x %X",locTime);
		    gtk_list_store_set(GTK_LIST_STORE(model),&treeIter,0,alarm->message,1,timeString,2,(unsigned int)*alarmIter,-1);
		  }
	  }
  }
  free(list);
  gtk_tree_view_set_model(tree_view,model);
}
