/*
 * Copyright (C) 2008 Andrew Olmsted, all rights reserved.
 *
 * Contact: Andrew Olmsted <andrew.olmsted@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <libosso.h>

#include <hildon/hildon.h>
#include <libhildondesktop/libhildondesktop.h>
#include <stdio.h>
#include <string.h>

#include "large-statusbar-clock-hours.h"

/*HD_DEFINE_PLUGIN (LargeStatusbarClockHoursPlugin, large_statusbar_clock_hours_plugin, STATUSBAR_TYPE_ITEM);*/

/* Hildon Status Bar plugin API prototypes */
void *large_statusbar_clock_hours_initialize(HildonStatusBarItem *item, GtkWidget **button);
void large_statusbar_clock_hours_entry(HildonStatusBarPluginFn_st *fn);
void large_statusbar_clock_hours_destroy(void *data);
gint large_statusbar_clock_hours_get_priority(void *data);
void large_statusbar_clock_hours_update(void *data, gint value1, gint value2, const gchar *str);

void hours_button_clicked(GtkButton *button, gpointer data);
gboolean update_hours(gpointer data);
gint dbus_req_handler(const gchar* interface, const gchar* method, GArray* arguments, gpointer data, osso_rpc_t* retval);

void *large_statusbar_clock_hours_initialize(HildonStatusBarItem *item, GtkWidget **button)
{
      osso_return_t result;

      LargeStatusbarClockHoursPlugin *statusbar_plugin=g_new0(LargeStatusbarClockHoursPlugin,1);

      statusbar_plugin->sbitem=item;
      statusbar_plugin->hoursLabel=gtk_label_new("");
      statusbar_plugin->button=gtk_button_new();
      /*gtk_misc_set_padding(GTK_MISC(GTK_BIN(button)->child),0,0);*/

      gtk_container_add(GTK_CONTAINER(statusbar_plugin->button),statusbar_plugin->hoursLabel);
      /*gtk_container_add(GTK_CONTAINER(statusbar_plugin), button);*/
      gtk_misc_set_alignment(GTK_MISC(statusbar_plugin->hoursLabel),1.0,0.5);
      /*gtk_widget_show_all(GTK_WIDGET(statusbar_plugin));*/
      *button=statusbar_plugin->button;

      statusbar_plugin->osso=osso_initialize("large_statusbar_clock_hours","0.7",TRUE,NULL);
      result=osso_rpc_set_default_cb_f(statusbar_plugin->osso,dbus_req_handler,statusbar_plugin);

      g_signal_connect(statusbar_plugin->button,"clicked",G_CALLBACK(hours_button_clicked),statusbar_plugin);

      result = osso_rpc_async_run(statusbar_plugin->osso,
				"com.nokia.large_statusbar_clock_minutes",
				"/com/nokia/large_statusbar_clock_minutes",
				"com.nokia.large_statusbar_clock_minutes",
				"large_statusbar_hours", NULL, NULL,
				      DBUS_TYPE_STRING,"initial reading",
				DBUS_TYPE_INVALID);
      if (result != OSSO_OK) {
	      printf("ERROR!\n");
      }  
  return statusbar_plugin;
}

void large_statusbar_clock_hours_entry(HildonStatusBarPluginFn_st *fn)
{
    fn->initialize   = large_statusbar_clock_hours_initialize;
    fn->update       = large_statusbar_clock_hours_update;
    fn->destroy      = large_statusbar_clock_hours_destroy;
    fn->get_priority = large_statusbar_clock_hours_get_priority;
}

//void Large_statusbar_clock_hoursApplet_entry(HildonStatusBarPluginFn_st *fn)
//{
	//large_statusbar_clock_hours_entry(fn);
//}

void large_statusbar_clock_hours_destroy(void *data)
{
      LargeStatusbarClockHoursPlugin *statusbar_plugin=(LargeStatusbarClockHoursPlugin*)data;
      
      g_free(statusbar_plugin);
}

void large_statusbar_clock_hours_update(void *data, gint value1, gint value2, const gchar *str)
{
    LargeStatusbarClockHoursPlugin *statusbar_plugin=(LargeStatusbarClockHoursPlugin*)data;

    if (value1 == 0)
	gtk_widget_destroy(GTK_WIDGET(statusbar_plugin->sbitem));

}

gint large_statusbar_clock_hours_get_priority(void *data)
{
    return 42;
}

gboolean update_hours(gpointer data)
{
  LargeStatusbarClockHoursPlugin *statusbar_plugin=(LargeStatusbarClockHoursPlugin*)data;
  
  time_t curTime;
  struct tm *locTime;
  gchar timeString[32];

  curTime=time(NULL);
  locTime=localtime(&curTime);

  if (statusbar_plugin->ampm)
  {
    if (statusbar_plugin->stacked)
    {
      strftime(timeString,32,"<span size='x-large'>%l</span>",locTime);
    }
    else
    {
      strftime(timeString,4,"%l:",locTime);
    }
  }
  else
  {
    strftime(timeString,28,"%H:",locTime);
  }

  gtk_label_set_markup(GTK_LABEL(statusbar_plugin->hoursLabel),g_strconcat("<span foreground='#",statusbar_plugin->fontColour,"' font-desc='",statusbar_plugin->fontDesc,"'>",timeString,"</span>",NULL));

  return TRUE;
}

void hours_button_clicked(GtkButton *button, gpointer data)
{
	  LargeStatusbarClockHoursPlugin* statusbar_plugin=(LargeStatusbarClockHoursPlugin*)data;
        osso_return_t ret;
        ret = osso_rpc_async_run(statusbar_plugin->osso,
                                 "com.nokia.large_statusbar_clock_minutes",
                                 "/com/nokia/large_statusbar_clock_minutes",
                                 "com.nokia.large_statusbar_clock_minutes",
                                 "large_statusbar_hours", NULL, NULL,
					DBUS_TYPE_STRING,"popup menu",
                                 DBUS_TYPE_INVALID);
        if (ret != OSSO_OK) {
                printf("ERROR!\n");
        }  
}

gint dbus_req_handler(const gchar* interface, const gchar* method, GArray* arguments, gpointer data, osso_rpc_t* retval)
{
  osso_rpc_t val;
  LargeStatusbarClockHoursPlugin *info=(LargeStatusbarClockHoursPlugin*)data;
  val=g_array_index(arguments,osso_rpc_t,0);
  if (DBUS_TYPE_STRING==val.type)
  {
    info->fontDesc=g_strdup(val.value.s);
  }
  val=g_array_index(arguments,osso_rpc_t,1);
  if (DBUS_TYPE_STRING==val.type)
  {
    info->fontColour=g_strdup(val.value.s);
  }
  val=g_array_index(arguments,osso_rpc_t,2);
  if (DBUS_TYPE_BOOLEAN==val.type)
  {
    info->ampm=val.value.b;
  }
  val=g_array_index(arguments,osso_rpc_t,3);
  if (DBUS_TYPE_BOOLEAN==val.type)
  {
    info->stacked=val.value.b;
  }

  update_hours(info);
/*  osso_rpc_retval_free(val);*/

  return OSSO_OK;
}
