/*
 * Copyright (C) 2008 Andrew Olmsted, all rights reserved.
 *
 * Contact: Andrew Olmsted <andrew.olmsted@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef LARGE_STATUSBAR_CLOCK_MINUTES_H
#define LARGE_STATUSBAR_CLOCK_MINUTES_H

#include <glib-object.h>

/* For Status Bar plugins */
#include <libhildondesktop/hildon-status-bar-item.h>

G_BEGIN_DECLS

/* Common struct types declarations */
typedef struct _LargeStatusbarClockMinutesPlugin LargeStatusbarClockMinutesPlugin;
typedef struct _LargeStatusbarClockMinutesPluginClass LargeStatusbarClockMinutesPluginClass;
typedef struct _LargeStatusbarClockMinutesPluginPrivate LargeStatusbarClockMinutesPluginPrivate;

/* Common macros */
#define TYPE_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN            (large_statusbar_clock_minutes_plugin_get_type ())
#define LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN, LargeStatusbarClockMinutesPlugin))
#define LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  TYPE_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN, LargeStatusbarClockMinutesPluginClass))
#define IS_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN))
#define IS_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  TYPE_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN))
#define LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  TYPE_LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN, LargeStatusbarClockMinutesPluginClass))

/* Instance struct */
struct _LargeStatusbarClockMinutesPlugin
{
	  HildonStatusBarItem* sbitem;
	  GtkWidget* minutesLabel;
	  GtkWidget* button;
	  guint eventID;
	  gboolean ampm;
	  gboolean stacked;
	  gboolean updated;
	  gboolean alarms;
	  GtkWidget* minutesMenu;
	  gchar* fontDesc;
	  gchar* fontColour;
	  gchar* curColour;
	  gchar* alarm1Colour;
	  gchar* alarm2Colour;
	  gint alarm1Time;
	  gint alarm2Time;
	  osso_context_t* osso;
	  gint previous;
};

/* Class struct */
struct _LargeStatusbarClockMinutesPluginClass
{
	  StatusbarItemClass parent_class;
};

GType  large_statusbar_clock_minutes_plugin_get_type  (void);

G_END_DECLS

#endif /* LARGE_STATUSBAR_CLOCK_MINUTES_PLUGIN_H */
