using Gtk;
 
public class SeekingBar : DrawingArea {
    Gdk.Pixbuf image;
    double position;
    
    public SeekingBar () {
    	this.position = 0;
    	this.image = new Gtk.Image.from_file("progress.gif").get_pixbuf();
        // Enable the events you wish to get notified about.
        // The 'expose' event is already enabled by the DrawingArea.
        add_events (Gdk.EventMask.BUTTON_PRESS_MASK
                  | Gdk.EventMask.BUTTON_RELEASE_MASK
                  | Gdk.EventMask.POINTER_MOTION_MASK);
 
        // Set favored widget size
	//change_background_color(this, "#00000");
    }
 
    /* Widget is asked to draw itself */
    public override bool expose_event (Gdk.EventExpose event) {
    	validate_looks();
        return false;
    }
    
    public void validate_looks()
    {
    	print("x:%i,y:%i,w:%i,h:%i\n", this.allocation.x, this.allocation.y, this.allocation.width, this.allocation.height);
    	//this.get_parent_window().draw_pixbuf(style.fg_gc[1], image, 0, 0, 0, 0, 50, 35, Gdk.RgbDither.NONE, 0, 0);
	this.get_parent_window().draw_rectangle (style.bg_gc[0], true, 2, this.allocation.y + 2, 100, 33);
    }
    
	public void change_background_color(Widget widget, string col)
	{
		Gdk.Color color;
		Gdk.Color.parse(col, out color);
		widget.modify_bg (Gtk.StateType.NORMAL, color);
		widget.modify_bg (Gtk.StateType.SELECTED, color);
		widget.modify_bg (Gtk.StateType.ACTIVE, color);
		widget.modify_base (Gtk.StateType.NORMAL, color);
		widget.modify_base (Gtk.StateType.SELECTED, color);
		widget.modify_base (Gtk.StateType.ACTIVE, color);
	}
 
    /* Mouse button got pressed over widget */
    public override bool button_press_event (Gdk.EventButton event) {
    	print("PRESS\n");
        // ...
        return false;
    }
 
    /* Mouse button got released */
    public override bool button_release_event (Gdk.EventButton event) {
    	print("RELEASE\n");
        // ...
        return false;
    }
 
    /* Mouse pointer moved over widget */
    public override bool motion_notify_event (Gdk.EventMotion event) {
    	this.position = event.x / (double)this.allocation.width;
	validate_looks();
        // ...
        return false;
    }
}
