using GLib;
using Gtk;

public class Scroller : Gtk.ScrolledWindow
{
	Viewport scroll;
	Gtk.Container container;
	private bool clicking;
	private bool autoscrolling;
	private GLib.TimeVal firsttime;
	private GLib.TimeVal oldtime;
	private EventBox eb;
	private double offsetx;
	private double offsety;
	private bool directionpageleft;
	private bool directionpageup;
	private bool moved;
	private bool vertical_scroll;
	private bool horizontal_scroll;
	private int drag_start_x;
	private int drag_start_y;
	private int drag_now_x;
	private int drag_now_y;
	
	construct {
		vertical_scroll = true;
		horizontal_scroll = true;
	}
	
	public Scroller(Gtk.Container container)
	{
		EventBox eb = new EventBox();
		change_background_color(eb, "#000");
		eb.add(container);
		this.container = container;
		this.clicking = false;
		set_policy (PolicyType.NEVER, PolicyType.NEVER);
		scroll = new Gtk.Viewport(null, null);
		scroll.add(eb);
		this.add(scroll);
		eb.motion_notify_event += (widget, event) => {
			scroll_motion(widget, event);
		};
		eb.button_press_event += (widget, event) => {
			scroll_pressed(widget, event);
		};
		eb.button_release_event += (widget, event) => {
			scroll_released(widget, event);
		};
		this.change_background_color(this, "#000000");
		this.change_background_color(scroll, "#000000");
	}
	
	public void set_scroll_policy(bool h, bool v)
	{
		horizontal_scroll = h;
		vertical_scroll = v;
	}
	
	public void change_background_color(Widget widget, string col)
	{
		Gdk.Color color;
		Gdk.Color.parse(col, out color);
		widget.modify_bg (Gtk.StateType.NORMAL, color);
		widget.modify_base (Gtk.StateType.NORMAL, color);
		
	}
	
	public bool window_scrolled()
	{
		return moved;
	}
	
	public EventBox get_scrollbar()
	{
		return eb;
	}
	
	public Gtk.Container get_container()
	{
		return container;
	}
	
	bool auto_scrolling() {
		double effect, effectx, effecty;
		long microseconds = 0;
		var newtime = TimeVal();
		
		newtime.get_current_time();
		if ((newtime.tv_sec - oldtime.tv_sec) > 0) {
			microseconds = 1000000 * (newtime.tv_sec - oldtime.tv_sec);
		}
		microseconds += (newtime.tv_usec - oldtime.tv_usec);

		effect = microseconds / 1000000.0;
		effect = GLib.Math.pow(effect, 2.0);
		effect = effect * -1.0;
		effect = GLib.Math.pow(GLib.Math.E, effect);
		effectx = effect * offsetx;
		effecty = effect * offsety;
		
		if (autoscrolling && effect > 0.05) {
			int can_move_up = (int)this.vadjustment.value;
			int can_move_down = (int)(this.vadjustment.upper - this.vadjustment.value - this.vadjustment.page_size);
			int can_move_left = (int)this.hadjustment.value;
			int can_move_right = (int)(this.hadjustment.upper - this.hadjustment.value - this.hadjustment.page_size);
			if (horizontal_scroll)
			{
				if (directionpageleft)
				{
					if (effectx > can_move_left)
						effectx = can_move_left;
					this.hadjustment.value -= effecty;
				}
				else {
					if (effectx > can_move_right)
						effectx = can_move_right;
					this.hadjustment.value += effectx;
				}
			}
			if (vertical_scroll)
			{
				if (directionpageup)
				{
					if (effecty > can_move_up)
						effecty = can_move_up;
					this.vadjustment.value -= effecty;
					if (this.vadjustment.value <= 0)
					{
						this.vadjustment.value = 0;
						return false;
					}
				}
				else {
					if (effecty > can_move_down)
						effectx = can_move_down;
					this.vadjustment.value += effecty;
					if (this.vadjustment.upper - this.vadjustment.value - this.vadjustment.page_size < 0)
					{
						this.vadjustment.value = this.vadjustment.upper - this.vadjustment.page_size;
						return false;
					}
				}
			}
			
			return true;
		}
		autoscrolling = false;
		return false;
	}

	bool scroll_released (Widget w, Gdk.EventButton ev)
	{
		if (!vertical_scroll && !horizontal_scroll)
			return false;
		this.clicking = false;
		var newtime = TimeVal();
		int x, y;
		this.get_pointer(out x, out y);
		newtime.get_current_time();
		if (!moved && !autoscrolling)
		{
			x += (int)this.hadjustment.value;
			y += (int)this.vadjustment.value;
			click_on(x, y, newtime);
			return false;
			
		}
		else
		if ((newtime.tv_sec - firsttime.tv_sec) < 0.4 && ((ev.x > offsetx + 15 || ev.x < offsetx - 15) || (ev.y > offsety + 15 || ev.y < offsety - 15))) {
			int new_x, new_y;	
			this.get_pointer(out new_x, out new_y);
			if (horizontal_scroll)
			{
				offsetx = drag_start_x - new_x;
				offsetx /= 2;
			}
			else
				offsetx = 0;
			if (vertical_scroll)
			{
				offsety = drag_start_y - new_y;
				offsety /= 2;
			}
			else
				offsety = 0;
			if (offsetx != 0 || offsety != 0)
			{
				autoscrolling = true;
				GLib.Timeout.add (1000/18, auto_scrolling);
			}
		}
		this.queue_draw();
		return false;
	}
	
	public void click_on(int x, int y, GLib.TimeVal newtime)
	{
		var children = this.container.get_children();
		foreach (Widget child in children) {
			Gtk.Allocation al = child.allocation;
			if (x >= al.x && x <= al.x + al.width)
			{
				if (y >= al.y && y <= al.y + al.height)
				{
					if (child is Item)
					{
						((Item)child).item_selected(null, newtime.tv_sec - firsttime.tv_sec);
						return;
					}
				}
			}
		}
	}
	
	bool check_wait() { 
		var newtime = TimeVal();
		newtime.get_current_time();

		if (!(this.clicking))
			return false;

		if ((newtime.tv_sec - oldtime.tv_sec) > 0.05) {
			int new_x, new_y;	
			this.get_pointer(out new_x, out new_y);
			if (horizontal_scroll)
			{
				offsetx = drag_start_x - new_x;
				offsetx /= 2;
			}
			else
				offsetx = 0;
			if (vertical_scroll)
			{
				offsety = drag_start_y - new_y;
				offsety /= 2;
			}
			else
				offsety = 0;
			oldtime.get_current_time();

			return true;
		}

		return true;
	}
	
	bool scroll_pressed (Widget w, Gdk.EventButton ev) {
		if (!vertical_scroll && !horizontal_scroll)
			return false;
		this.moved = false;
		this.get_pointer(out drag_start_x, out drag_start_y);
		this.drag_now_x = this.drag_start_x;
		this.drag_now_y = this.drag_start_y;
		if (autoscrolling) autoscrolling = false;
		firsttime.get_current_time();
		oldtime.get_current_time();
		this.clicking = true;
		GLib.Timeout.add (1000/50, check_wait);
		return false;
	}
	
	bool scroll_motion (Widget w, Gdk.EventMotion ev) {
		if (!vertical_scroll && !horizontal_scroll)
			return false;
		double aux_x, aux_y;
		var newtime = TimeVal();
			
		if (clicking) {
			newtime.get_current_time();
			int new_x, new_y;
			this.get_pointer(out new_x, out new_y);
			aux_x = drag_now_x - new_x;
			aux_y = drag_now_y - new_y;
			int can_move_up = (int)this.vadjustment.value;
			int can_move_down = (int)(this.vadjustment.upper - this.vadjustment.value - this.vadjustment.page_size);
			int can_move_left = (int)this.hadjustment.value;
			int can_move_right = (int)(this.hadjustment.upper - this.hadjustment.value - this.hadjustment.page_size);
			if ((newtime.tv_sec - oldtime.tv_sec) < 0.003) {
				if (aux_x < 0)
					directionpageleft = true;
				else
					directionpageleft = false;
				if (aux_y < 0)
					directionpageup = true;
				else
					directionpageup = false;
			}
			if (aux_x > 0)
				aux_x = aux_x < can_move_left ? aux_x : can_move_left;
			else
				aux_x = 0 - aux_x < can_move_right ? aux_x : 0 - can_move_right;
			if (aux_y > 0)
				aux_y = aux_y < can_move_down ? aux_y : can_move_down;
			else
				aux_y = 0 - aux_y < can_move_up ? aux_y : 0 - can_move_up;
			this.hadjustment.value += aux_x;
			this.vadjustment.value += aux_y;
			drag_now_x = new_x;
			drag_now_y = new_y;
			if (drag_start_x - drag_now_x < -15 || drag_start_x - drag_now_x > 15 || drag_start_y - drag_now_y < -15 || drag_start_y - drag_now_y > 15)
			{
				this.moved = true;
			}
		}
		return true;
	}
	
	public void scroll_up()
	{
		double value = this.vadjustment.page_increment;
		if (this.vadjustment.value - value < 0)
			value = this.vadjustment.value;
		this.vadjustment.value -= value;
	}
	
	public void scroll_down()
	{
		double value = this.vadjustment.page_increment;
		if (this.vadjustment.value + this.allocation.height + value > this.vadjustment.upper)
			value = this.vadjustment.upper - this.allocation.height - this.vadjustment.value;
		this.vadjustment.value += value; 
	}
	
	public void scroll_to_top()
	{
		this.vadjustment.value = 0;
		this.hadjustment.value = 0;
	}
	
}
