using GLib;
using Gtk;
using Hildon;
using Gdk;
using Xml;
using GConf;
using DBus;
using Osso;
using ConIc;

public class Knots : Hildon.Program {
	
	Common common;
	Settings settings;
        Hildon.Window window;
	bool fullscreen;
	Discovery discovery;
	public Osso.Context context;
	Notebook nb;
	public int ORIENTATION = -1;
	public int LANDSCAPE = 0;
	public int PORTRAIT = 1;
	private string version = "0.1";
	public static bool visible;
	public static bool topmost;
	private int rotation;
	private AboutDialog about;
	private bool updating_collection;
	ConIc.Connection con;
	private bool connected;
	
	static int main (string[] args)
	{
                Gtk.init (ref args);
                Knots knots = new Knots ();
                knots.run();
                return 0;
        }
	
        public void run()
	{
		this.topmost = true;
		settings = new Settings();
		context = new Osso.Context("com.nokia.knots2", version, false, null);
		discovery = new Discovery(this);
		common = new Common();
		fullscreen = false;
                window = new Hildon.Window ();
                add_window (window);
                Environment.set_application_name ("Knots");
		window.key_release_event += (widget, event) => {
			key_event(widget, event);
		};
		create_layout();
		create_menu();
		toggle_fullscreen();
		window.check_resize += check_orientation;
		window.focus_in_event += do_focus_check;
		window.focus_out_event += do_focus_check;
		//window.window_state_event += do_window_state;
		//window.state_changed += do_state_changed;
		context.set_hw_display_event_callback(display_event, this);
		window.show_all ();
		get_browser().get_toolbar_button(5).hide();
		get_browser().get_toolbar().hide();
		window.destroy += clean_up;
		con = new ConIc.Connection();
		connect_server();
                Gtk.main ();
        }
	
	public ConIc.Connection get_conic()
	{
		return con;
	}
	
	public void create_layout()
	{
		nb = new Notebook();
		nb.show_border = false;
		nb.show_tabs = false;
		Browser browser = new Browser();
		browser.init(this);
		Info info = new Info();
		info.init(this);
		Player player = new Player();
		player.init(this);
		Playlist playlist = new Playlist();
		playlist.init(this);
		nb.append_page(browser, null);
		nb.append_page(info, null);
		nb.append_page(player, null);
		nb.append_page(playlist, null);
		change_background_color(window, "#000000");
		window.add(nb);
	}
	
	public void create_menu()
	{	
		Gtk.Menu menu = new Gtk.Menu();
		Gtk.MenuItem connect_item = new Gtk.MenuItem.with_label("Connect");
		connect_item.activate += connect_server;
		menu.append(connect_item);
		add_sort_menu(menu);
		add_rotation_menu(menu);
		add_aspect_menu(menu);
		CheckMenuItem iv = new CheckMenuItem.with_label("Icon view");
		if (get_settings().get_value_default_to("icon_view", "true") == "true")
		{
			iv.active = true;
			get_browser().set_icon_view(true);
		}
		iv.toggled += (w) => {
			get_browser().set_icon_view(((Gtk.CheckMenuItem)w).active);
		};
		menu.append(iv);
		add_update_collection_menu(menu);
		add_about_menu(menu);
		Gtk.MenuItem quit_item = new Gtk.MenuItem.with_label("Quit");
		quit_item.activate += clean_up;
		menu.append(quit_item);
		window.set_menu(menu);
	}
	
	public void add_aspect_menu(Gtk.Menu menu)
	{
		Gtk.Menu aspectmenu = new Gtk.Menu();
		string[] fields = {"none", "16:9", "4:3"};
		string current_aspect = get_settings().get_value_default_to("aspect", "none");
		for (int i = 0; i < fields.length; i++)
		{
			CheckMenuItem cmi = new CheckMenuItem.with_label(fields[i]);
			if (current_aspect == fields[i])
				cmi.active = true;
			cmi.draw_as_radio = true;
			aspectmenu.append(cmi);
			cmi.toggled += (w) => {
				if (w.draw_as_radio)
					get_player().change_aspect(w);
			};
		}
		Gtk.MenuItem aspect = new Gtk.MenuItem.with_label("Video aspect");
		aspect.set_submenu(aspectmenu);
		menu.append(aspect);
	}
	
	public void add_sort_menu(Gtk.Menu menu)
	{
		Gtk.Menu sortmenu = new Gtk.Menu();
		string[] fields = {"date added", "date modified", "name", "duration", "resume position", "path", "size", "views"};
		string[] sorts = get_settings().get_value_default_to("sort", "0").split(",", 0);
		for (int i = 0; i < fields.length; i++)
		{
			CheckMenuItem cmi = new CheckMenuItem.with_label(fields[i]);
			sortmenu.append(cmi);
			cmi.toggled += (w) => {
				get_browser().change_sort(w);
			};
		}
		foreach(string token in sorts)
		{
			get_browser().select_sortable(sortmenu, token.to_int(), true);
		}
		Gtk.MenuItem sort = new Gtk.MenuItem.with_label("Sort items by");
		sort.set_submenu(sortmenu);
		menu.append(sort);
	}
	
	public void add_rotation_menu(Gtk.Menu menu)
	{
		rotation = get_rotation();
		if (rotation != -1)
		{
			Gtk.Menu rotatemenu = new Gtk.Menu();
			string[] fields = {"Normal", "90 degrees ccw", "180 degrees", "90 degrees cw"};
			for (int i = 0; i < fields.length; i++)
			{
				MenuItem mi = new MenuItem.with_label(fields[i]);
				rotatemenu.append(mi);
				mi.activate += (w) => {
					change_rotation(w);
				};
			}
			Gtk.MenuItem rotationmenu = new Gtk.MenuItem.with_label("Rotation");
			rotationmenu.set_submenu(rotatemenu);
			CheckMenuItem lv = new CheckMenuItem.with_label("Always use landscape video");
			lv.toggled += (w) => {
				get_settings().set_value("landscape_video", (((Gtk.CheckMenuItem)w).active).to_string());
			};
			if (get_settings().get_value_default_to("landscape_video", "false") == "true")
			{
				lv.active = true;
			}
			rotatemenu.append(lv);
			menu.append(rotationmenu);
			int last_rotation = get_settings().get_value_default_to("rotation", "0").to_int();
			if (last_rotation != rotation)
			{
				set_rotation(last_rotation);
			}
		}
	}
	
	public void add_update_collection_menu(Gtk.Menu menu)
	{
		updating_collection = false;
		Gtk.MenuItem update_item = new Gtk.MenuItem.with_label("Update collection");
		update_item.activate += () => {
			if (!updating_collection)
			{
				alert("Updating collection");
				try
				{
					con.connection_event += (s) => {
						if (s.get_status() == ConIc.ConnectionStatus.CONNECTED)
						{
							try
							{
								Thread.create(update_collection, true);
							}
							catch (GLib.Error e)
							{
							
							}
						}
					};
					con.connect(ConIc.ConnectFlags.NONE);
				}
				catch (ThreadError e)
				{
				}
			}
		};
		menu.append(update_item);
	}
	
	public void* update_collection()
	{
		updating_collection = true;
		get_connection().fetch("/root/update_collection");
		updating_collection = false;
		return null;
	}
	
	public void add_about_menu(Gtk.Menu menu)
	{
		Gtk.MenuItem about_item = new Gtk.MenuItem.with_label("About");
		about_item.activate += () => {
			show_about();
		};
		menu.append(about_item);	
	}
	
	public void show_about()
	{
		if (about == null)
		{
			about = new Gtk.AboutDialog();
			about.version = get_version();
			about.copyright = "Copyright © 2009 Janne Mäkinen";
			about.wrap_license = true;
			about.website = "http://www.nakkiboso.com/knots2";
			about.set_authors({"Janne Mäkinen <janne.makinen@surffi.fi>", null});
			about.logo = new Gdk.Pixbuf.from_file("/usr/share/icons/hicolor/scalable/apps/knots2.png");
			about.response += () => { about.hide(); };
		}
		about.show_all();
	}
	
	public void toggle_fullscreen()
	{
		fullscreen = !fullscreen;
		if (fullscreen)
			window.fullscreen();
		else
			window.unfullscreen();
	}
	
	public static void display_event(Osso.DisplayState state, void* data)
	{
		Knots knots = (Knots)data;
		if (state == Osso.DisplayState.ON)
			visible = true;
		else
		if (state == Osso.DisplayState.OFF)
			visible = false;
		for (int i = 0; i < knots.get_notebook().get_n_pages(); i++)
		{
			((PageWidget)knots.get_notebook().get_nth_page(i)).display_state_changed(state);
		}
	}

	public Settings get_settings()
	{
		return settings;
	}
	
	public bool is_visible()
	{
		return visible && topmost;
	}
	
	public void change_rotation(Gtk.Widget w)
	{
		int index = 0;
		var children = ((Gtk.Container)w.get_parent()).get_children();
		foreach(Gtk.Widget ww in children)
		{
			Gtk.MenuItem mi = (Gtk.MenuItem)ww;
			if (mi == w)
			{
				set_rotation(index);
				return;
			}
			index += 1;
		}
	}
	
	public void set_rotation(int i)
	{
		try
		{
			GLib.Process.spawn_command_line_sync ("/usr/share/knots/rotate " + i.to_string());
		}
		catch (GLib.SpawnError se)
		{
			print("ERROR: %s\n", se.message);
		}
	}
	
	public int get_rotation()
	{
		string rotation;
		try
		{
			GLib.Process.spawn_command_line_sync ("/usr/share/knots/rotate", out rotation);
			return rotation.to_int();
		}
		catch (GLib.SpawnError se)
		{
			print("ERROR: %s\n", se.message);
		}
		return -1;
	}
	
	public Hildon.Window get_window()
	{
		return window;
	}
	
	public string get_version()
	{
		return version;
	}
	
	public bool check_topmost()
	{
		if (window.get_is_topmost() != topmost)
		{
			topmost = window.get_is_topmost();
			for (int i = 0; i < get_notebook().get_n_pages(); i++)
			{
				((PageWidget)get_notebook().get_nth_page(i)).window_state_changed(topmost);
			}
			
		}
		return false;
	}
	
	public bool do_focus_check(EventFocus event)
	{
		GLib.Timeout.add(200, check_topmost);
		return false;
	}
	
	public void check_orientation()
	{
		int new_orientation = window.get_screen().get_width() > window.get_screen().get_height() ? LANDSCAPE : PORTRAIT;
		if (new_orientation != ORIENTATION)
		{
			ORIENTATION = new_orientation;
			for (int i = 0; i < nb.get_n_pages(); i++)
			{
				((PageWidget)nb.get_nth_page(i)).orientation_change();
			}
		}
	}
	
	public Discovery get_connection()
	{
		return discovery;
	}
	
	public void connect_server()
	{
		if (!get_player().is_playing())
		{
			if (!connected)
			{
				alert("Trying to connect, please wait.");
				con.connection_event += (s) => {
					if (s.get_status() == ConIc.ConnectionStatus.CONNECTED || get_settings().get_value("ignore_conic") != null)
					{
						this.connected = true;
						connect_server();
					}
					else
					{
						alert("Disconnected");
						get_browser().clear();
						get_browser().get_toolbar().hide();
						this.connected = false;
					}
				};
				con.connect(ConIc.ConnectFlags.NONE);
			}
			else
			{
				get_connection().discover_server_address();
				if (get_connection().server_count() == 1)
				{
					alert("Connected to server " + get_connection().server_name());
					get_browser().clear();
					get_browser().browse();
					get_playlist().update_playlists();
				}
				else
				if (get_connection().server_count() > 1)
				{
					get_browser().show_serverlist();
				}
				get_browser().reveal();
			}
		}
	}
	
	public Common get_common()
	{
		return common;
	}
	
	public Browser get_browser()
	{
		return (Browser)nb.get_nth_page(0);
	}
	
	public Info get_info()
	{
		return (Info)nb.get_nth_page(1);
	}
	
	public Playlist get_playlist()
	{
		return (Playlist)nb.get_nth_page(3);
	}
	
	public Player get_player()
	{
		return (Player)nb.get_nth_page(2);
	}
	
	public Notebook get_notebook()
	{
		return nb;
	}
	
	public void change_volume(bool up)
	{
		try
		{
			var client = GConf.Client.get_default();
			int vol = client.get_int("/apps/osso/sound/master_volume");
			if (up)
				vol += 5;
			else
				vol -= 5;
			if (vol > 100)
				vol = 100;
			else
			if (vol < 0)
				vol = 0;
			client.set_int("/apps/osso/sound/master_volume", vol);
			alert("Volume changed to " + vol.to_string());
		}
		catch (GLib.Error ge)
		{
		
		}
	}
	
	public void change_background_color(Widget widget, string col)
	{
		Gdk.Color color;
		Gdk.Color.parse(col, out color);
		widget.modify_bg (Gtk.StateType.NORMAL, color);
		widget.modify_bg (Gtk.StateType.SELECTED, color);
		widget.modify_bg (Gtk.StateType.ACTIVE, color);
		widget.modify_base (Gtk.StateType.NORMAL, color);
		widget.modify_base (Gtk.StateType.SELECTED, color);
		widget.modify_base (Gtk.StateType.ACTIVE, color);
	}
	
	public void change_foreground_color(Widget widget, string col)
	{
		Gdk.Color color;
		Gdk.Color.parse(col, out color);
		widget.modify_fg (Gtk.StateType.NORMAL, color);
		widget.modify_fg (Gtk.StateType.SELECTED, color);
		widget.modify_fg (Gtk.StateType.ACTIVE, color);
	}
	
	public void alert(string str){
	  	Hildon.Banner.show_information(window, "knots2", str);
	}
	
	public void puts(string message)
	{
		print("%s\n", message);
	}
	

	public void clean_up()
	{
		if (get_player().is_playing())
		{
			get_player().on_stop();
			get_player().stop();
		}
		int current_rotation = get_rotation();
		get_settings().set_value("rotation", current_rotation.to_string());
		if (rotation != -1 && rotation != current_rotation)
		{
			set_rotation(rotation);
		}
		get_settings().set_value("sort", get_browser().sort_settings()); 
		Gtk.main_quit();
	}
	
	public bool key_event(Gtk.Widget w, Gdk.EventKey ev)
	{
		if (!get_player().is_playing())
		{
			switch (ev.keyval) {
				case Gdk.KeySyms.F4:
					break;
				case Gdk.KeySyms.F6:
					toggle_fullscreen();
					break;
				case Gdk.KeySyms.F7:
					change_volume(true);
					break;
				case Gdk.KeySyms.F8:
					change_volume(false);
					break;
				case Gdk.KeySyms.Return:
					break;
				case Gdk.KeySyms.Escape:
					break;
				case Gdk.KeySyms.Up:
					((PageWidget)get_notebook().get_nth_page(get_notebook().get_current_page())).scroll_up();
					break;
				case Gdk.KeySyms.Down:
					((PageWidget)get_notebook().get_nth_page(get_notebook().get_current_page())).scroll_down();
					break;
			}
		}
		else
		{
			return get_player().key_event(ev);
		}
		return false;
	}
}

