//#include <config.h>

#include <string.h>
#include <errno.h>
#include <glob.h>

#define DISABLE_PRINTING
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>
extern "C" {
#include <gtkhtml/gtkhtml.h>
}
#ifdef BUILD_BORA
# include <hildon-widgets/gtk-infoprint.h>
# include <hildon-widgets/hildon-seekbar.h>
#else
# include <hildon/hildon-banner.h>
# include <hildon/hildon-seekbar.h>
#endif
//#include <gdk/gdk.h>
//#include <pango/pango-font.h>

#include "kmplayerplaylist.h"
#include "actor.h"
#include "kmplayer_lists.h"
#include "kmplayer_smil.h"
#include "kmplayercontrol.h"
#include "kmplayerprocess.h"
#include "kmplayer.h"
#include "viewarea.h"

using namespace KMPlayer;

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#ifdef KMPLAYER_DEBUG
static Application *debug_app;
static Control *debug_control;

void sig_usr1 (int) {
    debugLog () << "Start dump" << endl;
    debugLog () << debug_control->process () << " " <<
        debug_control->blanking_timer << endl;
    if (debug_control->process () && debug_control->process ()->mrl ())
        debugLog () << debug_control->process ()->playing () <<
            debug_control->process ()->mrl ()->src <<
            debug_control->process ()->mrl ()->audio_only <<
            debug_control->process ()->hasVideo () << endl;
    debugLog () << "End dump" << endl;
}
#endif

static gboolean playSchedule (void * ctr) {
    static_cast <Control *> (ctr)->play ();
    return false;
}

static gboolean playCurrentSchedule (void * ctr) {
    static_cast <Control *> (ctr)->playCurrent ();
    return false;
}

SourceDocument::SourceDocument (Control *c, const String &url)
    : Document (url, c), m_control (c) {}

void *SourceDocument::message (MessageType msg, void *data) {
    switch (msg) {

    case MsgQueryActorAgent:
        return m_control->actorAgent ();

    case MsgQueryRoleChildDisplay:
        return VIEWAREA(m_control->m_app)->getSurface ((Mrl *) data);

    case MsgInfoString:
        app_set_info_content (m_control->m_app, 
                data ? (const char *) *((String *) data) : "", false);
        return NULL;

    default:
        break;
    }
    return Document::message (msg, data);
}

Control::Control (Application * a)
    : m_process (0L), m_doc_timer (0), progress_banner (NULL),
      playlist_data (0L), m_config (new Config), m_app (a),
      paint_timer (0), update_tree_timer (0), blanking_timer (0),
      in_progress_update (false),
      request_download (false),
      actor_agent (new ActorAgent (this)) {
#ifdef KMPLAYER_DEBUG
    debug_app = a;
    debug_control = this;
#endif
}

Control::~Control () {
    delete m_process;
    if (playlist_data->document)
        playlist_data->document->document()->dispose ();
    delete playlist_data;
    delete m_config;
    m_process = 0L;
}

void Control::init () {
    unsigned int ver, rel, req, evb, err;
    glob_t gt;
    use_xvideo = !glob ("/usr/lib/libXv.so*", GLOB_ERR|GLOB_NOSORT, 0, &gt);
    globfree (&gt);
    media_server = new OssoMediaServer (this, m_app->osso_context, use_xvideo);
    mplayer = new MPlayer (this, use_xvideo);
#ifdef __ARMEL__
    npp = new NpPlayer (this);
#endif
    downloader = new Downloader (this, m_app);
    String p = m_config->readEntry (GCONF_KEY_PLAYER, OssoMediaServer::myname);
    setProcess ((const char *) p);

    if (use_xvideo)
        use_xvideo = !m_config->readNumEntry (GCONF_KEY_VO, 0);
    setUseXVideo (use_xvideo);
    if (!use_xvideo)
        gtk_check_menu_item_set_active (
                GTK_CHECK_MENU_ITEM (m_app->menu_item_mplayer_vo), true);

    GtkIconTheme *icon_theme = gtk_icon_theme_get_default();
    addTree (m_app, 0L, //gdk_pixbuf_new_from_xpm_data((const char**)www_xpm));
            gdk_pixbuf_scale_simple (
                    gtk_icon_theme_load_icon (icon_theme,
                        "qgn_grid_tasknavigator_web", 26,
                        (GtkIconLookupFlags)0, 0L),
                    26, 26, GDK_INTERP_BILINEAR));
    Playlist *pldoc = new Playlist (m_app, 0L);
    playlists = pldoc;
    String path = m_config->readEntry
        (GCONF_KEY_PLAYLIST_FILE, "/home/user/playlist.xml");
    const char *tmp = (const char *)path;
    struct stat st;
    if (stat (tmp, &st))
        tmp = "/usr/share/applications/kmplayer/playlist.xml";
    pldoc->path = tmp;
    m_app->playlists_tree_id = addTree (m_app, playlists,
            gtk_icon_theme_load_icon(icon_theme,
                "kmplayer-fav", 26, (GtkIconLookupFlags)0, 0L));
    GConfClient *client = (GConfClient *)(GConf &) *m_config;
    GSList *plists = gconf_client_all_entries (client, GCONF_KEY_LISTS, NULL );
    for (GSList *elm = plists; elm; elm = elm->next) {
        GConfEntry *entry = (GConfEntry *)elm->data;
        GConfValue *value = gconf_entry_get_value (entry);
        const char *str = gconf_value_get_string (value);
        debugLog() << entry->key << "=" << str << endl;
        if (str && *str) {
            Playlist *expl = new Playlist (m_app, 0L);
            extra_playlists.append (expl);
            expl->caption = entry->key + strlen (GCONF_KEY_LISTS) + 1;
            expl->path = str;
            addTree (m_app, expl,
                    gtk_icon_theme_load_icon(icon_theme,
                      "qgn_list_gene_playlist", 26, (GtkIconLookupFlags)0, 0L));
        }
        gconf_entry_free (entry);
    }
    g_slist_free (plists);
    recents = new KMPlayer::Recents (m_app);
    m_app->recents_tree_id = addTree (m_app, recents,
            gtk_icon_theme_load_icon(icon_theme,
                "qgn_list_gene_url_history", 26, (GtkIconLookupFlags)0, 0L));
    String sf = m_config->readEntry (GCONF_KEY_SAVE_FOLDER, String());
    if (!sf.isEmpty ())
        m_app->save_folder = g_strdup ((const char *)sf);
}

void Control::deinit () {
    stop ();
    setProcess ((Process *) NULL);

    Recents *rec = static_cast <Recents *> (recents.ptr());
    if (rec->resolved &&
            rec->load_tree_version != rec->m_tree_version)
        rec->writeToFile (m_config->readEntry
                (GCONF_KEY_RECENT_FILE, "/home/user/recent.xml"));
    rec->dispose ();

    Playlist *playlist = static_cast<Playlist *>(playlists.ptr());
    if (playlist->resolved &&
            playlist->load_tree_version != playlist->m_tree_version)
        playlist->writeToFile (m_config->readEntry
                (GCONF_KEY_PLAYLIST_FILE, "/home/user/playlist.xml"));
    if (m_app->save_folder)
        m_config->writeEntry (GCONF_KEY_SAVE_FOLDER, m_app->save_folder);
    playlist->dispose ();

    for (NodePtr n = extra_playlists.first(); n; n = n->nextSibling ())
        n->document()->dispose ();

    m_config->writeEntry (GCONF_KEY_VO, mplayer->hasXv () ? 0 : 1);

    delete media_server;
    delete mplayer;
#ifdef __ARMEL__
    delete npp;
#endif
    delete downloader;
}

gboolean cb_blankingTimer (void * p) {
    Application * app = static_cast <Application *> (p);
    if (CONTROL(app)->playlist_data->current &&
            (CONTROL(app)->playlist_data->current->id == SMIL::id_node_smil ||
             (CONTROL(app)->process ()->playing () &&
              CONTROL(app)->process ()->hasVideo ()))) {
        osso_display_blanking_pause (app->osso_context);
        return 1;
    }
    CONTROL(app)->blanking_timer = 0;
    return 0;
}

gboolean cb_docTimer (void * p) {
    return static_cast <Control *> (p)->docTimerEvent ();
}

gboolean cb_scheduledUpdateTree (void * vp) {
    Control *ctr = static_cast <Control *> (vp);
    if (ctr->process ()) {
        if (!ctr->playlist_data->document)
            ctr->playlist_data->document = new SourceDocument (ctr, String());
        updateTree (ctr->m_app, 0);
    }
    ctr->update_tree_timer = 0;
    return false;
}

void Control::play () {
    if (!playlist_data->document)                // nothing to play
        return;
    if (playlist_data->document->active ()) {    // is playing
        if (playlist_data->document->state == Node::state_deferred)
            playlist_data->document->undefer (); // unpause
        else
            playlist_data->document->defer ();   // pause
    } else {
        debugLog () << "play" << endl;
        //gtk_paned_set_position (m_app->vsplit_view, VSPLIT);
        //gtk_container_resize_children (GTK_CONTAINER (m_app->vsplit_view));
        if (!applyBackRequest () && playlist_data->document) {
            playCurrent ();
        }
    }
}

void Control::stop (bool keep_fullscreen) {
    debugLog () << "stop" << endl;
    setLoading (100); // no pogress bar
    if (blanking_timer) {
        g_source_remove (blanking_timer);
        blanking_timer = 0;
    }
    back_request = 0L;
    if (playlist_data->document &&
            playlist_data->document->state > Node::state_init) {
        playlist_data->document->reset ();
        //gtk_paned_set_position (m_app->vsplit_view, 40);
        setCurrent (0L);
    }
    VIEWAREA(m_app)->reset ();
    m_process->quit ();
    VIEWAREA(m_app)->scheduleRepaint (IRect (0, 0,
                    VIEWAREA(m_app)->width (), VIEWAREA(m_app)->height ()));
    if (!keep_fullscreen)
        app_normal_screen (m_app);
    setLength (0);
    setPosition (0);
    updatePlaylistView ();
}

String Control::currentMrl () {
    Mrl * mrl = playlist_data->current ? playlist_data->current->mrl () : 0L;
    if (!mrl)
        return String ();
    return mrl->absolutePath ();
}

void Control::openDocument (NodePtr doc, NodePtr cur) {
    stop (true);
    if (playlist_data->document)
        playlist_data->document->document()->dispose ();
    doc->document()->notify_listener = this;
    playlist_data->document = doc;
    cur_url = doc->caption;
    app_set_title ((const char *) cur_url, m_app);
    back_request = cur;
    g_timeout_add (0, playSchedule, static_cast <void *> (this));
    updatePlaylistView (true);
}

ViewArea *Control::viewArea () const {
    return (ViewArea *)m_app->viewarea;
}

unsigned long Control::videoOutput () const {
    return GDK_DRAWABLE_XID (GDK_DRAWABLE (VIEWAREA (m_app)->videoWindow ()));
}

void Control::playCurrent () {
    String url = currentMrl ();
    // set title url;
    aspect = 0.0;
    width = height = 0;
    //debugLog () << "playCurrent" << !!playlist_data->document << !playlist_data->document->active () << endl;
    // view ())->videoStop (); //show buttonbar
    if (playlist_data->document &&
            !playlist_data->document->active ()) {
        if (!playlist_data->current)
            setCurrent (playlist_data->document);
        else { // ugly code duplicate w/ back_request
            for (NodePtr p = playlist_data->current->parentNode(); p; p = p->parentNode())
                p->setState (Element::state_activated);
        }
        playlist_data->current->activate ();
        updateViewAreaSizes ();
    } else if (!playlist_data->current) {
        //debugLog () << "playCurrent no current" << endl;
        stop ();
        ; //emit endOfPlayItems ();
    } else if (playlist_data->current->state ==Element::state_deferred) {
        //debugLog () << "playCurrent set undefer" << endl;
        ;//playlist_data->current->undefer ();
    } else if (m_process->state () == Process::NotRunning) {
        //debugLog () << "playCurrent set ready" << endl;
        m_process->ready (GDK_DRAWABLE_XID (GDK_DRAWABLE (
                        VIEWAREA(m_app)->videoWindow ())));
    } else if (!playlist_data->current->active ()) {
        playlist_data->current->activate ();
        updateViewAreaSizes ();
    } else {
        Mrl *mrl = back_request
            ? back_request->mrl ()->linkNode ()
            : playlist_data->current->mrl ()->linkNode ();
        //debugLog () << "playCurrent " << m_process->playing () << " " << mrl->mrl ()->resolved << endl;
        if (m_process->playing ()) {
            errorLog() << "playCurrent and backend still playing" << endl;
            if (m_process->mrl () != mrl)
                m_process->stop ();
            else
                return; // FIXME
        }
        back_request = 0L;
        if (!mrl->src.isEmpty () && mrl->resolved) {
            updateViewAreaSizes ();
            if (m_process->hasXv ())
                XSync (GDK_DISPLAY_XDISPLAY (gtk_widget_get_display (VIEWAREA(m_app)->viewWidget ())), false);
            m_process->play (mrl);
        } else
            errorLog() << "playCurrent and mrl not resolved" << endl;
    }
}

bool Control::applyBackRequest() {
    if (!back_request || back_request->mrl ()->view_mode == Mrl::WindowMode)
        return false;
    if (playlist_data->current)
        playlist_data->document->reset ();
    playlist_data->current = 0L;
    if (back_request->document() != playlist_data->document) {
        //debugLog () << "playlist/recent" << endl;
        NodePtr n = back_request;
        back_request = 0L;
        n->activate();
    } else {
        setCurrent (back_request);
        for (NodePtr p = back_request->parentNode(); p; p = p->parentNode())
            p->setState (Element::state_activated);
        back_request = 0L;
        g_timeout_add(0, playCurrentSchedule, static_cast<void*>(this));
    }
    return true;
}

static String processForMimetype (Config *config, const String & mime) {
    String pname = config->readEntry (String (GCONF_KEY_MIME) + mime, "");
    if (pname.isEmpty ()) {
        // hardcoded defaults FIXME
        if (mime == "application/x-shockwave-flash" ||
                mime == "application/futuresplash")
            pname = "npp";
    }
    return pname;
}

ActorAgent *Control::actorAgent () const {
    return actor_agent;
}

/* dbus-send --print-reply /com/nokia/osso_browser \
 * --dest=com.nokia.osso_browser com.nokia.osso_browser.load_url \
 *  string:http://maemo.org/
 */
bool Control::requestPlayURL (NodePtr mrl) {
    debugLog () << "requestPlayURL " << mrl->mrl()->src << (mrl->mrl ()->view_mode == Mrl::SingleMode) << endl;
    if (process ()->state () > Process::Ready) {
        if (process ()->mrl () == mrl->mrl ()->linkNode ())
            return true;
        back_request = mrl; // still playing, schedule it
        if (!setProcess (mrl->mrl ()))
            process ()->stop ();
    } else {
        if (mrl->mrl ()->view_mode == Mrl::SingleMode)
            setCurrent (mrl);
        else
            back_request = mrl;
        setProcess (mrl->mrl ());
        g_timeout_add (0, playCurrentSchedule, static_cast <void *> (this));
    }
    return true;
}

bool Control::setProcess (const char *pname) {
    GtkWidget *menu;
    Process *old_process = m_process;
    if (!strcmp (pname, mplayer->name ())) {
        m_process = mplayer;
        menu = m_app->menu_item_mplayer;
#ifdef __ARMEL__
    } else if (!strcmp (pname, npp->name ())) {
        m_process = npp;
        menu = m_app->menu_item_npp;
#endif
    } else {
        m_process = media_server;
        menu = m_app->menu_item_media_server;
    }
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menu), true);
    if (old_process)
        old_process->quit ();
    VIEWAREA(m_app)->setControlsOverlap (m_process != mplayer || use_xvideo);
}

bool Control::setProcess (Mrl *mrl) {
    if (request_download) {
        m_process = downloader;
        request_download = false;
        return true;
    }
    String pname;
    bool changed = false;
    if (id_node_playlist_item == mrl->id) {
        String p = mrl->getAttribute ("player");
        if (p == mplayer->name () || p == media_server->name ()
#ifdef __ARMEL__
                || p == npp->name ()
#endif
           )
            pname = p;
    }
    if (pname.isEmpty () && !mrl->mimetype.isEmpty ())
        pname = processForMimetype (m_config, mrl->mimetype);
    if (pname.isEmpty ())
        pname = m_config->readEntry (GCONF_KEY_PLAYER, OssoMediaServer::myname);
    if (!m_process || pname != m_process->name ()) {
        setProcess ((const char *) pname);
        changed = true;
    }
    return changed;
}

void Control::setTimeout (int ms) {
    if (m_doc_timer > 0 && !g_source_remove (m_doc_timer))
        errorLog () << "failed to kill doc timer " << m_doc_timer << endl;

    m_doc_timer = ms > -1
        ? g_timeout_add (ms, cb_docTimer, static_cast <void *> (this))
        : 0;
}

void Control::openUrl (const URL &, const String &, const String & /*srv*/) {
    errorMsg ("Open for target and mimetype is not supported");
}

void Control::addRepaintUpdater (Node *node) {
    viewArea ()->addUpdater (node);
}

void Control::removeRepaintUpdater (Node *node) {
    viewArea ()->removeUpdater (node);
}

void Control::enableRepaintUpdaters (bool enable, unsigned int off_time) {
    viewArea ()->enableUpdaters (enable, off_time);
}

bool Control::docTimerEvent () {
    int id = m_doc_timer;

    m_doc_timer = -1;

    if (playlist_data->document && playlist_data->document->active ())
        playlist_data->document->document ()->timer (); //can call setTimeout()
    else
        m_doc_timer = 0;
    if (-1 == m_doc_timer) {
        // not called setTimeout(), keep interval
        m_doc_timer = id;
        return true;
    }
    return false;
}

bool Control::setCurrent (NodePtr n) {
    debugLog() << "setCurrent " << (n && n->mrl() ? n->mrl()->src : "-")<< endl;
    if (playlist_data->current == n)
        return true;
    playlist_data->current = n;
    current_selected = n;
    updatePlaylistView ();
    Mrl * mrl = n ? n->mrl () : 0L;
    if (mrl && (playlist_data->current->id == SMIL::id_node_smil ||
                !mrl->linkNode ()->audio_only)) {
        if (!blanking_timer)
            blanking_timer = g_timeout_add (25000, cb_blankingTimer, m_app);
        osso_display_blanking_pause (m_app->osso_context); // 60s delay
    } else if (blanking_timer) {
        g_source_remove (blanking_timer);
        blanking_timer = 0;
    }
    if (mrl) {
        String url;
        while (mrl) {
            if (mrl->src.startsWith ("Playlist://"))
                break;
            if (mrl->view_mode == Mrl::SingleMode)
                url = mrl->absolutePath ();
            NodePtr p = mrl->parentNode ();
            for (mrl = 0L; p; p = p->parentNode ())
                if (p->mrl ()) {
                    mrl = p->mrl ();
                    break;
                }
        }
        app_insert_location (m_app, (const char *)url);
    }
    return true;
}

static char * stateDesc [] = {
    "init", "deferred", "activated", "began", "finished", "deactivated"
};

void Control::stateElementChanged (Node* n, Node::State os, Node::State ns) {
    //debugLog () << "state " << n->nodeName () << " changed to " << stateDesc [int (ns)] << endl;
    if (!m_process) // destructing
        return;
    if (ns == Node::state_deactivated &&
            n == playlist_data->document && !back_request) {
        stop ();
        VIEWAREA(m_app)->setEventFiltering (m_app, false);
        app_set_playing (m_app, NOT_PLAYING);
    } else if ((ns == Node::state_deactivated || ns == Node::state_finished) &&
            n->mrl () && process ()->mrl () == n->mrl()->linkNode ()) {
        process ()->stop ();
        updateViewAreaSizes (); // move away video widget
    } else if ((ns == Node::state_deferred ||
                (os == Node::state_deferred && ns > Node::state_deferred)) &&
            n == playlist_data->document) {
    debugLog () << "doc state " << stateDesc [int (os)] << " changed to " << stateDesc [int (ns)] << endl;
        if ((ns == Node::state_deferred &&
                    m_process->state() != Process::Paused) ||
                (ns > Node::state_deferred &&
                 m_process->state() == Process::Paused))
            m_process->pause ();
        app_set_playing (m_app, ns > Node::state_deferred ? PLAYING : PAUSED);
    } else if (ns == Node::state_activated) {
        if (n == playlist_data->document) {
            VIEWAREA(m_app)->setEventFiltering (m_app, true);
            app_set_playing (m_app, PLAYING);
        }
        if (n->id == SMIL::id_node_body)
            updateViewAreaSizes (); // move away video widget
        if (n->isPlayable () &&
                n->mrl ()->view_mode == Mrl::SingleMode) {
            Node *p = n->parentNode();
            if (!p || !p->mrl () || p->mrl ()->view_mode == Mrl::SingleMode)
                // make sure we don't set current to nested document
                setCurrent (n);
        }
    }
    if (n == playlist_data->current &&
            (ns == Node::state_activated || ns == Node::state_deactivated))
        updatePlaylistView ();
}

void Control::updateViewAreaSizes () {
    if (!VIEWAREA(m_app)->videoWindow () || !m_process)
        return;
    VIEWAREA(m_app)->resizeEvent();
    Rect video_rect = VIEWAREA(m_app)->videoGeometry ();
    int x = video_rect.x ();
    int y = video_rect.y ();
#ifdef __ARMEL__
    if (process () == npp) {
        m_process->setVideoWindow (x, y,
                video_rect.width (), video_rect.height ());
    } else
#endif
    {
        for (GdkWindow * win = gdk_window_get_parent (
                    VIEWAREA(m_app)->videoWindow ());
                win;
                win = gdk_window_get_parent (win)) {
            int x1, y1;
            gdk_window_get_position (win, &x1, &y1);
            x += x1;
            y += y1;
        }
    }
    debugLog () << "updateViewAreaSizes " << x << ", " << y << " " << video_rect.width () << "x" << video_rect.height () << endl;
    m_process->setVideoWindow (x, y,
            video_rect.width (), video_rect.height ());
}

void Control::updatePlaylistView (bool force) {
    if (force) {
        if (update_tree_timer) {
            g_source_remove (update_tree_timer);
            update_tree_timer = 0;
        }
        updateTree (m_app, 0);
    } else if (!update_tree_timer) {
        update_tree_timer = g_timeout_add (200, cb_scheduledUpdateTree, this);
    }
}

static const char * statemap [] = {
        "Not Running", "Ready", "Buffering", "Playing", "Paused"
};

void Control::stateChanged (Process * p, Process::State os, Process::State ns) {
    debugLog () << "Process stateChanged " << statemap [(int)os] << " -> " << statemap [(int)ns] << endl;
    if (!m_process) // destructing
        return;
    if (!p->mrl () && ns > Process::Ready) {
        p->stop (); // reschedule to the NotRunning state
    } else if (ns == Process::NotRunning) {
        if (p == m_process) {
            if (playlist_data->document &&
                    playlist_data->document->state > Node::state_init) {
                stop (); // this should not happen
            } else if (blanking_timer) {
                g_source_remove (blanking_timer);
                blanking_timer = 0;
            }
            if (p == downloader &&
                    !((Downloader *) downloader)->saved_file.isEmpty ())
                addRecent (((Downloader *) downloader)->saved_file);
        }
        // else process changed
        if (!playlist_data->edit_mode)
            app_set_info_content (m_app, "", false);
    } else if (ns == Process::Ready) {
        setLoading (100); // move possible buffer info dialog
        if (os > Process::Ready) {
            setLength (0);
            setPosition (0);
            VIEWAREA(m_app)->setAspect (0.0);
            NodePtr node = p->mrl (); // p->mrl is weak, needs check
            Mrl * mrl = node ? node->mrl () : 0L;
            if (mrl && !applyBackRequest () &&  // if cause is no jump
                    mrl->active ()) {           // if cause is eof
                mrl->message (MsgMediaFinished);// set node to finished
                if (back_request)            // overlapping audio/video in SMIL
                    g_timeout_add(0, playCurrentSchedule, (void *) this);
            }
        } else
            g_timeout_add (0, playCurrentSchedule, static_cast <void *> (this));
    } else if (ns == Process::Buffering) {
        Mrl *mrl = p->mrl ();
        if (mrl->view_mode != Mrl::SingleMode) {
            AudioVideoActor *actor = mrl->media_info
                ? static_cast <AudioVideoActor *> (mrl->media_info->media)
                : NULL;
            if (actor)
                actor->ignore_pause = true;
            p->mrl ()->defer ();
            if (actor)
                actor->ignore_pause = false;
        }
    } else if (ns == Process::Paused &&
            playlist_data->document->state != Node::state_deferred &&
            !playlist_data->document->document ()->postponed ()) {
        if ((m_app->window_fullscreen &&
                gtk_window_has_toplevel_focus (GTK_WINDOW (m_app->window_fullscreen))) ||
                gtk_window_has_toplevel_focus (m_app->window))
            m_process->pause ();
        else
            playlist_data->document->defer ();
    } else if (ns == Process::Playing) {
        Mrl *mrl = p->mrl ()->mrl ();
        mrl->audio_only |= !p->hasVideo ();
        if (mrl->state == Element::state_deferred) {
            AudioVideoActor *actor = mrl->media_info
                ? static_cast <AudioVideoActor *> (mrl->media_info->media)
                : NULL;
            if (actor)
                actor->ignore_pause = true;
            p->mrl ()->undefer ();
            if (actor)
                actor->ignore_pause = false;
        }
        setLoading (100); // move possible buffer info dialog
        addRecent (playlist_data->document->mrl()->src);
        updatePlayTree (m_app);
    }
}

void Control::addRecent (const String &url) {
    recents->defer ();
    NodePtr c = recents->firstChild ();
    if (url != String ("Playlist://") && (!c || c->mrl()->src != url)) {
        recents->insertBefore (new Recent (recents, m_app, url), c);
        c = recents->firstChild ()->nextSibling ();
        int count = 1;
        KMPlayer::NodePtr more;
        while (c) {
            if (c->id == id_node_recent_node &&
                    c->mrl ()->src == url) {
                KMPlayer::NodePtr tmp = c->nextSibling ();
                recents->removeChild (c);
                c = tmp;
            } else {
                if (c->id == id_node_group_node)
                    more = c;
                c = c->nextSibling ();
                count++;
            }
        }
        if (!more && count > 10) {
            more = new Group (recents, m_app, "More ...");
            recents->appendChild (more);
        }
        if (more) {
            KMPlayer::NodePtr item;
            if (count > 10) {
                KMPlayer::NodePtr item = more->previousSibling ();
                recents->removeChild (item);
                more->insertBefore (item, more->firstChild ());
            }
            if (more->firstChild ())
                c = more->firstChild ()->nextSibling ();
            count = 0;
            while (c) {
                if (c->id == id_node_recent_node &&
                        c->mrl ()->src == url) {
                    KMPlayer::NodePtr tmp = c->nextSibling ();
                    more->removeChild (c);
                    c = tmp;
                } else {
                    c = c->nextSibling ();
                    count++;
                }
            }
            if (count > 50)
                more->removeChild (more->lastChild ());
        }
        updateTree (m_app, m_app->recents_tree_id);
    }
}

void Control::setCurrentSelected (NodePtr node) {
    current_selected = node;
    if (m_app->fullscreen && VIEWAREA(m_app)->controls)
        gdk_window_clear_area_e (VIEWAREA(m_app)->controls,
                110, 0, 410, 60);
        //gdk_window_invalidate_rect (VIEWAREA(m_app)->controls, NULL, false);
}

void Control::errorMsg (const String & msg) {
    hildon_banner_show_information (GTK_WIDGET (m_app->window),
            NULL, (const char *) msg);
}

void Control::setLoading (int perc) {
    if (perc >= 100) {
        if (progress_banner)
            gtk_widget_destroy (progress_banner);
        progress_banner = NULL;
    } else {
        if (!progress_banner)
            progress_banner = hildon_banner_show_progress (
                    GTK_WIDGET (m_app->window), NULL,
                    m_process == downloader ? "Saving" : "Buffering");
        hildon_banner_set_fraction (
                HILDON_BANNER (progress_banner), 1.0 * perc / 100);
    }
}

void Control::setPosition (int p) {
    if (p < hildon_seekbar_get_total_time(HILDON_SEEKBAR(m_app->progress_bar))){
        in_progress_update = true;
        if (progress_banner)
            setLoading (100);
        if (p > 0)
            hildon_seekbar_set_position(HILDON_SEEKBAR(m_app->progress_bar), p);
        in_progress_update = false;
    }
}

void Control::setLength (int len) {
    hildon_seekbar_set_total_time (HILDON_SEEKBAR (m_app->progress_bar), len);
    hildon_seekbar_set_fraction (HILDON_SEEKBAR (m_app->progress_bar), len);
    if (len > 50) {
        gtk_widget_hide (GTK_WIDGET (m_app->tb_location));
        gtk_widget_show (GTK_WIDGET (m_app->tb_progress));
    } else {
        gtk_widget_show (GTK_WIDGET (m_app->tb_location));
        gtk_widget_hide (GTK_WIDGET (m_app->tb_progress));
    }
}

void Control::setAspect (float aspect) {
    debugLog () << "Control::setAspect " << aspect << endl;
    VIEWAREA(m_app)->setAspect (aspect);
    updateViewAreaSizes ();
}

void Control::setUseXVideo (bool b) {
    mplayer->setUseXv (b);
    use_xvideo = b;
    if (m_process == mplayer)
        VIEWAREA(m_app)->setControlsOverlap (b);
}

void cb_view_area_configure (GtkWidget *widget, GdkEventConfigure *event, Application * app) {
    //debugLog () << "cb_view_area_configure " << event->width<< "x" << event->height << endl;
    CONTROL(app)->updateViewAreaSizes ();
}

void Control::bitRates (int & prefered, int & maximal) {
}

PlayListData::PlayListData(short i, PlayListData * n)
 : updated_document (NULL),
   updated_document_version (0),
   id (i),
   show_all (false),
   edit_mode (false),
   next (n) {}

Application *app_new () {
    Application *app = new Application;
    memset (app, 0, sizeof (Application));
    app->control = new Control (app);
    StringPool::init();
    return app;
}

void app_destroy (Application *app) {
    delete CONTROL(app);
    delete VIEWAREA(app);
    StringPool::reset ();
}

void app_init_control (Application *app) {
    app->viewarea = new ViewArea;
    CONTROL(app)->init ();
}

static Mrl *findFirstPlayable (Node *n) {
    if (n) {
        if (n->isPlayable ())
            return n->mrl ();
        for (Node *c = n->firstChild().ptr (); c; c = c->nextSibling().ptr ()) {
            Mrl *mrl = findFirstPlayable (c);
            if (mrl)
                return mrl;
        }
    }
    return NULL;
}

void KMPlayer::jump (Node *n, Control *ctr) {
    Mrl *mrl = findFirstPlayable (n);
    if (mrl && mrl->view_mode == Mrl::SingleMode) {
        if (!mrl->isPlayable ())
            return;
        if (ctr->process ()->playing () &&
                ctr->process ()->mrl() == mrl->linkNode ()) {
            if (ctr->playlist_data->document->state == Node::state_deferred)
                ctr->playlist_data->document->undefer (); // unpause
            else
                ctr->playlist_data->document->defer ();   // pause
        } else {
            //debugLog() << "jump " << mrl->src << endl;
            // FIXME: group activation doesn't work
            ctr->back_request = id_node_group_node == n->id ? mrl : n;
            if (ctr->process ()->playing ())
                ctr->process ()->stop ();
            else
                ctr->applyBackRequest();
        }
    } else
        ctr->updatePlaylistView ();
}

void app_set_info_content (Application *app, const char *utf8, bool plaintext) {
    if (!plaintext && utf8[0]) {
        gtk_widget_hide (app->info_viewport);
        gtk_widget_show (app->html_viewport);
        gtk_html_load_from_string (GTK_HTML (app->html_infopanel_view),utf8,-1);
    } else {
        gtk_widget_hide (app->html_viewport);
        gtk_widget_show (app->info_viewport);
        gtk_text_buffer_set_text (gtk_text_view_get_buffer
                (GTK_TEXT_VIEW (app->infopanel_view)), utf8, -1);
    }
}

void cb_playlist_prev (GtkButton * button, void *p) {
    Control *ctr = (Control *)p;
    if (ctr->playlist_data->current &&
            ctr->playlist_data->current->previousSibling ())
        jump (ctr->playlist_data->current->previousSibling (), ctr); //FIXME
}

void cb_playlist_play (GtkButton * button, void *p) {
    Control *ctr = (Control *)p;
    if (ctr->current_selected)
        jump (ctr->current_selected, ctr);
    else
        g_timeout_add (0, playSchedule, static_cast <void *> (ctr));
}

void cb_playlist_next (GtkButton * button, void *p) {
    Control *ctr = (Control *)p;
    if (ctr->process ()->playing ())
        ctr->process ()->stop ();
}

void cb_playlist_stop (GtkButton * button, void *p) {
    Control *ctr = (Control *)p;
    if (GTK_WIDGET_VISIBLE (ctr->m_app->tb_stop)) {
        ctr->stop ();
    } else if (ctr->current_selected) {
        ctr->request_download = true;
        jump (ctr->current_selected, ctr);
    }
}

void cb_favorites_add (Application *app) {
    Control *ctr = CONTROL(app);
    bool valid = false;
    gchar *msg = "Unknown failure";
    if (!ctr->current_selected) {
        msg = "No current selected";
    } else {
        Mrl *mrl = ctr->current_selected->mrl ();
        if (!mrl || mrl->src.isEmpty ()) {
            msg = "Not a valid link selected";
        } else {
            PlayListData *pd, *fav = NULL;
            for (pd = ctr->playlist_data; pd; pd = pd->next) {
                if (pd->id == app->playlists_tree_id)
                    fav = pd;
                if (pd->document.ptr () == mrl->document ()) {
                    if (fav == pd)
                        msg = "Already in favorites";
                    else
                        valid = true;
                }
            }
            if (fav && valid) {
                msg = "Added to favorites";
                NodePtr doc = mrl->document ();
                if (!fav->document->mrl ()->resolved)
                    fav->document->activate (); // lazy load playlist
                NodePtr n;
                if (id_node_playlist_item == mrl->id) {
                    n = mrl;
                } else {
                    n = new PlaylistItem (doc, app, false, mrl->src);
                    n->caption = mrl->caption;
                }
                String xml = n->outerXML ();
                TextStream inxml ((const char *) xml);
                readXML (fav->document, inxml, String(), false);
                if (fav->document->lastChild ())
                    fav->document->lastChild ()->normalize ();
                updateTree (app, fav->id);
            }
        }
    }
    hildon_banner_show_information (GTK_WIDGET (app->window), NULL, msg);
}

void openFile (Application * app, const gchar * path) {
    CONTROL(app)->stop ();
    PlayListData *pd = CONTROL(app)->playlist_data;
    if (pd->document)
        pd->document->document()->dispose ();
    pd->document = new SourceDocument (CONTROL(app), String (path));
    CONTROL(app)->cur_url = path;
    g_timeout_add (0, playSchedule, static_cast <void *> (CONTROL(app)));
    CONTROL(app)->updatePlaylistView (true);
}

void cb_openUrls (void *app, int argc, gchar **argv) {
}

const char * saveFile (void *p, const gchar *path) {
    Control *ctr = (Control *)p;
    if (!path)
        path = (const char *) ctr->cur_url;
    int fd = open (path, O_WRONLY | O_CREAT | O_TRUNC, 0664);
    if (fd < 0)
        return NULL;
    PlayListData *pd = ctr->playlist_data;
    String str = pd->document
        ? pd->document->childNodes ()->length () == 1
            ? pd->document->firstChild ()->outerXML ()
            : pd->document->outerXML ()
        : "";
    ::write (fd, (const char *) str, str.length ());
    g_print ("saved %s %d bytes\n", path, str.length ());
    ::close (fd);
    ctr->cur_url = path;
    return (const char *) ctr->cur_url;
}

void newFile (Application * app) {
    PlayListData *pd = CONTROL(app)->playlist_data;
    if (pd->document) {
        pd->document->reset ();
        pd->document->document ()->dispose ();
    }
    pd->document = new SourceDocument (CONTROL(app), String ());
    CONTROL(app)->updatePlaylistView (true);
    CONTROL(app)->cur_url = String ();
}

gboolean cb_mainview_delete (GtkObject *, GdkEvent *, Application *app) {
    CONTROL(app)->deinit ();
    gtk_main_quit ();
    debugLog () << "delete" << endl;
    return false;
}

void cb_mainview_close (GtkObject *, Application *app) {
    CONTROL(app)->deinit ();
    gtk_main_quit ();
    debugLog () << "close" << endl;
}

gboolean cb_keyPressed (GtkWidget *, GdkEventKey * e, Application *app) {
    switch (e->keyval) {
        case GDK_F6: //HILDON_HARDKEY_FULLSCREEN:
            //if (app->control->process ()->playing ()) {
             //   int w, h;
            if (!app->fullscreen) {
                if (CONTROL(app)->playlist_data->document &&
                        CONTROL(app)->playlist_data->document->active ())
                    app_full_screen (app);
            } else {
                app_normal_screen (app);
            }
            break;
        case GDK_F7: //HILDON_HARDKEY_INCREASE
            if (CONTROL(app)->process ()->playing ())
                CONTROL(app)->process ()->volume (2, false);
            break;
        case GDK_F8: //HILDON_HARDKEY_DECREASE
            if (CONTROL(app)->process ()->playing ())
                CONTROL(app)->process ()->volume (-2, false);
            break;
        case GDK_Left:
            if (CONTROL(app)->process ()->playing ())
                CONTROL(app)->process ()->seek (-200, false); // 20s
            break;
        case GDK_Right:
            if (CONTROL(app)->process ()->playing ())
                CONTROL(app)->process ()->seek (200, false); // 20s
            break;
        case GDK_Return: // HILDON_HARDKEY_SELECT
            if (app->fullscreen)
                rowSelected (app);
            break;
        case GDK_Up:
            if (app->fullscreen)
                previousSelected (app);
            break;
        case GDK_Down:
            if (app->fullscreen)
                nextSelected (app);
            break;
        case GDK_Escape:
            if (app->fullscreen)
                VIEWAREA(app)->controlsVisible (app, true);
            break;
        default:
            KMPlayer::debugLog () << "Keypress " << e->keyval << KMPlayer::endl;
    }
    return false;
}

void progressValueChanged(GtkWidget *w, Application * app) {
    if (!CONTROL(app)->in_progress_update &&
            CONTROL(app)->process ()->playing ()) {
        int p = hildon_seekbar_get_position(HILDON_SEEKBAR (app->progress_bar));
        CONTROL(app)->process ()->seek (p, true);
        //debugLog () << "progressBarClicked " << p << endl;
    }
}

void toggleMediaServer (GtkCheckMenuItem *radio, Application *app) {
    if (!gtk_check_menu_item_get_active (radio))
        return;
    Process *p;
    if (radio == GTK_CHECK_MENU_ITEM (app->menu_item_media_server))
        p = CONTROL(app)->media_server;
#ifdef __ARMEL__
    else if (radio == GTK_CHECK_MENU_ITEM (app->menu_item_npp))
        p = CONTROL(app)->npp;
#endif
    else
        p = CONTROL(app)->mplayer;
    CONTROL(app)->setProcess (p->name ());
#ifdef __ARMEL__
    if (p != CONTROL(app)->npp)
#endif
        CONTROL(app)->m_config->writeEntry(GCONF_KEY_PLAYER, String(p->name()));
}

void toggleVO (GtkCheckMenuItem *chk, Application *app) {
    CONTROL(app)->setUseXVideo (!gtk_check_menu_item_get_active (chk));
}

void app_set_suspend (Application *a, bool suspend) {
    PlayListData *pd = CONTROL(a)->playlist_data;
    if (pd->document &&
            pd->document->active () &&
            (!CONTROL(a)->process ()->playing () ||
             CONTROL(a)->process()->mrl()->view_mode ==Mrl::WindowMode ||
             CONTROL(a)->process ()->hasVideo ())) {
        if (pd->document->state == Node::state_deferred) {
            if (!suspend)
                ; // do nothing  a->playlist_data->document->undefer ();
        } else if (suspend)
            pd->document->defer ();
    }
}

static bool locationbar_initialized;

gboolean
locationbarGainFocus (GtkWidget *, GdkEventFocus *, Application * app) {
    int n = gtk_toolbar_get_n_items (GTK_TOOLBAR (app->main_toolbar));
    for (int i = 5; i < n; i++)
        gtk_widget_hide (GTK_WIDGET (gtk_toolbar_get_nth_item (GTK_TOOLBAR (app->main_toolbar), i)));
    app_set_playing (app, app->playing);
    if (!locationbar_initialized) {
        KMPlayer::debugLog() << "locationbar_initializing" << KMPlayer::endl;
        const char * defs[6] = {
            "http://www.cwi.nl/SMIL/EUROshow/EUROshowB.smi",
            "http://homepages.cwi.nl/~media/SMIL/fiets/fiets.smil",
            "http://www.theworld.org/rss/tech.xml",
            "http://www.etherbeat.com/shoutcast/64.pls",
            "http://www.swissgroove.ch/listen.m3u",
            "file:///home/user/MyDocs/.videos/Discovery.avi"
        };
        int defpos = 0;
        locationbar_initialized = true;
        KMPlayer::Config * config = CONTROL(app)->m_config;
        KMPlayer::String cfg_prefix (GCONF_KEY_LOCATION_URL);
        GtkTreeIter iterator;
        GtkListStore * model = GTK_LIST_STORE (gtk_combo_box_get_model (
                    GTK_COMBO_BOX (app->location_bar)));
        for (int i = 1; i < 7; i++) {
            gtk_list_store_append (model, &iterator);
            KMPlayer::String cfg = config->readEntry (cfg_prefix +
                    KMPlayer::String::number(i), "");
            if (cfg.isEmpty ())
                cfg = defs[defpos++];
            gtk_list_store_set (model, &iterator,
                0, (const char *) cfg, -1);
        }
    }
    gtk_editable_select_region (GTK_EDITABLE (GTK_BIN (app->location_bar)->child), 0, -1);
    //g_print ("callback_locationbar_gain_focus %d\n", n);
    return false;
}

void save_locationbar (Application *app) {
    if (!locationbar_initialized)
        return;
    KMPlayer::Config * config = CONTROL(app)->m_config;
    int idx = 1;
    KMPlayer::String cfg_pfx (GCONF_KEY_LOCATION_URL);
    GtkTreeIter iterator;
    GtkTreeModel * model = GTK_TREE_MODEL (gtk_combo_box_get_model (
                GTK_COMBO_BOX (app->location_bar)));
    for (bool b = gtk_tree_model_get_iter_first (model, &iterator);
            b;
            b = gtk_tree_model_iter_next (model, &iterator)) {
        GValue value = { 0 , };
        gtk_tree_model_get_value (model, &iterator, 0, &value);
        KMPlayer::String val (g_value_get_string (&value));
        g_value_unset (&value);
        KMPlayer::debugLog() << val << " " << idx << KMPlayer::endl;
        if (!val.isEmpty ())
            config->writeEntry (cfg_pfx + KMPlayer::String::number(idx++), val);
    }
}

/*
 * TODO
static void cb_iap (struct iap_event_t * event, void * arg) {
    if (event->type == OSSO_IAP_CONNECTED) {
    }
}

osso_iap_cb (cb_iap);
osso_iap_connect (OSSO_IAP_ANY, OSSO_IAP_REQUESTED_CONNECT, 0L);

'dbus-send --print-reply --dest=com.nokia.osso_browser /usr/bin/browser com.nokia.osso_browser.load_url string:%s' % url
*/
