/*
  Kandis - A tea steepming timer.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Configuration.h"

#include <algorithm>
#include <iostream>

#include <Lum/Base/Path.h>
#include <Lum/Base/String.h>

#include <Lum/Config/Config.h>

std::vector<Tea> teas;
bool             configurationChanged=false;

bool lessTea(const Tea& t1, const Tea& t2)
{
  return t1.name<t2.name;
}

bool LoadConfig()
{
  Lum::Config::Node      *top;
  Lum::Config::ErrorList errors;
  Lum::Base::Path        path(Lum::Base::Path::GetApplicationConfigPath());

  top=Lum::Config::LoadConfigFromXMLFile(path.GetPath(),errors);

  if (top==NULL) {
    return false;
  }

  if (top->GetName()!=L"Kandis") {
    std::cerr << "'" << Lum::Base::WStringToString(path.GetPath()) << "' is a valid config file!" << std::endl;
    delete top;
    return false;
  }

  for (Lum::Config::Node::NodeList::const_iterator iter=top->GetChildren().begin();
       iter!=top->GetChildren().end();
       ++iter) {
    Lum::Config::Node *node=*iter;

    if (node->GetName()==L"Tea") {
      Tea tea;

      if (node->GetAttribute(L"name",tea.name) &&
          node->GetAttribute(L"minutes",tea.minutes) &&
          node->GetAttribute(L"seconds",tea.seconds)) {
        teas.push_back(tea);
      }
    }
  }

  delete top;

  // TODO: Sort list by name

  std::sort(teas.begin(),teas.end(),lessTea);

  return true;
}

bool SaveConfig()
{
  Lum::Config::Node *top;
  Lum::Base::Path   path(Lum::Base::Path::GetApplicationConfigPath());
  std::wstring      config;
  bool              res;

  top=new Lum::Config::Node();
  top->SetName(L"Kandis");

  for (size_t i=0; i<teas.size(); i++) {
    Lum::Config::Node *node;

    node=new Lum::Config::Node();
    node->SetName(L"Tea");
    node->SetAttribute(L"name",teas[i].name);
    node->SetAttribute(L"minutes",teas[i].minutes);
    node->SetAttribute(L"seconds",teas[i].seconds);

    top->Add(node);
  }

  Lum::Base::Status status;

  status=path.CreateDirRecursive();

  if (!status) {
    std::cerr << "Cannot create config directory '" << Lum::Base::WStringToString(path.GetDir()) << "': " << Lum::Base::WStringToString(status.GetDescription()) << std::endl;
    return false;
  }

  res=Lum::Config::SaveConfigToXMLFile(path.GetPath(),top);

  delete top;

  return res;
}

void FreeConfig()
{
  teas.clear();
}

