#ifndef LUM_OS_X11_GTKTHEME_H
#define LUM_OS_X11_GTKTHEME_H

/*
  This source is part of the Illumination library
  Copyright (C) 2006  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <gtk/gtk.h>

#include <Lum/OS/Base/Theme.h>

#include <Lum/OS/Display.h>
#include <Lum/OS/DrawInfo.h>
#include <Lum/OS/Fill.h>
#include <Lum/OS/Frame.h>
#include <Lum/OS/Image.h>

namespace Lum {
  namespace OS {
    namespace X11 {

      struct GtkWidgets
      {
        enum GtkStyles {
          styleWindow       =  0,
          styleColumn       =  1,
          styleColumnLeft   =  2,
          styleColumnMiddle =  3,
          styleColumnRight  =  4,

          styleButton       =  5,
          styleToolbar      =  6,
          styleToolButton   =  7,
          styleEdit         =  8,
          styleProgressH    =  9,
          styleProgressV    = 10,
          styleHKnob        = 11,
          styleVKnob        = 12,
          styleCheck        = 13,
          styleRadio        = 14,
          styleRadio2       = 15,
          styleTab          = 16,
          styleList         = 17,
          styleComboBox     = 18,
          styleEditComboBox = 19,
          styleHLine        = 20,
          styleVLine        = 21,
          styleHScale       = 22,
          styleVScale       = 23,
          styleStatus       = 24,
          styleScrolled     = 25,
          styleLabel        = 26,
          styleButtonBox    = 27,
          stylePane         = 28,
          styleDummy        = 29,

          styleMenuBar      = 30,
          styleMenuPullDown = 31,
          styleMenu         = 32,
          styleMenuItem     = 33,
          stylePopup        = 34,

          styleMax          = 35
        };

      public:
        ::GtkWidget     *layout;
        ::GtkAdjustment *adjustment;
        ::GtkWidget     *widget[styleMax];
        ::GdkPixbuf     *positiveIcon;
        ::GdkPixbuf     *negativeIcon;
        ::GdkPixbuf     *defaultIcon;
        ::GdkPixbuf     *helpIcon;
        ::GdkPixbuf     *closeIcon;

      public:
        GtkWidgets();
        ~GtkWidgets();


        GtkWidget* GetWidget(GtkStyles style) const;
        GtkStyle* GetStyle(GtkStyles style) const;
      };

      extern GtkWidgets *gtkWidgets;

      class GtkImage : public ::Lum::OS::Image
      {
      private:
        Display::ImageIndex image;
        size_t              width;
        size_t              height;

      public:
        GtkImage(Display::ImageIndex image);

        size_t GetWidth() const;
        size_t GetHeight() const;
        bool GetAlpha() const;
        unsigned long GetDrawCap() const;

        void Draw(::Lum::OS::DrawInfo *draw, int x, int y, size_t w, size_t h);
      };

      class GtkFill : public Fill
      {
      private:
        Display::FillIndex fill;

      public:
        GtkFill(Display::FillIndex fill);

        void Draw(::Lum::OS::DrawInfo* draw,
                  int xOff, int yOff, size_t width, size_t height,
                  int x, int y, size_t w, size_t h);
      };

      class GtkFrame : public Frame
      {
      private:
        Display::FrameIndex frame;

      public:
        GtkFrame(Display::FrameIndex frame);

        void Draw(::Lum::OS::DrawInfo* draw, int x, int y, size_t w, size_t h);
      };

      extern int GetWidgetStyleIntValue(GtkWidget *widget, const char* name);
      extern bool GetWidgetStyleBoolValue(GtkWidget *widget, const char* name);
      extern void GetWidgetStyleBorderValue(GtkWidget *widget, const char* name,
                                            int& left, int&right, int &top, int& bottom);

      class GtkTheme : public ::Lum::OS::Base::Theme
      {
      public:
        Color          helpBackgroundColor;
        Color          whiteColor;
        Color          blackColor;
        Color          shineColor;
        Color          shadowColor;

        ScrollKnobMode scrollKnobMode;

      public:
        GtkTheme(::Lum::OS::Display *display);
        ~GtkTheme();

        bool HasFontSettings() const;

        std::wstring GetProportionalFontName() const;
        size_t GetProportionalFontSize() const;

        std::wstring GetFixedFontName() const;
        size_t GetFixedFontSize() const;

        void GetObjectSize(ObjectType object,
                           size_t& width,
                           size_t& height) const;

        bool NeedsObjectParentDraw(ObjectType object) const;

        void DrawObject(OS::DrawInfo* draw,
                        ObjectType object,
                        int x, int y, size_t width, size_t height,
                        int cX, int cY, size_t cWidth, size_t cHeight);

        size_t GetSpaceHorizontal(OS::Display::Space space) const;
        size_t GetSpaceVertical(OS::Display::Space space) const;
        size_t GetMinimalButtonWidth() const;
        size_t GetFirstTabOffset() const;
        size_t GetLastTabOffset() const;
        size_t GetEntryHorizTextOffset() const;
        size_t GetEntryVertTextOffset() const;
        size_t GetDragStartSensitivity() const;
        size_t GetMouseClickHoldSensitivity() const;

        ScrollKnobMode GetScrollKnobMode() const;
        ToolbarPosition GetToolbarPosition() const;
        bool ShowButtonImages() const;
        MenuType GetMenuType() const;
      };

    }
  }
}

#endif
