/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Image.h>

namespace Lum {

  Image::Image()
  {
    // no code
  }

  Image::~Image()
  {
    // delete bitmap;
  }

  void Image::SetImage(Images::Image *image)
  {
    osImage=NULL;
    extImage=image;
  }

  void Image::SetImage(OS::Image *image)
  {
    extImage=NULL;
    osImage=image;

    if (osImage.Valid()) {

      /*
      if (osImage->GetAlpha()) {
        SetBackground(NULL);
      }*/
    }
  }

  void Image::CalcSize()
  {
    if (osImage.Valid()) {
      width=osImage->GetWidth();
      height=osImage->GetHeight();
    }
    else if (extImage.Valid()) {
      width=extImage->GetWidth();
      height=extImage->GetHeight();
    }
    else {
      if (OS::display->GetType()==OS::Display::typeTextual) {
        width=1;
        height=1;
      }
      else {
        width=20;
        height=20;
      }
    }

    minWidth=width;
    minHeight=height;

    Object::CalcSize();
  }

  void Image::Draw(int x, int y, size_t w, size_t h)
  {
    Object::Draw(x,y,w,h);

    if (!Intersect(x,y,w,h)) {
      return;
    }

    /* --- */

    if (width==0 || height==0 || w==0 || h==0) {
      return;
    }

    if (osImage.Valid()) {
      OS::DrawInfo *draw=GetDrawInfo();

      if (osImage->GetAlpha()) {
        DrawBackground(x,y,w,h);
      }

      osImage->Draw(draw,this->x,this->y,this->width,this->height);
    }
    else if (extImage.Valid()) {
      OS::DrawInfo *draw=GetDrawInfo();

      if (extImage->HasAlpha()) {
        DrawBackground(x,y,w,h);
      }

      extImage->DrawSub(draw,0,0,this->width,this->height,this->x,this->y);
    }
    else {
      DrawBackground(x,y,w,h);
    }
  }
}
