#ifndef LUM_OS_X11_DISPLAY_H
#define LUM_OS_X11_DISPLAY_H

/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

// std
#include <list>
#include <string>

#include <Lum/Private/Config.h>

// X11
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#if defined(HAVE_LIBSM)
#include <X11/SM/SMlib.h>
#endif

#if defined(HAVE_LIB_DBUS)
#define DBUS_API_SUBJECT_TO_CHANGE 1
#include <dbus/dbus.h>
#endif

#ifdef HAVE_LIB_GSTREAMER
#include <gst/gst.h>
#endif

#include <Lum/OS/Base/Display.h>

#include <Lum/OS/Event.h>
#include <Lum/OS/Thread.h>

#include <Lum/OS/X11/Event.h>

namespace Lum {
  namespace OS {
    namespace X11 {

      /*
      class SleepDesc; // module private
      class ChannelDesc; // module private
      class PatternDesc; // module private

      typedef SleepDesc *Sleep; // module private
      typedef ChannelDesc *Channel; // module private

      */

      class Tray;
      class Window;
      class Display;

      class LUMAPI Display : public OS::Base::Display
      {
      private:
        friend class Window;
        friend class Tray;

      public:
        enum Atoms {
          atomAtom                   =  0,
          deleteProtAtom             =  1,
          wmStateAtom                =  2,
          XdndAwareAtom              =  3,
          XdndEnterAtom              =  4,
          XdndLeaveAtom              =  5,
          XdndPositionAtom           =  6,
          XdndStatusAtom             =  7,
          XdndFinishedAtom           =  8,
          XdndDropAtom               =  9,
          XdndActionCopyAtom         = 10,
          XdndActionMoveAtom         = 11,
          XdndActionLinkAtom         = 12,
          XdndActionAskAtom          = 13,
          XdndActionPrivateAtom      = 14,
          XdndActionListAtom         = 15,
          XdndSelectionAtom          = 16,
          XdndTypeListAtom           = 17,
          dropAtom                   = 18,
          selectionAtom              = 19,
          compoundTextAtom           = 20,
          clipboardAtom              = 21,
          clipBufferAtom             = 22,
          netWMNameAtom              = 23,
          netWMWindowTypeAtom        = 24,
          netWMWindowTypeDesktopAtom = 25,
          netWMWindowTypeToolbarAtom = 26,
          netWMWindowTypeMenuAtom    = 27,
          netWMWindowTypeUtilityAtom = 28,
          netWMWindowTypeSplashAtom  = 29,
          netWMWindowTypeDialogAtom  = 30,
          netWMWindowTypeNormalAtom  = 31,
          netWMPingAtom              = 32,
          netWMPIDAtom               = 33,
	  netWMStateAtom             = 34,
	  netWMStateFullScreenAtom   = 35,
          netSystemTrayOpcodeAtom    = 36,
          netSystemTrayMsgDataAtom   = 37,
          netWorkAreaAtom            = 38,
          utf8StringAtom             = 39,
          xEmbedAtom                 = 40,
          xEmbedInfoAtom             = 41,
          cardinalAtom               = 42,
          windowAtom                 = 43,
          targetsAtom                = 44,

          atomCount                  = 45
        };

#if defined(HAVE_LIB_DBUS)
        class DBusWatchEntry
        {
        public:
          DBusWatch *watch;
        };

        class DBusTimeoutEntry
        {
        public:
          DBusTimeout *timeout;
        };
#endif

#if defined(HAVE_LIB_GSTREAMER)
      public:
        class GstMsg : public ::Lum::Base::ResyncMsg
        {
        public:
          GstMessage *message;
        };

      private:
        class GstListener
        {
        public:
          bool                  async;
          GstElement            *element;
          Lum::Model::ActionRef action;
        };

#endif
      public:
        Atom atoms[atomCount];

      private:
        Cursor                    sleepCursor;
        Cursor                    popCursor;
        Cursor                    dndCursor;
        Cursor                    copyCursor;
        Cursor                    moveCursor;
        Cursor                    linkCursor;

        std::list<Tray*>          trayList;
        std::list<Window*>        winList;
        Window                    *currentWin;

        Lum::Base::DnDObject      *selectObject;
        Lum::Base::DnDObject      *querySelectObject;
        Lum::Base::DnDObject      *queryClipboardObject;
        bool                      selClearPend;

        //::Lum::OS::Display::Timer contextTimer;
        bool                      contextHelp;

        //Sleep sleepList;
        //Channel channelList;

        Window*                   dropWindow;

        std::wstring              clipboard;

        double                    dpi;

        bool                      exit;

        int                       signalPipe[2];

#if defined(HAVE_LIBSM)
        SmcConn                   smSession;
        IceConn                   iceSession;
        int                       iceFd;
#endif

        //::Lum::OS::Display::Object dragObject;
        //::Lum::Base::DragDrop::DnDDataInfo dragInfo;
        //int dndAction;
        //int dragX;
        //int dragY;
        //bool dragging;
        //bool dragStart;

      public:
        ::Window                  appWindow;
        int                       scrNum;
        ::Display                 *display;
        Visual                    *visual;
        Colormap                  colorMap;
        XIM                       xim;
#if defined(HAVE_LIB_DBUS)
        DBusConnection            *dbusSession;
        DBusConnection            *dbusSystem;
        std::list<DBusWatchEntry>   dbusWatches;
        std::list<DBusTimeoutEntry> dbusTimeouts;
#endif
#if defined(HAVE_LIB_GSTREAMER)
        bool                      gstSyncSet;
        ::Lum::OS::Mutex          gstMutex;
        std::list<GstMessage*>    gstMessages;
        std::list<GstListener>    gstListener;
#endif
      public:
        Display();

        double GetDPI() const;

        void Beep();

        FontRef GetFontInternal(FontType type, size_t size) const;
        //::Lum::OS::Display::FontList GetFontList();

        bool AllocateColor(double red, double green, double blue,
                           OS::Color& color);
        bool AllocateNamedColor(const std::string& name,
                                OS::Color& color);
        void FreeColor(OS::Color color);
        //Sleep AddSleep(::Lum::OS::Object::MsgObject object);
        //void RemoveSleep(::Lum::Base::Display::Sleep sleep);
        //Channel AddChannel(Channel channel, unsigned long ops, ::Lum::Base::Object::MsgObject object);
        //void RemoveChannel(::Lum::OS::Display::Channel channel);

        bool Open();
        void Close();

        bool RegisterSelection(Lum::Base::DnDObject* object, OS::Window* window);
        void CancelSelection();
        ::Lum::Base::DnDObject* GetSelectionOwner() const;
        bool QuerySelection(OS::Window* window, Lum::Base::DnDObject* object);

        bool SetClipboard(const std::wstring& content);
        std::wstring GetClipboard() const;
        void ClearClipboard();
        bool HasClipboard() const;

        void ReinitWindows();

        //void Receive(::Lum::Base::Object::Message message);
        void PutBackEvent(OS::Event* event, OS::Window* destWin);
        void EventLoop();
        void SignalEventLoop();
        void Exit();

        bool GetMousePos(int& x, int& y) const;

#if defined(HAVE_LIBSM)
        //Session Management
        void CallbackDie(SmcConn smc_conn, SmPointer client_data);
        void CallbackSaveYourself(SmcConn smc_conn, SmPointer client_data,
                                  int save_style, Bool shutdown,
                                  int interact_style,
                                  Bool fast);
        void CallbackShutdownCancelled(SmcConn smc_conn, SmPointer client_data);
        void CallbackSaveComplete(SmcConn smc_conn, SmPointer client_data);
        void CallbackICEIOError(IceConn connection);
#endif

#if defined(HAVE_LIB_DBUS)
        DBusConnection *InitiateDBusConnection(DBusBusType busType);
#endif

#if defined(HAVE_LIB_GSTREAMER)
        void AddGstListener(GstElement* element, ::Lum::Model::Action* action, bool async=true);
        void RemoveGstListener(Model::Action* action);
        void HandleGstMessage(GstMessage *message);
#endif
      private:
        void EnlargeUCS2Buffer(int len);

        void SetUTF8Property(Window* window, Atom property, std::wstring value);
        void SetAtomProperty(Window* window, Atom property, Atom value);
        void SetCardinalProperty(Window* window, Atom property, int value);
        void SetEmbedInfoProperty(::Window window);

        void SendNetSystemTrayRequestDock(::Window window);
        void SendNetSystemTrayBaloonMessage(Window* window);

        Window* GetWindowOnScreen(int rX, int rY, int cX, int cY);
        Window* GetWindow(::Window window);
        Tray* GetTray(::Window window);

        void StopContextHelp();
        void RestartContextHelp();
        void StartContextHelp();

        void AddWindow(Window* w);
        void RemoveWindow(Window* w);

        void AddTray(Tray* tray);
        void RemoveTray(Tray* tray);

        void HandleXSelectionNotify(const XSelectionEvent& event);
        void HandleXSelectionRequest(const XSelectionRequestEvent& event);

        void Flush();
        void CheckSleeps();
        void GetEvent();
        bool Wait();

      public:
        bool WaitTimedForX11Event(::Window window, int eventType, XEvent& event) const;
      };
    }
  }
}

#endif
