/*
  This source is part of the Illumination library
  Copyright (C) 2005  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/DateSelect.h>

#include <Lum/DateView.h>
#include <Lum/PopupGroup.h>

namespace Lum {
  static DateSelect::Prefs *prefs= new DateSelect::Prefs();

  DateSelect::Prefs::Prefs()
  : PopupControl::Prefs(L"DateSelect")
  {
    // no code
  }

  DateSelect::DateSelect()
  : PopupControl(new DateView()),popup(NULL)
  {
    SetPrefs(Lum::prefs);

    SetCanFocus(true);
    RequestFocus();
  }

  DateSelect::~DateSelect()
  {
    // no code
  }

  DateSelect::Popup::Popup(DateSelect *select)
  : select(select),
    picker(new DatePicker())
  {
    AttachModel(picker->GetSelectAction());
  }

  DateSelect::Popup::~Popup()
  {
    UnattachModel(picker->GetSelectAction());
  }

  void DateSelect::Popup::PreInit()
  {
    PopupGroup *container;

    container=new PopupGroup();

    picker->SetFlex(true,true);
    picker->SetModel(select->GetModel());

    container->SetMain(picker);

    SetTop(container);

    Dialog::PreInit();
  }

  void DateSelect::Popup::Resync(Base::Model* model, const Base::ResyncMsg& msg)
  {
    if (model==picker->GetSelectAction() && picker->GetSelectAction()->IsFinished()) {
      select->GetModel()->Save();
      Exit();
    }

    Dialog::Resync(model,msg);
  }

  void DateSelect::OpenPopup()
  {
    GetModel()->Push();

    popup=new Popup(this);
    popup->SetType(OS::Window::typePopup);
    popup->SetParent(GetWindow());
    popup->SetReference(this);

    if (popup->Open()) {
      popup->EventLoop();
      popup->Close();
    }

    delete popup;
    popup=NULL;

    GetModel()->Pop();
  }

  void DateSelect::Resync(Base::Model* model, const Base::ResyncMsg& msg)
  {
    if (model==popupAction && popupAction->IsFinished()) {
      OpenPopup();
    }

    PopupControl::Resync(model,msg);
  }
}

