/*
  This source is part of the Illumination library
  Copyright (C) 2007 Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Toggle.h>

#include <Lum/OS/Display.h>

#include <Lum/Text.h>

namespace Lum {

  static Toggle::Prefs *prefs=new ::Lum::Toggle::Prefs();

  Toggle::Prefs::Prefs()
  : State::Prefs(L"Toggle")
  {
    // no code
  }

  void Toggle::Prefs::Initialize()
  {
    State::Prefs::Initialize();

    background=OS::display->GetFill(OS::Display::buttonBackgroundFillIndex);
    frame=OS::display->GetFrame(OS::Display::buttonFrameIndex);
  }

  Toggle::Toggle()
   : label(NULL)
  {
    SetPrefs(::Lum::prefs);
  }

  Toggle::~Toggle()
  {
    delete label;
  }

  void Toggle::SetLabel(Object *label)
  {
    assert(label!=NULL);

    delete this->label;

    this->label=label;
    this->label->SetParent(this);
  }

  void Toggle::SetLabel(const std::wstring& label)
  {
    Text *text;

    text=new Text(label);
    text->SetParent(this);
    text->SetFlex(true,true);
    text->SetAlignment(Text::centered);

    SetLabel(text);
  }

  void Toggle::CalcSize()
  {
    minWidth=2*OS::display->GetSpaceHorizontal(OS::Display::spaceObjectBorder);
    minHeight=2*OS::display->GetSpaceVertical(OS::Display::spaceObjectBorder);

    width=minWidth;
    height=minHeight;

    if (label!=NULL) {
      label->CalcSize();

      minWidth+=label->GetOMinWidth();
      minHeight+=label->GetOMinHeight();

      width+=label->GetOWidth();
      height+=label->GetOHeight();
    }

    State::CalcSize();
  }

  void Toggle::Layout()
  {
    if (label!=NULL) {
      label->Resize(width-2*OS::display->GetSpaceHorizontal(OS::Display::spaceObjectBorder),
                    height-2*OS::display->GetSpaceVertical(OS::Display::spaceObjectBorder));

      label->Move(x+(width-label->GetOWidth())/2,
                  y+(height-label->GetOHeight())/2);
    }

    State::Layout();
  }

  void Toggle::DrawContent(int x, int y, size_t w, size_t h)
  {
    DrawBackground(x,y,w,h);

    if (label!=NULL) {
      label->Draw(x,y,w,h);
    }
  }
}
