/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Boolean.h>

#include <Lum/OS/Display.h>

namespace Lum {

  static Boolean::Prefs *prefs=new ::Lum::Boolean::Prefs();

  Boolean::Prefs::Prefs()
  : ImageState::Prefs(L"Boolean")
  {
    // no code
  }

  void Boolean::Prefs::Initialize()
  {
    ImageState::Prefs::Initialize();

    image=OS::display->GetImage(OS::Display::checkImageIndex);
  }

  Boolean::Boolean()
  {
    SetPrefs(::Lum::prefs);
  }
}
