/*
  This source is part of the Illumination library
  Copyright (C) 2005  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/ColorChooser.h>

#include <Lum/Base/L10N.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/ColorView.h>
#include <Lum/Panel.h>
#include <Lum/RGBControl.h>
#include <Lum/Space.h>
#include <Lum/WindowGroup.h>

namespace Lum {
  namespace Dlg {
    ColorChooser::ColorChooser(Model::Color* color)
    : color(color),
      okAction(new Lum::Model::Action)
    {
      AttachModel(okAction);
      AttachModel(GetClosedAction());
    }

    ColorChooser::~ColorChooser()
    {
      UnattachModel(GetClosedAction());
      UnattachModel(okAction);
    }

    void ColorChooser::PreInit()
    {
      Button      *button;
      ButtonRow   *row;
      ColorView   *colorView;
      Panel       *vPanel,*hPanel;
      RGBControl  *rgb;
      WindowGroup *wGroup;

      wGroup=new Lum::WindowGroup();
      wGroup->SetFlex(true,false);

      vPanel=new Lum::VPanel();
      vPanel->SetFlex(true,false);

      hPanel=new Lum::HPanel();
      hPanel->SetFlex(true,false);

      colorView=new Lum::ColorView();
      colorView->SetFlex(true,true);
      colorView->SetModel(color);
      hPanel->Add(colorView);

      hPanel->Add(new HSpace());

      rgb=new Lum::RGBControl();
      rgb->SetModel(color);
      hPanel->Add(rgb);

      vPanel->Add(hPanel);

      vPanel->Add(new VSpace());

      row=new Lum::ButtonRow();
      row->SetFlex(true,false);

      button=new Lum::Button;
      button->SetFlex(true,true);
      button->RequestFocus();
      button->SetModel(okAction);
      button->SetText(_ld(dlgButtonOk));
      button->SetType(Lum::Button::typeCommit);
      row->Add(button);

      button=new Lum::Button;
      button->SetFlex(true,true);
      button->RequestFocus();
      button->SetModel(GetClosedAction());
      button->SetText(_ld(dlgButtonCancel));
      button->SetType(Lum::Button::typeCancel);
      row->Add(button);

      vPanel->Add(row);

      wGroup->SetMain(vPanel);

      SetTop(wGroup);

      Dialog::PreInit();
    }

    void ColorChooser::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
    {
      if (model==okAction && okAction->IsFinished()) {
        color->Save();
        Exit();
      }
      else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
        Exit();
      }
      else {
        Dialog::Resync(model,msg);
      }
    }

    void ColorChooser::GetColor(OS::Window* parent,
                                Model::Color* color)
    {
      assert(color!=NULL);

      ColorChooser *dlg;

      color->Push();

      dlg=new ColorChooser(color);
      dlg->SetParent(parent);
      dlg->SetTitle(L""/*caption*/);

      if (dlg->Open()) {
        dlg->EventLoop();
        dlg->Close();
      }

      delete dlg;

      color->Pop();
    }
  }
}
