#ifndef LUM_OS_X11_GTKTHEME_H
#define LUM_OS_X11_GTKTHEME_H

/*
  This source is part of the Illumination library
  Copyright (C) 2006  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <gtk/gtk.h>

#include <Lum/OS/Base/Theme.h>

#include <Lum/OS/Display.h>
#include <Lum/OS/DrawInfo.h>
#include <Lum/OS/Fill.h>
#include <Lum/OS/Frame.h>
#include <Lum/OS/Image.h>

namespace Lum {
  namespace OS {
    namespace X11 {

      struct GtkWidgets
      {
        enum GtkStyles {
          gtkStyleWindow       =  0,
          gtkStyleColumn       =  1,
          gtkStyleColumnLeft   =  2,
          gtkStyleColumnMiddle =  3,
          gtkStyleColumnRight  =  4,

          gtkStyleButton       =  5,
          gtkStyleToolbar      =  6,
          gtkStyleToolButton   =  7,
          gtkStyleEdit         =  8,
          gtkStyleProgress     =  9,
          gtkStyleHKnob        = 10,
          gtkStyleVKnob        = 11,
          gtkStyleCheck        = 12,
          gtkStyleRadio        = 13,
          gtkStyleRadio2       = 14,
          gtkStyleTab          = 15,
          gtkStyleList         = 16,
          gtkStyleComboBox     = 17,
          gtkStyleEditComboBox = 18,
          gtkStyleHLine        = 19,
          gtkStyleVLine        = 20,
          gtkStyleHScale       = 21,
          gtkStyleVScale       = 22,
          gtkStyleStatus       = 23,
          gtkStyleScrolled     = 24,
          gtkStyleDummy        = 25,

          gtkStyleMenuBar      = 26,
          gtkStyleMenuPullDown = 27,
          gtkStyleMenu         = 28,
          gtkStyleMenuItem     = 29,

          gtkStyleMax          = 30
        };

      public:
        ::GtkWidget     *layout;
        ::GtkAdjustment *adjustment;
        ::GtkWidget     *widget[gtkStyleMax];
        ::GdkPixbuf     *positiveIcon;
        ::GdkPixbuf     *negativeIcon;
        ::GdkPixbuf     *defaultIcon;
        ::GdkPixbuf     *helpIcon;
        ::GdkPixbuf     *closeIcon;

      public:
        GtkWidgets();
        ~GtkWidgets();


        GtkWidget* GetWidget(GtkStyles style) const;
        GtkStyle* GetStyle(GtkStyles style) const;
      };

      extern GtkWidgets *gtkWidgets;

      class GtkImage : public ::Lum::OS::Image
      {
      private:
        Display::ImageIndex image;
        size_t              width;
        size_t              height;

      public:
        GtkImage(Display::ImageIndex image);

        size_t GetWidth() const;
        size_t GetHeight() const;
        bool GetAlpha() const;
        unsigned long GetDrawCap() const;

        void Draw(::Lum::OS::DrawInfo *draw, int x, int y, size_t w, size_t h);
      };

      class GtkFill : public Fill
      {
      private:
        Display::FillIndex fill;

      public:
        GtkFill(Display::FillIndex fill);

        void Draw(::Lum::OS::DrawInfo* draw,
                  int xOff, int yOff, size_t width, size_t height,
                  int x, int y, size_t w, size_t h);
      };

      class GtkFrame : public Frame
      {
      private:
        Display::FrameIndex frame;

      public:
        GtkFrame(Display::FrameIndex frame);

        void Draw(::Lum::OS::DrawInfo* draw, int x, int y, size_t w, size_t h);
      };

      extern int GetWidgetStyleIntValue(GtkWidget *widget, const char* name);
      extern bool GetWidgetStyleBoolValue(GtkWidget *widget, const char* name);
      extern void GetWidgetStyleBorderValue(GtkWidget *widget, const char* name,
                                            int& left, int&right, int &top, int& bottom);

      class GtkTheme : public ::Lum::OS::Base::Theme
      {
      public:
        Color          helpBackgroundColor;
        Color          whiteColor;
        Color          blackColor;
        Color          shineColor;
        Color          shadowColor;

        ScrollKnobMode scrollKnobMode;

      public:
        GtkTheme(::Lum::OS::Display *display);
        ~GtkTheme();

        bool HasFontSettings() const;

        std::wstring GetProportionalFontName() const;
        size_t GetProportionalFontSize() const;

        std::wstring GetFixedFontName() const;
        size_t GetFixedFontSize() const;

        ScrollKnobMode GetScrollKnobMode() const;
        ToolbarPosition GetToolbarPosition() const;
        size_t GetMinimalButtonWidth() const;
        size_t GetFirstTabOffset() const;
        size_t GetLastTabOffset() const;
        size_t GetEntryHorizTextOffset() const;
        size_t GetEntryVertTextOffset() const;
      };

    }
  }
}

#endif
