#ifndef LUM_OS_BASE_THEME_H
#define LUM_OS_BASE_THEME_H

/*
  This source is part of the Illumination library
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/OS/Display.h>
#include <Lum/OS/DrawInfo.h>
#include <Lum/OS/Fill.h>
#include <Lum/OS/Frame.h>
#include <Lum/OS/Image.h>
#include <Lum/OS/Theme.h>

namespace Lum {
  namespace OS {
    namespace Base {

      class Theme : public OS::Theme
      {
      protected:
        Display   *display;
        Color     color[Display::colorCount];
        FillRef   fill[Display::fillCount];
        FrameRef  frame[Display::frameCount];
        ImageRef  image[Display::imageCount];

        FrameRef  emptyFrame;

        Color     fillColor[3];

      public:
        Theme(OS::Display *display);
        ~Theme();

        Color GetColor(Display::ColorIndex color) const;
        Fill* GetFill(Display::FillIndex fill) const;
        Frame* GetFrame(Display::FrameIndex frame) const;
        Image* GetImage(Display::ImageIndex image) const;

        void PushUniqueFill(OS::DrawInfo* draw, size_t index, size_t maximum);
        void PopUniqueFill(OS::DrawInfo* draw, size_t index, size_t maximum);
      };

      class DefaultTheme : public Theme
      {
      private:
        Color fillColors[Display::fillCount];

      public:
        Color shineColor;
        Color halfShineColor;
        Color halfShadowColor;
        Color shadowColor;

      public:
        DefaultTheme(OS::Display *display);
        ~DefaultTheme();

        bool HasFontSettings() const;

        std::wstring GetProportionalFontName() const;
        size_t GetProportionalFontSize() const;

        std::wstring GetFixedFontName() const;
        size_t GetFixedFontSize() const;

        ScrollKnobMode GetScrollKnobMode() const;
        ToolbarPosition GetToolbarPosition() const;
        size_t GetMinimalButtonWidth() const;
        size_t GetFirstTabOffset() const;
        size_t GetLastTabOffset() const;
        size_t GetEntryHorizTextOffset() const;
        size_t GetEntryVertTextOffset() const;
      };
    }
  }
}

#endif
