#include <Lum/Base/DragDrop.h>

namespace Lum {
  namespace Base {

    DnDType::DnDType(Type type, SubType subType)
    : type(type),subType(subType)
    {
      // no code
    }

    void DnDType::SetType(Type type, SubType subType)
    {
      this->type=type;
      this->subType=subType;
    }

    DnDType::Type DnDType::GetType() const
    {
      return type;
    }

    DnDType::SubType DnDType::GetSubType() const
    {
      return subType;
    }

    bool DnDType::Matches(Type type) const
    {
      return this->type==type;
    }

    bool DnDType::Matches(Type type, SubType subType) const
    {
      return this->type==type && this->subType==subType;
    }

    void DnDData::SetText(const std::wstring& text)
    {
      this->text=text;
    }

    std::wstring DnDData::GetText() const
    {
      return text;
    }

    DnDObject::~DnDObject()
    {
      // no code
    }

    bool DnDObject::GetDragTypes(DnDTypeList& types) const
    {
      return false;
    }

    bool DnDObject::GetDataOfType(DnDType type, DnDData& data) const
    {
      return false;
    }

    bool DnDObject::CanDrop(DnDTypeList& types, DnDAction action, DnDType& type)
    {
      return false;
    }

    bool DnDObject::Drop(const DnDType& type, DnDData& data, DnDAction action)
    {
      return false;
    }

    void DnDObject::Deselect()
    {
      // no code
    }
  }
}


