#ifndef LUM_OS_THEME_H
#define LUM_OS_THEME_H

/*
  This source is part of the Illumination library
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Private/ImportExport.h>

#include <Lum/OS/Color.h>
#include <Lum/OS/Display.h>
#include <Lum/OS/DrawInfo.h>
#include <Lum/OS/Fill.h>
#include <Lum/OS/Frame.h>
#include <Lum/OS/Image.h>

namespace Lum {
  namespace OS {

    /**
      A abstract base class for holding all information for theming a user interface.
    */
    class LUMAPI Theme
    {
    public:
      enum ScrollKnobMode {
        scrollKnobModeSingle,
        scrollKnobModeDouble
      };

      enum ToolbarPosition {
        toolbarTop,
        toolbarBottom
      };

    public:
      Theme(Display *display);
      virtual ~Theme();

      virtual bool HasFontSettings() const = 0;

      virtual std::wstring GetProportionalFontName() const = 0;
      virtual size_t GetProportionalFontSize() const = 0;

      virtual std::wstring GetFixedFontName() const = 0;
      virtual size_t GetFixedFontSize() const = 0;

      virtual Color GetColor(Display::ColorIndex color) const = 0;
      virtual Fill* GetFill(Display::FillIndex fill) const = 0;
      virtual Frame* GetFrame(Display::FrameIndex frame) const = 0;
      virtual Image* GetImage(Display::ImageIndex image) const = 0;

      virtual void PushUniqueFill(DrawInfo* draw, size_t index, size_t maximum) = 0;
      virtual void PopUniqueFill(DrawInfo* draw, size_t index, size_t maximum) = 0;

      virtual ScrollKnobMode GetScrollKnobMode() const = 0;
      virtual ToolbarPosition GetToolbarPosition() const = 0;
      virtual size_t GetMinimalButtonWidth() const = 0;
      virtual size_t GetFirstTabOffset() const = 0;
      virtual size_t GetLastTabOffset() const = 0;
      virtual size_t GetEntryHorizTextOffset() const = 0;
      virtual size_t GetEntryVertTextOffset() const = 0;
    };
  }
}

#endif
