#ifndef LUM_PREFS_BASE_H
#define LUM_PREFS_BASE_H

/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <string>

#include <Lum/Private/ImportExport.h>

#include <Lum/Config/Config.h>

namespace Lum {
  namespace Prefs {

    class LUMAPI Prefs
    {
    private:
      std::wstring name;

    public:
      Prefs(const std::wstring& name=L"");
      virtual ~Prefs();

      std::wstring GetName() const;

      virtual void Initialize() = 0;

      virtual void ReadConfig(::Lum::Config::Node *top);
      virtual void ReadTheme(::Lum::Config::Node *top);
    };

    extern void InitializePrefs(Prefs* dont);

    extern bool LoadConfig(const std::wstring& name);
    extern void ReadDisplayConfig();
    extern void ReadOthersConfig();

    extern bool LoadTheme(const std::wstring& name);
    extern void ReadDisplayTheme();
    extern void ReadOthersTheme();

    extern void FreeData();
    extern void FreePrefs();
  }
}

#endif
