#ifndef LUM_BASE_DRAGDROP_H
#define LUM_BASE_DRAGDROP_H

#include <string>
#include <vector>

#include <Lum/Base/Model.h>

namespace Lum {
  namespace Base {

    class LUMAPI DnDType
    {
    public:
      enum Type {
        none,

        application,
        audio,
        image,
        text,
        video
      };

      enum SubType {
        // none, application
        octectStream,

        // text
        plain
      };

    private:
      Type    type;
      SubType subType;

    public:
      DnDType(Type type, SubType subType);

      void SetType(Type type, SubType subType);

      Type GetType() const;
      SubType GetSubType() const;
      bool Matches(Type type) const;
      bool Matches(Type type, SubType subType) const;
    };

    typedef std::vector<DnDType> DnDTypeList;

    class LUMAPI DnDData
    {
    private:
      std::wstring text;

    public:
      // setter
      void SetText(const std::wstring& text);

      // getter
      std::wstring GetText() const;
    };

    /**
    DnDObject holds the data content that is part of a drag or drop
    transaction.
    */
    class LUMAPI DnDObject : public MsgObject
    {
    public:
      enum DnDAction {
        dndMove, // Data should be moved
        dndCopy, // Data should be copied
        dndLink, // Data should be linked or referenced
        dndInsert
      };

    public:
      virtual ~DnDObject();
      virtual bool GetDragTypes(DnDTypeList& types) const;
      virtual bool GetDataOfType(DnDType type, DnDData& data) const;
      virtual bool CanDrop(DnDTypeList& types, DnDAction action, DnDType& type);
      virtual bool Drop(const DnDType& type, DnDData& data, DnDAction action);
      virtual void Deselect();
    };
  }
}

#endif
