/*
* This file is part of IceBreaker
*
* Copyright (C) 2007 INdT - Instituto Nokia de Tecnologia
* http://www.indt.org/maemo
*
* This software is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* as published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA
*
*/

#include <stdio.h>
#include <gtk/gtk.h>
#include <startup_plugin.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

static GtkWidget *load_plugin      (void);
static void       unload_plugin    (void);
static void       write_config     (void);
static GtkWidget **load_menu       (guint *);
static void       update_menu      (void);

GConfClient *gcc = NULL;

static StartupPluginInfo plugin_info = {
  load_plugin,
  unload_plugin,
  write_config,
  load_menu,
  update_menu,
  NULL
};

static GameStartupInfo gs;
STARTUP_INIT_PLUGIN(plugin_info, gs, FALSE, FALSE)

static GtkWidget **
load_menu (guint *nitems) {
    return NULL;
}

static void 
update_menu (void)
{
    return;
}

static GtkWidget *
load_plugin (void)
{
  GtkWidget *game_vbox;

  g_type_init();
  gcc = gconf_client_get_default();

  game_vbox = gtk_vbox_new (TRUE, 0);
  g_assert (game_vbox);

  return game_vbox;
}

static void
unload_plugin (void)
{
}

static void 
write_config (void)
{
}
