#!/usr/bin/env python2.5
import hildon
import pygtk
pygtk.require('2.0')
import gtk

class i_am_free(hildon.Window):
	def __init__(self):
		hildon.Window.__init__(self)
		self.set_wmclass("i_am_free","i_am_free")
		gtk.set_application_name("I Am Free")
		#self.set_title("I Am Free")
	
		pixbuf = gtk.gdk.pixbuf_new_from_file("/usr/share/pixmaps/RichRed1-wide.jpg")
		#pixbuf = pixbuf.scale_simple(800, 480, gtk.gdk.INTERP_BILINEAR)
		image = gtk.image_new_from_pixbuf(pixbuf)
		self.add(image)
		
		menu = gtk.Menu()
		menu.set_title("I Am Free")
		menuitem = gtk.MenuItem("Quit")
		menuitem.connect("activate", self.on_quit) 
		menu.append(menuitem)
		
		self.set_menu(menu)
		self.connect("delete-event", self.on_quit)
		self.connect("key-press-event", self.on_key_press_event)
		self.connect("window-state-event", self.on_window_state)
	
		self._fullscreened = False

	def on_quit(self, menuitem, arg=None):
		gtk.main_quit()

	def on_key_press_event(self, widget, event):
		keyname = gtk.gdk.keyval_name(event.keyval)
		if keyname == 'F6':
			if self._fullscreened:
				self.unfullscreen()
			else:
				self.fullscreen()

	def on_window_state(self, client, event):
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self._fullscreened = True
		elif event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN == 0:
			self._fullscreened = False


o = i_am_free()
o.show_all()
o.fullscreen()
gtk.main()
