import gtk
import hildondesktop
import cairo
import gobject
import pango
import commands
import traceback

supports_alpha = False

class IPPlugin(hildondesktop.HomeItem):
	def __init__(self):
		hildondesktop.HomeItem.__init__(self)

		self.label = gtk.Label()
		self.label.set_use_markup(True)
		self.label.modify_font(pango.FontDescription ("Sans 16"))
		self.label.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#000"))
		self.label.modify_fg(gtk.STATE_NORMAL, gtk.gdk.color_parse("#fff"))
		self.label.set_text(self.get_ip())
		self.label.set_padding(15, 10)
#		self.label.set_padding(-1, -1)
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)

		self.connect("expose-event", self.expose)
		self.connect("screen-changed", self.screen_changed)
		self.add(self.label)
		self.show_all()

		# set a timeout to change the images
		self.timer = gobject.timeout_add(2000, self.update)
#		print "foreground timer", self.timer

		self.connect ("background", self.background)
		self.connect ("foreground", self.foreground)

	def expose(self, widget, event):
		cr = self.window.cairo_create()
		if supports_alpha == True:
			cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent
		else:
			cr.set_source_rgb(1.0, 1.0, 1.0) # Opaque white

		# Draw the background
		cr.set_operator(cairo.OPERATOR_SOURCE)
		cr.paint()

		# draw rounded rect
		width, height = self.allocation[2], self.allocation[3]

		#/* a custom shape, that could be wrapped in a function */
		x0 = 0   #/*< parameters like cairo_rectangle */
		y0 = 0

		radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */

		x1 = x0 + width
		y1 = y0 + height

		cr.move_to  (x0, y0 + radius)
		cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
		cr.line_to (x1 - radius, y0)
		cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
		cr.line_to (x1 , y1 - radius)
		cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
		cr.line_to (x0 + radius, y1)
		cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)

		cr.close_path ()

		cr.set_source_rgba (0.0, 0.0, 0.0, 0.5)
		cr.fill_preserve ()
		# cr.set_source_rgba (0.5, 0.5, 1.0, 0.8)
		# cr.stroke ()

	def screen_changed(self, widget, old_screen=None):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = widget.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
#			print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
#			print 'Your screen supports alpha channels!'
			supports_alpha = True

		# Now we have a colormap appropriate for the screen, use it
		widget.set_colormap(colormap)

		return False

	def background(self, widget, data=None):
		#Avoid refresh when applet is in background
		self.label.set_text("refreshing")
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)		
		if self.timer != None:
			gobject.source_remove(self.timer)
			self.timer = None

	def foreground(self, widget, data=None):
		self.label.set_text(self.get_ip())
		self.timer = gobject.timeout_add(2000, self.update)
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
#		print "foreground timer", self.timer

	def unrealize(self, widget, date=None):
		# cancel timeout
		v = gobject.source_remove(self.timer)
#		print "canceled homeip timeout:", v

	def update(self):
		self.label.set_text(self.get_ip())
		self.label.set_size_request(-1,-1)
		self.set_size_request(-1,-1)
		self.timer = gobject.timeout_add(2000, self.update)

	def get_ip(self):
		#CPU Speed
		text = ""
		receive = 0
		devs = commands.getoutput("cat /proc/net/dev | awk '{print $2}'")
		devs = devs.rsplit('\n')
		for dev in devs: 
			if dev.isdigit()==True:	
				receive = receive + int(dev)
		transmit = 0
		devs = commands.getoutput("cat /proc/net/dev | awk '{print $10}'")
		devs = devs.rsplit('\n')
		for dev in devs:
			if dev.isdigit()==True:
				transmit = transmit + int(dev)
		text = 'Up : '+(transmit/1024).__str__() + ' kB\n' + 'Down : '+(receive/1024).__str__() + ' kB'
		return text

def hd_plugin_get_objects():
	plugin = IPPlugin()
	return [plugin]

