#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "support.h"

#include <libintl.h>
#include <locale.h>
#define _(String) gettext(String)

gchar *imageDir = NULL;

void setGrcmImageDir() {
	if (!imageDir) {
		imageDir = g_strconcat(g_get_home_dir(), "/MyDocs/.images/", PACKAGE, NULL);
	}
}

gchar *getGrcmImageDIr() {
	setGrcmImageDir();
	return imageDir;
}

gchar *getIconFullPath(gchar *fileName) {
	return g_strconcat(getGrcmImageDIr(), "/", fileName, NULL);
}

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        const gchar     *filename)
{
  GtkWidget *pixmap;
  gchar *pathName;

	if (!filename || !filename[0])
		return gtk_image_new ();

	if (g_path_is_absolute (filename)) {
		pathName = g_strdup(filename);
	} else {
		setGrcmImageDir();
		pathName = g_strconcat(imageDir, "/", filename, NULL);
	}

  if (!g_file_test(pathName, G_FILE_TEST_IS_REGULAR))
    {
	g_warning (_("Couldn't find pixmap file: %s in %s"), filename, imageDir);
	g_free(pathName);
	return gtk_image_new ();
    }

  pixmap = gtk_image_new_from_file (pathName);
  g_free (pathName);
  return pixmap;
}

/* This is an internally used function to create pixmaps. */
GdkPixbuf*
create_pixbuf                          (const gchar     *filename)
{
  gchar *pathName = NULL;
  GdkPixbuf *pixbuf;
  GError *error = NULL;

  if (!filename || !filename[0])
      return NULL;

  if (g_path_is_absolute (filename)) {
	  pathName = g_strdup(filename);
  } else {
	setGrcmImageDir();
	pathName = g_strconcat(imageDir, "/", filename, NULL);
  }

  if (!g_file_test(pathName, G_FILE_TEST_IS_REGULAR))
    {
	g_warning (_("Couldn't find pixmap file: %s : %s"), filename, pathName);
	g_free (pathName);
	return NULL;
    }

  pixbuf = gdk_pixbuf_new_from_file (pathName, &error);
  if (!pixbuf)
    {
      fprintf (stderr, "Failed to load pixbuf file: %s: %s\n",
               pathName, error->message);
      g_error_free (error);
    }
  g_free (pathName);
  return pixbuf;
}

