#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#if HILDON == 1
#include <hildon/hildon.h>
#include <hildon/hildon-file-chooser-dialog.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#endif

#include <libintl.h>
#include <locale.h>
#define _(String) gettext(String)

GtkMenu *create_menus(UIComponents *uic) {
	GtkWidget *menuBar;
	GtkWidget *menuGroup;
	GtkWidget *menuItem;
	GtkWidget *image;
	
	menuBar = gtk_menu_new ();
	
	menuGroup = gtk_menu_new();
	menuItem = gtk_menu_item_new_with_label (_("File"));
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuItem), menuGroup);
	gtk_menu_append(menuBar, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("New Host"));
	image = gtk_image_new_from_file ("grcm/host-16.png");
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_file_new_connection_activate), (gpointer) uic);
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("New Type"));
	image = gtk_image_new_from_stock (GTK_STOCK_NEW, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_file_new_type_menu_activate), (gpointer) uic);
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem =  gtk_separator_menu_item_new();
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("Quit"));
	image = gtk_image_new_from_stock (GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_file_quit_activate), (gpointer) uic);
	gtk_menu_append(menuGroup, menuItem);
	
	menuGroup = gtk_menu_new();
	menuItem = gtk_menu_item_new_with_label (_("Edit"));
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuItem), menuGroup);
	gtk_menu_append(menuBar, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("Delete"));
	image = gtk_image_new_from_stock (GTK_STOCK_DELETE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_edit_delete_menu_activate), (gpointer) uic);
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem =  gtk_separator_menu_item_new();
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("Properties"));
	image = gtk_image_new_from_stock (GTK_STOCK_PROPERTIES, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_edit_properties_activate), (gpointer) uic);
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem =  gtk_separator_menu_item_new();
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("Preferences"));
	image = gtk_image_new_from_stock (GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_edit_preferences_activate), (gpointer) uic);
	gtk_menu_append(menuGroup, menuItem);
	
	menuGroup = gtk_menu_new();
	menuItem = gtk_menu_item_new_with_label (_("Help"));
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuItem), menuGroup);
	gtk_menu_append(menuBar, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("Help"));
	image = gtk_image_new_from_stock (GTK_STOCK_HELP, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
/*
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_help_activate), (gpointer) uic);
*/
	gtk_menu_append(menuGroup, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("About"));
	image = gtk_image_new_from_stock (GTK_STOCK_ABOUT, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_about_activate), (gpointer) uic);
	gtk_menu_append(menuGroup, menuItem);
	
	
	return GTK_MENU(menuBar);
}

GtkWidget*
create_MainWindow (GtkWidget *MainWindow, UIComponents *uic)
{
  GdkPixbuf *MainWindow_icon_pixbuf;
  GtkWidget *toolbar1;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *TbConnectionBtn;
  GtkWidget *TbExecuteBtn;
  GtkWidget *TbPropertiesBtn;
  GtkWidget *TbDeleteBtn;
  GtkWidget *main_window_srolled_window;
  GtkListStore *store;

  MainWindow_icon_pixbuf = create_pixbuf ("grcm.png");
  if (MainWindow_icon_pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (MainWindow), MainWindow_icon_pixbuf);
      gdk_pixbuf_unref (MainWindow_icon_pixbuf);
    }

  hildon_window_set_menu (HILDON_WINDOW(MainWindow), create_menus (uic));

  toolbar1 = gtk_toolbar_new ();
  gtk_widget_show (toolbar1);
	hildon_window_add_toolbar (HILDON_WINDOW(MainWindow), GTK_TOOLBAR(toolbar1));
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar1), GTK_TOOLBAR_ICONS);

  tmp_toolbar_icon = create_pixmap (MainWindow, "host.png");
  TbConnectionBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("New Host"),
                                _("Add a new host."), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (TbConnectionBtn);

  tmp_toolbar_icon = create_pixmap (MainWindow, "connect.png");
  TbExecuteBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Connect"),
                                _("Connect to selected host."), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (TbExecuteBtn);

  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar1));

  tmp_toolbar_icon = gtk_image_new_from_stock (GTK_STOCK_PROPERTIES, gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar1)));
  TbPropertiesBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Properties"),
                                _("Edit a hosts Properties"), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (TbPropertiesBtn);

  tmp_toolbar_icon = gtk_image_new_from_stock (GTK_STOCK_DELETE, gtk_toolbar_get_icon_size (GTK_TOOLBAR (toolbar1)));
  TbDeleteBtn = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Delete"),
                                _("Delete host."), NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_show (TbDeleteBtn);

  main_window_srolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (main_window_srolled_window);
  gtk_container_add (GTK_CONTAINER (MainWindow), main_window_srolled_window);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (main_window_srolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  store = gtk_list_store_new(N_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_POINTER);
  uic->MainList = gtk_icon_view_new_with_model (GTK_TREE_MODEL(store));
  gtk_icon_view_set_text_column(GTK_ICON_VIEW(uic->MainList), LABEL_COLUMN);
  gtk_icon_view_set_pixbuf_column(GTK_ICON_VIEW(uic->MainList), ICON_COLUMN);
  gtk_widget_show (uic->MainList);
  gtk_container_add (GTK_CONTAINER (main_window_srolled_window), uic->MainList);
  gtk_widget_set_events (uic->MainList, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

  g_signal_connect (G_OBJECT (MainWindow), "delete_event",
		      G_CALLBACK (on_MainWindow_delete_event), (gpointer) uic);
  g_signal_connect (G_OBJECT (TbConnectionBtn), "clicked",
		      G_CALLBACK (on_TbConnectionBtn_clicked), (gpointer) uic);
  g_signal_connect (G_OBJECT (TbExecuteBtn), "clicked",
                      G_CALLBACK (on_TbExecuteBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (TbPropertiesBtn), "clicked",
                      G_CALLBACK (on_TbPropertiesBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (TbDeleteBtn), "clicked",
                      G_CALLBACK (on_TbDeleteBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (uic->MainList), "button_press_event",
                      G_CALLBACK (on_MainList_button_press_event),
                      (gpointer) uic);

  return MainWindow;
}

GtkWidget*
create_AboutWindow (void)
{
  const gchar *authors[] = {
    "Steve Przepiora <steve@przepiora.org>",
    "Fred Lefevere-Laoide",
    NULL
  };
  const gchar *documenters[] = { NULL };
  /* TRANSLATORS: Replace this string with your names, one name per line. */
  gchar *translators = _("translator_credits");
  GtkWidget *AboutWindow;

  if (!strcmp (translators, "translator_credits"))
    translators = NULL;
  AboutWindow = gtk_about_dialog_new ();
  gtk_about_dialog_set_name (GTK_ABOUT_DIALOG(AboutWindow), "Connection Manager");
  gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(AboutWindow), VERSION);
  gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(AboutWindow), _("(C)2003 by Steve Przepiora\n(C)2007 by Fred Lefevere-Laoide"));
  gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(AboutWindow), _("Remote Connection Manager is a highly configurable application that stores information about remote connections."));
  gtk_about_dialog_set_authors(GTK_ABOUT_DIALOG(AboutWindow), authors);
  gtk_about_dialog_set_documenters(GTK_ABOUT_DIALOG(AboutWindow), documenters);
  gtk_about_dialog_set_translator_credits(GTK_ABOUT_DIALOG(AboutWindow), translators);

  return AboutWindow;
}

GtkWidget*
create_PropertiesWindow (UIComponents *uic)
{
  GtkWidget *PropertiesWindow;
  GtkWidget *dialog_vbox1;
  GtkWidget *table5;
  GtkWidget *frame4;
  GtkWidget *vbox7;
  GtkWidget *table7;
  GtkWidget *label22;
  GtkWidget *label23;
  GtkWidget *label20;
  GtkWidget *frame3;
  GtkWidget *table6;
  GtkWidget *hseparator1;
  GtkWidget *label40;
  GtkWidget *label19;
  GtkWidget *dialog_action_area1;
  GtkWidget *PropertyOkBtn;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  PropertiesWindow = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (PropertiesWindow), _("Grcm Preferences"));
  gtk_window_set_modal (GTK_WINDOW (PropertiesWindow), TRUE);

  dialog_vbox1 = GTK_DIALOG (PropertiesWindow)->vbox;
  gtk_widget_show (dialog_vbox1);

  table5 = gtk_table_new (2, 3, FALSE);
  gtk_widget_show (table5);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table5, TRUE, TRUE, 5);
  gtk_table_set_row_spacings (GTK_TABLE (table5), 5);

  frame4 = gtk_frame_new (NULL);
  gtk_widget_show (frame4);
  gtk_table_attach (GTK_TABLE (table5), frame4, 0, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 3, 3);

  vbox7 = gtk_vbox_new (FALSE, 2);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (frame4), vbox7);
  gtk_container_set_border_width (GTK_CONTAINER (vbox7), 3);

  table7 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table7);
  gtk_box_pack_start (GTK_BOX (vbox7), table7, FALSE, FALSE, 0);

  uic->PropertyTerminalEntry = gtk_entry_new ();
  gtk_widget_show (uic->PropertyTerminalEntry);
  gtk_table_attach (GTK_TABLE (table7), uic->PropertyTerminalEntry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_tooltips_set_tip (tooltips, uic->PropertyTerminalEntry, _("Your path will be searched for this program when a terminal is needed."), NULL);

  uic->PropertyTerminalArgumentsEntry = gtk_entry_new ();
  gtk_widget_show (uic->PropertyTerminalArgumentsEntry);
  gtk_table_attach (GTK_TABLE (table7), uic->PropertyTerminalArgumentsEntry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_tooltips_set_tip (tooltips, uic->PropertyTerminalArgumentsEntry, _("Enter any arguments for the terminal program."), NULL);

  label22 = gtk_label_new (_("Terminal Program"));
  gtk_widget_show (label22);
  gtk_table_attach (GTK_TABLE (table7), label22, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_label_set_justify (GTK_LABEL (label22), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label22), 0, 0.5);

  label23 = gtk_label_new (_("Arguments"));
  gtk_widget_show (label23);
  gtk_table_attach (GTK_TABLE (table7), label23, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_label_set_justify (GTK_LABEL (label23), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label23), 0, 0.5);

  label20 = gtk_label_new (_("Terminal"));
  gtk_widget_show (label20);
  gtk_frame_set_label_widget (GTK_FRAME (frame4), label20);
  gtk_label_set_justify (GTK_LABEL (label20), GTK_JUSTIFY_LEFT);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_table_attach (GTK_TABLE (table5), frame3, 0, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  table6 = gtk_table_new (4, 2, TRUE);
  gtk_widget_show (table6);
  gtk_container_add (GTK_CONTAINER (frame3), table6);
  gtk_container_set_border_width (GTK_CONTAINER (table6), 3);

  uic->PropertyShowUserNames = gtk_check_button_new_with_mnemonic (_("Show user names"));
  gtk_widget_show (uic->PropertyShowUserNames);
  gtk_table_attach (GTK_TABLE (table6), uic->PropertyShowUserNames, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, uic->PropertyShowUserNames, _("Select to show usernames in the main display window."), NULL);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_set_name (hseparator1, "hseparator1");
  gtk_widget_show (hseparator1);
  gtk_table_attach (GTK_TABLE (table6), hseparator1, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  uic->PropertyAscendingSort = gtk_check_button_new_with_mnemonic (_("Sort Ascending"));
  gtk_widget_show (uic->PropertyAscendingSort);
  gtk_table_attach (GTK_TABLE (table6), uic->PropertyAscendingSort, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_tooltips_set_tip (tooltips, uic->PropertyAscendingSort, _("Sort connections in ascending order."), NULL);

  uic->PropertyTypeSort = gtk_check_button_new_with_mnemonic (_("Sort Type"));
  gtk_widget_show (uic->PropertyTypeSort);
  gtk_table_attach (GTK_TABLE (table6), uic->PropertyTypeSort, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_tooltips_set_tip (tooltips, uic->PropertyTypeSort, _("Sort connections by connection type."), NULL);

  uic->PropertyNoneSort = gtk_check_button_new_with_mnemonic (_("Do Not Sort"));
  gtk_widget_show (uic->PropertyNoneSort);
  gtk_table_attach (GTK_TABLE (table6), uic->PropertyNoneSort, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_tooltips_set_tip (tooltips, uic->PropertyNoneSort, _("Do not sort the connections."), NULL);

  uic->PropertyDescendingSort = gtk_check_button_new_with_mnemonic (_("Sort Descending"));
  gtk_widget_show (uic->PropertyDescendingSort);
  gtk_table_attach (GTK_TABLE (table6), uic->PropertyDescendingSort, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_tooltips_set_tip (tooltips, uic->PropertyDescendingSort, _("Sort connections in descending order."), NULL);

  label40 = gtk_label_new ("");
  gtk_widget_show (label40);
  gtk_table_attach (GTK_TABLE (table6), label40, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label40), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label40), 0, 0.5);

  label19 = gtk_label_new (_("Display"));
  gtk_widget_show (label19);
  gtk_frame_set_label_widget (GTK_FRAME (frame3), label19);
  gtk_label_set_justify (GTK_LABEL (label19), GTK_JUSTIFY_LEFT);

  dialog_action_area1 = GTK_DIALOG (PropertiesWindow)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  PropertyOkBtn = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_widget_show (PropertyOkBtn);
  gtk_dialog_add_action_widget (GTK_DIALOG (PropertiesWindow), PropertyOkBtn, GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (PropertyOkBtn, GTK_CAN_DEFAULT);

  g_signal_connect (G_OBJECT (uic->PropertyAscendingSort), "toggled",
                      G_CALLBACK (on_PropertyAscendingSort_toggled),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (uic->PropertyTypeSort), "toggled",
                      G_CALLBACK (on_PropertyTypeSort_toggled),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (uic->PropertyNoneSort), "toggled",
                      G_CALLBACK (on_PropertyNoneSort_toggled),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (uic->PropertyDescendingSort), "toggled",
                      G_CALLBACK (on_PropertyDescendingSort_toggled),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (PropertyOkBtn), "clicked",
                      G_CALLBACK (on_PropertyCloseBtn_clicked),
                      (gpointer) uic);

  return PropertiesWindow;
}

GtkWidget*
create_MainWindowPopupMenu (UIComponents *uic, gboolean sensitive)
{
	GtkWidget *MainWindowPopupMenu;
	GtkWidget *menuItem;
	GtkWidget *image;
	
	MainWindowPopupMenu = gtk_menu_new ();
	
	menuItem = gtk_image_menu_item_new_with_label (_("Connect"));
	image = gtk_image_new_from_file ("grcm/connect-16.png");
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_popup_execute_activated), (gpointer) uic);
	gtk_menu_append(MainWindowPopupMenu, menuItem);
	gtk_widget_set_sensitive(menuItem, sensitive);

	menuItem = gtk_image_menu_item_new_with_label (_("Edit"));
	image = gtk_image_new_from_stock (GTK_STOCK_EDIT, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_popup_edit_activated), (gpointer) uic);
	gtk_menu_append(MainWindowPopupMenu, menuItem);
	gtk_widget_set_sensitive(menuItem, sensitive);

	menuItem =  gtk_separator_menu_item_new();
	gtk_menu_append(MainWindowPopupMenu, menuItem);
	
	menuItem = gtk_image_menu_item_new_with_label (_("Delete"));
	image = gtk_image_new_from_stock (GTK_STOCK_DELETE, GTK_ICON_SIZE_MENU);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuItem), image);
	g_signal_connect (G_OBJECT (menuItem), "activate", G_CALLBACK (on_popup_delete_activated), (gpointer) uic);
	gtk_menu_append(MainWindowPopupMenu, menuItem);
	gtk_widget_set_sensitive(menuItem, sensitive);
	
	
	return MainWindowPopupMenu;
}

GtkWidget*
create_ConnectionsWindow (UIComponents *uic)
{
  GtkWidget *ConnectionsWindow;
  GtkWidget *dialog_vbox2;
  GtkWidget *hbox7;
  GtkWidget *scrolledwindow5;
  GtkWidget *vbox8;
  GtkWidget *frame5;
  GtkWidget *table8;
  GtkWidget *combo_entry1;
  GtkWidget *label26;
  GtkWidget *label27;
  GtkWidget *label28;
  GtkWidget *label29;
  GtkWidget *label30;
  GtkWidget *label24;
  GtkWidget *hbuttonbox5;
  GtkWidget *ConnectionsSaveBtn;
  GtkWidget *alignment5;
  GtkWidget *hbox8;
  GtkWidget *image64;
  GtkWidget *label31;
  GtkWidget *ConnectionsDeleteBtn;
  GtkWidget *alignment6;
  GtkWidget *hbox9;
  GtkWidget *image65;
  GtkWidget *label32;
  GtkWidget *ConnectionsClearBtn;
  GtkWidget *alignment7;
  GtkWidget *hbox10;
  GtkWidget *image66;
  GtkWidget *label33;
  GtkWidget *label25;
  GtkWidget *dialog_action_area2;
  GtkWidget *closebutton1;

  ConnectionsWindow = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (ConnectionsWindow), _("Grcm - Edit Connections"));
  gtk_window_set_modal (GTK_WINDOW (ConnectionsWindow), TRUE);

  dialog_vbox2 = GTK_DIALOG (ConnectionsWindow)->vbox;
  gtk_widget_show (dialog_vbox2);

  hbox7 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), hbox7, TRUE, TRUE, 0);

  scrolledwindow5 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow5);
  gtk_box_pack_start (GTK_BOX (hbox7), scrolledwindow5, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow5), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  uic->ConnectionsList = gtk_tree_view_new ();
  gtk_widget_show (uic->ConnectionsList);
  gtk_container_add (GTK_CONTAINER (scrolledwindow5), uic->ConnectionsList);
  gtk_tree_view_set_reorderable (GTK_TREE_VIEW (uic->ConnectionsList), TRUE);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox8);
  gtk_box_pack_start (GTK_BOX (hbox7), vbox8, FALSE, FALSE, 0);

  frame5 = gtk_frame_new (NULL);
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (vbox8), frame5, FALSE, FALSE, 5);

  table8 = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (table8);
  gtk_container_add (GTK_CONTAINER (frame5), table8);

  uic->ConnectionNameEntry = gtk_entry_new ();
  gtk_widget_show (uic->ConnectionNameEntry);
  gtk_table_attach (GTK_TABLE (table8), uic->ConnectionNameEntry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  uic->ConnectionHostnameEntry = gtk_entry_new ();
  gtk_widget_show (uic->ConnectionHostnameEntry);
  gtk_table_attach (GTK_TABLE (table8), uic->ConnectionHostnameEntry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  uic->ConnectionUsernameEntry = gtk_entry_new ();
  gtk_widget_show (uic->ConnectionUsernameEntry);
  gtk_table_attach (GTK_TABLE (table8), uic->ConnectionUsernameEntry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  uic->ConnectionArgumentsEntry = gtk_entry_new ();
  gtk_widget_show (uic->ConnectionArgumentsEntry);
  gtk_table_attach (GTK_TABLE (table8), uic->ConnectionArgumentsEntry, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  uic->ConnectionTypeCombo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (uic->ConnectionTypeCombo)->popwin),
                       "GladeParentKey", uic->ConnectionTypeCombo);
  gtk_widget_show (uic->ConnectionTypeCombo);
  gtk_table_attach (GTK_TABLE (table8), uic->ConnectionTypeCombo, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  combo_entry1 = GTK_COMBO (uic->ConnectionTypeCombo)->entry;
  gtk_widget_show (combo_entry1);

  label26 = gtk_label_new (_("Name"));
  gtk_widget_show (label26);
  gtk_table_attach (GTK_TABLE (table8), label26, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_label_set_justify (GTK_LABEL (label26), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label26), 0, 0.5);

  label27 = gtk_label_new (_("Type"));
  gtk_widget_show (label27);
  gtk_table_attach (GTK_TABLE (table8), label27, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_label_set_justify (GTK_LABEL (label27), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label27), 0, 0.5);

  label28 = gtk_label_new (_("Hostname"));
  gtk_widget_show (label28);
  gtk_table_attach (GTK_TABLE (table8), label28, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_label_set_justify (GTK_LABEL (label28), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label28), 0, 0.5);

  label29 = gtk_label_new (_("Username"));
  gtk_widget_show (label29);
  gtk_table_attach (GTK_TABLE (table8), label29, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_label_set_justify (GTK_LABEL (label29), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label29), 0, 0.5);

  label30 = gtk_label_new (_("Arguments"));
  gtk_widget_show (label30);
  gtk_table_attach (GTK_TABLE (table8), label30, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 5, 5);
  gtk_label_set_justify (GTK_LABEL (label30), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label30), 0, 0.5);

  label24 = gtk_label_new (_("Connection Properties"));
  gtk_widget_show (label24);
  gtk_frame_set_label_widget (GTK_FRAME (frame5), label24);
  gtk_label_set_justify (GTK_LABEL (label24), GTK_JUSTIFY_LEFT);

  hbuttonbox5 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox5);
  gtk_box_pack_start (GTK_BOX (vbox8), hbuttonbox5, FALSE, FALSE, 4);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox5), 3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox5), GTK_BUTTONBOX_SPREAD);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox5), 3);

  ConnectionsSaveBtn = gtk_button_new ();
  gtk_widget_show (ConnectionsSaveBtn);
  gtk_container_add (GTK_CONTAINER (hbuttonbox5), ConnectionsSaveBtn);
  GTK_WIDGET_SET_FLAGS (ConnectionsSaveBtn, GTK_CAN_DEFAULT);

  alignment5 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment5);
  gtk_container_add (GTK_CONTAINER (ConnectionsSaveBtn), alignment5);

  hbox8 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox8);
  gtk_container_add (GTK_CONTAINER (alignment5), hbox8);

  image64 = gtk_image_new_from_stock (GTK_STOCK_SAVE, GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image64);
  gtk_box_pack_start (GTK_BOX (hbox8), image64, FALSE, FALSE, 0);

  label31 = gtk_label_new_with_mnemonic (_("_Save"));
  gtk_widget_show (label31);
  gtk_box_pack_start (GTK_BOX (hbox8), label31, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label31), GTK_JUSTIFY_LEFT);

  ConnectionsDeleteBtn = gtk_button_new ();
  gtk_widget_show (ConnectionsDeleteBtn);
  gtk_container_add (GTK_CONTAINER (hbuttonbox5), ConnectionsDeleteBtn);
  GTK_WIDGET_SET_FLAGS (ConnectionsDeleteBtn, GTK_CAN_DEFAULT);

  alignment6 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment6);
  gtk_container_add (GTK_CONTAINER (ConnectionsDeleteBtn), alignment6);

  hbox9 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox9);
  gtk_container_add (GTK_CONTAINER (alignment6), hbox9);

  image65 = gtk_image_new_from_stock (GTK_STOCK_DELETE, GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image65);
  gtk_box_pack_start (GTK_BOX (hbox9), image65, FALSE, FALSE, 0);

  label32 = gtk_label_new_with_mnemonic (_("_Delete"));
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (hbox9), label32, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label32), GTK_JUSTIFY_LEFT);

  ConnectionsClearBtn = gtk_button_new ();
  gtk_widget_show (ConnectionsClearBtn);
  gtk_container_add (GTK_CONTAINER (hbuttonbox5), ConnectionsClearBtn);
  GTK_WIDGET_SET_FLAGS (ConnectionsClearBtn, GTK_CAN_DEFAULT);

  alignment7 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment7);
  gtk_container_add (GTK_CONTAINER (ConnectionsClearBtn), alignment7);

  hbox10 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox10);
  gtk_container_add (GTK_CONTAINER (alignment7), hbox10);

  image66 = gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image66);
  gtk_box_pack_start (GTK_BOX (hbox10), image66, FALSE, FALSE, 0);

  label33 = gtk_label_new_with_mnemonic (_("_Clear"));
  gtk_widget_show (label33);
  gtk_box_pack_start (GTK_BOX (hbox10), label33, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label33), GTK_JUSTIFY_LEFT);

  label25 = gtk_label_new ("");
  gtk_widget_show (label25);
  gtk_box_pack_start (GTK_BOX (vbox8), label25, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label25), GTK_JUSTIFY_LEFT);

  dialog_action_area2 = GTK_DIALOG (ConnectionsWindow)->action_area;
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);

  closebutton1 = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_widget_show (closebutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (ConnectionsWindow), closebutton1, GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (closebutton1, GTK_CAN_DEFAULT);

  g_signal_connect (G_OBJECT (ConnectionsWindow), "delete_event",
                      G_CALLBACK (on_ConnectionsWindow_delete_event),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (combo_entry1), "changed",
                      G_CALLBACK (on_ConnectionTypeCombo_changed),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (ConnectionsSaveBtn), "clicked",
                      G_CALLBACK (on_ConnectionsSaveBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (ConnectionsDeleteBtn), "clicked",
                      G_CALLBACK (on_ConnectionsDeleteBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (ConnectionsClearBtn), "clicked",
                      G_CALLBACK (on_ConnectionsClearBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (closebutton1), "clicked",
                      G_CALLBACK (on_ConnectionsOkBtn_clicked),
                      (gpointer) uic);

  return ConnectionsWindow;
}

GtkWidget*
create_ConnectionTypesWindow (UIComponents *uic)
{
  GtkWidget *ConnectionTypesWindow;
  GtkWidget *dialog_vbox3;
  GtkWidget *hbox11;
  GtkWidget *scrolledwindow6;
  GtkWidget *vbox9;
  GtkWidget *frame6;
  GtkWidget *table9;
  GtkWidget *label39;
  GtkWidget *label38;
  GtkWidget *label37;
  GtkWidget *label36;
  GtkWidget *label35;
  GtkWidget *hbuttonbox6;
  GtkWidget *ConnectionTypesSaveBtn;
  GtkWidget *ConnectionTypesDeleteBtn;
  GtkWidget *ConnectionTypesClearBtn;
  GtkWidget *label34;
  GtkWidget *dialog_action_area3;
  GtkWidget *closebutton2;
  GtkFileFilter *fileFilter;

  ConnectionTypesWindow = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (ConnectionTypesWindow), _("Grcm - Edit connection Types"));

  dialog_vbox3 = GTK_DIALOG (ConnectionTypesWindow)->vbox;
  gtk_widget_show (dialog_vbox3);

  hbox11 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox11);
  gtk_box_pack_start (GTK_BOX (dialog_vbox3), hbox11, TRUE, TRUE, 0);

  scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow6);
  gtk_box_pack_start (GTK_BOX (hbox11), scrolledwindow6, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow6), 5);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  uic->ConnectionTypesList = gtk_tree_view_new ();
  gtk_widget_show (uic->ConnectionTypesList);
  gtk_container_add (GTK_CONTAINER (scrolledwindow6), uic->ConnectionTypesList);
  gtk_tree_view_set_reorderable (GTK_TREE_VIEW (uic->ConnectionTypesList), TRUE);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox9);
  gtk_box_pack_start (GTK_BOX (hbox11), vbox9, FALSE, FALSE, 0);

  frame6 = gtk_frame_new (NULL);
  gtk_widget_show (frame6);
  gtk_box_pack_start (GTK_BOX (vbox9), frame6, TRUE, TRUE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (frame6), 5);

  table9 = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (table9);
  gtk_container_add (GTK_CONTAINER (frame6), table9);
  gtk_table_set_row_spacings (GTK_TABLE (table9), 1);
  gtk_table_set_col_spacings (GTK_TABLE (table9), 1);

  uic->fileChooserDialog = hildon_file_chooser_dialog_new  (GTK_WINDOW(ConnectionTypesWindow), GTK_FILE_CHOOSER_ACTION_OPEN);
/*
  uic->ConnectionTypesIconEntry = gtk_file_chooser_button_new_with_dialog(fileChooserDialog);
*/
  uic->iconButton = gtk_button_new();
  setIcon(GTK_BUTTON(uic->iconButton), NULL);
  g_signal_connect (G_OBJECT (uic->iconButton), "clicked",
                      G_CALLBACK (on_ConnectionTypesIconEntry_clicked),
                      (gpointer) uic);
  fileFilter = gtk_file_filter_new();
  gtk_file_filter_add_pixbuf_formats(fileFilter);
  gtk_file_filter_add_pattern(fileFilter, "*.png");
  gtk_file_filter_add_pattern(fileFilter, "*.svg");
  gtk_file_filter_add_pattern(fileFilter, "*.xpm");
  gtk_file_filter_set_name(fileFilter, _("Icons"));
  gtk_file_chooser_set_filter(GTK_FILE_CHOOSER(uic->fileChooserDialog), fileFilter);
  gtk_widget_show (uic->iconButton);
  gtk_table_attach (GTK_TABLE (table9), uic->iconButton, 0, 2, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 5, 5);


  uic->ConnectionTypesNameEntry = gtk_entry_new ();
  gtk_widget_show (uic->ConnectionTypesNameEntry);
  gtk_table_attach (GTK_TABLE (table9), uic->ConnectionTypesNameEntry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  uic->ConnectionTypesCommandEntry = gtk_entry_new ();
  gtk_widget_show (uic->ConnectionTypesCommandEntry);
  gtk_table_attach (GTK_TABLE (table9), uic->ConnectionTypesCommandEntry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  uic->ConnectionTypesArgumentsEntry = gtk_entry_new ();
  gtk_widget_show (uic->ConnectionTypesArgumentsEntry);
  gtk_table_attach (GTK_TABLE (table9), uic->ConnectionTypesArgumentsEntry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  uic->ConnectionTypesTerminalChkBox = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (uic->ConnectionTypesTerminalChkBox);
  gtk_table_attach (GTK_TABLE (table9), uic->ConnectionTypesTerminalChkBox, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  label39 = gtk_label_new (_("Run in Terminal"));
  gtk_widget_show (label39);
  gtk_table_attach (GTK_TABLE (table9), label39, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_label_set_justify (GTK_LABEL (label39), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label39), 0, 0.5);

  label38 = gtk_label_new (_("Arguments"));
  gtk_widget_show (label38);
  gtk_table_attach (GTK_TABLE (table9), label38, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_label_set_justify (GTK_LABEL (label38), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label38), 0, 0.5);

  label37 = gtk_label_new (_("Command"));
  gtk_widget_show (label37);
  gtk_table_attach (GTK_TABLE (table9), label37, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_label_set_justify (GTK_LABEL (label37), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label37), 0, 0.5);

  label36 = gtk_label_new (_("Name"));
  gtk_widget_show (label36);
  gtk_table_attach (GTK_TABLE (table9), label36, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_label_set_justify (GTK_LABEL (label36), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label36), 0, 0.5);

  label35 = gtk_label_new (_("Connection Types Properties"));
  gtk_widget_show (label35);
  gtk_frame_set_label_widget (GTK_FRAME (frame6), label35);
  gtk_label_set_justify (GTK_LABEL (label35), GTK_JUSTIFY_LEFT);

  hbuttonbox6 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox6);
  gtk_box_pack_start (GTK_BOX (vbox9), hbuttonbox6, TRUE, TRUE, 3);
  gtk_container_set_border_width (GTK_CONTAINER (hbuttonbox6), 5);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox6), 5);

  ConnectionTypesSaveBtn = gtk_button_new_from_stock (GTK_STOCK_SAVE);
  gtk_widget_show (ConnectionTypesSaveBtn);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), ConnectionTypesSaveBtn);
  GTK_WIDGET_SET_FLAGS (ConnectionTypesSaveBtn, GTK_CAN_DEFAULT);

  ConnectionTypesDeleteBtn = gtk_button_new_from_stock (GTK_STOCK_DELETE);
  gtk_widget_show (ConnectionTypesDeleteBtn);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), ConnectionTypesDeleteBtn);
  GTK_WIDGET_SET_FLAGS (ConnectionTypesDeleteBtn, GTK_CAN_DEFAULT);

  ConnectionTypesClearBtn = gtk_button_new_from_stock (GTK_STOCK_CLEAR);
  gtk_widget_show (ConnectionTypesClearBtn);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), ConnectionTypesClearBtn);
  GTK_WIDGET_SET_FLAGS (ConnectionTypesClearBtn, GTK_CAN_DEFAULT);

  label34 = gtk_label_new ("");
  gtk_widget_show (label34);
  gtk_box_pack_start (GTK_BOX (vbox9), label34, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label34), GTK_JUSTIFY_LEFT);

  dialog_action_area3 = GTK_DIALOG (ConnectionTypesWindow)->action_area;
  gtk_widget_show (dialog_action_area3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_END);

  closebutton2 = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_widget_show (closebutton2);
  gtk_dialog_add_action_widget (GTK_DIALOG (ConnectionTypesWindow), closebutton2, GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS (closebutton2, GTK_CAN_DEFAULT);

  g_signal_connect (G_OBJECT (ConnectionTypesSaveBtn), "clicked",
                      G_CALLBACK (on_ConnectionTypesSaveBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (ConnectionTypesDeleteBtn), "clicked",
                      G_CALLBACK (on_ConnectionTypesDeleteBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (ConnectionTypesClearBtn), "clicked",
                      G_CALLBACK (on_ConnectionTypesClearBtn_clicked),
                      (gpointer) uic);
  g_signal_connect (G_OBJECT (closebutton2), "clicked",
                      G_CALLBACK (on_ConnectionTypesOkBtn_clicked),
                      (gpointer) uic);

  return ConnectionTypesWindow;
}

