/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef NOTES_H
#define NOTES_H

void notes_load_all(appdata_t *appdata, gpx_t *gpx);
void notes_free(notes_t *notes);
GtkWidget *cache_notes(cache_context_t *c);
gint notes_destroy_event(GtkWidget *widget, gpointer data );
pos_t notes_get_pos(cache_context_t *context);
gboolean notes_get_override(cache_context_t *context);
void notes_log_export(appdata_t *appdata);

#endif // NOTES_H
