/*
 * Copyright (C) 2005 Luca De Cicco <ldecicco@gmail.com>
 * Hildonized by Luca De Cicco
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include "guesses.h"

/* Add to a guess list a value */
gboolean
guess_add(GSList **guess, guint value)
{
	if(!g_slist_find(*guess,GINT_TO_POINTER(value))){
		//printf("Appending value: %d\n",value);
		*guess = g_slist_append(*guess, GINT_TO_POINTER(value));
		return TRUE;
	}else{
		g_warning("Element already in the list\n");
		return FALSE;
	}

}
/* Return true if value is in guess list */
gboolean guess_is_in(GSList *guess, guint value)
{
	if(g_slist_find(guess,GINT_TO_POINTER(value))){
		return TRUE;
	}else{
		return FALSE;
	}
}

gboolean
guess_del(GSList **guess, guint value)
{
	GSList *found;
	
	found = g_slist_find(*guess,GINT_TO_POINTER(value));
		
	if(found){
		*guess = g_slist_delete_link(*guess,found);
		return TRUE;
	}else{
		g_warning("Element not in the list\n");
		return FALSE;
	}

}


void
guess_dump(GSList *guess)
{
	GSList *iter;
   	g_print("\n");
   	for(iter = guess; iter ; iter=iter->next){
	  	g_print("value: %d\n",GPOINTER_TO_INT(iter->data));
	}
    g_print("\n");
}

gchar *
guess_to_str(GSList *guess)
{
	GSList *iter;
	gchar *str ; 
	
	str = g_malloc(5);
	str[0]='\0';
   	
   	for(iter = guess; iter ; iter=iter->next){
		g_sprintf(str,"%s%d",str,GPOINTER_TO_INT(iter->data));
	  	
	}
	return str;
}

