/*
 * Copyright (C) 2005 Luca De Cicco <ldecicco@gmail.com>
 * Hildonized by Luca De Cicco
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include "actions.h"
extern guint state;
GSList *actions_new()
{
	return NULL;	
}

void
action_add(GSList **actions, struct action a)
{
	struct action *action, *last_action ;
	GSList *item;
	//printf ("Actions: %p\n",*actions);
	item = g_slist_last(*actions);
	a.n = state;
	//printf("Action N: %d cell: %d old: %d new: %d\n",a.n,a.cell,a.old,a.new);
	action = g_memdup(&a,sizeof(struct action));
	*actions = g_slist_append(*actions, action);
	
}

struct action *action_get_last(GSList **as)
{
	struct action *action;
	GSList *item;
	if(g_slist_length(*as)){
		item = g_slist_last(*as);
		action = (struct action *)g_memdup((struct action *)item->data,sizeof(struct action));
		*as = g_slist_delete_link(*as,g_slist_last(*as));
        return action;
    }else{
                return NULL;
    }
}

void actions_empty(GSList *actions)
{
	return !actions;

}
void actions_dump(GSList *actions)
{
   	GSList *iter;
   	struct action *a;
	   
   	for(iter = actions; iter ; iter=iter->next)
	{
		a = (struct action *)iter->data;
    	printf("action %d. cell: %d. old: %d new: %d\n",a->n,a->cell,a->old,a->new);
  
     }
 }
