/*
 * This file is part of gnokii-gconf
 *
 * Copyright (C) 2008 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <stdlib.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <gtk/gtk.h>
#include <glib/gprintf.h>

#include <config.h>

/* strlen needed from string.h */
#include <string.h>

#if HILDON == 1
#include <hildon/hildon.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#include <hildon-widgets/hildon-file-chooser-dialog.h>
#include <hildon-widgets/hildon-note.h>
#include <hildon-widgets/hildon-font-selection-dialog.h>
#include <hildon-widgets/hildon-number-editor.h>
#endif

#include <gnokii.h>
#include <gnokii-gconf-private.h>

#include <libosso.h>

#include <libintl.h>
#include <locale.h>

#define _(String) gettext(String)

struct _gggui {
	GtkWidget *modelCombo;
	GtkWidget *btEntry;
	GtkWidget *rfcommEntry;
};
typedef struct _gggui GGGui;

void getPhone_cb(GtkButton *button, GGGui *guiData) {
	hildon_banner_show_information(GTK_WIDGET(gtk_widget_get_toplevel(GTK_WIDGET(button))), GTK_STOCK_DIALOG_INFO, _("Fonction not yet implemented : You'll have to get your Phone BT MAC Address yourself !"));
}

void loadGnokiiRcFile_cb(GtkButton *button, GGGui *guiData) {
	hildon_banner_show_information(GTK_WIDGET(gtk_widget_get_toplevel(GTK_WIDGET(button))), GTK_STOCK_DIALOG_INFO, _("Fonction not yet implemented : You'll have to get your Phone BT MAC Address yourself !"));
}

void identifyPhone_cb(GtkButton *button, GGGui *guiData) {
	gchar *btMac;
	gchar *rfcomm;
	gchar *chaine;
	gchar **config;
    gn_data data;
	struct gn_statemachine *state;
	gn_error err;
    const char *model;
    const char *imei;
	GtkWidget *note;
	gchar *text;
	GtkWidget *mainWin = GTK_WIDGET(gtk_widget_get_toplevel(GTK_WIDGET(button)));

	btMac = g_strdup(gtk_entry_get_text(GTK_ENTRY(guiData->btEntry)));
	if (!btMac || btMac[0] == '\0') {
		hildon_banner_show_information(mainWin, GTK_STOCK_DIALOG_INFO, _("Cannot identify a phone without his BT Mac Address !"));
		g_free(btMac);
		return;
	}
	
#ifdef HILDON
    rfcomm = g_strdup_printf("%d",  hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(guiData->rfcommEntry)));
#else
    rfcomm = g_strdup_printf("%d", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(guiData->rfcommEntry)));
#endif
	if (rfcomm == NULL || rfcomm[0] == '\0' || rfcomm[0] == '0') {
		rfcomm = g_strdup("1");
	}

	chaine = g_strdup_printf(GNOKII_CFG, btMac, "AT", rfcomm);
g_printf("Config gnokii pour identify **%s**\n", chaine);
	config = g_strsplit(chaine, "\n", -1);
	g_free(btMac);
	g_free(rfcomm);

    err = gn_cfg_memory_read ((const char **)config);
	g_strfreev(config);
	if (err != GN_ERR_NONE) {
        text = g_strdup_printf(_("Error reading gnokii configuration %s\n%s"), gn_error_print(err), chaine);
        hildon_banner_show_information(mainWin, GTK_STOCK_DIALOG_INFO, text);
        g_free(text);
        g_free(chaine);
		return;
	}
    g_free(chaine);
g_printf("Config loaded\n");

    state = g_new0(struct gn_statemachine,1);
	
    err = gn_cfg_phone_load(NULL, state);
	if (err != GN_ERR_NONE) {
        text = g_strdup_printf(_("gn_cfg_phone_load : %s"),  gn_error_print(err));
        hildon_banner_show_information(mainWin, GTK_STOCK_DIALOG_INFO, text);
        g_free(text);
        gn_lib_library_free();
        g_free(state);
		return;
	}
g_printf("Phone loaded \n");    

    err = gn_lib_phone_open(state); 
	if (err != GN_ERR_NONE) {
        text = g_strdup_printf(_("gn_lib_phone_open : %s"),  gn_error_print(err));
        hildon_banner_show_information(mainWin, GTK_STOCK_DIALOG_INFO, text);
        g_free(text);
		gn_lib_phone_close(state);
        gn_lib_library_free();
        g_free(state);
		return;
	}
g_printf("Phone opened\n");

    g_printf("ici \n");
    
    model = gn_lib_get_phone_model(state);

    g_printf("ici 0\n");
    
    imei = gn_lib_get_phone_imei(state);

    g_printf("ici 1\n");
    
    text = g_strdup_printf(_("gnokii identify your phone as : %s\nIMEI = %s"), model, imei);
 
g_printf("ici 2\n");
    note = hildon_note_new_information_with_icon_name (GTK_WINDOW(mainWin), text, GTK_STOCK_DIALOG_INFO);
    g_printf("ici 3\n");
    
    g_free(text);
    g_printf("ici 4\n");
    
	gtk_widget_show_all(note);
    g_printf("ici 5\n");
    
	gtk_dialog_run(GTK_DIALOG(note));
    g_printf("ici 6\n");
    

	gtk_widget_destroy(note);
	g_printf("ici 7\n");
    
    gn_lib_phone_close(state);
    gn_lib_library_free(); 

    g_free(state);
}

osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
	GError *locError = NULL;
    GError **error = NULL;
	GtkWidget *dialog;
	GConfClient *gc_client;
	gint response;
	gchar *btMac;
	gchar *model;
	gchar *rfcomm;
	gboolean useGnokiiRc = FALSE;
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *table;
	GtkWidget *check;
	gint num;
	gchar *supportedModel;
	GGGui *guiData;
	
	/* Init type system */
	g_type_init();

	/* Load default GConf path */
	gc_client = gconf_client_get_default();

	if (gc_client == NULL) {
	    return FALSE;		
	}

	guiData = g_new0(GGGui, 1);
	
	/* Get string variable */
	btMac = gconf_client_get_string(gc_client, GNOKII_GCONF_BT_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}
	model = gconf_client_get_string(gc_client, GNOKII_GCONF_MODEL_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}
	rfcomm = gconf_client_get_string(gc_client, GNOKII_GCONF_RFCOMM_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}
	useGnokiiRc = gconf_client_get_bool(gc_client, GNOKII_GCONF_USE_GNOKIIRC_KEY, &locError);
	if (locError != NULL) {
		g_propagate_error(error, locError);
	}

	if (!btMac || btMac[0] == '\0') {
		/* Get preferred phone */
		btMac = gconf_client_get_string(gc_client, "/system/osso/connectivity/BT/preferred", &locError);
		if (locError != NULL) {
			g_propagate_error(error, locError);
		}
	}
	if (!model || model[0] == '\0') {
		/* base model */
		model = g_strdup("AT");
	}
	if (!rfcomm || rfcomm[0] == '\0') {
		/* rfcomm : 2 */
		rfcomm = g_strdup("1");
	}
	
	/* Create dialog with OK and Cancel buttons. Leave the separator out, as we do not have any content. */
	dialog = gtk_dialog_new_with_buttons(
		_("Gnokii GConf control panel"),
		GTK_WINDOW(data),
		GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
		GTK_STOCK_OK,
		GTK_RESPONSE_OK,
		GTK_STOCK_CANCEL,
		GTK_RESPONSE_CANCEL,
		NULL);

	/* ... add something to the dialog ... */
	table = gtk_table_new(4, 3, TRUE);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), table);
	gtk_table_set_col_spacings(GTK_TABLE(table), 5);
	
	/* Add a label, a field & 1 button */
	label = gtk_label_new(_("phone BT Mac"));
	gtk_table_attach_defaults( GTK_TABLE(table), label, 0, 1, 0, 1);

	guiData->btEntry = gtk_entry_new();
	if (btMac) {
		gtk_entry_set_text(GTK_ENTRY(guiData->btEntry), btMac);
		g_free(btMac);
	}
	gtk_table_attach_defaults( GTK_TABLE(table), guiData->btEntry, 1, 2, 0, 1);

	button = gtk_button_new_with_label (_("Get Phone"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect (G_OBJECT (button), "clicked",
	                  G_CALLBACK (getPhone_cb), (gpointer) guiData);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 0, 1);
	gtk_widget_grab_default(button);
	
	
	label = gtk_label_new(_("phone Model"));
	gtk_table_attach_defaults( GTK_TABLE(table), label, 0, 1, 1, 2);

	guiData->modelCombo = gtk_combo_box_entry_new_text();
	supportedModel = g_strdup("AT");
	gtk_combo_box_append_text(GTK_COMBO_BOX(guiData->modelCombo), supportedModel);
	if (model && strcmp(supportedModel, model) == 0) {
		gtk_combo_box_set_active(GTK_COMBO_BOX(guiData->modelCombo), 0);
	}
	g_free(supportedModel);
	num = 0;
	while (gn_lib_get_supported_phone_model(num) != NULL) {
		supportedModel = g_strdup(gn_lib_get_supported_phone_model(num));
		gtk_combo_box_append_text(GTK_COMBO_BOX(guiData->modelCombo), supportedModel);
		if (model && strcmp(supportedModel, model) == 0) {
			gtk_combo_box_set_active(GTK_COMBO_BOX(guiData->modelCombo), num+1);
		}
		num++;
		g_free(supportedModel);
	}
	g_free(model);
	gtk_table_attach_defaults( GTK_TABLE(table), guiData->modelCombo, 1, 2, 1, 2);
	
	button = gtk_button_new_with_label (_("Identify Phone"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect (G_OBJECT (button), "clicked",
	                  G_CALLBACK (identifyPhone_cb), (gpointer) guiData);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 1, 2);
	
	label = gtk_label_new(_("rfcomm"));
	gtk_table_attach_defaults( GTK_TABLE(table), label, 0, 1, 2, 3);

#ifdef HILDON
	guiData->rfcommEntry =  hildon_number_editor_new( 1, 20);
#else
	guiData->rfcommEntry =  gtk_spin_button_new_with_range( 1, 20, 1);
#endif
	if (rfcomm) {
#ifdef HILDON
		hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(guiData->rfcommEntry), atoi(rfcomm));
#else
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(guiData->rfcommEntry), atoi(rfcomm));
#endif
		g_free(rfcomm);
	}
	gtk_table_attach_defaults( GTK_TABLE(table), guiData->rfcommEntry, 1, 2, 2, 3);

	check = gtk_check_button_new_with_label(_("Use .GnokiiRc file"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), useGnokiiRc);
	gtk_table_attach_defaults( GTK_TABLE(table), check, 1, 2, 3, 4);

	button = gtk_button_new_with_label (_("Load .gnokiirc file"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect (G_OBJECT (button), "clicked",
	                  G_CALLBACK (loadGnokiiRcFile_cb), (gpointer) guiData);
	gtk_table_attach_defaults(GTK_TABLE(table), button, 2, 3, 3, 4);

	gtk_window_set_default_size(GTK_WINDOW(dialog), 500, 350);
	gtk_widget_show_all (dialog);
	
#if HILDON == 1
	if (!user_activated) {
	}
#endif
	/* Wait until user finishes the dialog. */
	response = gtk_dialog_run(GTK_DIALOG(dialog));

	if (response == GTK_RESPONSE_OK) {
		btMac = g_strdup(gtk_entry_get_text(GTK_ENTRY(guiData->btEntry)));
		if (btMac) {
			/* Set string variable */
			if (btMac[0] == '\0') {
				gconf_client_unset(gc_client, GNOKII_GCONF_BT_KEY, &locError);
			} else {
				gconf_client_set_string(gc_client, GNOKII_GCONF_BT_KEY, btMac, &locError);
			}
			if (locError != NULL) {
				g_propagate_error(error, locError);
			}
			g_free(btMac);
		}
		model = gtk_combo_box_get_active_text(GTK_COMBO_BOX(guiData->modelCombo));
		if (model) {
			/* Set string variable */
			if (model[0] == '\0') {
				gconf_client_unset(gc_client, GNOKII_GCONF_MODEL_KEY, &locError);
			} else {
				gconf_client_set_string(gc_client, GNOKII_GCONF_MODEL_KEY, model, &locError);
			}
			if (locError != NULL) {
				g_propagate_error(error, locError);
			}
			g_free(model);
		}
#ifdef HILDON
		rfcomm = g_strdup_printf("%d",  hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(guiData->rfcommEntry)));
#else
		rfcomm = g_strdup_printf("%d", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(guiData->rfcommEntry)));
#endif		
		if (rfcomm) {
			/* Set string variable */
			if (rfcomm[0] == '\0') {
				gconf_client_unset(gc_client, GNOKII_GCONF_RFCOMM_KEY, &locError);
			} else {
				gconf_client_set_string(gc_client, GNOKII_GCONF_RFCOMM_KEY, rfcomm, &locError);
			}
			if (locError != NULL) {
				g_propagate_error(error, locError);
			}
			g_free(rfcomm);
		}
		gconf_client_set_bool(gc_client, GNOKII_GCONF_USE_GNOKIIRC_KEY, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check)), &locError);
		if (locError != NULL) {
			g_propagate_error(error, locError);
		}
	}

	/* Free the dialog (and it's children) */
	gtk_widget_destroy(GTK_WIDGET(dialog));

	/* Free gconf settings object */
	g_object_unref(gc_client);

	return OSSO_OK;
}             
     
osso_return_t save_state(osso_context_t *osso, gpointer data)
{
        /* ... save state ... */

        return OSSO_OK;
}
