/*
 * This file is part of gnokii-gconf
 *
 * Copyright (C) 2008 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
 
#include <glib.h> 
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include <gnokii-gconf-private.h>

gchar ** getGnokiiCfg(GError **error) {
	GConfClient *gc_client;
	gchar *btMac;
	gchar *model;
	gchar *rfcomm;
	gchar *gnokiiCfg;
	int i;

	/* Init type system */
	g_type_init();

	/* Load default GConf path */
	gc_client = gconf_client_get_default();

	if (gc_client == NULL) {
		return NULL;
	}

	/* Get string variable */
	btMac = gconf_client_get_string(gc_client, GNOKII_GCONF_BT_KEY, NULL);
	model = gconf_client_get_string(gc_client, GNOKII_GCONF_MODEL_KEY, NULL);
	rfcomm = gconf_client_get_string(gc_client, GNOKII_GCONF_RFCOMM_KEY, NULL);

	if (!btMac) {
		/* Get preferred phone */
		btMac = gconf_client_get_string(gc_client, "/system/osso/connectivity/BT/preferred", NULL);
		if (!btMac) {
			return NULL;
		}
	}
	if (!model) {
		model = g_strdup("AT");
	}
	if (!rfcomm) {
		rfcomm = g_strdup("2");
	}
	
	gnokiiCfg = g_strjoin("\n", 
				g_strdup("[global]"), 
				g_strconcat("port = ", btMac, NULL), 
				g_strconcat("model = ", model, NULL),
				g_strdup("connection = bluetooth"),
				g_strconcat("rfcomm_channel = ", rfcomm, NULL),
				NULL);
	
	return g_strsplit(gnokiiCfg, "\n", -1);
	
 }
