// Free42.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "resource.h"
#include <commctrl.h>
#include <aygshell.h>
#include <sipapi.h>
#include <stdio.h>

#include "free42.h"
#include "shell.h"
#include "shell_skin.h"
#include "shell_spool.h"
#include "core_display.h"
#include "core_main.h"
#include "msg2string.h"

#define MAX_LOADSTRING 100
#define FILENAMELEN 256

// The maximum height of a Bitmap is 32767 pixels;
// so, if I want to use a larger buffer, I'll have to
// change repaint_printout() so that it creates
// its Bitmap objects a bit more cleverly. TODO.

#define PRINT_LINES 16384
#define PRINT_BYTESPERLINE 36
#define PRINT_SIZE 589824
/*
#define PRINT_LINES 32767
#define PRINT_BYTESPERLINE 36
#define PRINT_SIZE 1179612
*/

/**********************************************************/
/* Linked-in skins; defined in the skins.c, which in turn */
/* is generated by skin2c.c under control of skin2c.conf  */
/**********************************************************/

extern int skin_count;
extern const TCHAR *skin_name[];
extern const long skin_layout_size[];
extern const char *skin_layout_data[];
extern const long skin_bitmap_size[];
extern const char *skin_bitmap_data[];


// Global Variables:
static HINSTANCE hInst;				// The current instance
static HWND hMainWnd = NULL;
static HWND hPrintOutWnd = NULL;
static HWND hwndCB;					// The command bar handle
static TCHAR szMainTitle[MAX_LOADSTRING];
static TCHAR szPrintOutTitle[MAX_LOADSTRING];
static TCHAR szMainWindowClass[MAX_LOADSTRING];
static TCHAR szPrintOutWindowClass[MAX_LOADSTRING];

static SHACTIVATEINFO s_sai;

static UINT timer = 0;
static UINT timer3 = 0;
static int running = 0;
static int enqueued = 0;

static int printout_top;
static int printout_bottom;
static int printout_pos;
static char *printout;
static bool narrow_printout;

static int ckey = 0;
static int skey;
static unsigned char *macro;
static int active_keycode = 0;
static bool ctrl_down = false;
static bool alt_down = false;
static bool shift_down = false;
static bool just_pressed_shift = false;
static bool mouse_key;

static int keymap_length = 0;
static keymap_entry *keymap = NULL;


#define SHELL_VERSION 1

typedef struct state {
	int printerToTxtFile;
	int printerToGifFile;
	TCHAR printerTxtFileName[FILENAMELEN];
	TCHAR printerGifFileName[FILENAMELEN];
	int printerGifMaxLength;
	TCHAR skinName[FILENAMELEN];
} state_type;

static state_type state;
static int printOutHeight;

static TCHAR free42dirname[FILENAMELEN];
static TCHAR statefilename[FILENAMELEN];
static FILE *statefile = NULL;
static TCHAR printfilename[FILENAMELEN];

static FILE *print_txt = NULL;
static FILE *print_gif = NULL;
static TCHAR print_gif_name[FILENAMELEN];
static int gif_seq = -1;
static int gif_lines;

static int sel_prog_count;
static int *sel_prog_list;
static TCHAR export_file_name[FILENAMELEN];
static FILE *export_file = NULL;
static FILE *import_file = NULL;

static int ann_updown = 0;
static int ann_shift = 0;
static int ann_print = 0;
static int ann_run = 0;
static int ann_battery = 0;
static int ann_g = 0;
static int ann_rad = 0;


// Forward declarations of functions included in this code module:
static void MyRegisterClass(HINSTANCE);
static BOOL InitInstance(HINSTANCE, int);
static LRESULT CALLBACK	MainWndProc(HWND, UINT, WPARAM, LPARAM);
static LRESULT CALLBACK PrintOutWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
static HWND CreateRpCommandBar(HWND);
static LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
static LRESULT CALLBACK	ExportProgram(HWND, UINT, WPARAM, LPARAM);
static int browse_file(HWND owner, TCHAR *title, int save, TCHAR *filter, TCHAR *defExt, TCHAR *buf, int buflen);
static LRESULT CALLBACK	Preferences(HWND, UINT, WPARAM, LPARAM);
static void copy();
static void paste();
static void Quit();

static VOID CALLBACK repeater(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);
static VOID CALLBACK timeout1(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);
static VOID CALLBACK timeout2(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);
static VOID CALLBACK timeout3(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);
static VOID CALLBACK battery_checker(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);

static void show_printout();
static void export_program();
static void import_program();
static void clear_printout();
static void repaint_printout(int x, int y, int width, int height, int validate);
static void repaint_printout(HDC hdc, int destpos, int x, int y, int width, int height, int validate);
static void printout_scrolled(int offset);
static void printout_scroll_to_bottom(int offset);
static void printout_length_changed();

static void read_key_map(const TCHAR *keymapfilename);
static void init_shell_state(int4 version);
static bool read_shell_state(int4 *version);
static bool write_shell_state();
static void txt_writer(const char *text, int length);
static void txt_newliner();
static void gif_seeker(int4 pos);
static void gif_writer(const char *text, int length);


int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	// Initialize global strings
#ifdef BCD_MATH
	LoadString(hInstance, IDS_APP_TITLE_DEC, szMainTitle, MAX_LOADSTRING);
#else
	LoadString(hInstance, IDS_APP_TITLE_BIN, szMainTitle, MAX_LOADSTRING);
#endif
	LoadString(hInstance, IDS_PRINTOUT_TITLE, szPrintOutTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_FREE42, szMainWindowClass, MAX_LOADSTRING);
	LoadString(hInstance, IDC_FREE42_PRINTOUT, szPrintOutWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_FREE42);

	// Main message loop:
	while (1) {
		while (running && !PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
			int dummy1, dummy2;
			running = core_keydown(0, &dummy1, &dummy2);
		}
		if (!GetMessage(&msg, NULL, 0, 0)) 
			break;
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	Quit();
	return msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    It is important to call this function so that the application 
//    will get 'well formed' small icons associated with it.
//
static void MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) MainWndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_FREE42));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szMainWindowClass;

	RegisterClass(&wc);

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) PrintOutWndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_FREE42));
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(GRAY_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szPrintOutWindowClass;

	RegisterClass(&wc);
}

//
//  FUNCTION: InitInstance(HANDLE, int)
//
//  PURPOSE: Saves instance handle and creates main window
//
//  COMMENTS:
//
//    In this function, we save the instance handle in a global variable and
//    create and display the main program window.
//
static BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	hInst = hInstance;		// Store instance handle in our global variable

	//If it is already running, then focus on the window
	HWND hWnd = FindWindow(szMainWindowClass, szMainTitle);	
	if (hWnd) 
	{
		// set focus to foremost child window
		// The "| 0x01" is used to bring any owned windows to the foreground and
		// activate them.
		SetForegroundWindow((HWND)((ULONG) hWnd | 0x00000001));
		return 0;
	} 

	srand(GetTickCount());

	GetModuleFileName(0, free42dirname, FILENAMELEN - 1);
	TCHAR *lastbackslash = _tcsrchr(free42dirname, _T('\\'));
	if (lastbackslash != NULL)
		*lastbackslash = 0;
	else
		free42dirname[0] = 0;

	TCHAR keymapfilename[FILENAMELEN];
	_tcscpy(statefilename, free42dirname);
	_tcscat(statefilename, _T("\\state.bin"));
	_tcscpy(printfilename, free42dirname);
	_tcscat(printfilename, _T("\\print.bin"));
	_tcscpy(keymapfilename, free42dirname);
	_tcscat(keymapfilename, _T("\\keymap.txt"));

	read_key_map(keymapfilename);

	printout = (char *) malloc(PRINT_SIZE);
	// TODO - handle memory allocation failure
	FILE *printfile = _tfopen(printfilename, _T("rb"));
    if (printfile != NULL) {
		int n = fread(&printout_bottom, 1, sizeof(int), printfile);
		if (n == sizeof(int)) {
			int bytes = printout_bottom * PRINT_BYTESPERLINE;
			n = fread(printout, 1, bytes, printfile);
			if (n != bytes)
				printout_bottom = 0;
		} else
			printout_bottom = 0;
		fclose(printfile);
    } else
		printout_bottom = 0;
    printout_top = 0;
    for (int n = printout_bottom * PRINT_BYTESPERLINE; n < PRINT_SIZE; n++)
		printout[n] = 0;
	printout_pos = printout_bottom;

	int scrollWidth = GetSystemMetrics(SM_CXVSCROLL);
	int screenWidth = GetSystemMetrics(SM_CXSCREEN);
	narrow_printout = screenWidth - scrollWidth < 286;

	int init_mode;
	int4 version;

	statefile = _tfopen(statefilename, _T("rb"));
	if (statefile != NULL) {
		if (read_shell_state(&version))
			init_mode = 1;
		else {
			init_shell_state(-1);
			init_mode = 2;
		}
	} else {
		init_shell_state(-1);
		init_mode = 0;
	}

	hMainWnd = CreateWindow(szMainWindowClass, szMainTitle, WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	if (!hMainWnd)
	{	
		return FALSE;
	}
	//When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created) is not taken into account. So we resize the window after creating it
	// if a menubar is present
	if (hwndCB)
    {
		RECT rc;
        RECT rcMenuBar;

		GetWindowRect(hMainWnd, &rc);
        GetWindowRect(hwndCB, &rcMenuBar);
		rc.bottom -= (rcMenuBar.bottom - rcMenuBar.top);
		
		MoveWindow(hMainWnd, rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top, FALSE);
	}

	RECT r;
	GetClientRect(hMainWnd, &r);
	skin_load(state.skinName, free42dirname, r.right, r.bottom);

	core_init(init_mode, version);
	if (statefile != NULL) {
		fclose(statefile);
		statefile = NULL;
	}

	ShowWindow(hMainWnd, nCmdShow);
	UpdateWindow(hMainWnd);

	if (core_powercycle())
		running = 1;
	SetTimer(NULL, 0, 60000, battery_checker);

	return TRUE;
}

static void shell_keydown() {
	if (ckey != 0) {
		HDC hdc = GetDC(hMainWnd);
		HDC memdc = CreateCompatibleDC(hdc);
		if (skey == -1)
			skey = skin_find_skey(ckey);
		skin_repaint_key(hdc, memdc, skey, 1);
		DeleteObject(memdc);
		ReleaseDC(hMainWnd, hdc);
	}
	if (timer != 0) {
		KillTimer(NULL, timer);
		timer = 0;
	}
	if (timer3 != 0 && (macro != NULL || ckey != 28 /* SHIFT */)) {
		KillTimer(NULL, timer3);
		timer3 = 0; 
		core_timeout3(0);
	}
	int repeat;
	if (macro != NULL) {
		if (*macro == 0) {
			squeak();
			return;
		}
		bool one_key_macro = macro[1] == 0 || (macro[2] == 0 && macro[0] == 28);
		if (!one_key_macro)
			skin_display_set_enabled(false);
		while (*macro != 0) {
			running = core_keydown(*macro++, &enqueued, &repeat);
			if (*macro != 0 && !enqueued)
				core_keyup();
		}
		if (!one_key_macro) {
			skin_display_set_enabled(true);
			HDC hdc = GetDC(hMainWnd);
			HDC memdc = CreateCompatibleDC(hdc);
			skin_repaint_display(hdc, memdc);
			skin_repaint_annunciator(hdc, memdc, 1, ann_updown);
			skin_repaint_annunciator(hdc, memdc, 2, ann_shift);
			skin_repaint_annunciator(hdc, memdc, 3, ann_print);
			skin_repaint_annunciator(hdc, memdc, 4, ann_run);
			skin_repaint_annunciator(hdc, memdc, 5, ann_battery);
			skin_repaint_annunciator(hdc, memdc, 6, ann_g);
			skin_repaint_annunciator(hdc, memdc, 7, ann_rad);
			DeleteDC(memdc);
			ReleaseDC(hMainWnd, hdc);
			repeat = 0;
		}
	} else
		running = core_keydown(ckey, &enqueued, &repeat);
	if (!running) {
		if (repeat != 0)
			timer = SetTimer(NULL, 0, repeat == 1 ? 1000 : 500, repeater);
		else if (!enqueued)
			timer = SetTimer(NULL, 0, 250, timeout1);
	}
}

static void shell_keyup() {
	HDC hdc = GetDC(hMainWnd);
	HDC memdc = CreateCompatibleDC(hdc);
	skin_repaint_key(hdc, memdc, skey, 0);
	DeleteObject(memdc);
	ReleaseDC(hMainWnd, hdc);
	ckey = 0;
	skey = -1;
	if (timer != 0) {
		KillTimer(NULL, timer);
		timer = 0;
	}
	if (!enqueued)
		running = core_keyup();
}

static int tchar_sort(const void *a, const void *b) {
	const TCHAR *aa = *(const TCHAR **) a;
	const TCHAR *bb = *(const TCHAR **) b;
	return _tcsicmp(aa, bb);
}

static void update_skin_menu(HMENU menu) {
	UINT id = 50000;
	if (state.skinName[0] == 0)
		_tcscpy(state.skinName, skin_name[0]);

	while (RemoveMenu(menu, 0, MF_BYPOSITION));

	int i;
	for (i = 0; i < skin_count; i++) {
		UINT flags = 0;
		if (_tcscmp(state.skinName, skin_name[i]) == 0)
			flags = MF_CHECKED;
		AppendMenu(menu, flags, id++, skin_name[i]);
	}

	int have_separator = 0;
	TCHAR path[MAX_PATH];
	path[MAX_PATH - 1] = 0;
	WIN32_FIND_DATA wfd;
	int n = 0;
	TCHAR *name[100];

	_tcsncpy(path, free42dirname, MAX_PATH - 1);
	_tcsncat(path, _T("\\*.layout"), MAX_PATH - 1);
	path[MAX_PATH - 1] = 0;
	HANDLE search = FindFirstFile(path, &wfd);
	if (search != INVALID_HANDLE_VALUE) {
		do {
			if ((wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0) {
				wfd.cFileName[_tcslen(wfd.cFileName) - 7] = 0;
				name[n] = (TCHAR *) malloc((_tcslen(wfd.cFileName) + 1) * sizeof(TCHAR));
				// TODO - handle memory allocation failure
				_tcscpy(name[n++], wfd.cFileName);
			}
		} while (FindNextFile(search, &wfd));
		FindClose(search);
	}

	qsort(name, n, sizeof(TCHAR *), tchar_sort);
	for (i = 0; i < n; i++) {
		UINT flags;
		int j;
		if (i > 0 && _tcsicmp(name[i], name[i - 1]) == 0)
			goto skip;
		for (j = 0; j < skin_count; j++)
			if (_tcsicmp(name[i], skin_name[j]) == 0)
				goto skip;
		if (!have_separator) {
			AppendMenu(menu, MF_SEPARATOR, 0, NULL);
			have_separator = 1;
		}
		flags = 0;
		if (_tcsicmp(state.skinName, name[i]) == 0)
			flags = MF_CHECKED;
		AppendMenu(menu, flags, id++, name[i]);
		skip:;
	}
	for (i = 0; i < n; i++)
		free(name[i]);
}

//
//  FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
static LRESULT CALLBACK MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
#if 0
	static FILE *logfile = fopen("\\Storage Card\\log.txt", "w");
	fprintf(logfile, "message=%s wParam=0x%x lParam=0x%lx\n", msg2string(message), wParam, lParam);
	fflush(logfile);
#endif

	int wmId, wmEvent;

	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{	
				case IDM_SHOWPRINTOUT:
					show_printout();
					break;
				case IDM_EXPORTPROGRAM:
					export_program();
					break;
				case IDM_IMPORTPROGRAM:
					import_program();
					break;
				case IDM_CLEARPRINTOUT:
					clear_printout();
					break;
				case IDM_PREFERENCES:
					DialogBox(hInst, (LPCTSTR)IDD_PREFERENCES, hWnd, (DLGPROC)Preferences);
					break;
				case ID_EDIT_COPY:
					copy();
					break;
				case ID_EDIT_PASTE:
					paste();
					break;
				case IDM_EXIT:
					DestroyWindow(hWnd);
					break;
				case IDM_ABOUT:
					DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				    break;
				default:
					if (wmId >= 50000) {
						// 'Skin' menu
						HMENU mainmenu = (HMENU) SendMessage((hwndCB), SHCMBM_GETMENU, (WPARAM)0, (LPARAM)0);
						HMENU skinmenu = GetSubMenu(mainmenu, 2);
						MENUITEMINFO mii;
						mii.cbSize = sizeof(MENUITEMINFO);
						mii.fMask = MIIM_TYPE;
						mii.cch = FILENAMELEN;
						mii.dwTypeData = state.skinName;
						GetMenuItemInfo(skinmenu, wmId, FALSE, &mii);

						RECT r;
						GetClientRect(hWnd, &r);
						skin_load(state.skinName, free42dirname, r.right, r.bottom);
						core_repaint_display();
						InvalidateRect(hWnd, &r, FALSE);
						break;
					}
					return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_CREATE:
			hwndCB = CreateRpCommandBar(hWnd);
            // Initialize the shell activate info structure
            memset (&s_sai, 0, sizeof (s_sai));
            s_sai.cbSize = sizeof (s_sai);
			break;
		case WM_PAINT: {
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hWnd, &ps);
			HDC memdc = CreateCompatibleDC(hdc);
			skin_repaint(hdc, memdc);
			skin_repaint_display(hdc, memdc);
			skin_repaint_annunciator(hdc, memdc, 1, ann_updown);
			skin_repaint_annunciator(hdc, memdc, 2, ann_shift);
			skin_repaint_annunciator(hdc, memdc, 3, ann_print);
			skin_repaint_annunciator(hdc, memdc, 4, ann_run);
			skin_repaint_annunciator(hdc, memdc, 5, ann_battery);
			skin_repaint_annunciator(hdc, memdc, 6, ann_g);
			skin_repaint_annunciator(hdc, memdc, 7, ann_rad);
			if (ckey != 0)
				skin_repaint_key(hdc, memdc, skey, 1);
			DeleteDC(memdc);
			EndPaint(hWnd, &ps);
			break;
		}
		case WM_LBUTTONDOWN: {
			if (ckey == 0) {
				int x = LOWORD(lParam);  // horizontal position of cursor
				int y = HIWORD(lParam);  // vertical position of cursor
				skin_find_key(x, y, ann_shift != 0, &skey, &ckey);
				if (ckey != 0) {
					macro = skin_find_macro(ckey);
					shell_keydown();
					mouse_key = true;
				}
			}
			break;
		}
		case WM_LBUTTONUP:
			if (ckey != 0 && mouse_key)
				shell_keyup();
			break;
		case WM_KEYDOWN:
		case WM_CHAR:
		case WM_SYSKEYDOWN:
		case WM_SYSCHAR: {
			static int virtKey = 0;
			int keyChar;
			if ((lParam & (1 << 30)) != 0)
				// Auto-repeat event; ignore.
				break;
			if (message == WM_KEYDOWN || message == WM_SYSKEYDOWN) {
				keyChar = 0;
				virtKey = (int) wParam;
			} else
				keyChar = (int) wParam;
			just_pressed_shift = false;
			if (virtKey == 17) {
				ctrl_down = true;
				goto do_default;
			} else if (virtKey == 18) {
				alt_down = true;
				goto do_default;
			} else if (virtKey == 16) {
				shift_down = true;
				just_pressed_shift = true;
				goto do_default;
			}
			if ((message == WM_KEYDOWN || message == WM_SYSKEYDOWN)
					&& !ctrl_down
					&& (virtKey == 8 // Backspace
					|| virtKey == 9 // Tab
					|| virtKey == 13 // Enter
					|| (virtKey == 27 && !shift_down) // Escape
					|| virtKey == 32 // Space
					|| (virtKey >= 48 && virtKey < 112)
					|| (virtKey >= 0xB0 && virtKey < 0xF0)))
				// Keystrokes that will be followed by a WM_CHAR
				// message; we defer handling them until then.
				break;

			if (ckey == 0 || !mouse_key) {
				int i;
				bool printable = keyChar >= 32 && keyChar <= 126;
				if (ckey != 0) {
					shell_keyup();
					active_keycode = 0;
				}
				if (printable && core_alpha_menu()) {
					if (keyChar >= 'a' && keyChar <= 'z')
						keyChar = keyChar + 'A' - 'a';
					else if (keyChar >= 'A' && keyChar <= 'Z')
						keyChar = keyChar + 'a' - 'A';
					ckey = 1024 + keyChar;
					skey = -1;
					macro = NULL;
					shell_keydown();
					mouse_key = false;
					active_keycode = virtKey;
					break;
				} else if (core_hex_menu() && ((keyChar >= 'a' && keyChar <= 'f')
							|| (keyChar >= 'A' && keyChar <= 'F'))) {
					if (keyChar >= 'a' && keyChar <= 'f')
						ckey = keyChar - 'a' + 1;
					else
						ckey = keyChar - 'A' + 1;
					skey = -1;
					macro = NULL;
					shell_keydown();
					mouse_key = false;
					active_keycode = virtKey;
					break;
				}

				bool exact;
				bool cshift_down = ann_shift != 0;
				unsigned char *key_macro = skin_keymap_lookup(virtKey, ctrl_down, alt_down, shift_down, cshift_down, &exact);
				if (key_macro == NULL || !exact) {
					for (i = 0; i < keymap_length; i++) {
						keymap_entry *entry = keymap + i;
						if (ctrl_down == entry->ctrl
								&& alt_down == entry->alt
								&& shift_down == entry->shift
								&& virtKey == entry->keycode) {
							if (cshift_down == entry->cshift) {
								key_macro = entry->macro;
								break;
							} else {
								if (key_macro == NULL)
									key_macro = entry->macro;
							}
						}
					}
				}
				if (key_macro != NULL) {
					// A keymap entry is a sequence of zero or more calculator
					// keystrokes (1..37) and/or macros (38..255). We expand
					// macros here before invoking shell_keydown().
					// If the keymap entry is one key, or two keys with the
					// first being 'shift', we highlight the key in question
					// by setting ckey; otherwise, we set ckey to -10, which
					// means no skin key will be highlighted.
					ckey = -10;
					skey = -1;
					if (key_macro[0] != 0)
						if (key_macro[1] == 0)
							ckey = key_macro[0];
						else if (key_macro[2] == 0 && key_macro[0] == 28)
							ckey = key_macro[1];
					bool needs_expansion = false;
					for (int j = 0; key_macro[j] != 0; j++)
						if (key_macro[j] > 37) {
							needs_expansion = true;
							break;
						}
					if (needs_expansion) {
						static unsigned char macrobuf[1024];
						int p = 0;
						for (int j = 0; key_macro[j] != 0 && p < 1023; j++) {
							int c = key_macro[j];
							if (c <= 37)
								macrobuf[p++] = c;
							else {
								unsigned char *m = skin_find_macro(c);
								if (m != NULL)
									while (*m != 0 && p < 1023)
										macrobuf[p++] = *m++;
							}
						}
						macrobuf[p] = 0;
						macro = macrobuf;
					} else
						macro = key_macro;
					shell_keydown();
					mouse_key = false;
					active_keycode = virtKey;
					break;
				}
			}
			goto do_default;
		}
		case WM_KEYUP:
		case WM_SYSKEYUP: {
			int virtKey = (int) wParam;
			if (virtKey == 17) {
				ctrl_down = false;
				goto do_default;
			} else if (virtKey == 18) {
				alt_down = false;
				goto do_default;
			} else if (virtKey == 16) {
				shift_down = false;
				if (ckey == 0 && just_pressed_shift) {
					ckey = 28;
					skey = 1;
					macro = NULL;
					shell_keydown();
					shell_keyup();
				}
				goto do_default;
			}
			if (ckey != 0 && !mouse_key && virtKey == active_keycode) {
				shell_keyup();
				active_keycode = 0;
			}
			goto do_default;
		}
		case WM_DESTROY:
			CommandBar_Destroy(hwndCB);
			PostQuitMessage(0);
			break;
		case WM_INITMENUPOPUP:
			if (LOWORD(lParam) == IDM_SKIN)
				update_skin_menu((HMENU) wParam);
			break;
		case WM_ACTIVATE:
            // Notify shell of our activate message
			SHHandleWMActivate(hWnd, wParam, lParam, &s_sai, FALSE);
     		break;
		case WM_SETTINGCHANGE:
			SHHandleWMSettingChange(hWnd, wParam, lParam, &s_sai);
     		break;
		default:
		do_default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

static HWND CreateRpCommandBar(HWND hwnd)
{
	SHMENUBARINFO mbi;

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hwnd;
	mbi.nToolBarId = IDM_MENU;
	mbi.hInstRes   = hInst;
	mbi.nBmpId     = 0;
	mbi.cBmpImages = 0;

	if (!SHCreateMenuBar(&mbi)) 
		return NULL;

	return mbi.hwndMB;
}

//
//  FUNCTION: PrintOutWndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the print-out window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
static LRESULT CALLBACK PrintOutWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) 
	{
		case WM_PAINT: {
			RECT r;
			if (GetUpdateRect(hWnd, &r, FALSE)) {
				PAINTSTRUCT ps;
				HDC hdc = BeginPaint(hWnd, &ps);
				repaint_printout(hdc, 1, r.left, r.top, r.right - r.left, r.bottom - r.top, 0);
				EndPaint(hWnd, &ps);
				break;
			}
		}
		case WM_DESTROY:
			hPrintOutWnd = NULL;
			return 0;
		case WM_SIZE:
			if (wParam == SIZE_MAXIMIZED || wParam == SIZE_RESTORED) {
				printOutHeight = HIWORD(lParam);
				printout_length_changed();
			}
			return 0;
		case WM_VSCROLL: {
			int scroll_code = LOWORD(wParam);
			SCROLLINFO si;
			si.cbSize = sizeof(SCROLLINFO);
			si.fMask = SIF_ALL;
			GetScrollInfo(hPrintOutWnd, SB_VERT, &si);
			int pos;
			int p = si.nPage;
			if (p > 0)
				p--;
			int maxpos = si.nMax - p;
			switch (scroll_code) {
				case SB_TOP: pos = si.nMin; break;
				case SB_BOTTOM: pos = si.nMax; break;
				case SB_LINEUP: pos = printout_pos - 18; break;
				case SB_LINEDOWN: pos = printout_pos + 18; break;
				case SB_PAGEUP: pos = printout_pos - printOutHeight + 18; break;
				case SB_PAGEDOWN: pos = printout_pos + printOutHeight - 18; break;
				case SB_THUMBPOSITION:
				case SB_THUMBTRACK: pos = HIWORD(wParam); break;
				default: pos = printout_pos;
			}
			if (pos < 0)
				pos = 0;
			else if (pos > maxpos)
				pos = maxpos;
			if (pos != printout_pos) {
				int oldpos = printout_pos;
				printout_pos = pos;
				SetScrollPos(hPrintOutWnd, SB_VERT, printout_pos, TRUE);
				printout_scrolled(oldpos - printout_pos);
			}
			return 0;
		}
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Mesage handler for the About box.
static LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	//SHINITDLGINFO shidi;

	switch (message)
	{
		case WM_INITDIALOG:
			// Create a Done button and size it.  
			//shidi.dwMask = SHIDIM_FLAGS;
			//shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
			//shidi.hDlg = hDlg;
			//SHInitDialog(&shidi);
			return TRUE; 

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK)
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

// Mesage handler for Export Program dialog.
static LRESULT CALLBACK ExportProgram(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) {
		case WM_INITDIALOG: {
			HWND list = GetDlgItem(hDlg, IDC_LIST1);
			char buf[10000];
			TCHAR pname[1000];
			int count = core_list_programs(buf, 10000);
			unsigned char *src = (unsigned char *) buf;
			for (int i = 0; i < count; i++) {
				TCHAR *dst = pname;
				while (*dst++ = *src++);
				SendMessage(list, LB_ADDSTRING, 0, (long) pname);
			}
			return TRUE;
		}
		case WM_COMMAND: {
			int cmd = LOWORD(wParam);
			switch (cmd) {
				case IDOK: {
					HWND list = GetDlgItem(hDlg, IDC_LIST1);
					sel_prog_count = SendMessage(list, LB_GETSELCOUNT, 0, 0);
					if (sel_prog_count > 0) {
						sel_prog_list = (int *) malloc(sel_prog_count * sizeof(int));
						// TODO - handle memory allocation failure
						SendMessage(list, LB_GETSELITEMS, sel_prog_count, (long) sel_prog_list);
					}
					EndDialog(hDlg, 1);
					return TRUE;
				}
				case IDCANCEL: {
					EndDialog(hDlg, 0);
					return FALSE;
				}
			}
			return FALSE;
		}
	}
	return FALSE;
}

// Mesage handler for preferences dialog.
static LRESULT CALLBACK Preferences(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	// TODO: track focus changes so that we can force the IDC_PRINTER_GIF_HEIGHT
	// text field to contain a legal value whenever it loses focus.
	// Question: HOW do you track focus changes? I don't know what message
	// to look for.

	switch (message)
	{
		case WM_INITDIALOG: {
			// Initialize the dialog from the prefs structures
			HWND ctl;
			if (core_settings.matrix_singularmatrix) {
				ctl = GetDlgItem(hDlg, IDC_MATRIX_SINGULARMATRIX);
				SendMessage(ctl, BM_SETCHECK, 1, 0);
			}
			if (core_settings.matrix_outofrange) {
				ctl = GetDlgItem(hDlg, IDC_MATRIX_OUTOFRANGE);
				SendMessage(ctl, BM_SETCHECK, 1, 0);
			}
			if (state.printerToTxtFile) {
				ctl = GetDlgItem(hDlg, IDC_PRINTER_TXT);
				SendMessage(ctl, BM_SETCHECK, 1, 0);
			}
			SetDlgItemText(hDlg, IDC_PRINTER_TXT_NAME, state.printerTxtFileName);
			if (core_settings.raw_text) {
				ctl = GetDlgItem(hDlg, IDC_RAW_TEXT);
				SendMessage(ctl, BM_SETCHECK, 1, 0);
			}
			if (state.printerToGifFile) {
				ctl = GetDlgItem(hDlg, IDC_PRINTER_GIF);
				SendMessage(ctl, BM_SETCHECK, 1, 0);
			}
			SetDlgItemText(hDlg, IDC_PRINTER_GIF_NAME, state.printerGifFileName);
			SetDlgItemInt(hDlg, IDC_PRINTER_GIF_HEIGHT, state.printerGifMaxLength, TRUE);
			return TRUE;
		}

		case WM_COMMAND: {
			int cmd = LOWORD(wParam);
			switch (cmd) {
				case IDOK: {
					// Update the prefs structures from the dialog
					HWND ctl = GetDlgItem(hDlg, IDC_MATRIX_SINGULARMATRIX);
					core_settings.matrix_singularmatrix = SendMessage(ctl, BM_GETCHECK, 0, 0) != 0;
					ctl = GetDlgItem(hDlg, IDC_MATRIX_OUTOFRANGE);
					core_settings.matrix_outofrange = SendMessage(ctl, BM_GETCHECK, 0, 0) != 0;

					ctl = GetDlgItem(hDlg, IDC_PRINTER_TXT);
					state.printerToTxtFile = SendMessage(ctl, BM_GETCHECK, 0, 0);
					TCHAR buf[FILENAMELEN];
					GetDlgItemText(hDlg, IDC_PRINTER_TXT_NAME, buf, FILENAMELEN - 1);
					int len = _tcslen(buf);
					if (len > 0 && (len < 4 || _tcsicmp(buf + len - 4, _T(".txt")) != 0))
						_tcscat(buf, _T(".txt"));
					if (print_txt != NULL && (!state.printerToTxtFile
							|| _tcsicmp(state.printerTxtFileName, buf) != 0)) {
						fclose(print_txt);
						print_txt = NULL;
					}
					_tcscpy(state.printerTxtFileName, buf);
					ctl = GetDlgItem(hDlg, IDC_RAW_TEXT);
					core_settings.raw_text = SendMessage(ctl, BM_GETCHECK, 0, 0) != 0;
					ctl = GetDlgItem(hDlg, IDC_PRINTER_GIF);
					state.printerToGifFile = SendMessage(ctl, BM_GETCHECK, 0, 0);
					BOOL success;
					int maxlen = (int) GetDlgItemInt(hDlg, IDC_PRINTER_GIF_HEIGHT, &success, TRUE);
					state.printerGifMaxLength = !success ? 256 : maxlen < 32 ? 32 : maxlen > 32767 ? 32767 : maxlen;
					GetDlgItemText(hDlg, IDC_PRINTER_GIF_NAME, buf, FILENAMELEN - 1);
					len = _tcslen(buf);
					if (len > 0 && (len < 4 || _tcsicmp(buf + len - 4, _T(".gif")) != 0))
						_tcscat(buf, _T(".gif"));
				    if (print_gif != NULL && (!state.printerToGifFile
							|| _tcsicmp(state.printerGifFileName, buf) != 0)) {
						shell_finish_gif(gif_seeker, gif_writer);
						fclose(print_gif);
						print_gif = NULL;
					}
					_tcscpy(state.printerGifFileName, buf);
					// fall through
				}
				case IDCANCEL:
					EndDialog(hDlg, LOWORD(wParam));
					return TRUE;
				case IDC_PRINTER_TXT_BROWSE: {
					TCHAR buf[FILENAMELEN];
					GetDlgItemText(hDlg, IDC_PRINTER_TXT_NAME, buf, FILENAMELEN - 1);
					if (browse_file(hDlg,
									_T("Select Text File Name"),
									1,
									_T("Text Files (*.txt)\0*.txt\0All Files (*.*)\0*.*\0\0"),
									_T("txt"),
									buf,
									FILENAMELEN))
						SetDlgItemText(hDlg, IDC_PRINTER_TXT_NAME, buf);
					return TRUE;
				}
				case IDC_PRINTER_GIF_BROWSE: {
					TCHAR buf[FILENAMELEN];
					GetDlgItemText(hDlg, IDC_PRINTER_GIF_NAME, buf, FILENAMELEN - 1);
					if (browse_file(hDlg,
									_T("Select GIF File Name"),
									1,
									_T("GIF Files (*.gif)\0*.gif\0All Files (*.*)\0*.*\0\0"),
									_T("gif"),
									buf,
									FILENAMELEN))
						SetDlgItemText(hDlg, IDC_PRINTER_GIF_NAME, buf);
					return TRUE;
				}
			}
			break;
		}
	}
    return FALSE;
}

static int browse_file(HWND owner, TCHAR *title, int save, TCHAR *filter, TCHAR *defExt, TCHAR *buf, int buflen) {
	OPENFILENAME ofn;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = owner;
	ofn.lpstrFilter = filter;
	ofn.lpstrCustomFilter = NULL;
	ofn.lpstrFile = buf;
	ofn.nMaxFile = buflen;
	ofn.lpstrFileTitle = NULL;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = title;
	ofn.Flags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	ofn.lpstrDefExt = defExt;
	return save ? GetSaveFileName(&ofn) : GetOpenFileName(&ofn);
}

static void copy() {
	if (!OpenClipboard(hMainWnd))
		return;
	char buf[100];
	core_copy(buf, 100);
	int len = strlen(buf) + 1;
	HLOCAL h = LocalAlloc(LMEM_MOVEABLE, len * sizeof(TCHAR));
	if (h != NULL) {
		TCHAR *dst = (TCHAR *) LocalLock(h);
		char *src = buf;
		while (*dst++ = (unsigned char) *src++);
		LocalUnlock(h);
		EmptyClipboard();
		if (SetClipboardData(CF_UNICODETEXT, h) == NULL)
			LocalFree(h);
	}
	CloseClipboard();
}

static void paste() {
	if (!OpenClipboard(hMainWnd))
		return;
	// TODO: If getting Unicode text fails, maybe also try getting
	// CF_TEXT or CF_OEMTEXT.
	HANDLE h = GetClipboardData(CF_UNICODETEXT);
	if (h != NULL) {
		TCHAR *p = (TCHAR *) LocalLock(h);
		if (p != NULL) {
			int len = _tcslen(p);
			char buf[100];
			for (int i = 0; i < 99 && p[i] != 0; i++)
				buf[i] = (char) p[i];
			buf[i] = 0;
			core_paste(buf);
			redisplay();
			LocalUnlock(h);
		}
	}
	CloseClipboard();
}

static void Quit() {
    FILE *printfile = _tfopen(printfilename, _T("wb"));
    if (printfile != NULL) {
		int length = printout_bottom - printout_top;
		if (length < 0)
			length += PRINT_LINES;
		int n = fwrite(&length, 1, sizeof(int), printfile);
		if (n != sizeof(int))
			goto failed;
		if (printout_bottom >= printout_top) {
			n = fwrite(printout + PRINT_BYTESPERLINE * printout_top,
						   1, PRINT_BYTESPERLINE * length, printfile);
			if (n != PRINT_BYTESPERLINE * length)
				goto failed;
		} else {
			n = fwrite(printout + PRINT_BYTESPERLINE * printout_top,
						   1, PRINT_SIZE - PRINT_BYTESPERLINE * printout_top,
							printfile);
			if (n != PRINT_SIZE - PRINT_BYTESPERLINE * printout_top)
				goto failed;
			n = fwrite(printout, 1,
						   PRINT_BYTESPERLINE * printout_bottom, printfile);
			if (n != PRINT_BYTESPERLINE * printout_bottom)
				goto failed;
		}

		fclose(printfile);
		goto done;

		failed:
		fclose(printfile);
		DeleteFile(printfilename);

		done:
		;
    }

	statefile = _tfopen(statefilename, _T("wb"));
	if (statefile != NULL)
		write_shell_state();
	core_quit();
	if (statefile != NULL)
		fclose(statefile);

    if (print_txt != NULL)
		fclose(print_txt);
    
    if (print_gif != NULL) {
		shell_finish_gif(gif_seeker, gif_writer);
		fclose(print_gif);
    }

    shell_spool_exit();
}

static VOID CALLBACK repeater(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime) {
	KillTimer(NULL, timer);
	int repeat = core_repeat();
	if (repeat != 0)
		timer = SetTimer(NULL, 0, repeat == 1 ? 200 : 100, repeater);
	else
		timer = SetTimer(NULL, 0, 250, timeout1);
}

static VOID CALLBACK timeout1(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime) {
	KillTimer(NULL, timer);
	if (ckey != 0) {
		core_keytimeout1();
		timer = SetTimer(NULL, 0, 1750, timeout2);
	} else
		timer = 0;
}

static VOID CALLBACK timeout2(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime) {
	KillTimer(NULL, timer);
	if (ckey != 0)
		core_keytimeout2();
	timer = 0;
}

static VOID CALLBACK timeout3(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime) {
	KillTimer(NULL, timer3);
	core_timeout3(1);
	timer3 = 0;
}

static VOID CALLBACK battery_checker(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime) {
	shell_low_battery();
}

static void show_printout() {
	if (hPrintOutWnd != NULL) {
		BringWindowToTop(hPrintOutWnd);
		return;
	}

	hPrintOutWnd = CreateWindow(szPrintOutWindowClass, szPrintOutTitle, WS_VISIBLE | WS_VSCROLL,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInst, NULL);

	//When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created) is not taken into account. So we resize the window after creating it
	// if a menubar is present
	if (hwndCB)
    {
		RECT rc;
        RECT rcMenuBar;

		GetWindowRect(hPrintOutWnd, &rc);
        GetWindowRect(hwndCB, &rcMenuBar);
		rc.bottom -= (rcMenuBar.bottom - rcMenuBar.top);
		
		MoveWindow(hPrintOutWnd, rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top, FALSE);
	}

	RECT r;
	GetClientRect(hPrintOutWnd, &r);
	printOutHeight = r.bottom;

	printout_length_changed();
	printout_scroll_to_bottom(0);

	ShowWindow(hPrintOutWnd, SW_SHOW);
	UpdateWindow(hPrintOutWnd);
}

static void export_program() {
	if (!DialogBox(hInst, (LPCTSTR)IDD_SELECTPROGRAM, hMainWnd, (DLGPROC)ExportProgram))
		return;
	/* The sel_prog_count global now has the number of selected items;
	 * sel_prog_list is an array of integers containing the item numbers.
	 */
	if (!browse_file(hMainWnd,
					 _T("Export Program"),
					 1,
					 _T("Program Files (*.raw)\0*.raw\0All Files (*.*)\0*.*\0\0"),
					 _T("raw"),
					 export_file_name,
					 FILENAMELEN))
		return;

	export_file = _tfopen(export_file_name, _T("wb"));
	if (export_file == NULL) {
		TCHAR buf[1000];
		_stprintf(buf, _T("Can't open \"%s\" for output."), export_file_name);
		MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
	} else {
		core_export_programs(sel_prog_count, sel_prog_list, NULL);
		if (export_file != NULL) {
			fclose(export_file);
			export_file = NULL;
		}
	}

	free(sel_prog_list);
}

static void import_program() {
	TCHAR buf[FILENAMELEN];
	buf[0] = 0;
	if (!browse_file(hMainWnd,
					 _T("Import Program"),
					 0,
					 _T("Program Files (*.raw)\0*.raw\0All Files (*.*)\0*.*\0\0"),
					 NULL,
					 buf,
					 FILENAMELEN))
		return;

	import_file = _tfopen(buf, _T("rb"));
	if (import_file == NULL) {
		TCHAR buf[1000];
		_stprintf(buf, _T("Could not open \"%s\" for reading."), buf);
		MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
	} else {
		core_import_programs(NULL);
		redisplay();
		if (import_file != NULL) {
			fclose(import_file);
			import_file = NULL;
		}
	}
}

static void clear_printout() {
	printout_top = 0;
	printout_bottom = 0;
	printout_pos = 0;
	printout_length_changed();
	if (hPrintOutWnd != NULL)
		InvalidateRect(hPrintOutWnd, NULL, FALSE);

	if (print_gif != NULL) {
		shell_finish_gif(gif_seeker, gif_writer);
		fclose(print_gif);
		print_gif = NULL;
    }
}

static void repaint_printout(int x, int y, int width, int height, int validate) {
	HDC hdc = GetDC(hPrintOutWnd);
	repaint_printout(hdc, 0, x, y, width, height, validate);
	ReleaseDC(hPrintOutWnd, hdc);
}

static void repaint_printout(HDC hdc, int destpos, int x, int y,
							 int width, int height, int validate) {
	HDC memdc;
	HBITMAP bitmap;
	int xdest, ydest;

	if (destpos) {
		xdest = x;
		ydest = y;
		y = ydest + printout_pos;
	} else {
		xdest = x;
		ydest = y - printout_pos;
	}

	int printout_length = printout_bottom - printout_top;
	if (printout_length < 0)
		printout_length += PRINT_LINES;
	if (y + height > printout_length) {
		RECT r;
		SetRect(&r, xdest, printout_length - printout_pos,
					xdest + width, ydest + height);
		HBRUSH brush = (HBRUSH) GetStockObject(GRAY_BRUSH);
		SelectObject(hdc, brush);
		FillRect(hdc, &r, brush);
		if (y >= printout_length)
			return;
		height = printout_length - y;
	}

	memdc = CreateCompatibleDC(hdc);
	bitmap = CreateBitmap(286, PRINT_LINES, 1, 1, printout);
	SelectObject(memdc, bitmap);

    if (printout_bottom >= printout_top)
		/* The buffer is not wrapped */
		BitBlt(hdc, xdest, ydest, width, height,
				memdc, x, printout_top + y, SRCCOPY);
    else {
		/* The buffer is wrapped */
		if (printout_top + y < PRINT_LINES) {
			if (printout_top + y + height <= PRINT_LINES)
				/* The rectangle is in the lower part of the buffer */
				BitBlt(hdc, xdest, ydest, width, height,
						memdc, x, printout_top + y, SRCCOPY);
			else {
				/* The rectangle spans both parts of the buffer */
				int part1_height = PRINT_LINES - printout_top - y;
				int part2_height = height - part1_height;
				BitBlt(hdc, xdest, ydest, width, part1_height,
						memdc, x, printout_top + y, SRCCOPY);
				BitBlt(hdc, xdest, ydest + part1_height, width, part2_height,
						memdc, x, 0, SRCCOPY);
			}
		} else
			/* The rectangle is in the upper part of the buffer */
			BitBlt(hdc, xdest, ydest, width, height,
					memdc, x, y + printout_top - PRINT_LINES, SRCCOPY);
    }

	DeleteDC(memdc);
	DeleteObject(bitmap);

	if (validate) {
		RECT r;
		SetRect(&r, xdest, ydest, xdest + width, ydest + height);
		ValidateRect(hPrintOutWnd, &r);
	}
}

static void printout_scrolled(int offset) {
	RECT client;
	GetClientRect(hPrintOutWnd, &client);
	ScrollWindowEx(hPrintOutWnd, 0, offset, &client, &client, NULL, NULL, SW_INVALIDATE);
}

static void printout_scroll_to_bottom(int offset) {
	SCROLLINFO si;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
	GetScrollInfo(hPrintOutWnd, SB_VERT, &si);
	si.fMask = SIF_POS;
	int p = si.nPage;
	int oldpos = si.nPos;
	if (p > 0)
		p--;
	si.nPos = si.nMax - p;
	printout_pos = si.nPos;
	SetScrollInfo(hPrintOutWnd, SB_VERT, &si, TRUE);
	printout_scrolled(oldpos - printout_pos - offset);
}

static void printout_length_changed() {
	SCROLLINFO si;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_POS;
	GetScrollInfo(hPrintOutWnd, SB_VERT, &si);
	
	int printout_length = printout_bottom - printout_top;
	if (printout_length < 0)
		printout_length += PRINT_LINES;

	si.fMask = SIF_ALL | SIF_DISABLENOSCROLL;
	si.nMin = 0;
	si.nMax = printout_length > 0 ? printout_length - 1 : 0;
	si.nPage = printout_length < printOutHeight ? printout_length : printOutHeight;
	
	int p = si.nPage;
	if (p > 0)
		p--;
	int maxpos = si.nMax - p;
	if (si.nPos > maxpos)
		si.nPos = maxpos;

	printout_pos = si.nPos;
	SetScrollInfo(hPrintOutWnd, SB_VERT, &si, TRUE);
}

void shell_blitter(const char *bits, int bytesperline, int x, int y,
				   int width, int height) {
	HDC hdc = GetDC(hMainWnd);
	skin_display_blitter(hdc, bits, bytesperline, x, y, width, height);
	if (skey >= -7 && skey <= -2) {
		HDC memdc = CreateCompatibleDC(hdc);
		skin_repaint_key(hdc, memdc, skey, 1);
		DeleteObject(memdc);
	}
	ReleaseDC(hMainWnd, hdc);
}

void shell_beeper(int frequency, int duration) {
	HWAVEOUT     hSoundDevice;
	WAVEFORMATEX wf;
	WAVEHDR      wh;
	HANDLE       hEventSound;
	DWORD        i;

	hEventSound = CreateEvent(NULL,FALSE,FALSE,NULL);

	wf.wFormatTag      = WAVE_FORMAT_PCM;
	wf.nChannels       = 1;
	wf.nSamplesPerSec  = 11025;
	wf.nAvgBytesPerSec = 11025;
	wf.nBlockAlign     = 1;
	wf.wBitsPerSample  = 8;
	wf.cbSize          = 0;

	if (waveOutOpen(&hSoundDevice,WAVE_MAPPER,&wf,(DWORD)hEventSound,0,CALLBACK_EVENT) != 0)
	{
		CloseHandle(hEventSound);			// no sound available
		MessageBeep(MB_ICONASTERISK);
		return;
	}

	// (samp/sec) * msecs * (secs/msec) = samps
	wh.dwBufferLength = (DWORD) ((__int64) 11025 * duration / 1000);
	wh.lpData = (LPSTR) LocalAlloc(LMEM_FIXED,wh.dwBufferLength);
	if (wh.lpData != NULL) {
		wh.dwBytesRecorded = 0;
		wh.dwUser = 0;
		wh.dwFlags = 0;
		wh.dwLoops = 0;

		for (i = 0; i < wh.dwBufferLength; ++i)	// generate square wave
			wh.lpData[i] = (BYTE) (((__int64) 2 * frequency * i / 11025) & 1) * 64;

		if (waveOutPrepareHeader(hSoundDevice,&wh,sizeof(wh)) == MMSYSERR_NOERROR) {
			ResetEvent(hEventSound);				// prepare event for finishing
			if (waveOutWrite(hSoundDevice,&wh,sizeof(wh)) == MMSYSERR_NOERROR)
				WaitForSingleObject(hEventSound,INFINITE); // wait for finishing

			waveOutUnprepareHeader(hSoundDevice,&wh,sizeof(wh));
			waveOutClose(hSoundDevice);
		}

		LocalFree(wh.lpData);
	}
	CloseHandle(hEventSound);
	return;
}

/* shell_annunciators()
 * Callback invoked by the emulator core to change the state of the display
 * annunciators (up/down, shift, print, run, battery, (g)rad).
 * Every parameter can have values 0 (turn off), 1 (turn on), or -1 (leave
 * unchanged).
 * The battery annunciator is missing from the list; this is the only one of
 * the lot that the emulator core does not actually have any control over, and
 * so the shell is expected to handle that one by itself.
 */
void shell_annunciators(int updn, int shf, int prt, int run, int g, int rad) {
	HDC hdc = GetDC(hMainWnd);
	HDC memdc = CreateCompatibleDC(hdc);

    if (updn != -1 && ann_updown != updn) {
		ann_updown = updn;
		skin_repaint_annunciator(hdc, memdc, 1, ann_updown);
    }
    if (shf != -1 && ann_shift != shf) {
		ann_shift = shf;
		skin_repaint_annunciator(hdc, memdc, 2, ann_shift);
    }
    if (prt != -1 && ann_print != prt) {
		ann_print = prt;
		skin_repaint_annunciator(hdc, memdc, 3, ann_print);
    }
    if (run != -1 && ann_run != run) {
		ann_run = run;
		skin_repaint_annunciator(hdc, memdc, 4, ann_run);
    }
    if (g != -1 && ann_g != g) {
		ann_g = g;
		skin_repaint_annunciator(hdc, memdc, 6, ann_g);
    }
    if (rad != -1 && ann_rad != rad) {
		ann_rad = rad;
		skin_repaint_annunciator(hdc, memdc, 7, ann_rad);
    }

	DeleteDC(memdc);
	ReleaseDC(hMainWnd, hdc);
}

int shell_wants_cpu() {
	MSG msg;
	return PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE) != 0;
}

void shell_delay(int duration) {
	Sleep(duration);
}

/* Callback to ask the shell to call core_timeout3() after the given number of
 * milliseconds. If there are keystroke events during that time, the timeout is
 * cancelled. (Pressing 'shift' does not cancel the timeout.)
 * This function supports the delay after SHOW, MEM, and shift-VARMENU.
 */
void shell_request_timeout3(int delay) {
	if (timer3 != 0)
		KillTimer(NULL, timer3);
	timer3 = SetTimer(NULL, 0, delay, timeout3);
}

int4 shell_read_saved_state(void *buf, int4 bufsize) {
    if (statefile == NULL)
        return -1;
    else {
        int4 n = fread(buf, 1, bufsize, statefile);
        if (n != bufsize && ferror(statefile)) {
            fclose(statefile);
            statefile = NULL;
            return -1;
        } else
            return n;
    }
}

bool shell_write_saved_state(const void *buf, int4 nbytes) {
    if (statefile == NULL)
        return false;
    else {
        int4 n = fwrite(buf, 1, nbytes, statefile);
        if (n != nbytes) {
            fclose(statefile);
			DeleteFile(statefilename);
            statefile = NULL;
            return false;
        } else
            return true;
    }
}

uint4 shell_get_mem() {
	MEMORYSTATUS memstat;
	GlobalMemoryStatus(&memstat);
	return memstat.dwAvailPhys;
}

int shell_low_battery() {
	SYSTEM_POWER_STATUS_EX powerstat;
	int lowbat;
	if (!GetSystemPowerStatusEx(&powerstat, TRUE))
		lowbat = 0; // getting power status failed; assume we're fine
	else
		lowbat = powerstat.ACLineStatus == AC_LINE_OFFLINE // offline
				&& (powerstat.BatteryFlag
					& (BATTERY_FLAG_LOW | BATTERY_FLAG_CRITICAL)) != 0; // low or critical
	if (ann_battery != lowbat) {
		ann_battery = lowbat;
		HDC hdc = GetDC(hMainWnd);
		HDC memdc = CreateCompatibleDC(hdc);
		skin_repaint_annunciator(hdc, memdc, 5, ann_battery);
		DeleteDC(memdc);
		ReleaseDC(hMainWnd, hdc);
	}
	return lowbat;
}

void shell_powerdown() {
	PostQuitMessage(0);
}

double shell_random_seed() {
	return ((double) rand()) / (RAND_MAX + 1.0);
}

uint4 shell_milliseconds() {
	return GetTickCount();
}

void shell_print(const char *text, int length,
		 const char *bits, int bytesperline,
		 int x, int y, int width, int height) {
    int xx, yy;
    int oldlength, newlength;

    for (yy = 0; yy < height; yy++) {
		if (narrow_printout) {
			for (xx = 0; xx < 286; xx++) {
				int bit;
				if (xx < width) {
					char c = bits[(y + yy) * bytesperline + ((x + xx) >> 3)];
					bit = (c & (1 << ((x + xx) & 7))) != 0;
				} else
					bit = 0;
				int4 Y = (printout_bottom + yy) % PRINT_LINES;
				if (!bit)
					printout[Y * PRINT_BYTESPERLINE + (xx >> 3)]
						|= 128 >> (xx & 7);
				else
					printout[Y * PRINT_BYTESPERLINE + (xx >> 3)]
						&= ~(128 >> (xx & 7));
			}
		} else {
			int4 Y = (printout_bottom + 2 * yy) % PRINT_LINES;
			for (xx = 0; xx < 143; xx++) {
				int bit, px, py;
				if (xx < width) {
					char c = bits[(y + yy) * bytesperline + ((x + xx) >> 3)];
					bit = (c & (1 << ((x + xx) & 7))) != 0;
				} else
					bit = 0;
				for (px = xx * 2; px < (xx + 1) * 2; px++)
					for (py = Y; py < Y + 2; py++)
						if (!bit)
							printout[py * PRINT_BYTESPERLINE + (px >> 3)]
								|= 128 >> (px & 7);
						else
							printout[py * PRINT_BYTESPERLINE + (px >> 3)]
								&= ~(128 >> (px & 7));
			}
		}
    }

    oldlength = printout_bottom - printout_top;
    if (oldlength < 0)
		oldlength += PRINT_LINES;
	int h = narrow_printout ? height : (2 * height);
    printout_bottom = (printout_bottom + h) % PRINT_LINES;
    newlength = oldlength + h;

	if (newlength >= PRINT_LINES) {
		printout_top = (printout_bottom + 2) % PRINT_LINES;
		newlength = PRINT_LINES - 2;
		if (hPrintOutWnd != NULL) {
			if (newlength != oldlength)
				printout_length_changed();
			printout_scroll_to_bottom(h + oldlength - newlength);
			repaint_printout(0, newlength - h, 286, h, 1);
		}
	} else {
		if (hPrintOutWnd != NULL) {
			printout_length_changed();
			printout_scroll_to_bottom(0);
			repaint_printout(0, oldlength, 286, h, 1);
		}
	}

    if (state.printerToTxtFile) {
		TCHAR buf[1000];

		if (print_txt == NULL) {
			print_txt = _tfopen(state.printerTxtFileName, _T("ab"));
			if (print_txt == NULL) {
				state.printerToTxtFile = 0;
				_stprintf(buf, _T("Can't open \"%s\" for output.\nPrinting to TXT file disabled."), state.printerTxtFileName);
				MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
				goto done_print_txt;
			}
		}

		shell_spool_txt(text, length, txt_writer, txt_newliner);
		done_print_txt:;
    }

    if (state.printerToGifFile) {
		TCHAR buf[1000];
		
		if (print_gif != NULL
			&& gif_lines + height > state.printerGifMaxLength) {
			shell_finish_gif(gif_seeker, gif_writer);
			fclose(print_gif);
			print_gif = NULL;
		}

		if (print_gif == NULL) {
			while (1) {
				int len, p;
				FILE *testfile;

				gif_seq = (gif_seq + 1) % 10000;

				_tcscpy(print_gif_name, state.printerGifFileName);
				len = _tcslen(print_gif_name);

				/* Strip ".gif" extension, if present */
				if (len >= 4 &&
					_tcsicmp(print_gif_name + len - 4, _T(".gif")) == 0) {
					len -= 4;
					print_gif_name[len] = 0;
				}

				/* Strip ".[0-9]+", if present */
				p = len;
				while (p > 0 && print_gif_name[p] >= _T('0') && print_gif_name[p] <= _T('9'))
					p--;
				if (p < len && p >= 0 && print_gif_name[p] == _T('.'))
					print_gif_name[p] = 0;

				/* Make sure we have enough space for the ".nnnn.gif" */
				p = 1000 - 10;
				print_gif_name[p] = 0;
				p = _tcslen(print_gif_name);
				_stprintf(print_gif_name + p, _T(".%04d"), gif_seq);
				_tcscat(print_gif_name, _T(".gif"));
				
				/* I know, I know, the civilized thing to do would be to
				 * use stat(2) to find out if the file exists. Another time.
				 * (TODO)
				 */
				testfile = _tfopen(print_gif_name, _T("rb"));
				if (testfile != NULL)
					fclose(testfile);
				else
					break;
			}
			print_gif = _tfopen(print_gif_name, _T("w+b"));
			if (print_gif == NULL) {
				state.printerToGifFile = 0;
				_stprintf(buf, _T("Can't open \"%s\" for output.\nPrinting to GIF file disabled."), print_gif_name);
				MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
				goto done_print_gif;
			}
			if (!shell_start_gif(gif_writer, state.printerGifMaxLength)) {
				state.printerToGifFile = 0;
				MessageBox(hMainWnd, _T("Not enough memory for the GIF encoder.\nPrinting to GIF file disabled."), _T("Message"), MB_ICONWARNING);
				goto done_print_gif;
			}
			gif_lines = 0;
		}

		shell_spool_gif(bits, bytesperline, x, y, width, height, gif_writer);
		gif_lines += height;
		done_print_gif:;
    }
}

int shell_write(const char *buf, int4 buflen) {
    int4 written;
    if (export_file == NULL)
		return 0;
    written = fwrite(buf, 1, buflen, export_file);
    if (written != buflen) {
		TCHAR buf[1000];
		fclose(export_file);
		export_file = NULL;
		_stprintf(buf, _T("Writing \"%s\" failed."), export_file_name);
		MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
		return 0;
    } else
		return 1;
}

int4 shell_read(char *buf, int4 buflen) {
    int4 nread;
    if (import_file == NULL)
		return -1;
    nread = fread(buf, 1, buflen, import_file);
    if (nread != buflen && ferror(import_file)) {
		fclose(import_file);
		import_file = NULL;
		MessageBox(hMainWnd, _T("An error occurred; import was terminated prematurely."), _T("Message"), MB_ICONWARNING);
		return -1;
    } else
		return nread;
}

shell_bcd_table_struct *shell_get_bcd_table() {
	return NULL;
}

shell_bcd_table_struct *shell_put_bcd_table(shell_bcd_table_struct* bcdtab,
					    uint4 size) {
	return bcdtab;
}

void shell_release_bcd_table(shell_bcd_table_struct *bcdtab) {
	free(bcdtab);
}

extern long keymap_filesize;
extern char keymap_filedata[];

static void read_key_map(const TCHAR *keymapfilename) {
	FILE *keymapfile = _tfopen(keymapfilename, _T("r"));
	int kmcap = 0;
	char line[1024];
	int lineno = 0;

	if (keymapfile == NULL) {
		/* Try to create default keymap file */
		long n;

		keymapfile = _tfopen(keymapfilename, _T("wb"));
		if (keymapfile == NULL)
			return;
		n = fwrite(keymap_filedata, 1, keymap_filesize, keymapfile);
		if (n != keymap_filesize)
			fprintf(stderr, "Error writing \"%s\".\n", keymapfilename);
		fclose(keymapfile);

		keymapfile = _tfopen(keymapfilename, _T("r"));
		if (keymapfile == NULL)
			return;
	}

	while (fgets(line, 1024, keymapfile) != NULL) {
		lineno++;
		keymap_entry *entry = parse_keymap_entry(line, lineno);
		if (entry != NULL) {
			/* Create new keymap entry */
			if (keymap_length == kmcap) {
				kmcap += 50;
				keymap = (keymap_entry *) realloc(keymap, kmcap * sizeof(keymap_entry));
				// TODO - handle memory allocation failure
			}
			memcpy(keymap + (keymap_length++), entry, sizeof(keymap_entry));
		}
	}

	fclose(keymapfile);
}

static void init_shell_state(int4 version) {
	switch (version) {
		case -1:
			state.printerToTxtFile = 0;
			state.printerToGifFile = 0;
			state.printerTxtFileName[0] = 0;
			state.printerGifFileName[0] = 0;
			state.printerGifMaxLength = 256;
			state.skinName[0] = 0;
			// fall through
		case 0:
			// current version (SHELL_VERSION = 0),
			// so nothing to do here since everything
			// was initialized from the state file.
			;
	}
}

static bool read_shell_state(int4 *ver) {
    int4 magic;
    int4 version;
    int4 state_size;
    int4 state_version;

    if (shell_read_saved_state(&magic, sizeof(int4)) != sizeof(int4))
        return false;
    if (magic != FREE42_MAGIC)
        return false;

    if (shell_read_saved_state(&version, sizeof(int4)) != sizeof(int4))
        return false;
    if (version < 0 || version > FREE42_VERSION)
        /* Unknown state file version */
        return false;

	if (version > 0) {
		if (shell_read_saved_state(&state_size, sizeof(int4)) != sizeof(int4))
			return false;
		if (shell_read_saved_state(&state_version, sizeof(int4)) != sizeof(int4))
			return false;
		if (state_version < 0 || state_version > SHELL_VERSION)
			/* Unknown shell state version */
			return false;
		if (shell_read_saved_state(&state, state_size) != state_size)
			return false;
		// Initialize the parts of the shell state
		// that were NOT read from the state file
		init_shell_state(state_version);
	} else
		init_shell_state(-1);

	*ver = version;
    return true;
}

static bool write_shell_state() {
    int4 magic = FREE42_MAGIC;
    int4 version = FREE42_VERSION;
    int4 state_size = sizeof(state_type);
    int4 state_version = SHELL_VERSION;

    if (!shell_write_saved_state(&magic, sizeof(int4)))
        return false;
    if (!shell_write_saved_state(&version, sizeof(int4)))
        return false;
    if (!shell_write_saved_state(&state_size, sizeof(int4)))
        return false;
    if (!shell_write_saved_state(&state_version, sizeof(int4)))
        return false;
    if (!shell_write_saved_state(&state, sizeof(state_type)))
        return false;

    return true;
}

/* Callbacks used by shell_print() and shell_spool_txt() / shell_spool_gif() */

static void txt_writer(const char *text, int length) {
    int n;
    if (print_txt == NULL)
		return;
    n = fwrite(text, 1, length, print_txt);
    if (n != length) {
		TCHAR buf[1000];
		state.printerToTxtFile = 0;
		fclose(print_txt);
		print_txt = NULL;
		_stprintf(buf, _T("Error while writing to \"%s\".\nPrinting to TXT file disabled"), state.printerTxtFileName);
		MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
    }
}

static void txt_newliner() {
    if (print_txt == NULL)
		return;
    fputs("\r\n", print_txt);
    fflush(print_txt);
}

static void gif_seeker(int4 pos) {
    if (print_gif == NULL)
		return;
    if (fseek(print_gif, pos, SEEK_SET) == -1) {
		TCHAR buf[1000];
		state.printerToGifFile = 0;
		fclose(print_gif);
		print_gif = NULL;
		_stprintf(buf, _T("Error while seeking \"%s\".\nPrinting to GIF file disabled"), print_gif_name);
		MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
    }
}

static void gif_writer(const char *text, int length) {
    int n;
    if (print_gif == NULL)
		return;
    n = fwrite(text, 1, length, print_gif);
    if (n != length) {
		TCHAR buf[1000];
		state.printerToGifFile = 0;
		fclose(print_gif);
		print_gif = NULL;
		_stprintf(buf, _T("Error while writing to \"%s\".\nPrinting to GIF file disabled"), print_gif_name);
		MessageBox(hMainWnd, buf, _T("Message"), MB_ICONWARNING);
    }
}
