/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "params.h"
#include "strings.h"

static char *(str_cz[]) = {
	"Chyba: ",
	"Nedostatek pameti",
	"Parametr -map vyzaduje uvedeni nazvu kola",
	"Neznamy parametr (%s)",
	"Nelze vytvorit odkladaci buffer (malo pameti?)",
	"patn heslo.",
	"Nelze otevrit %s pro zapis.",
	"Nelze natahnout obrazek",
	"Nelze zkonvertovat obrazek",
	"Nepodarilo se inicializovat SDL",
	"Nelze nastavit fullscreen videorezim 640x400x16",
	"%d. kolo",
	"Heslo: ",
	"Vytvoen kolo",
	"Nekonzistence v datech.",
	"Nelze otevrit balik (%s)",
	"Pouzivam balik %s.\n",
	"Chyba pri cteni hlavicky baliku",
	"Chyba pri cteni hlavicek baliku",
	"Vadny balik",
	"Nelze najit %s v baliku",
	"Chyba pri cteni souboru z baliku",
	"Chyba pri dekomprimaci baliku (%s)",
	"Soubor v baliku je zkomprimovany a neni zakompilovana podpora dekomprimace",
	"Spatny pocet kol (sada %d)",
	"Vadne kolo (%d/%d)",
	"Nelze otevrit soubor %s",
	"Nelze cist ze souboru %s",
	"Vadny soubor %s",
	"Chybejici heslo pro %d. kolo",
	"Chyba pi zpisu save souboru!",
	"%d.%m.'%y %H:%M",
};

static char *(str_en[]) = {
	"Error: ",
	"Not enough memory",
	"The -map parameter requires a file name",
	"Unknown parameter (%s)",
	"Cannot create store buffer (not enough memory?)",
	"Bad password.",
	"Cannot open %s for writing.",
	"Cannot load image",
	"Cannot convert image",
	"SDL init failed",
	"Cannot set fullscreen 640x400x16 videomode",
	"Level %d",
	"Passw: ",
	"User level",
	"Inconsistent data.",
	"Cannot open pack file (%s)",
	"Using pack file %s.\n",
	"Error reading pack file header",
	"Error reading pack file headers",
	"Invalid pack file",
	"Cannot find %s in the pack file",
	"Error reading file from the pack file",
	"Error unpacking pack file (%s)",
	"Packed file in the pack file but no support for unpacking",
	"Invalid number of levels (set %d)",
	"Damaged level (%d/%d)",
	"Cannot open file %s",
	"Cannot read file %s",
	"Bad file %s",
	"Missing password for level %d",
	"Error writing save file!",
	"%m.%d.'%y %H:%M",
};

static char **str_act = str_en;

char *ls(enum ls_string id)
{
	return str_act[id];
}

void reinit_ls(void)
{
	switch (param_lang) {
	case LANG_CZ:
		str_act = str_cz;
		break;
	case LANG_EN:
	default:
		str_act = str_en;
		break;
	}
}
