/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * params.h
 *
 * Funkce pro parsing prikazoveho radku a nahrani/ulozeni konfigurace.
 *
 */

#ifndef _PARAMS_H
#define _PARAMS_H
#include "SDL.h"

/* Promenne param_xxx */
extern int param_editor;        /* spustit editor - neimplementovano */
extern int param_userlevel;     /* uzivatelske kolo */
extern int param_lang;          /* jazyk */

#define LANG_EN		0
#define LANG_CZ		1

extern char *userlevel;         /* nazev souboru s uzivatelskym kolem */

extern char *exedir;            /* cesta, kde je ulozen spusteny program */
extern char homedir[];          /* cesta k domovskemu adresari
                                 * (naplni se az po prvnim volani load_config()) */

extern SDLKey keyscfg[];        /* klavesy pro ovladani */


/* Proparsuje parametry predane na prikazovem radku a nastavi prislusne
 * promenne param_xxx. */
void parse_parameters(int argc, char **argv);

/* Nacte konfiguraci klaves z ~/.fredcfg */
void load_config();

/* Ulozi konfiguraci klaves do ~/.fredcfg */
void save_config();

#endif
