/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef maemo

#include <stdlib.h>
#include <libosso.h>
#include "maemo.h"

static osso_context_t *osco;

static void shutdown_maemo(void)
{
	if (osco) {
		osso_deinitialize(osco);
		osco = NULL;
	}
}

void init_maemo(void)
{
	putenv("SDL_VIDEO_X11_WMCLASS=fred");
	osco = osso_initialize("cz.upir.fred", "0.9.1", TRUE, NULL);
	atexit(shutdown_maemo);
}

#endif
