/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * keytable.c
 *
 * Include soubor s tabulkami klaves (inkludovano z keys.c)
 *
 */

/* Pole nazvu klaves */
keyname_pair keynames_cz[] = {
  { SDLK_UNKNOWN, "(nic)" },
  { SDLK_BACKSPACE, "Backspace" },
  { SDLK_TAB, "Tab" },
  { SDLK_CLEAR, "Clear" },
  { SDLK_RETURN, "Enter" },
  { SDLK_PAUSE, "Pause" },
#ifdef maemo
  { SDLK_ESCAPE, "Zpt" },
#else
  { SDLK_ESCAPE, "Escape" },
#endif
  { SDLK_SPACE, "Mezernk" },
  { SDLK_EXCLAIM, "Exclaim" },
  { SDLK_QUOTEDBL, "\"" },
  { SDLK_HASH, "#" },
  { SDLK_DOLLAR, "$" },
  { SDLK_AMPERSAND, "&" },
  { SDLK_QUOTE, "'" },
  { SDLK_LEFTPAREN, "(" },
  { SDLK_RIGHTPAREN, ")" },
  { SDLK_ASTERISK, "*" },
  { SDLK_PLUS, "+" },
  { SDLK_COMMA, "," },
  { SDLK_MINUS, "-" },
  { SDLK_PERIOD, "." },
  { SDLK_SLASH, "/" },
  { SDLK_0, "0" },
  { SDLK_1, "1" },
  { SDLK_2, "2" },
  { SDLK_3, "3" },
  { SDLK_4, "4" },
  { SDLK_5, "5" },
  { SDLK_6, "6" },
  { SDLK_7, "7" },
  { SDLK_8, "8" },
  { SDLK_9, "9" },
  { SDLK_COLON, ":" },
  { SDLK_SEMICOLON, ";" },
  { SDLK_LESS, "<" },
  { SDLK_EQUALS, "=" },
  { SDLK_GREATER, ">" },
  { SDLK_QUESTION, "?" },
  { SDLK_AT, "@" },
  { SDLK_LEFTBRACKET, "[" },
  { SDLK_BACKSLASH, "\\" },
  { SDLK_RIGHTBRACKET, "]" },
  { SDLK_CARET, "^" },
  { SDLK_UNDERSCORE, "_" },
  { SDLK_BACKQUOTE, "`" },
  { SDLK_a, "A" },
  { SDLK_b, "B" },
  { SDLK_c, "C" },
  { SDLK_d, "D" },
  { SDLK_e, "E" },
  { SDLK_f, "F" },
  { SDLK_g, "G" },
  { SDLK_h, "H" },
  { SDLK_i, "I" },
  { SDLK_j, "J" },
  { SDLK_k, "K" },
  { SDLK_l, "L" },
  { SDLK_m, "M" },
  { SDLK_n, "N" },
  { SDLK_o, "O" },
  { SDLK_p, "P" },
  { SDLK_q, "Q" },
  { SDLK_r, "R" },
  { SDLK_s, "S" },
  { SDLK_t, "T" },
  { SDLK_u, "U" },
  { SDLK_v, "V" },
  { SDLK_w, "W" },
  { SDLK_x, "X" },
  { SDLK_y, "Y" },
  { SDLK_z, "Z" },
  { SDLK_DELETE, "Delete" },
  { SDLK_KP0, "num. 0" },
  { SDLK_KP1, "num. 1" },
  { SDLK_KP2, "num. 2" },
  { SDLK_KP3, "num. 3" },
  { SDLK_KP4, "num. 4" },
  { SDLK_KP5, "num. 5" },
  { SDLK_KP6, "num. 6" },
  { SDLK_KP7, "num. 7" },
  { SDLK_KP8, "num. 8" },
  { SDLK_KP9, "num. 9" },
  { SDLK_KP_PERIOD, "num. ." },
  { SDLK_KP_DIVIDE, "num. /" },
  { SDLK_KP_MULTIPLY, "num. *" },
  { SDLK_KP_MINUS, "num. -" },
  { SDLK_KP_PLUS, "num. +" },
  { SDLK_KP_ENTER, "num. Enter" },
  { SDLK_KP_EQUALS, "num. =" },
  { SDLK_UP, "Nahoru" },
  { SDLK_DOWN, "Dol" },
  { SDLK_RIGHT, "Vpravo" },
  { SDLK_LEFT, "Vlevo" },
  { SDLK_INSERT, "Insert" },
  { SDLK_HOME, "Home" },
  { SDLK_END, "End" },
  { SDLK_PAGEUP, "Page Up" },
  { SDLK_PAGEDOWN, "Page Down" },
  { SDLK_F1, "F1" },
  { SDLK_F2, "F2" },
  { SDLK_F3, "F3" },
#ifdef maemo
  { SDLK_F4, "Menu" },
  { SDLK_F5, "Dom" },
  { SDLK_F6, "Fullscreen" },
  { SDLK_F7, "+" },
  { SDLK_F8, "-" },
#else
  { SDLK_F4, "F4" },
  { SDLK_F5, "F5" },
  { SDLK_F6, "F6" },
  { SDLK_F7, "F7" },
  { SDLK_F8, "F8" },
#endif
  { SDLK_F9, "F9" },
  { SDLK_F10, "F10" },
  { SDLK_F11, "F11" },
  { SDLK_F12, "F12" },
  { SDLK_F13, "F13" },
  { SDLK_F14, "F14" },
  { SDLK_F15, "F15" },
  { SDLK_NUMLOCK, "Num Lock" },
  { SDLK_CAPSLOCK, "Caps Lock" },
  { SDLK_SCROLLOCK, "Scroll Lock" },
  { SDLK_RSHIFT, "Prav Shift" },
#ifdef win32
  { SDLK_LSHIFT, "(Lev)Shift" },
#else
  { SDLK_LSHIFT, "Lev Shift" },
#endif
  { SDLK_RCTRL, "Prav Ctrl" },
  { SDLK_LCTRL, "Lev Ctrl" },
  { SDLK_RALT, "Prav Alt" },
  { SDLK_LALT, "Lev Alt" },
  { SDLK_RMETA, "Prav Meta" },
  { SDLK_LMETA, "Lev Meta" },
  { SDLK_LSUPER, "Lev Win" },
  { SDLK_RSUPER, "Prav Win" },
  { SDLK_MODE, "Mode Shift" },
  { SDLK_HELP, "Help" },
  { SDLK_PRINT, "PrintScreen" },
  { SDLK_SYSREQ, "SysRq" },
  { SDLK_BREAK, "Break" },
  { SDLK_MENU, "Menu" },
  { SDLK_POWER, "Power" },
  { SDLK_EURO, "Euro" }
};

keyname_pair keynames_en[] = {
  { SDLK_UNKNOWN, "(none)" },
  { SDLK_BACKSPACE, "Backspace" },
  { SDLK_TAB, "Tab" },
  { SDLK_CLEAR, "Clear" },
  { SDLK_RETURN, "Enter" },
  { SDLK_PAUSE, "Pause" },
#ifdef maemo
  { SDLK_ESCAPE, "Back" },
#else
  { SDLK_ESCAPE, "Escape" },
#endif
  { SDLK_SPACE, "Space" },
  { SDLK_EXCLAIM, "Exclaim" },
  { SDLK_QUOTEDBL, "\"" },
  { SDLK_HASH, "#" },
  { SDLK_DOLLAR, "$" },
  { SDLK_AMPERSAND, "&" },
  { SDLK_QUOTE, "'" },
  { SDLK_LEFTPAREN, "(" },
  { SDLK_RIGHTPAREN, ")" },
  { SDLK_ASTERISK, "*" },
  { SDLK_PLUS, "+" },
  { SDLK_COMMA, "," },
  { SDLK_MINUS, "-" },
  { SDLK_PERIOD, "." },
  { SDLK_SLASH, "/" },
  { SDLK_0, "0" },
  { SDLK_1, "1" },
  { SDLK_2, "2" },
  { SDLK_3, "3" },
  { SDLK_4, "4" },
  { SDLK_5, "5" },
  { SDLK_6, "6" },
  { SDLK_7, "7" },
  { SDLK_8, "8" },
  { SDLK_9, "9" },
  { SDLK_COLON, ":" },
  { SDLK_SEMICOLON, ";" },
  { SDLK_LESS, "<" },
  { SDLK_EQUALS, "=" },
  { SDLK_GREATER, ">" },
  { SDLK_QUESTION, "?" },
  { SDLK_AT, "@" },
  { SDLK_LEFTBRACKET, "[" },
  { SDLK_BACKSLASH, "\\" },
  { SDLK_RIGHTBRACKET, "]" },
  { SDLK_CARET, "^" },
  { SDLK_UNDERSCORE, "_" },
  { SDLK_BACKQUOTE, "`" },
  { SDLK_a, "A" },
  { SDLK_b, "B" },
  { SDLK_c, "C" },
  { SDLK_d, "D" },
  { SDLK_e, "E" },
  { SDLK_f, "F" },
  { SDLK_g, "G" },
  { SDLK_h, "H" },
  { SDLK_i, "I" },
  { SDLK_j, "J" },
  { SDLK_k, "K" },
  { SDLK_l, "L" },
  { SDLK_m, "M" },
  { SDLK_n, "N" },
  { SDLK_o, "O" },
  { SDLK_p, "P" },
  { SDLK_q, "Q" },
  { SDLK_r, "R" },
  { SDLK_s, "S" },
  { SDLK_t, "T" },
  { SDLK_u, "U" },
  { SDLK_v, "V" },
  { SDLK_w, "W" },
  { SDLK_x, "X" },
  { SDLK_y, "Y" },
  { SDLK_z, "Z" },
  { SDLK_DELETE, "Delete" },
  { SDLK_KP0, "num 0" },
  { SDLK_KP1, "num 1" },
  { SDLK_KP2, "num 2" },
  { SDLK_KP3, "num 3" },
  { SDLK_KP4, "num 4" },
  { SDLK_KP5, "num 5" },
  { SDLK_KP6, "num 6" },
  { SDLK_KP7, "num 7" },
  { SDLK_KP8, "num 8" },
  { SDLK_KP9, "num 9" },
  { SDLK_KP_PERIOD, "num ." },
  { SDLK_KP_DIVIDE, "num /" },
  { SDLK_KP_MULTIPLY, "num *" },
  { SDLK_KP_MINUS, "num -" },
  { SDLK_KP_PLUS, "num +" },
  { SDLK_KP_ENTER, "num Enter" },
  { SDLK_KP_EQUALS, "num =" },
  { SDLK_UP, "Up" },
  { SDLK_DOWN, "Down" },
  { SDLK_RIGHT, "Right" },
  { SDLK_LEFT, "Left" },
  { SDLK_INSERT, "Insert" },
  { SDLK_HOME, "Home" },
  { SDLK_END, "End" },
  { SDLK_PAGEUP, "Page Up" },
  { SDLK_PAGEDOWN, "Page Down" },
  { SDLK_F1, "F1" },
  { SDLK_F2, "F2" },
  { SDLK_F3, "F3" },
#ifdef maemo
  { SDLK_F4, "Menu" },
  { SDLK_F5, "Home" },
  { SDLK_F6, "Fullscreen" },
  { SDLK_F7, "+" },
  { SDLK_F8, "-" },
#else
  { SDLK_F4, "F4" },
  { SDLK_F5, "F5" },
  { SDLK_F6, "F6" },
  { SDLK_F7, "F7" },
  { SDLK_F8, "F8" },
#endif
  { SDLK_F9, "F9" },
  { SDLK_F10, "F10" },
  { SDLK_F11, "F11" },
  { SDLK_F12, "F12" },
  { SDLK_F13, "F13" },
  { SDLK_F14, "F14" },
  { SDLK_F15, "F15" },
  { SDLK_NUMLOCK, "Num Lock" },
  { SDLK_CAPSLOCK, "Caps Lock" },
  { SDLK_SCROLLOCK, "Scroll Lock" },
  { SDLK_RSHIFT, "Right Shift" },
#ifdef win32
  { SDLK_LSHIFT, "(Left) Shift" },
#else
  { SDLK_LSHIFT, "Left Shift" },
#endif
  { SDLK_RCTRL, "Right Ctrl" },
  { SDLK_LCTRL, "Left Ctrl" },
  { SDLK_RALT, "Right Alt" },
  { SDLK_LALT, "Left Alt" },
  { SDLK_RMETA, "Right Meta" },
  { SDLK_LMETA, "Left Meta" },
  { SDLK_LSUPER, "Left Win" },
  { SDLK_RSUPER, "Right Win" },
  { SDLK_MODE, "Mode Shift" },
  { SDLK_HELP, "Help" },
  { SDLK_PRINT, "PrintScreen" },
  { SDLK_SYSREQ, "SysRq" },
  { SDLK_BREAK, "Break" },
  { SDLK_MENU, "Menu" },
  { SDLK_POWER, "Power" },
  { SDLK_EURO, "Euro" }
};


/* Prekladova tabulka klaves */
keytranslate_pair xtab_cz[] = {
  { SDLK_BACKSPACE, '\b' },
  { SDLK_CLEAR, '\x1b' },
  { SDLK_RETURN, '\n' },
  { SDLK_ESCAPE, '\x1b' },
  { SDLK_SPACE, ' ' },
  { SDLK_QUOTEDBL, '"' },
  { SDLK_HASH, '#' },
  { SDLK_DOLLAR, '$' },
  { SDLK_AMPERSAND, '&' },
  { SDLK_QUOTE, '\xac' },                /* uvozovky dole */
  { SDLK_LEFTPAREN, '(' },
  { SDLK_RIGHTPAREN, ')' },
  { SDLK_ASTERISK, '*' },
  { SDLK_PLUS, '+' },
  { SDLK_COMMA, ',' },
  { SDLK_MINUS, '=' },
  { SDLK_PERIOD, '.' },
  { SDLK_SLASH, '-' },
  { SDLK_0, '' },
  { SDLK_1, '+' },
  { SDLK_2, '' },
  { SDLK_3, '' },
  { SDLK_4, '' },
  { SDLK_5, '' },
  { SDLK_6, '' },
  { SDLK_7, '' },
  { SDLK_8, '' },
  { SDLK_9, '' },
  { SDLK_COLON, ':' },
  { SDLK_SEMICOLON, '' },
  { SDLK_LESS, '<' },
  { SDLK_EQUALS, '=' },
  { SDLK_GREATER, '>' },
  { SDLK_QUESTION, '?' },
  { SDLK_AT, '@' },
  { SDLK_LEFTBRACKET, '' },
  { SDLK_BACKSLASH, '\\' },
  { SDLK_RIGHTBRACKET, ')' },
  { SDLK_CARET, '^' },
  { SDLK_UNDERSCORE, '_' },
  { SDLK_BACKQUOTE, ';' },
  { SDLK_a, 'a' },
  { SDLK_b, 'b' },
  { SDLK_c, 'c' },
  { SDLK_d, 'd' },
  { SDLK_e, 'e' },
  { SDLK_f, 'f' },
  { SDLK_g, 'g' },
  { SDLK_h, 'h' },
  { SDLK_i, 'i' },
  { SDLK_j, 'j' },
  { SDLK_k, 'k' },
  { SDLK_l, 'l' },
  { SDLK_m, 'm' },
  { SDLK_n, 'n' },
  { SDLK_o, 'o' },
  { SDLK_p, 'p' },
  { SDLK_q, 'q' },
  { SDLK_r, 'r' },
  { SDLK_s, 's' },
  { SDLK_t, 't' },
  { SDLK_u, 'u' },
  { SDLK_v, 'v' },
  { SDLK_w, 'w' },
  { SDLK_x, 'x' },
  { SDLK_y, 'z' },
  { SDLK_z, 'y' },
  { SDLK_DELETE, '\b' },
  { SDLK_KP0, '0' },
  { SDLK_KP1, '1' },
  { SDLK_KP2, '2' },
  { SDLK_KP3, '3' },
  { SDLK_KP4, '4' },
  { SDLK_KP5, '5' },
  { SDLK_KP6, '6' },
  { SDLK_KP7, '7' },
  { SDLK_KP8, '8' },
  { SDLK_KP9, '9' },
  { SDLK_KP_PERIOD, '.' },
  { SDLK_KP_DIVIDE, '/' },
  { SDLK_KP_MULTIPLY, '*' },
  { SDLK_KP_MINUS, '-' },
  { SDLK_KP_PLUS, '+' },
  { SDLK_KP_ENTER, '\n' },
  { SDLK_KP_EQUALS, '=' }
};

/* Prekladova tabulka klaves se SHIFTem */
keytranslate_pair xtab_sh_cz[] = {
  { SDLK_BACKSPACE, '\b' },
  { SDLK_CLEAR, '\x1b' },
  { SDLK_RETURN, '\n' },
  { SDLK_ESCAPE, '\x1b' },
  { SDLK_SPACE, ' ' },
  { SDLK_QUOTEDBL, '"' },
  { SDLK_HASH, '#' },
  { SDLK_DOLLAR, '$' },
  { SDLK_AMPERSAND, '&' },
  { SDLK_QUOTE, '!' },
  { SDLK_LEFTPAREN, '(' },
  { SDLK_RIGHTPAREN, ')' },
  { SDLK_ASTERISK, '*' },
  { SDLK_PLUS, '+' },
  { SDLK_COMMA, '?' },
  { SDLK_MINUS, '%' },
  { SDLK_PERIOD, ':' },
  { SDLK_SLASH, '_' },
  { SDLK_0, '0' },
  { SDLK_1, '1' },
  { SDLK_2, '2' },
  { SDLK_3, '3' },
  { SDLK_4, '4' },
  { SDLK_5, '5' },
  { SDLK_6, '6' },
  { SDLK_7, '7' },
  { SDLK_8, '8' },
  { SDLK_9, '9' },
  { SDLK_COLON, ':' },
  { SDLK_SEMICOLON, '"' },
  { SDLK_LESS, '<' },
  { SDLK_EQUALS, '+' },
  { SDLK_GREATER, '>' },
  { SDLK_QUESTION, '?' },
  { SDLK_AT, '@' },
  { SDLK_LEFTBRACKET, '/' },
  { SDLK_BACKSLASH, '|' },
  { SDLK_RIGHTBRACKET, '(' },
  { SDLK_CARET, '^' },
  { SDLK_UNDERSCORE, '_' },
  { SDLK_BACKQUOTE, '~' },
  { SDLK_a, 'A' },
  { SDLK_b, 'B' },
  { SDLK_c, 'C' },
  { SDLK_d, 'D' },
  { SDLK_e, 'E' },
  { SDLK_f, 'F' },
  { SDLK_g, 'G' },
  { SDLK_h, 'H' },
  { SDLK_i, 'I' },
  { SDLK_j, 'J' },
  { SDLK_k, 'K' },
  { SDLK_l, 'L' },
  { SDLK_m, 'M' },
  { SDLK_n, 'N' },
  { SDLK_o, 'O' },
  { SDLK_p, 'P' },
  { SDLK_q, 'Q' },
  { SDLK_r, 'R' },
  { SDLK_s, 'S' },
  { SDLK_t, 'T' },
  { SDLK_u, 'U' },
  { SDLK_v, 'V' },
  { SDLK_w, 'W' },
  { SDLK_x, 'X' },
  { SDLK_y, 'Z' },
  { SDLK_z, 'Y' },
  { SDLK_DELETE, '\b' },
  { SDLK_KP0, '0' },
  { SDLK_KP1, '1' },
  { SDLK_KP2, '2' },
  { SDLK_KP3, '3' },
  { SDLK_KP4, '4' },
  { SDLK_KP5, '5' },
  { SDLK_KP6, '6' },
  { SDLK_KP7, '7' },
  { SDLK_KP8, '8' },
  { SDLK_KP9, '9' },
  { SDLK_KP_PERIOD, '.' },
  { SDLK_KP_DIVIDE, '/' },
  { SDLK_KP_MULTIPLY, '*' },
  { SDLK_KP_MINUS, '-' },
  { SDLK_KP_PLUS, '+' },
  { SDLK_KP_ENTER, '\n' },
  { SDLK_KP_EQUALS, '=' }
};


keytranslate_pair xtab_en[] = {
  { SDLK_BACKSPACE, '\b' },
  { SDLK_CLEAR, '\x1b' },
  { SDLK_RETURN, '\n' },
  { SDLK_ESCAPE, '\x1b' },
  { SDLK_SPACE, ' ' },
  { SDLK_QUOTEDBL, '"' },
  { SDLK_HASH, '#' },
  { SDLK_DOLLAR, '$' },
  { SDLK_AMPERSAND, '&' },
  { SDLK_QUOTE, '\'' },
  { SDLK_LEFTPAREN, '(' },
  { SDLK_RIGHTPAREN, ')' },
  { SDLK_ASTERISK, '*' },
  { SDLK_PLUS, '+' },
  { SDLK_COMMA, ',' },
  { SDLK_MINUS, '-' },
  { SDLK_PERIOD, '.' },
  { SDLK_SLASH, '/' },
  { SDLK_0, '0' },
  { SDLK_1, '1' },
  { SDLK_2, '2' },
  { SDLK_3, '3' },
  { SDLK_4, '4' },
  { SDLK_5, '5' },
  { SDLK_6, '6' },
  { SDLK_7, '7' },
  { SDLK_8, '8' },
  { SDLK_9, '9' },
  { SDLK_COLON, ':' },
  { SDLK_SEMICOLON, ';' },
  { SDLK_LESS, '<' },
  { SDLK_EQUALS, '=' },
  { SDLK_GREATER, '>' },
  { SDLK_QUESTION, '?' },
  { SDLK_AT, '@' },
  { SDLK_LEFTBRACKET, '[' },
  { SDLK_BACKSLASH, '\\' },
  { SDLK_RIGHTBRACKET, ']' },
  { SDLK_CARET, '^' },
  { SDLK_UNDERSCORE, '_' },
  { SDLK_BACKQUOTE, '`' },
  { SDLK_a, 'a' },
  { SDLK_b, 'b' },
  { SDLK_c, 'c' },
  { SDLK_d, 'd' },
  { SDLK_e, 'e' },
  { SDLK_f, 'f' },
  { SDLK_g, 'g' },
  { SDLK_h, 'h' },
  { SDLK_i, 'i' },
  { SDLK_j, 'j' },
  { SDLK_k, 'k' },
  { SDLK_l, 'l' },
  { SDLK_m, 'm' },
  { SDLK_n, 'n' },
  { SDLK_o, 'o' },
  { SDLK_p, 'p' },
  { SDLK_q, 'q' },
  { SDLK_r, 'r' },
  { SDLK_s, 's' },
  { SDLK_t, 't' },
  { SDLK_u, 'u' },
  { SDLK_v, 'v' },
  { SDLK_w, 'w' },
  { SDLK_x, 'x' },
  { SDLK_y, 'y' },
  { SDLK_z, 'z' },
  { SDLK_DELETE, '\b' },
  { SDLK_KP0, '0' },
  { SDLK_KP1, '1' },
  { SDLK_KP2, '2' },
  { SDLK_KP3, '3' },
  { SDLK_KP4, '4' },
  { SDLK_KP5, '5' },
  { SDLK_KP6, '6' },
  { SDLK_KP7, '7' },
  { SDLK_KP8, '8' },
  { SDLK_KP9, '9' },
  { SDLK_KP_PERIOD, '.' },
  { SDLK_KP_DIVIDE, '/' },
  { SDLK_KP_MULTIPLY, '*' },
  { SDLK_KP_MINUS, '-' },
  { SDLK_KP_PLUS, '+' },
  { SDLK_KP_ENTER, '\n' },
  { SDLK_KP_EQUALS, '=' }
};

keytranslate_pair xtab_sh_en[] = {
  { SDLK_BACKSPACE, '\b' },
  { SDLK_CLEAR, '\x1b' },
  { SDLK_RETURN, '\n' },
  { SDLK_ESCAPE, '\x1b' },
  { SDLK_SPACE, ' ' },
  { SDLK_QUOTEDBL, '"' },
  { SDLK_HASH, '#' },
  { SDLK_DOLLAR, '$' },
  { SDLK_AMPERSAND, '&' },
  { SDLK_QUOTE, '\'' },
  { SDLK_LEFTPAREN, '(' },
  { SDLK_RIGHTPAREN, ')' },
  { SDLK_ASTERISK, '*' },
  { SDLK_PLUS, '+' },
  { SDLK_COMMA, '<' },
  { SDLK_MINUS, '_' },
  { SDLK_PERIOD, '>' },
  { SDLK_SLASH, '?' },
  { SDLK_0, ')' },
  { SDLK_1, '!' },
  { SDLK_2, '@' },
  { SDLK_3, '#' },
  { SDLK_4, '$' },
  { SDLK_5, '%' },
  { SDLK_6, '^' },
  { SDLK_7, '&' },
  { SDLK_8, '*' },
  { SDLK_9, '(' },
  { SDLK_COLON, ':' },
  { SDLK_SEMICOLON, ':' },
  { SDLK_LESS, '<' },
  { SDLK_EQUALS, '+' },
  { SDLK_GREATER, '>' },
  { SDLK_QUESTION, '?' },
  { SDLK_AT, '@' },
  { SDLK_LEFTBRACKET, '{' },
  { SDLK_BACKSLASH, '|' },
  { SDLK_RIGHTBRACKET, '}' },
  { SDLK_CARET, '^' },
  { SDLK_UNDERSCORE, '_' },
  { SDLK_BACKQUOTE, '~' },
  { SDLK_a, 'A' },
  { SDLK_b, 'B' },
  { SDLK_c, 'C' },
  { SDLK_d, 'D' },
  { SDLK_e, 'E' },
  { SDLK_f, 'F' },
  { SDLK_g, 'G' },
  { SDLK_h, 'H' },
  { SDLK_i, 'I' },
  { SDLK_j, 'J' },
  { SDLK_k, 'K' },
  { SDLK_l, 'L' },
  { SDLK_m, 'M' },
  { SDLK_n, 'N' },
  { SDLK_o, 'O' },
  { SDLK_p, 'P' },
  { SDLK_q, 'Q' },
  { SDLK_r, 'R' },
  { SDLK_s, 'S' },
  { SDLK_t, 'T' },
  { SDLK_u, 'U' },
  { SDLK_v, 'V' },
  { SDLK_w, 'W' },
  { SDLK_x, 'X' },
  { SDLK_y, 'Y' },
  { SDLK_z, 'Z' },
  { SDLK_DELETE, '\b' },
  { SDLK_KP0, '0' },
  { SDLK_KP1, '1' },
  { SDLK_KP2, '2' },
  { SDLK_KP3, '3' },
  { SDLK_KP4, '4' },
  { SDLK_KP5, '5' },
  { SDLK_KP6, '6' },
  { SDLK_KP7, '7' },
  { SDLK_KP8, '8' },
  { SDLK_KP9, '9' },
  { SDLK_KP_PERIOD, '.' },
  { SDLK_KP_DIVIDE, '/' },
  { SDLK_KP_MULTIPLY, '*' },
  { SDLK_KP_MINUS, '-' },
  { SDLK_KP_PLUS, '+' },
  { SDLK_KP_ENTER, '\n' },
  { SDLK_KP_EQUALS, '=' }
};
