/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * keys.h
 *
 * Funkce pro praci s klavesnici.
 *
 */

#ifndef _KEYS_H
#define _KEYS_H
#include "SDL.h"

/* hodnota a modifikatory naposledy stisknute klavesy */
extern SDLKey lastkey;
extern SDLMod lastmod;

/* pole stisknutych klaves */
extern Uint8 *keyboard;


/* Inicializace klavesnice (urceno pro volani z init_sdl()). */
void init_sdlkeys();

void reinit_keys(void);

/* Delay v delce, jaka se ceka pred prijetim klavesy jako stisknute. */
void delay_before_key();

/* Ceka na stisk klavesy a vrati ji. */
SDLKey wait_for_key();


/* Vrati nazev klavesy. */
char *key_name(SDLKey key);

/* Prelozi posledni stisknutou klavesu na znak. */
char key_translate();

#endif
