/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * demosave.c
 *
 * Funkce pro nahrani dema
 *
 */

#ifdef DEMOSAVE

#include <stdlib.h>
#include <stdio.h>
#include "common.h"
#include "demosave.h"


static FILE *fdemo;             /* soubor pro nahravani dema */

static uchar lastdir;           /* pomocne promenne pro RLE kompresi */
static int rlecnt;

static int totalcnt;            /* celkovy pocet ulozenych klaves */


/* Otevre soubor pro nahravani dema (./demosave) */
void init_demosave()
{
  fdemo = fopen("demosave", "wb");
  if (!fdemo)
    error(ls(STR_DEMOSAVE_OPEN_ERROR), "~/demosave");
  rlecnt = 0;
  totalcnt = 0;
  /* ulozime pocet klaves (ted zatim 0) */
  fwrite(&totalcnt, 2, 1, fdemo);
}


/* Zapise jednu klavesu. */
void store_demosave(uchar dir)
{
  /* za chodu provadime RLE kompresi */
  if (!rlecnt || (dir == lastdir && rlecnt < 0x7f)) {
    lastdir = dir;
    rlecnt++;
  }
  else {
    totalcnt += rlecnt;
    if (rlecnt > 1) {
      rlecnt |= 0x80;
      fwrite(&rlecnt, 1, 1, fdemo);
    }
    fwrite(&lastdir, 1, 1, fdemo);
    lastdir = dir;
    rlecnt = 1;
  }
}


/* Ukonci nahravani dema a zavre soubor. */
void shutdown_demosave()
{
  store_demosave(0xff);                 /* trik na vyprazdneni RLE bufferu */
  /* ulozime pocet klaves */
  fseek(fdemo, 0, SEEK_SET);
  fwrite(&totalcnt, 2, 1, fdemo);
  fclose(fdemo);
}

#endif
