/*
 *  Copyright (c) 2002-2007 Jiri Benc <jbenc@upir.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * common.c
 *
 * Spolecne datove typy a funkce.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "common.h"


/* Vypis chyby a ukonceni programu. */
void error(const char *format, ...)
{
  va_list list;

  va_start(list, format);
  fprintf(stderr, ls(STR_COMMON_ERROR));
  vfprintf(stderr, format, list);
  fprintf(stderr, ".\n");
  va_end(list);
  exit(1);
}


/* Alokace pameti a ukonceni programu s chybovou hlaskou, pokud se alokace
 * nepovedla */
void *emalloc(size_t size)
{
  void *res;

  res = malloc(size);
  if (!res)
    error(ls(STR_COMMON_NO_MEM));
  return res;
}

