# Simple Ogg Player v0.2
# Oscar Acena (c) 2006, under GPL terms.

# This is a simple player made on python
# with gstreamer (v0.10), which can read
# ogg files. It plays on alsa.

# Globals? It will do, as this is only an example. };>
ERROR = -1     # The error condition

import pygst
pygst.require("0.10")
import sys, gst, gobject


def new_pad_cb(waveEle, newPad, pipeline):
	print "new pad"
	audioSink = gst.element_factory_make("dsppcmsink", "sinker")
	pipeline.add(audioSink)
	#audioSink.set_property("volume", 65000)
	ugg = audioSink.get_compatible_pad(newPad, newPad.get_caps())
	print ugg.get_direction()
	print newPad.get_direction()
	print newPad.can_link(ugg)
	print audioSink.get_pad("sink").is_linked()
	print waveEle.link_pads("src", audioSink, "sink")
	print audioSink.get_pad("sink").is_linked()


# Main function, it does everything.
def main(args):
    
    # Fist of all, we need the name of the file to play
    # and only that, no more.
   
    # create a new bin to hold the elements, and create
    # the elements to hold.
    try:
		pipeline = gst.Pipeline("flipPipe")
		audioSrc = gst.element_factory_make("gnomevfssrc", "source")
		
		pipeline.add(audioSrc)
		
		
		#create wav parser thing
		test = gst.element_factory_make("wavparse", "test")
		test.connect("pad_added", new_pad_cb, pipeline);
		
		
		pipeline.add(test)



		#audioSink = gst.element_factory_make("dsppcmsink", "sink")
		#pipeline.add(audioSink)
		
		#audioSrc.link(audioSink)
		#gst.element_link_many(audioSrc, test, test2, audioSink)
		
		#test.link(audioSink)
		
		#audioSrc.set_property("location", "file:///home/user/MyDocs/.sounds/Moby-In_My_Heart.mp3")
		audioSrc.set_property("location", "file:///usr/share/sounds/ui-charging_started.wav")
		audioSrc.set_state(gst.STATE_READY) 
		
		audioSrc.link(test)
		#audioSink.set_property("volume", 11000)
		
    except gobject.GError, e:
		print "could not create pipeline, " +str(e)
		return ERROR
        
    # And we put it to dance...
    pipeline.set_state(gst.STATE_PLAYING)

    # Then, the main loop.
    loop = gobject.MainLoop()

    # Event handler for MainLoop's. It is a nested
    # function because we need acces to loop.
    def events(bus, msg):
        print msg
        t = msg.type
        if t == gst.MESSAGE_EOS: # En Of Stream
            loop.quit()
            
        elif t == gst.MESSAGE_ERROR:
            e, d = msg.parse_error()
            print "ERROR:",e
            loop.quit()
        
        return True    

    # A watch for handle events.
    pipeline.get_bus().add_watch(events)

    # Start all.
    try:
        print "Playing..."    
        loop.run()
        
    except KeyboardInterrupt: # if you press Ctrl+C
        pass
    
    print "Stopping...\nBye!"

    # Once the file is played, we go out
    pipeline.set_state(gst.STATE_NULL)
    return 0

# If it is not a module, but a script...
if __name__ == "__main__":
    sys.exit(main(sys.argv))
