#!/usr/bin/python
import pygst
pygst.require("0.10")
import gst
import pygtk
import gtk
import hildon
 
class Player(hildon.Program):
    def __init__(self):
	hildon.Program.__init__(self)
        self.window = hildon.Window()
        self.window.connect("delete_event", gtk.main_quit)
        self.window.set_title("Player")  
        self.add_window(self.window)
 
	self.create_interface()
	self.create_pipeline()
 
	self.window.add(self.table)
	self.window.show_all()
	
    def create_interface(self):
	self.table = gtk.Table(2,2,True)
	buttonPlay = gtk.Button("Play")	
	buttonPause = gtk.Button("Pause")	
	buttonStop = gtk.Button("Stop")
	buttonOpen = gtk.Button("Open")
 
	buttonPlay.connect("clicked",self.OnPlay)
	buttonPause.connect("clicked",self.OnPause)
	buttonStop.connect("clicked",self.OnStop)
	buttonOpen.connect("clicked",self.OnOpen)
 
	self.table.attach(buttonPlay,0,1,0,1)
	self.table.attach(buttonPause,1,2,0,1)
	self.table.attach(buttonStop,0,1,1,2)
	self.table.attach(buttonOpen,1,2,1,2)
 
    def create_pipeline(self):
        # Create GStreamer bits and bobs
 
        self.pipeline = gst.Pipeline("mypipeline")
 
        self.audiosrc = gst.element_factory_make("gnomevfssrc","source")
        self.pipeline.add(self.audiosrc)
 
        self.audiosink = gst.element_factory_make("dspmp3sink", "sink")
        self.pipeline.add(self.audiosink)
 
        self.audiosrc.link(self.audiosink)
 
    def OnPlay(self, widget):
        self.pipeline.set_state(gst.STATE_PLAYING)
 
    def OnPause(self, widget):
        self.pipeline.set_state(gst.STATE_PAUSED)
 
    def OnStop(self, widget):
	if self.pipeline.get_state() != gst.STATE_PAUSED:
		self.pipeline.set_state(gst.STATE_PAUSED)
	if self.pipeline.get_state() != gst.STATE_NULL:
        	self.pipeline.set_state(gst.STATE_NULL)
 
    def OnOpen(self, widget): 
	dialog = hildon.FileChooserDialog(self.window,gtk.FILE_CHOOSER_ACTION_OPEN)
        response = dialog.run()
        dialog.hide()
        file_name = dialog.get_filename()
        print file_name
        if response == gtk.RESPONSE_OK:
                self.audiosrc.set_property("location", "file:///home/user/MyDocs/.sounds/Moby-In_My_Heart.mp3")       
                self.pipeline.set_state(gst.STATE_READY) 
 
start=Player()
gtk.main()