import ci_init as ci
import sys
import ci_gfx
import ci_clock
import ci_alarm
import ci_clock

#Load the configuration/preferences module
import ci_config

import pygame
import pygame.event
from pygame.locals import *
#####################################################################
# Modulo EVENTS 0.1.4 manage the events for differents screens
# Ciro Ippolito
# 20.00 02/21/2009
#
# Updated by Rob Williams (jolouis)
# on 02/27/09 fixed quit button to dispatch quit event to main loop
# rather than trying to handle internally.
#
# On 03/04/09 implemented ci_config for buttons and preferences.
# Cleaned up and added comments to try and help keep track of what all these things do!
# 
######################################################################
pospress=    0
posrelease=   0
cl_pressdown=[]
cl_release= []
al_pressdown=[]
al_release= []
wi_pressdown=[]
wi_release= []
aposx,aposy,ax,ay,aposoff,aposon=ci.al_switch_coords
mposx,mposy,mx,my,mposoff,mposon=ci.mt_switch_coords
#************Area for the CLOCK
cl_area=[(Rect (  0,  0,800,380)),       #0 SWING UP AND DOWN
         (Rect (530,390,168, 80)),       #1 Night
         (Rect (700,390,100, 80))]       #2 EXIT
#************Area for ALARMSET
al_area=[(Rect ( 28, 88,107,207)),	     # 0 H1							
         (Rect (130, 88,107,207)),       # 1 H2								
         (Rect (260, 88,107,207)),       # 2 M1
         (Rect (365, 88,107,207)),       # 3 M2
         (Rect (aposx,aposy,ax,ay)),     # 4 ALARM SWITCH
         (Rect (707,385,80, 80)),     	 # 5 MOOD
         (Rect (mposx,mposy,mx,my)),     #6 12/24 SWITCH
         (Rect (504,280,280, 85)),       #7 ABOUT
         (Rect (  0,  0,800, 75)),       #8 EXIT
         (Rect (0,0,0, 0)),         	   #9 EX HELP
         (Rect (310,390, 50, 53)),       #ALARM Sched 0
         (Rect (360,390, 50, 53)),       #ALARM Sched sun
         (Rect (410,390, 50, 53)),       #ALARM Sched mon
         (Rect (460,390, 50, 53)),       #ALARM Sched tue
         (Rect (510,390, 50, 53)),       #ALARM Sched wed
         (Rect (560,390, 50, 53)),       #ALARM Sched thu
         (Rect (610,390, 50, 53)),       #ALARM Sched fri
         (Rect (660,390, 50, 53))]       #ALARM Sched sat
#************Area for WINDOW MODE
wi_area=[(Rect (  0,    0,400,320)),      # 0 Drag up
         (Rect (aposx-80,aposy-59,ax,ay)),#1 ALARM SWITCH
         (Rect (mposx-80,mposy-59,mx,my)),#2 12/24 SWITCH
         (Rect (500-80,280-60,300, 85)),  #3 ABOUT
         (Rect (707-80,385-60,80, 80))]   #4 MOOD


#################################################################################
# getdata
#   Args - area : a list of rects that you want to check against
#        - position : an [x,y] list position indicating the position you want to check
#
#  Loops over all rects in the "area" list, and checks to see if any of them were hit by "position".
#  The condition of each index is then added to a new status list that can be passed to checkdata
# 
#  eeee... this could use some overhauling... 
#
#################################################################################

def getdata(area,position):               #*********GET  DATA BUTTONS**********
    status=[]
    a=0
    while True:
      try:
        status.append(area[a].collidepoint(position[0],position[1]))
        if status[a]:
          if ci.sw_led==1:
            ci.r,ci.g,ci.b= ci.mr,ci.mg,ci.mb
          ci_alarm.led()
      except:
        break
      a=a+1
    return status

#################################################################################
# checkdata
#   Args - screenname : the "screen" name?
#        - press : a list of indecies representing all the button co-ordinates that the mouse was over when pressed
#        - release : a list of indecies representing all of the button co-ordinates that the mouse was over when released
#
#  Compares the two lists of indecies to decide if a button was pressed and released upon by the user.
# If so, then uses the exec call to call the function "screenname" + the index. I.e. press and release on
# cl_area for night, means index 1 is valid, so tries to call "clockbutton1" since "clockbutton" was passed as the screenname
#
# Wow, that's confusing...
##################################################################################

def checkdata(screenname,press,release):  #*********CHECK DATA BUTTONS*********
  if press == release <>0:       
    a = 0
    while True:
      try:
        if press[a] == release[a] == 1:
          bt=a
      except:
        break
      a = a +1
    try:
      exec "%s%d()" % (screenname, bt)
    except:  
      pass
  #return bt


def drag(switch,slide,posx,posy,x,y):
  x0,y0=pospress
  while True:
    event = pygame.event.wait()
    if event.type == MOUSEBUTTONUP:
      tap_release()
      break
    x,y=pygame.mouse.get_pos()
    #      print x
    spostamento=x-x0
    if ci.sw_config[switch]==0:
      if spostamento<0: spostamento=0
      if spostamento>70: spostamento=70
      ci.al_screen.blit(ci.onoff_switch[1+slide],(posx-76+ spostamento,posy+1))
    elif ci.sw_config[switch]==1:
      if spostamento>0: spostamento=0
      if spostamento<-70: spostamento=-70
      ci.al_screen.blit(ci.onoff_switch[1+slide],(posx-6 + spostamento,posy+1))
    ci.al_screen.blit(ci.onoff_switch[0],(posx,posy))
    area = Rect(posx,posy,x,y)
    pygame.display.update(ci.sw_coords[slide])    


#**************************************PRESS DOWN **********************************************
def tap_down():
  global cl_area, cl_pressdown, cl_release
  global al_area, al_pressdown, al_release
  global ab_area, ab_pressdown, ab_release
  global wi_area, wi_pressdown, wi_release 
  global pospress
  pospress=pygame.mouse.get_pos()
  if ci.fcmode==0:      #sono in CLOCK MODE*****************************
    cl_pressdown=getdata (cl_area,pospress)
  elif ci.fcmode==1:    #sono in ALARM MODE*****************************
    al_pressdown=getdata (al_area,pospress)
    if al_area[4].collidepoint(pospress[0],pospress[1]):            #Alarm SWITCH
      posx, posy ,x ,y = ci.sw_coords[0]
      drag(0, 0, posx, posy, x, y)     
    if al_area[6].collidepoint(pospress[0],pospress[1]):            #MTime SWITCH
      posx, posy ,x ,y = ci.sw_coords[1]
      drag(1, 1, posx,posy,x,y)        
  elif ci.fcmode==2:    #sono in ABOUT MODE*****************************
    pass
  elif ci.fcmode==3:    #sono in WINDOW MODE*****************************
    wi_pressdown=getdata (wi_area,pospress)
    if wi_area[1].collidepoint(pospress[0],pospress[1]):            #Alarm SWITCH
      posx, posy ,x ,y = ci.sw_coords[2]
      drag(0, 0, posx, posy, x, y)          
    if wi_area[2].collidepoint(pospress[0],pospress[1]):            #MTime SWITCH
      posx, posy ,x ,y = ci.sw_coords[3]
      drag(1, 1, posx, posy, x, y)     
  if ci.fcmode==4:      #sono in NIGHT MODE*****************************
    cl_pressdown=getdata (cl_area,pospress)
  return 


#**************************************RELEASE**************************************************
def tap_release():     
  global cl_area, cl_pressdown, cl_release
  global al_area, al_pressdown, al_release
  global ab_area, ab_pressdown, ab_release
  global pospress,posrelease
  posrelease=pygame.mouse.get_pos()
  if ci.sw_led==1:
    ci.r,ci.g,ci.b=0,0,0
    ci_alarm.led()
  ###bt=0
  if ci.fcmode==0:        #*******************CLOCK MODE********************
    cl_release=getdata (cl_area,posrelease)
    bt=checkdata("clockbutton",cl_pressdown,cl_release)
	
  elif ci.fcmode==1:      #*******************ALARM MODE********************    
    al_release = getdata (al_area,posrelease)      
    if al_pressdown[8] > al_release[8]:
      button8()
    if al_pressdown[4]: 						            #Alarm Switch
      ci.sw_config[0]=slide(ci.sw_config[0])    #
      ci_clock.clock()  
    if al_pressdown[6]:                         #Military time switch
		################################ UPDATED BY ROB #######################
		#change between 12 and 24 hour modes
		ci.sw_config[1]=slide(ci.sw_config[1])    #
		ci_config.preferences["militaryTime"] = ci.sw_config[1]
		
		#Save the updated configuration
		ci_config.savePrefs();  
		################################ DONE UPDATED BY ROB ##################
		ci_clock.clock()  
    
	#Run the event handler associated with this position
	bt=checkdata("button",al_pressdown,al_release)
  elif ci.fcmode==2:      #*******************ABOUT MODE********************
    aboutbutton()
  elif ci.fcmode==3:      #*******************WINDOW MODE*******************
    wi_release=getdata (wi_area,posrelease) 
    if wi_pressdown[1]: 
      ci.sw_config[0]=slide(ci.sw_config[0])
      ci_clock.clock()  
    if wi_pressdown[2]:
      ci.sw_config[1]=slide(ci.sw_config[1])
      ################################ UPDATED BY ROB #######################
      ci_config.preferences["militaryTime"] = ci.sw_config[1]

      #Save the updated configuration
      ci_config.savePrefs(); 
      ################################ DONE UPDATED BY ROB ##################
      ci_clock.clock()      
    bt=checkdata("windobutton",wi_pressdown,wi_release)
  elif ci.fcmode==4:      #*******************NIGHT MODE********************
    cl_release=getdata (cl_area,posrelease)
    bt=checkdata("clockbutton",cl_pressdown,cl_release)
  return
  
  
#******************************CLOCK Buttons actions ********************
################### General Clock Mode Button ###########################
# Slide up to change to Window Mode, slide down to go to Alarm settings
#

def clockbutton0():
	if cl_pressdown and cl_release:
		if pospress[1]-20>posrelease[1]:       #slide up to set the alarm
			ci.fcmode = 1
			ca=ci.alarms[ci.al_set]
			ci.al_edi =[int(ca[0]),int(ca[1]),int(ca[3]),int(ca[4])]
			#print "conversizone:",int(curala[0]),curala[1],curala[3],curala[4]
			ci_clock.clock()

		if pospress[1]+20<posrelease[1]:       #slide down switch fulls/window
			ci.fcmode = 3
			ci_clock.clock()
			ci.pygame.display.toggle_fullscreen()      
			
################### Done General Clock Mode Button ######################


################### Button handler to toggle "Night Mode" ###############
def clockbutton1():                         #NIGHT TIME
  if ci.fcmode == 4:
    #Night mode already, so switch to Regular Mode and redraw
    ci.fcmode = 0
    ci_clock.clock()
	
  elif ci.fcmode == 0:
    #Regular mode, so switch to Night Mode and redraw
	ci.fcmode = 4
    ci_clock.clock()
	
################### DONE Button handler to toggle "Night Mode" ##########

################### Button handler to Quit ###############
def clockbutton2():                         #Asta La vista, ciao, arrivederci
	################################ UPDATED BY ROB #######################
	#uhh no! just dispatch the quit event!
	ci.pygame.event.post(pygame.event.Event(pygame.QUIT))
	
	# ci.event=QUIT  
	#ci.pygame.display.quit 
	#ci.pygame.quit()
	#sys.exit(0)
	################################ DONE UPDATED BY ROB ##################

################### Done Button handler to Quit ###############

  
#****************************** ABOUT Buttons actions ********************
def aboutbutton():
  ci.fcmode=1
  ci_clock.clock()

#****************************** WINDOW Buttons actions ********************
def windobutton0():                 #FULL SCREEN (slide up)
  if cl_pressdown and cl_release:
    if pospress[1]-20>posrelease[1]:    #FULL SCREEN (slide up)
      ci.fcmode=0
      ci_clock.clock()
      ci.pygame.display.toggle_fullscreen()      

def windobutton1():                 #ALLARME ON / OFF
  pass  

def windobutton3():                     #Playsound
  if ci.tablet==1:  ci.hildon.hildon_play_system_sound(ci.path+ci.alarmsound)

def windobutton4():                     #HELP
  if ci.moodc<5:
    ci.moodc=ci.moodc+1
  else:
    ci.moodc=0
  if ci.moodc ==0:
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,  0,     0,  0,  0
  elif ci.moodc ==1:    #Yello
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,125,  0,   250,125,  0
  elif ci.moodc ==2:    #blue
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,250,     0,  0,250
  elif ci.moodc ==3:    #red
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,  0,   250,  0,  0    
  elif ci.moodc ==4:    #porpora
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,125,   250,  0,125    
  elif ci.moodc ==5:    #Green
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,250,  0,     0,250,250    
  if ci.fcmode==1:  
    ci_clock.clock()
  elif ci.fcmode==0:
    ci_clock.clock()
  elif ci.fcmode==3:
    ci_clock.clock()
  elif ci.fcmode==4:
    ci_gfx.drawmood()
  ci_gfx.gfx_refresh() 
  
     
#****************************** ALARM buttons actions **************** 
def button0():                            #H1*********************
  if pospress[1] > posrelease[1] :         #direzione giu incremento (sliding up)
    ci.al_edi[0]=ci.al_edi[0]-1
    if ci.al_edi[0]==-1:
      ci.al_edi[0]=0
    else:
      soundrelease()
  elif  pospress[1]<posrelease[1] :     #direzione su decremento (sliding down)
    ci.al_edi[0]=ci.al_edi[0]+1
    if ci.al_edi[0]==2 and ci.al_edi[1] > 4:
      ci.al_edi[0]=1
    elif ci.al_edi[0]==3  and ci.al_edi[1] < 5:
      ci.al_edi[0]=2
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  
  ci_clock.clock()
def button1():                            #H2*********************
  if pospress[1]>posrelease[1]:           #direzione su decremento
    ci.al_edi[1]=ci.al_edi[1]-1
    if ci.al_edi[1]==-1:
      ci.al_edi[1]=0
    else:
      soundrelease()
  elif pospress[1]<posrelease[1]:         #direzione giu incremento
    ci.al_edi[1]=ci.al_edi[1]+1
    if ci.al_edi[1]==4 and ci.al_edi[0]>1:
      ci.al_edi[1]=3      
    elif ci.al_edi[1]>9:
      ci.al_edi[1]=9
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  ci_clock.clock()
def button2():                            #M1*********************
  if pospress[1]>posrelease[1]:
    ci.al_edi[2]=ci.al_edi[2]-1
    if ci.al_edi[2]==-1:
      ci.al_edi[2]=0
    else:
      soundrelease()
  elif pospress[1]<posrelease[1]:
    ci.al_edi[2]=ci.al_edi[2]+1
    if ci.al_edi[2]>5:
      ci.al_edi[2]=5
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  ci_clock.clock()
def button3():                            #M2
  if pospress[1]>posrelease[1]:
    ci.al_edi[3]=ci.al_edi[3]-1
    if ci.al_edi[3]<0:
      ci.al_edi[3]=0
    else:
      soundrelease()
  elif pospress[1]<posrelease[1]:
    ci.al_edi[3]=ci.al_edi[3]+1
    if ci.al_edi[3]>9:
      ci.al_edi[3]=9
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  ci_clock.clock()
def slide(value):
  x0,y0=0,0
  x,y=posrelease
  x0,y0=pospress
  if value==0:
    if x-x0>35:
      value=1
  elif value==1:
    if x-x0<-35:
      value=0
  return value

######################## Alarm On/Off SELECTOR? ######################
def button4():                          #ALLARME ON / OFF...?...
  pass
######################## DONE Alarm On/Off SELECTOR ##################


########################## MOOD Selector ############################
def button5():            #
  if ci.moodc<5:
    ci.moodc=ci.moodc+1
  else:
    ci.moodc=0
  if ci.moodc ==0:
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,  0,     0,  0,  0
  elif ci.moodc ==1:    #Yello
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,125,  0,   250,125,  0
  elif ci.moodc ==2:    #blue
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,250,     0,  0,250
  elif ci.moodc ==3:    #red
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,  0,   250,  0,  0    
  elif ci.moodc ==4:    #porpora
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,125,   250,  0,125    
  elif ci.moodc ==5:    #Green
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,250,  0,     0,250,250    
  if ci.fcmode==1:  
    ci_clock.clock()
  elif ci.fcmode==0:
    ci_clock.clock()
  elif ci.fcmode==3:
    ci_clock.clock()
  elif ci.fcmode==4:
    ci_gfx.drawmood()
  ci_gfx.gfx_refresh()
######################## DONE MOOD SELECTOR ######################

######################## Military Time Handler? ##################
def button6():            #Military Time ON OFF
  pass
######################## Done Military Time Handler ##############

######################## ABOUT Button ############################
def button7():            #ABOUT
  ci.fcmode=2
  ci_clock.clock()
  ci_gfx.gfx_refresh()
######################## Done ABOUT Button #######################

######################## Button to move from ALARM Mode to Clock mode #############
def button8():            #Close Alarm set; return to clock
  #Go back to Regular Clock Mode
  ci.fcmode=0
  
  #Generate alarm time from 4 digit scroller
  ci.sveglia =[ci.al_edi[0],
               ci.al_edi[1],
               ci.al_edi[2],
               ci.al_edi[3]]
			   
  #Convert alarm time to minutes?...
  ci.all_min = ci.sveglia[0]*600+ci.sveglia[1]*60+ci.sveglia[2]*10+ci.sveglia[3]
  
  #Something? Checking to see if alarm time matches now? Something like that?...
  ora = [int(ci.orario[11]),int(ci.orario[12]),int(ci.orario[14]),int(ci.orario[15])]
  if ci.sveglia == ora:         ci.sw_config[0]=0

  ################################## UPDATED BY ROB ###############################
  #Save the updated configuration
  ci_config.savePrefs(); 

  #f = open(ci.userpath+'.flipclock.conf', 'w')
  #for item in ci.alarms:
  #  f.write (item+"\n")
  #f.close()
  ################################### DONE UPDATED BY ROB ##########################
  
  #Redraw clock in new mode
  ci_clock.clock()

######################## DOINE Button to move from ALARM Mode to Clock mode #############

def button9():                         #HELP
	print "premuto help"



#########################################################################################
# Alarm schedule selectors. There's got to be a better way of doing this!

######################## Select Alarm schedule 0 ########################################
def button10():                         #ALARM SCHED
  ci.al_set=0
  ci.bt_aledit=0
  c=ci.alarms[0]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 0 ########################################
  
######################## Select Alarm schedule 1 ############################################# 
def button11():                         #SUNDAY
  ci.al_set=1
  ci.bt_aledit=1
  c=ci.alarms[1]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 1 ########################################

######################## Select Alarm schedule 2 #############################################
def button12():                         #
  ci.al_set=2
  ci.bt_aledit=2
  c=ci.alarms[2]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 2 ########################################

######################## Select Alarm schedule 3 #############################################
def button13():                         #
  ci.al_set=3
  ci.bt_aledit=3
  c=ci.alarms[3]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 4 ########################################

######################## Select Alarm schedule 5 #############################################
def button14():
  ci.al_set=4
  ci.bt_aledit=4
  c=ci.alarms[4]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 5 ########################################

######################## Select Alarm schedule 6 #############################################
def button15():                         #
  ci.al_set=5
  ci.bt_aledit=5
  c=ci.alarms[5]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 6 ########################################

######################## Select Alarm schedule 7 #############################################
def button16():                         #
  ci.al_set=6
  ci.bt_aledit=6
  c=ci.alarms[6]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 7 ########################################

######################## Select Alarm schedule 8 #############################################
def button17():                         #
  ci.al_set=17
  ci.bt_aledit=7
  c=ci.alarms[7]
  ci.al_edi[0]=int(c[0])
  ci.al_edi[1]=int(c[1])
  ci.al_edi[2]=int(c[3])
  ci.al_edi[3]=int(c[4])
  ci_clock.clock()
######################## DONE Select Alarm schedule 8 ########################################


######################## Sound Handlers (Play sound when a button gets clicked) ##############
def soundtap():
	if ci.tablet==1:
		ci.hildon.hildon_play_system_sound(ci.path+"ui-key_press.wav")
	
def soundrelease():
	if ci.tablet==1:
		ci.hildon.hildon_play_system_sound(ci.path+"ui-pen_down.wav")
