######################################################################
# Main FlipClock routines/callbacks.
# Setup in main application and executed by gobject.MainLoop()
# Rob Williams
# 20.00 02/27/2009
######################################################################

#Import libs that we need
import osso
import dbus
import time as myTime
import sys
import gobject

import ci_init as ci
import ci_eventsNew as ci_events
import ci_flip
import ci_clock

from pygame import *



###############################################################################
# clockEventIdle 
# This function gets called periodically by the mainloop
# whenever nothing is happening. It first checks for any
# pygame events that might be pending, and processes them.
# Once those are handled, it checks to see if the tablet is
# in "idle mode", and sleeps for either 10 ms or 100ms if idle
# (to try to save battery since response time is not as important)
# Finally, must return true in order to run in the next mainloop iteration
#
# NO CLOCK/TIME events here, just pygame interactivity events
###############################################################################
def clockEventIdle():
	#nothing else going on, so check for pygame events?...
	event = ci.pygame.event.poll();
			
	if event.type == QUIT:
		ci.pygame.display.quit 
		ci.pygame.quit()
		ci.loop.quit();

	elif event.type == MOUSEBUTTONDOWN:
		ci_events.mouseDown = 1
		ci_events.tap_down()                  #Check where the user tap/click
	elif event.type == MOUSEBUTTONUP:
		ci_events.mouseDown = 0
		ci_events.tap_release()               #User HAVE to release to s*it happen
	elif event.type == MOUSEMOTION:
		if (ci_events.mouseDown):
			#Mouse is moving while pressing, so fire events
			ci_events.tap_drag()				#Mouse is being dragged while held down
	
	if (ci.inactive == 0 or ci.charging == 1):
		myTime.sleep(0.01)
	else:
		#inactive and not charging
		#sleep in a little since nobody's watching
		myTime.sleep(0.1)
	
	return 1

###############################################################################
# clockEventRedraw
#
# Function will be called to redraw the clock. It's initially triggered by a timeout
# and will automatically set itself up to be called again at the next minute change
# if the system is active; if the tablet is inactive then the event does not get fired
# again until the system resumes use.
############################################################################### 
def drawClockEvent():

	#Draw flip as per Ciro's 0.1.3 modification
	ci_flip.flipclock()

	#Redraw the clock
	ci_clock.clock()
			
	#recalculate time for clock event if system is active
	if (ci.inactive == 0 or ci.charging == 1):
		ctime = myTime.ctime()
		gobject.timeout_add((60-int(str(ctime[17])+str(ctime[18])))*1000, drawClockEvent)


############################### D-BUS Event Handling ##############################

##################################################################################
# deviceStateChange
# As per libosso device state, this is a callback that takes arguments:
# shutdown, save_unsaved_data, memory_low, system_inactivity, message, loop
# More details of their meanings here:
# http://maemo.org/api_refs/4.1/libosso-2.16-1/
#
# Anyways, in this case all we're doing is watching to see if the device is active or not, and setting
# the inactivity flag accordingly. Also, if the device does return to activity then the drawClock function is called
# to start displaying again.
#
##################################################################################

def deviceStateChangeEvent(shutdown, save_unsaved_data, memory_low, system_inactivity, message, loop):
	print "System Inactivity: ", system_inactivity
	ci.inactive = system_inactivity
		
	if (ci.inactive == 0 and ci.charging == 0):
		#Just returned from inactivity
		drawClockEvent()
		
	return False


####################################################################################
# dbusRecieveAlarm
# This function gets executed when a dbus event is directed at our interface (org.maemo.flipclock)
# requesting that an alarm be triggered (alarmd is calling us to let us know it's time
# to do our thing.
#
# Currently it accepts the following arguments: 
# alarmSound - Soundfile to use for alarm; if no sound, then null or empty string must be passed
# alarmLEDMode - Use the given LED mode, or 0 for no LED option
# 
# other options to be added in the future?...
#
####################################################################################

def dbusRecieveAlarm(alarmSound, alarmLEDMode = 0):
	osso_c = osso.Context("osso_test_note", "0.0.1", False)
	note = osso.SystemNote(osso_c)
	result = note.system_note_dialog("Can't read the user wallpaper", type='notice') 
	print "Received alarm trigger for " + alarmSound + " with LED " + alarmLEDMode

