######################################################################
# Modulo ci_clock 0.1.0 Manage all the clock/alarm/setting functions
#
# Ciro Ippolito
#
# Updated by Rob Williams (jolouis) on
# 20.00 03/04/2009
######################################################################
import ci_gfx
import ci_init as ci
import ci_alarm
import time
import ci_flip

#Import Config options
import ci_config

#import events
import ci_eventsNew as ci_events


if ci.animation:  import ci_flip

def init_app():
  ci_gfx.bg_clock()
  if ci.animation:  ci_flip.flippingout()
  ci.orario=time.ctime()              # .ctime instead of .locatime        Ritorna: 'DAY MON DA OR:MI:SE YEAR'
  ci.hou_min=int(ci.orario[11])*600+int(ci.orario[12])*60+int(ci.orario[14])*10+int(ci.orario[15])
  #alarm=[0,0,0,0]
  #alarm[0:4] = ci.alarms[int(ci.al_set)]
  #ci.ala_min=int(alarm[0])*600+int(alarm[1])*60+int(alarm[3])*10+int(alarm[4])
  #ci.sveglia=conv_min2est(ci.ala_min)
  #ci_alarm.countdown()
  ci_gfx.drawcountdown()
  clock()
  if ci.sw_led==1:  ci_alarm.carnevale()  
def init_clock():
  ci_gfx.drawclock()
  if ci.sw_led==1:  ci_alarm.carnevale()  
  ci.pygame.display.flip()
def clock():
  ci.day = time.strftime("%w", time.localtime())        #0=Sunday
  ci.orario=time.ctime()              # .ctime instead of .locatime        Ritorna: 'DAY MON DA OR:MI:SE YEAR'
  ci.hou_min=int(ci.orario[11])*600+int(ci.orario[12])*60+int(ci.orario[14])*10+int(ci.orario[15])

  ############################### UPDATED BY ROB ##################################
  # Fixed midnight bug, moved AM/PM calculation to here instead of gfx to simplify and eliminate duplicate code
  #Draw 12 Hour mode instead of 24 hour
  #if (ci.sw_config[1] == 0):
  if (ci_config.preferences["militaryTime"] == 0):
	hours = (int(ci.orario[11]) * 10) + int(ci.orario[12])
	ci.isPM = 0
	if (hours > 11):
		ci.isPM = 1
	if (hours == 0):
		hours = 12
	if (hours > 12):
		hours = hours - 12

	
	ci.timeDigits = str(hours)
  	if (hours < 10):
		ci.timeDigits = "0" + ci.timeDigits
  else:
	ci.timeDigits = ci.orario[11] + ci.orario[12] 
  
  ci.timeDigits = ci.timeDigits + ci.orario[14] + ci.orario[15]
  
  ############################## DONE UPDATED BY ROB ##############################

  ######################## UPDATED BY ROB ######################################
  #
  # WE don't need to redraw everything all the time... just the parts that change.
  # Here, since the clock() method is called based on a timeout, we only redraw
  # parts of screens that are clock/time based... everything else can be
  # redrawn based on interaction and events...

  if ci.fcmode==0:                      #***clockMode ********************************
    #alarm()
    ci_gfx.bg_clock()
    ci_gfx.drawclock()
    ci_gfx.drawdate()
    #ci_gfx.drawsveglia()
    ci_gfx.drawmood()
    #ci_alarm.countdown()
    #ci_gfx.drawcountdown()
    ci_events.initializeScreen()
    #ci_gfx.gfx_refresh()
    #ci_alarm.checkalarm() 
	              
  elif ci.fcmode==1:                    #ALARM*******************************
    pass
	#ci_gfx.bg_alarm()        #Should only be drawn when changing to alarm mode
    #ci_gfx.drawalarm()       #Drawn by selecting the alarm    

    #ci_gfx.drawsveglia()		#Definitely don't need this, that's done by events
    #ci_alarm.countdown()		#thisis a good time based thing, but really it means nothing now so ditch it
    #ci_gfx.drawcountdown()
    #ci_gfx.drawmood()			#this should be handled by an event object,just haven't quite gotten there yet...
  elif ci.fcmode==2:                    #ABOUT********************************
    ci_gfx.bg_about()
    if ci.tablet==1:      ci.hildon.hildon_play_system_sound(ci.path+ci.alarmsound)
    ci_gfx.gfx_refresh()
  elif ci.fcmode==3:                    #WINDOW********************************
    ci_gfx.bg_windo()
    ci_gfx.drawdate()
    ci_gfx.drawsveglia()
    ci_gfx.drawmood()
    #ci_gfx.gfx_refresh() 
    ci_gfx.changecaption()
    #ci_gfx.drawcountdown()
    ci_gfx.drawwindo() 
  elif ci.fcmode==4:            #its business (night) time
    ci_gfx.bg_night()
    ci_gfx.drawnight()
    ci_gfx.drawdate()
    #ci_gfx.drawsveglia()
    ci_gfx.drawmood()
    ci_events.initializeScreen()
	#ci_gfx.gfx_refresh()         
    #ci_alarm.countdown()
    #ci_gfx.drawcountdown()
    #ci_alarm.checkalarm()               # CHECK THE ALARM TIME
  elif ci.fcmode==5:          #Alarm playing
    ci_gfx.bg_clock()
    ci_gfx.drawclock()
    ci_gfx.drawdate()
    ci_gfx.drawsveglia()
    ci_gfx.drawmood()
    ci_gfx.gfx_refresh()
  return
def alarm():
  alarm=[0,0,0,0]
  alarm[0:4] = ci.alarms[ci.al_set]

def conv_min2est(min):
  est=[0,0,0,0]
  est = [(ci.ala_min/600),
         (ci.ala_min%600)/60,
         (ci.ala_min%60)/10,
         (ci.ala_min%60)%10]
  return est

def conv_est2min():
  pass
