import ci_init as ci
import sys
import osso
import os

from datetime import date

#import gtk stuff for file chooser
import pygtk
import gtk
import hildon

import time as myTime
import ci_gfx
import ci_clock
import ci_alarmNew as ci_alarm
import ci_clock

#Load the configuration/preferences module
import ci_config

#copy module, needed for element copying
import copy

#Load alarmD module
import ci_alarmD

import pygame
import pygame.event
from pygame.locals import *

#####################################################################
# Modulo EVENTS 0.1.4 manage the events for differents screens
# Ciro Ippolito
# 20.00 02/21/2009
#
# Updated by Rob Williams (jolouis)
# on 02/27/09 fixed quit button to dispatch quit event to main loop
# rather than trying to handle internally.
#
# On 03/04/09 implemented ci_config for buttons and preferences.
# Cleaned up and added comments to try and help keep track of what all these things do!
# 
######################################################################
pospress=    0
posrelease=   0
cl_pressdown=[]
cl_release= []
al_pressdown=[]
al_release= []
wi_pressdown=[]
wi_release= []
aposx,aposy,ax,ay,aposoff,aposon=ci.al_switch_coords
mposx,mposy,mx,my,mposoff,mposon=ci.mt_switch_coords

########################### UPDATED BY ROB ############################
# Here's the original rect maps for the various screens. 
# To make it easier to follow along with, these will be replace
# with rect-maps stored in dict entries... That way we know by name which is whic
# and can do whatever we want more easily...
# So, these become obsolete, replaced by the dicts to follow...

#************Area for the CLOCK
cl_area=[(Rect (  0,  0,800,380)),       #0 SWING UP AND DOWN
         (Rect (530,390,168, 80)),       #1 Night
         (Rect (700,390,100, 80))]       #2 EXIT

#************Area for ALARMSET
al_area=[(Rect ( 28, 88,107,207)),	     # 0 H1							
         (Rect (130, 88,107,207)),       # 1 H2								
         (Rect (260, 88,107,207)),       # 2 M1
         (Rect (365, 88,107,207)),       # 3 M2
         (Rect (aposx,aposy,ax,ay)),     # 4 ALARM SWITCH
         (Rect (707,385,80, 80)),     	 # 5 MOOD
         (Rect (mposx,mposy,mx,my)),     #6 12/24 SWITCH
         (Rect (504,280,280, 85)),       #7 ABOUT
         (Rect (  0,  0,800, 75)),       #8 EXIT
         (Rect (0,0,0, 0)),         	   #9 EX HELP
         (Rect (310,390, 50, 53)),       #ALARM Sched 0
         (Rect (360,390, 50, 53)),       #ALARM Sched sun
         (Rect (410,390, 50, 53)),       #ALARM Sched mon
         (Rect (460,390, 50, 53)),       #ALARM Sched tue
         (Rect (510,390, 50, 53)),       #ALARM Sched wed
         (Rect (560,390, 50, 53)),       #ALARM Sched thu
         (Rect (610,390, 50, 53)),       #ALARM Sched fri
         (Rect (660,390, 50, 53))]       #ALARM Sched sat

#************Area for WINDOW MODE
wi_area=[(Rect (  0,    0,400,320)),      # 0 Drag up
         (Rect (aposx-80,aposy-59,ax,ay)),#1 ALARM SWITCH
         (Rect (mposx-80,mposy-59,mx,my)),#2 12/24 SWITCH
         (Rect (500-80,280-60,300, 85)),  #3 ABOUT
         (Rect (707-80,385-60,80, 80))]   #4 MOOD





#Global variable to store mouse state (down or not)
# This is used to determine if we need to monitor the mouse move or not
mouseDown = 0

#indicates the alarm day that's currently being selected 
#default is Sunday (0)
#try to set the default to today... unfortunately Python's a bit odd in that it considers monday 0, but...
thisDay = date.today().weekday() + 1
if (thisDay == 7):
	#sunday
	thisDay = 0

currentAlarmNum = thisDay

#global flag to prevent multiple file choosers from being opened by accident/etc
modalOpen = 0

################## Button class definitions ####################################
# Buttons come in one of three flavours thus far:
# clickButton - Triggered by a press and release over the same area
# dragButton - Triggered by a press and drag-release (released in a different area)
# slideButton - Similar to drag button, but with a toggle setting


######## clickButton Class ###############
# Defines a simple object that represents a clickable button
# Requires a Rect indicating the target for the click, and triggerFunc to be
# called when a click occurs
##########################################

class clickButton:

	
	#Button initializer
	def __init__(self, targetRect=None, triggerFunc=None, currentValue=1):
		#the target for this button
		self.targetRect = None
		#flag indicating if this button has been pressed
		self.pressed = 0
		
		#Position that we were pressed at
		self.pressedPos = ()
		
		#flag indicating if this button has been released
		self.released = 0
		
		#Position that we were released at
		self.releasedPos = ()
		
		#Button value; is always 1 for click buttons, but useful in the future
		self.currentValue = 1
		
		#callback function to be executed when button is clicked
		self.callback = None

		##Now apply arguments to override defaults
		self.targetRect = targetRect
		self.callback = triggerFunc
		self.currentValue = currentValue
		
		#String to indicate foreign value that this should show whenever screen is redrawn or interacted with
		self.defaultValue = ""
		
		#string to indicate foreign value that this should show when the screen is first drawn/initialized
		self.initValue = ""
		
		
		#enabled property, used with enable or disable methods
		self.enabled = 1
		
		#variable to watch that determines enabled/disabled state
		self.enableCondition = ""
		self.enableConditionTarget = 1  #default; what should the enableCondition equate to?

	
	#Method to check to see if the mouse is within our rect
	def checkForHit(self):
		hit = 0
		#Quick error check to make sure a rect has been defined for us
		if (self.targetRect == None):
			return 0
		
		#Get the mouse position
		mousePos = pygame.mouse.get_pos()
		
		if (self.targetRect.collidepoint(mousePos)):
			hit = 1
		
		return hit
	
		
	#Method to handle the press event
	def handlePress(self):
		#check to see if the mouse is within our rect
		
		#reset pressed to be safe
		self.pressed = self.checkForHit()
		
		if (self.pressed):
			self.pressedPos = pygame.mouse.get_pos()
		else:
			self.pressedPos = ()
		
	
	#Method to handle the release event
	def handleRelease(self):
		self.released = self.checkForHit()
		
		if (self.released):
			self.releasedPos = pygame.mouse.get_pos()
		else:
			self.releasedPos = ()
		

		if ((self.pressed == 1) and (self.released == 1) and (self.enabled == 1)):
			
			if (self.callback != None):
				self.callback(self)
		
		#turn off hit since mouse is now up
		self.pressed = 0
		self.pressedPos = ()
		
	#method to enable or disable the button
	def enable(self):
		self.enabled = 1;
		
	def disable(self):
		self.enabled = 0;
		
	def setDefault(self):
		#check to see if we should be enabled or not
		if (self.enableCondition != ""):
			
			test = eval(self.enableCondition)
			if (test == self.enableConditionTarget):
				self.enabled = 1
			else:
				self.enabled = 0

		if ((self.defaultValue != "") and (self.defaultValue != "0")):
			self.currentValue = int(eval(self.defaultValue))
	
	#Method to set an enable/disable condition
	def setEnableCondition(self, conditionStr, targetVal=1):
		self.enableCondition = conditionStr
		self.enableConditionTarget = targetVal
		
	#Method to set a foreign initial value
	def setInitValue(self, initValStr=""):
		self.initValue = initValStr
		
		
	def handleInit(self):
		if (self.initValue != ""):
			self.currentValue = int(eval(self.initValue))
		


######## Done clickButton Class ###############

######## dragButton Class #####################
# Extends/updates the clickButton class to give it actions based
# on "drag gestures" instead of just clicks
#
# Create a new instance just like with clickButton, then
# call the "addDragCallback" to add drag calls
#     takes args: direction - "left", "right", "up", or "down" to indicate direction of drag
#                 offset - takes an absolute value indicating the offset required
#                 callbackFunc - the function to be called when the drag finishes
###############################################

class dragButton(clickButton):
	
	def __init__(self, targetRect=None, triggerFunc=None, currentValue=1):
	
		clickButton.__init__(self, targetRect, triggerFunc, currentValue)
	
		#property to store the drag callbacks
		self.dragCallbacks = {}
		self.dragCallbacks["up"] = None
		self.dragCallbacks["down"] = None
		self.dragCallbacks["left"] = None
		self.dragCallbacks["right"] = None
		
		#property to store the drag offsets
		self.dragOffsets = {}
		self.dragOffsets["up"] = 0
		self.dragOffsets["down"] = 0
		self.dragOffsets["left"] = 0
		self.dragOffsets["right"] = 0

	#Method to add a drag callback
	def addDragCallback(self, direction, offset, callbackFunc):
		self.dragCallbacks[direction] = callbackFunc
		self.dragOffsets[direction] = offset

	#Override the default method for the release
	def handleRelease(self):
		self.released = self.checkForHit()
		self.releasedPos = pygame.mouse.get_pos()

		#Track as we only want the regular click action to happen if a drag action doesn't...or it'll be confusing
		#for the user...
		doneDrag = 0
		if ((self.pressed == 1)):
			doneDrag = self.checkForDrag()
		
		#do drag fired, so check for a regular click action
		if ((self.pressed == 1) and (self.released == 1) and (doneDrag == 0) and (self.enabled == 1)):
			if (self.callback != None):
				self.callback(self)
			
		
		#turn off hit since mouse is now up
		self.pressed = 0
		self.pressedPos = ()
		
	#Method to check for drag events and fire callback accordingly
	def checkForDrag(self):

		doneDrag = 0
		if (self.enabled == 1):
		#check for up drag
			if ((self.dragCallbacks["up"] != None) and (self.dragOffsets["up"] > 0) ):
				yDelta = self.releasedPos[1] - self.pressedPos[1]
				if (yDelta >= self.dragOffsets["up"]):
					
					#Execute the callback
					self.dragCallbacks["up"](self)
					doneDrag = 1
			#check for down drag
			if ((self.dragCallbacks["down"] != None) and (self.dragOffsets["down"] > 0) ):
				yDelta = self.pressedPos[1] - self.releasedPos[1]
	
				if (yDelta >= self.dragOffsets["up"]):
					#Execute the callback
					self.dragCallbacks["down"](self)
					doneDrag = 1
			#check for left drag
			if ((self.dragCallbacks["left"] != None) and (self.dragOffsets["left"] > 0) ):
				xDelta = self.releasedPos[0] - self.pressedPos[0]
				if (xDelta >= self.dragOffsets["left"]):
					#Execute the callback
					self.dragCallbacks["left"](self)
					doneDrag = 1		
			#check for right drag
			if ((self.dragCallbacks["right"] != None) and (self.dragOffsets["right"] > 0) ):
				xDelta = self.pressedPos[0] - self.releasedPos[0]
				if (xDelta >= self.dragOffsets["left"]):
					#Execute the callback
					self.dragCallbacks["right"](self)
					doneDrag = 1
		
		return doneDrag		
######## Done dragButton Class #####################

######## digitScroller Class #############################
# Extends the dragButton class to create a digit scroller
# as used on the alarm controller page
#
# Accepts additional arguments:
#              - range : list identifying [min, max] values... 0-9 by default
#
##########################################################

class digitScroller(dragButton):

	def __init__(self, targetRect=None, triggerFunc=None, currentValue=1, range=[0,9]):
		#Initialize the underlying dragButton
		dragButton.__init__(self, targetRect, None, currentValue)
		
		self.changeValCallback = None
		#Define a changeVal callback
		if (triggerFunc != None):
			self.changeValCallback = triggerFunc
		
		self.range = range
		
		self.imageRect = Rect(targetRect.left, targetRect.top + 20,  targetRect.width, targetRect.height)
		
		#Setup the callback handlers
		self.addDragCallback("up", 5, self.scrollUp)
		self.addDragCallback("down", 5, self.scrollDown)
		
		#Create the sub-buttons for the static up/down (incase you don't want the gestures)
		self.subUp = clickButton(Rect(targetRect.left, targetRect.top, targetRect.width, 30), self.scrollUp)
		
		self.subDown = clickButton(Rect(targetRect.left, targetRect.top + targetRect.height + 20, targetRect.width, 30), self.scrollDown)
		
		#set the initial value
		self.setValue(currentValue, 1)
		
	
	#Pass messages from mouse events along to subButtons as well
	def handlePress(self):
		dragButton.handlePress(self)
		self.subUp.handlePress()
		self.subDown.handlePress()
		
	def handleRelease(self):
		dragButton.handleRelease(self)
		self.subUp.handleRelease()
		self.subDown.handleRelease()
	
	def scrollUp(self, button):
		
		#Scroll this digit up one
		if (self.currentValue < self.range[1]):
			#Still allowed to scroll up

			#Play the release sound...?... sure, why not...
			soundrelease()
			
			self.setValue(self.currentValue + 1)

	
	def scrollDown(self, button):
		#Scroll down one digit
		if (self.currentValue > self.range[0]):
			#Still allowed to scroll down
			
			#Play the release sound...?... sure, why not...
			soundrelease()
			
			self.setValue(self.currentValue -1)
			
				
	def setValue(self, newValue, fromInit = 0, tempBuffer=None):
		#External method to specifically set the value of this scroller
		if (self.range[0] <= newValue <= self.range[1]):
			self.currentValue = newValue
		elif (newValue > self.range[1]):
			self.currentValue = self.range[1]
		elif (newValue < self.range[0]):
			self.currentValue = self.range[0]
		
		if (fromInit != 1):
			#draw the new digit
			self.drawButton(tempBuffer)
				
			if (self.changeValCallback != None):
				self.changeValCallback(self)
			
			
	def setRange(self, newRange):
		self.range = newRange
		if (self.currentValue > self.range[1]):
			self.setValue(self.range[1])
		elif (self.currentValue < self.range[0]):
			self.setValue(self.range[0])
					
					
	#Method to draw the scrolling Digit
	def drawButton(self, tempBuffer = None):
		#print "Drawing digit"
		if (tempBuffer == None):
			#Get a reference to the surface
			myScreen = pygame.display.get_surface()
		else:
			myScreen = tempBuffer
		
		
		#Redraw the digit
		myScreen.blit(ci.al_numeri[self.currentValue], self.imageRect)
	
		if (tempBuffer == None):
			
			#Refresh the redrawn part of the screen
			pygame.display.update(self.imageRect)
	
	def handleInit(self, tempBuffer=None):
		
		if (self.initValue != ""):
			self.setValue(int(eval(self.initValue)), 0, tempBuffer)


######## doubleHoursScroller Class #########
#
#  Simple wrapper class that creates two digitScrollers and sets them
# up with some restrictions so that it's impossible to select invalid times
#
#  Takes the arguments - digit1Rect : Rect of first digit Scroller
#                      - digit2Rect : Rect of second digit Scroller
#					   - militaryTime :1 for 24 hour, 0 for 12 hour operations
#
# needs some more work..... obviously....
#
###########################################

class doubleHoursScroller:

	def __init__(self, digit1Rect, digit2Rect, militaryTimePointer=""):
	
		self.firstDigit = None
		self.secondDigit = None
	
		if (militaryTimePointer == ""):
			self.militaryTime = 0
			self.militaryTimePointer = ""
		else:
			self.militaryTimePointer = militaryTimePointer
			self.militaryTime = eval(self.militaryTimePointer)
	
		if (self.militaryTime):
			self.digit1Range = [0, 2]
			self.digit2Range = [0, 9]
		else:
			self.digit1Range = [0, 1]
			self.digit2Range = [0, 9]
		
		self.secondDigit = digitScroller(digit2Rect, None, 0, self.digit2Range)
		self.firstDigit = digitScroller(digit1Rect, self.checkDigit1, 0, self.digit1Range)
		
		self.checkDigit1(self)
	
	#Method to track digit one and limit it accordingly
	def checkDigit1(self, buttonRef):
		
		if (self.militaryTimePointer != ""):
			self.militaryTime = eval(self.militaryTimePointer)
	
		try:
			if (self.militaryTime == 1):
				
				#In 24 hour mode, range can be 00 - 23, so set accordingly
				self.firstDigit.setRange([0, 2])
				if (self.firstDigit.currentValue == 0):
					self.secondDigit.setRange([0,9])
				elif (self.firstDigit.currentValue == 1):
					self.secondDigit.setRange([0,9])
				else:
					self.secondDigit.setRange([0, 3])
			else:
				self.firstDigit.setRange([0, 1])
				#In 12 hour mode, range can only be 01-12
				if (self.firstDigit.currentValue == 0):
					self.secondDigit.setRange([1, 9])
				else:
					self.secondDigit.setRange([0, 2])
		except:
			pass
	
	#Pass mouse events along
	#Pass messages from mouse events along to subButtons as well
	def handlePress(self):
		self.firstDigit.handlePress()
		self.secondDigit.handlePress()
		
	def handleRelease(self):
		self.firstDigit.handleRelease()
		self.secondDigit.handleRelease()
	
	def setDefault(self):
		#This is needed but I'm not quite sure when/why yet... maybe it's not... but I have a feeling...
		self.checkDigit1(self)
		
		if ((self.firstDigit.defaultValue != "") and (self.firstDigit.defaultValue != "0")):
			self.firstDigit.setValue(int(eval(self.firstDigit.defaultValue)))
		
		if ((self.secondDigit.defaultValue != "") and (self.secondDigit.defaultValue != "0")):
			self.secondDigit.setValue(int(eval(self.secondDigit.defaultValue)))
		
		
	def drawButton(self, tempBuffer = None):
		self.firstDigit.drawButton(tempBuffer)
		self.secondDigit.drawButton(tempBuffer)
	
	#Set the values to be re-read any time the init method is called...
	def setInitValues(self, defaultVal1Str="", defaultVal2Str=""):
		self.firstDigit.setInitValue(defaultVal1Str)
		self.secondDigit.setInitValue(defaultVal2Str)
		
	def handleInit(self, tempBuffer=None):
		self.firstDigit.handleInit(tempBuffer)
		self.secondDigit.handleInit(tempBuffer)


######## slideButton Class ###############
# Extends the clickButton class to turn it into a sliding 
# button instead of a clickable one
#
# NOTE!! The currentValue argument should be a string, not an int! That way you
# can leave it pointed at a global var, config object, etc and it will
# still work properly...
##########################################

class slideButton(clickButton):
	
	#Extended creator
	def __init__(self, targetRect=None, triggerFunc=None, currentValue="", slideImgObj=None, slideMaskObj=None, maxPos=70, minPos=-70):
		clickButton.__init__(self, targetRect, None)
		
		#Additional properties
		self.slideImgObj = None        #Image object to be displayed
		self.slideMaskObj = None       #Mask to overlay image
		
		#Screen surface element
		self.myScreen = None
		
		#callback to override clickButton one... this is necessary, just trust me here
		self.dragCallback = None
		
		#max and min positions for slider image (max pos is on, minpos is off)
		self.maxPos = 70
		self.minPos = -70
		
		self.defaultValue = "0"
		
		
		self.slideImgObj = slideImgObj 
		self.myScreen = pygame.display.get_surface()
		self.slideMaskObj = slideMaskObj
		self.dragCallback = triggerFunc
		self.maxPos = maxPos
		self.minPos = minPos
		
		if (currentValue != ""):
			self.defaultValue = currentValue

	
	#Method to handle the dragging of a slide switch
	def handleDrag(self):

		if ((self.pressed) and (self.enabled == 1)):
			#Mouse was pressed on us, so drag is valid

			
			#get the current mouse position
			mouseX, mouseY = pygame.mouse.get_pos()
			offset = mouseX - self.pressedPos[0]
			

			
			#Current value is zero, then calculate based on that position
			if (self.currentValue == 0):
				if (offset < 0):
					offset = 0
				if (offset > self.maxPos):
					offset = self.maxPos
					
				
				self.myScreen.blit(self.slideImgObj, (self.targetRect.left - self.maxPos - 6 + offset, self.targetRect.top + 1))
			elif (self.currentValue == 1):
				if (offset > 0):
					offset = 0
				if (offset < self.minPos):
					offset = self.minPos
				self.myScreen.blit(self.slideImgObj, (self.targetRect.left - 6 + offset, self.targetRect.top + 1))

			#Now draw the mask ontop of the image
			if (self.slideMaskObj != None):
				self.myScreen.blit(self.slideMaskObj, (self.targetRect.left, self.targetRect.top))
				
			#Finally, update only the part of the screen that we've affected
			pygame.display.update(self.targetRect)
			
	#Method to extend the release to make our slider "snap" to the closest value
	def handleRelease(self):
		self.released = self.checkForHit()
		
		self.releasedPos = pygame.mouse.get_pos()
		
		#now the extended stuff
		if ((self.pressed == 1) and (self.enabled == 1)):
			#check to see which side we're closer to, and force to that end
			offset = self.releasedPos[0] - self.pressedPos[0] 
			if (offset > 35):
				self.currentValue = 1
			elif (offset < -35):
				self.currentValue = 0
			#draw the snap movement
			
			self.drawButton()
			
			if (self.dragCallback != None):
				self.dragCallback(self)
				
		#turn off hit since mouse is now up
		self.pressed = 0
		self.pressedPos = ()
		
		
	#Method to draw the switch based on the value
	def drawButton(self, tempBuffer = None):
		if (self.enabled == 1):
			if (tempBuffer == None):
				thisBuff = self.myScreen
			else:
				thisBuff = tempBuffer
			#Make sure we only redraw the rect we want
			thisBuff.set_clip(self.targetRect)
		
			if (self.currentValue == 1):
				thisBuff.blit(self.slideImgObj,(self.targetRect.left - 6,self.targetRect.top+1))
			
			else:
				thisBuff.blit(self.slideImgObj,(self.targetRect.left - self.maxPos - 6,self.targetRect.top+1))
					
			#Now draw the mask ontop of the image
			if (self.slideMaskObj != None):
				thisBuff.blit(self.slideMaskObj, (self.targetRect.left, self.targetRect.top))
			
			#only redraw locally if not using a buffer screen surface		
			if (tempBuffer == None):
				#Finally, update only the part of the screen that we've affected
				pygame.display.update(self.targetRect)
			
			#Okay, done, so make sure the whole screen can be redrawn
			thisBuff.set_clip(ci.screenSize)
######## Done slideButton Class ###############	



################### DONE BUTTON DEFITINITIONS #################################

################### Label Definitions #########################################

#
# textLabel
#
# A class that takes a piece of text and renders it on the screen whenever
# init is called
# 

class textLabel:
	def __init__(self, targetRect=None, textToShow="", defaultValue="", zIndex=0):
	
		#The area that the label should appear at
		self.targetRect = targetRect
		 
		#The text to render
		self.textToShow = textToShow
				
		#default value
		self.defaultValue = defaultValue
		
		#should this image be drawn after everything else on screen?
		self.zIndex = zIndex
		
		#Internal properties
		self.enabled = 1
		self.enableCondition = ""
		self.enableConditionTarget = 1
		
		self.myScreen = pygame.display.get_surface()
		
		#default font is "big"
		self.font = ci.flipFonts["big"]
		
		#default colour
		self.textColour = (33,33,33)
	
	
	#Method to set the text
	def setText(self, newText):
		self.textToShow = newText
	
	#Method to set the text colour
	def setColour(self, newColour):
		self.textColour = newColour
	
	#method to set the font to use
	def setFont(self, newFont):
		self.font = newFont
	
	
	#method to enable or disable the button
	def enable(self):
		self.enabled = 1;
		
	def disable(self):
		self.enabled = 0;
		
	def setDefault(self):
		#check to see if we should be enabled or not
		if (self.enableCondition != ""):
			test = eval(self.enableCondition)
			
			if (test == self.enableConditionTarget):
				self.enabled = 1
			else:
				self.enabled = 0
				
		if ((self.defaultValue != "") and (self.defaultValue != "0")):
			self.textToShow = eval(self.defaultValue)
	
	#Method to set an enable/disable condition
	def setEnableCondition(self, conditionStr, targetVal=1):
		self.enableCondition = conditionStr
		self.enableConditionTarget = targetVal
	
	
	#method to draw the text
	def drawLabel(self, tempBuffer = None):
		if (self.enabled == 1):
			if (tempBuffer == None):
				thisBuff = self.myScreen
			else:
				thisBuff = tempBuffer
			#Make sure we only redraw the rect we want
			thisBuff.set_clip(self.targetRect)
			
			
			#Draw the text
			myLabel = self.font.render("%s"%(self.textToShow), True, self.textColour)
			thisBuff.blit(myLabel, (self.targetRect.left, self.targetRect.top))
			
			
			#only redraw locally if not using a buffer screen surface		
			if (tempBuffer == None):
				#Finally, update only the part of the screen that we've affected
				pygame.display.update(self.targetRect)
			
			#Okay, done, so make sure the whole screen can be redrawn
			thisBuff.set_clip(ci.screenSize)
	


#
# imageLabel
#
# A class that takes an image and renders it on the screen whenever
# init is called. Can also support multiple images by adding them to
# the target array
# 

class imageLabel:
	def __init__(self, targetRect=None, imagesDict={}, zIndex=0):
	
		#The area that the label should appear at
		self.targetRect = targetRect
		 
		#Dict of images to show based on value
		self.imagesDict = imagesDict
				
		#default value
		self.defaultValue = ""
		
		#should this image be drawn after everything else on screen?
		self.zIndex = zIndex
		
		#Internal properties
		self.currentValue = 0
		self.enabled = 1
		self.enableCondition = ""
		self.enableConditionTarget = 1
		
		self.myScreen = pygame.display.get_surface()
		
	#Method to add an image to the array
	def addImage(self, key, image):
		self.imagesDict[key] = image
	
	#Method to remove an image from the array
	def removeImage(self, key):
		del self.imagesDict[key]
	
	
	#method to enable or disable the button
	def enable(self):
		self.enabled = 1;
		
	def disable(self):
		self.enabled = 0;
		
	def setDefault(self):
		#check to see if we should be enabled or not
		if (self.enableCondition != ""):
			test = eval(self.enableCondition)
			if (test == self.enableConditionTarget):
				self.enabled = 1
			else:
				self.enabled = 0
				
		if ((self.defaultValue != "")):
			self.currentValue = eval(self.defaultValue)
	
	
	#Method to set the default string
	def setDefaultCondition(self, defaultCondStr):
		self.defaultValue = defaultCondStr
	
	#Method to set an enable/disable condition
	def setEnableCondition(self, conditionStr, targetVal=1):
		self.enableCondition = conditionStr
		self.enableConditionTarget = targetVal
	
	
	#method to draw the text
	def drawLabel(self, tempBuffer = None):
		goodToGo = 0
		needsRedraw = 0
		if (self.enabled == 1):
			#Only draw if there's an image associated with the current value
			if (self.imagesDict.has_key(self.currentValue)):
				if (self.imagesDict[self.currentValue] != ""):
				
					goodToGo = 1
		
		if (goodToGo):
			if (tempBuffer == None):
				thisBuff = self.myScreen
				needsRedraw = 1
			else:
				thisBuff = tempBuffer
				needsRedraw = 0
			#Make sure we only redraw the rect we want
			thisBuff.set_clip(self.targetRect)
			
			
			#Draw the image
			thisBuff.blit(self.imagesDict[self.currentValue], (self.targetRect.left, self.targetRect.top))
			
			#only redraw locally if not using a buffer screen surface		
			if (needsRedraw):
				
				#Finally, update only the part of the screen that we've affected
				pygame.display.update(self.targetRect)
			
			#Okay, done, so make sure the whole screen can be redrawn
			thisBuff.set_clip(ci.screenSize)





#################### Button Functions #########################################
#
# These are the functions that will be associated with buttons; notice that
# some of them are used in multiple places (i.e. gotoMainClock, etc)

##### Screen/App Control Functions #####

## Switch to Window Mode
def gotoWindowMode(buttonRef):
	ci.fcmode = ci.FCMODE_WINDOW
	
	#Redraw the clock interface
	ci_clock.clock()
	
	#switch into window mode
	ci.pygame.display.toggle_fullscreen()  


##Switch to Alarm Control Mode
def gotoAlarmControlMode(buttonRef):
	ci.fcmode= ci.FCMODE_ALARM_CONTROL
	
	
	#Initialize the alarm mode
	initializeScreen()
	


##Toggle between Day and Night Mode
def dayNightToggle(buttonRef):

	if (ci.fcmode == ci.FCMODE_CLOCK):
		ci.fcmode = ci.FCMODE_NIGHT
	elif (ci.fcmode == ci.FCMODE_NIGHT):
		ci.fcmode = ci.FCMODE_CLOCK
	
	#redraw the clock interface
	ci_clock.clock()

##Exit FlipClock
def quitApp(buttonRef):
	#Dispatch the quit event; the main loop will get the signal and do the rest...
	ci.pygame.event.post(pygame.event.Event(pygame.QUIT))

##Switch to regular clock mode
def gotoClockMode(buttonRef):
	wasWindow = 0
	if (ci.fcmode == ci.FCMODE_WINDOW):
		wasWindow = 1
		
	elif (ci.fcmode == ci.FCMODE_ALARM_CONTROL):
		#We need to sync all the alarms with the alarmD daemon just to be safe
		updateCurrentAlarm()
		

	ci.fcmode = ci.FCMODE_CLOCK
	
	#Redraw the clock interface
	ci_clock.clock()
	if (wasWindow):
		ci.pygame.display.toggle_fullscreen()
	

def selectAlarm(buttonRef):
	global currentAlarmNum
	
	#update the current alarm settings before leaving
	updateCurrentAlarm()
	
	
	#Set the current alarm to the val of the button that was pressed
	currentAlarmNum = buttonRef.currentValue
	
	
	#Re-draw the alarm mode
	initializeScreen()


##### Done Screen/App Control Functions #####


##### Toggle switch/control functions #########

##Switch to set military time on or off
def setMilitaryTime(buttonRef):
	#print "Set military time"
	#print buttonRef.currentValue
	ci_config.preferences["militaryTime"] = buttonRef.currentValue
		
	#Save the updated configuration
	ci_config.savePrefs();
	
	
	#Re-draw the alarm mode
	initializeScreen()
	

	
	#ci_clock.clock()
	
##Switch to turn the currently selected alarm on or off
# 
# This technically is a bit redundant since the alarm will be
# set once the user leaves the screen or chooses to show another
# alarm, but hey, just to be safe...
#

def setAlarmOnOff(buttonRef):
	#Enable or disable the alarm

	origVal = buttonRef.currentValue

	status = updateCurrentAlarm()
	
	if (status != 1):
		buttonRef.currentValue = origVal
		#buttonRef.drawButton()
	
	#Re-draw the alarm mode
	initializeScreen()
		

def setAMPM(buttonRef):
	ci_config.alarms[currentAlarmNum]["ampm"] = buttonRef.currentValue


def setLoop(buttonRef):
	ci_config.alarms[currentAlarmNum]["loopSound"] = buttonRef.currentValue


#######################
# updateCurrentAlarm
#
# Method to save the settings for the currently selected alarm
# to the local ci_config.alarms structure. 
# This struct is then sync'd with the alarmD and config files
# later when the screen is changed
########################

def updateCurrentAlarm():
	#Enable or disable the alarm
	
	#did we succeed?
	success = 0

	#Store the user's prefs in the global alarms array	
	#Get the current time for the alarm from the buttons
	hour1 = screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["hours"].firstDigit.currentValue
	hour2 = screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["hours"].secondDigit.currentValue
	
	min1 = screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["minute1"].currentValue
	min2 = screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["minute2"].currentValue
	
	#Here's the tricky bit... get the timestamp that represents the next time this day of the week will come up, and this time
	#on that day...
	
	#start by getting the current timestamp
	now = myTime.time()
	
	#$today = mktime(0,0,0,date("n", $today), date("j", $today), date("Y", $today));
	#dayOnly = myTime.mktime((time.strftime("%Y", now), time
	
	#or we could just not care, since we're repeating...
	#let's get the time, for say, 
	#1236488400 is Sunday, March 8, 2009 @00:00:00, so let's try that as a base
	
	#so first, which day of the week are we? Sunday, + current alarm (0-7) times seconds in a day (86400)
	targetTime = 1236488400 + ((currentAlarmNum) * 86400)
			
	#now, we add the current time specified
	#Minutes are always the same, just multiply by 60 seconds
	extra = ((min1 * 10) + min2) * 60
	
	#Get the hours as an int
	hoursTotal = (hour1 * 10) + hour2
	
	#isAMPM.. AM == 1, PM == 0
	isAMPM = 1
	
	#now add the hours, which are either am/pm, or 24 hour... let's pretend for the moment there always 24
	#don't forget, 3600 seconds in an hour...
	if (ci_config.preferences["militaryTime"]):
		extra = extra + (hoursTotal * 3600)
		
		#Convert to 12 hour time to store in array
		if (hoursTotal == 0):
			hoursStr = "12"
			isAMPM = 1
		elif (0 < hoursTotal < 10):
			hoursStr = "0" + str(hoursTotal)
			isAMPM = 1
		elif (9 < hoursTotal < 13):
			hoursStr = str(hoursTotal)
			isAMPM = 1
		else:
			hoursStr = str(hoursTotal)
			isAMPM = 0 	
	else:
		#Get the AM/PM setting... AM == 1, PM ==0
		ampm = screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["ampmSwitch"].currentValue
		isAMPM = ampm
		if (hoursTotal == 12 and ampm == 1):
			#12 am = 00
			hoursTotal = 0
		elif (hoursTotal == 12 and ampm == 0):
			#12pm = 12.. gotta do something, so...
			hoursTotal = hoursTotal
		elif (ampm == 0):
			#pm value
			hoursTotal = 12 + hoursTotal		
		extra = extra + (hoursTotal * 3600)
		
		#string to store the hours (Always stored in 12 hour format)
		hoursStr = str(hour1) + str(hour2)
		
	#so finally, our target time is
	targetTime = targetTime + extra
		
	#check for DST
	if (myTime.daylight):
		#DST is active, so adjust time accordingly
		adjustment = myTime.timezone - myTime.altzone
			
		#If DST, subtract the difference of the zones..
		targetTime = targetTime - adjustment
	
	
	#original alarm time
	originalAlarmTime = ci_config.alarms[currentAlarmNum]["alarm_time"]
	
	#set the alarm propeties
	ci_config.alarms[currentAlarmNum]["alarm_time"] = targetTime
	ci_config.alarms[currentAlarmNum]["alarm_hhmm"] = hoursStr + str(min1) + str(min2)
	ci_config.alarms[currentAlarmNum]["ampm"] = isAMPM
	
	if (originalAlarmTime != targetTime and screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["alarmSwitch"].currentValue == 1):
		#Alarm should be on, but time has changed so update it!
		#print "updating alarm"
		runScreenState("setBusy")
		success = ci_alarmD.enableAlarm(currentAlarmNum)
	
	elif (screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["alarmSwitch"].currentValue == 1 and ci_config.alarms[currentAlarmNum]["enabled"] != 1):
		#Alarm has been set to enabled, so apply the current settings
		runScreenState("setBusy")
		print "setting alarm req"
		#enable alarm
		success = ci_alarmD.enableAlarm(currentAlarmNum)

	elif (screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["alarmSwitch"].currentValue == 0 and ci_config.alarms[currentAlarmNum]["enabled"] != 0):
		#disable alarm
		#print "unsetting alarm req"
		runScreenState("setBusy")
		success = ci_alarmD.disableAlarm(currentAlarmNum)
	
	else:
		#No action is required, so assume we succeeded
		success = 1

	if (success != 1):
		#Failed for some reason
		
		osso_c = osso.Context("osso_test_note", "0.0.1", False)
		note = osso.SystemNote(osso_c)
		result = note.system_note_dialog("Failed while attempting to set alarm", type='notice') 
	
		
		screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["alarmSwitch"].currentValue = success
		screens[ci.FCMODE_ALARM_CONTROL]["buttons"]["alarmSwitch"].drawButton()

	#handled by enable/disable alarm calls
	#update the config file since alarm state has changed
	ci_config.savePrefs()
	print "Done alarm update"
	runScreenState("clearBusy")


	return success






##### Done Toggle switch/control functions ####


##### General Alarm Functions #################

#####chooseAlarmFile ##########################
#
# Function to select an MP3 file to use as the alarm sound
###############################################

def chooseAlarmSound(buttonRef):
	global modalOpen
	
	if (modalOpen == 0):
		modalOpen = 1
		runScreenState("setBusy")
		dialog = hildon.FileChooserDialog(hildon.Window(), gtk.FILE_CHOOSER_ACTION_OPEN)
		response = dialog.run()
		dialog.hide()
		
		modalOpen = 0
		
		fileName = dialog.get_filename()
		
		if (response == gtk.RESPONSE_OK):
			print "Selected file"
			if (fileName.lower().endswith("mp3")):
				#good to go
				ci_config.alarms[currentAlarmNum]["sound"] = "file://" + fileName
				
				#Redraw the file display in a moment...
				#initializeScreen()
			else:
				osso_c = osso.Context("osso_test_note", "0.0.1", False)
				note = osso.SystemNote(osso_c)
				result = note.system_note_dialog("Sorry, only .mp3 files are working right now", type='notice') 
		runScreenState("clearBusy")
	




#################### Done Button Functions #########################################



################### Dict Screen Definitions ######################################
############ Clock Screen ##############

###### Buttons ########
clockScreenButtons={}
##Swing up/down to change screens
clockScreenButtons["swinger"] = dragButton(Rect(  0,  0,800,380)) 
clockScreenButtons["swinger"].addDragCallback("up", 20, gotoWindowMode)
clockScreenButtons["swinger"].addDragCallback("down", 20, gotoAlarmControlMode) 
#disable dragging if alarm running
clockScreenButtons["swinger"].setEnableCondition("ci.alarmRunning", 0) 

##Day/Night toggle button    
clockScreenButtons["nightDay"] = clickButton(Rect(530,390,168, 80), dayNightToggle)

##Exit button
clockScreenButtons["exit"] = clickButton(Rect(700,390,100, 80), quitApp)

######## Alarm mode buttons #############
# these buttons are only active when the alarm is playing
#########################################
clockScreenButtons["alarmOff"] = clickButton(Rect(0, 0, 800, 380), ci_alarm.stopAlarm)
clockScreenButtons["alarmOff"].setEnableCondition("ci.alarmRunning", 1)

###### Done Buttons #######

###### Labels #############
clockScreenLabels = {}

#Alarm Time Label (alarm off)
clockScreenLabels["alarmTime"] = textLabel(Rect(87, 400, 114, 55), "", "ci_config.alarms[thisDay][\"alarm_hhmm\"][0:2] + \":\" + ci_config.alarms[thisDay][\"alarm_hhmm\"][2:4]")
clockScreenLabels["alarmTime"].setColour((110, 110, 110))
clockScreenLabels["alarmTime"].setEnableCondition("ci_config.alarms[thisDay][\"enabled\"]", 0)

##Alarm time label (alarmOn)
clockScreenLabels["alarmTimeOn"] = textLabel(Rect(87, 400, 114, 55), "", "ci_config.alarms[thisDay][\"alarm_hhmm\"][0:2] + \":\" + ci_config.alarms[thisDay][\"alarm_hhmm\"][2:4]")
clockScreenLabels["alarmTimeOn"].setColour((ci.mr, ci.mg, ci.mb))
clockScreenLabels["alarmTimeOn"].setEnableCondition("ci_config.alarms[thisDay][\"enabled\"]", 1)

##Alarm on helpers
clockScreenLabels["alarmEngaged"] = textLabel(Rect(114, 389, 114, 55), "ALARM")
clockScreenLabels["alarmEngaged"].setColour((ci.mr, ci.mg, ci.mb))
clockScreenLabels["alarmEngaged"].setFont(ci.flipFonts["small"])
clockScreenLabels["alarmEngaged"].setEnableCondition("ci_config.alarms[thisDay][\"enabled\"]", 1)

clockScreenLabels["alarmEngaged2"] = textLabel(Rect(104, 443, 114, 55), "ENGAGED")
clockScreenLabels["alarmEngaged2"].setColour((ci.mr, ci.mg, ci.mb))
clockScreenLabels["alarmEngaged2"].setFont(ci.flipFonts["small"])
clockScreenLabels["alarmEngaged2"].setEnableCondition("ci_config.alarms[thisDay][\"enabled\"]", 1)

#### Alarm is playing labels ##########

## Snooze background
clockScreenLabels["snoozeBG"] = imageLabel(Rect(0,383,800,90), {1:ci.buttonImages["snoozeBG"]}, 1)
clockScreenLabels["snoozeBG"].setDefaultCondition("ci.alarmRunning")

## Snooze text
clockScreenLabels["snoozeText1"] = textLabel(Rect(100, 200, 400, 60), "Snooze for another :", "", 2)
clockScreenLabels["snoozeText1"].setEnableCondition("ci.alarmRunning", 1)

## Snooze time


###### Done Labels ########

############ Done Clock Screen #################


############ Alarm Settings Screen ######

###### Buttons ########
alarmControlScreenButtons={}


##H1 & 2 Combined
alarmControlScreenButtons["hours"] = doubleHoursScroller(Rect( 28, 88,107,207), Rect(130, 88,107,207), "ci_config.preferences[\"militaryTime\"]")
alarmControlScreenButtons["hours"].setInitValues("ci_config.alarms[currentAlarmNum][\"alarm_hhmm\"][0]", "ci_config.alarms[currentAlarmNum][\"alarm_hhmm\"][1]")

##M1 Scroller
alarmControlScreenButtons["minute1"] = digitScroller(Rect(257, 88,107,207), None, 0, [0,5])
#set the default value
alarmControlScreenButtons["minute1"].setInitValue("ci_config.alarms[currentAlarmNum][\"alarm_hhmm\"][2]")
##M2 Scroller
alarmControlScreenButtons["minute2"] = digitScroller(Rect (358, 88,107,207), None, 0)
#set the default value
alarmControlScreenButtons["minute2"].setInitValue("ci_config.alarms[currentAlarmNum][\"alarm_hhmm\"][3]")

##Alarm on/off switch
alarmControlScreenButtons["alarmSwitch"] = slideButton(Rect(*ci.al_switch_coords[0:4]), setAlarmOnOff, "ci_config.alarms[currentAlarmNum][\"enabled\"]", ci.switch_images["onoff"], ci.switch_masks["alDark"])

##Alarm am/pm switch
alarmControlScreenButtons["ampmSwitch"] = slideButton(Rect(664,194,102,70), setAMPM, "ci_config.alarms[currentAlarmNum][\"ampm\"]", ci.switch_images["ampm"], ci.switch_masks["alDark"])
#set switch enable condition so that it's only enabled if 24 hour mode == 0
alarmControlScreenButtons["ampmSwitch"].setEnableCondition("ci_config.preferences[\"militaryTime\"]", 0)

##Alarm MP3 File chooser button
alarmControlScreenButtons["fileChooser"] = clickButton(Rect(504, 283, 150, 82), chooseAlarmSound)

##Alarm MP3 Loop/Once switch
alarmControlScreenButtons["loopSwitch"] = slideButton(Rect(664,290,102,70), setLoop, "ci_config.alarms[currentAlarmNum][\"loopSound\"]", ci.switch_images["loop"], ci.switch_masks["alMed"])



alarmControlScreenButtons["mood"] = Rect (707,385,80, 80)      #Mood selector thing

##Switch for military time
alarmControlScreenButtons["mtSwitch"] = slideButton(Rect(580, 400, 102, 70), setMilitaryTime, "ci_config.preferences[\"militaryTime\"]", ci.switch_images["1224"], ci.switch_masks["alLight"])

##About button needs to be relocated, deal with that later...
##alarmControlScreenButtons["about"] = Rect (504,280,280, 85)    #About Button

##Close the alarm settings window and go back to the clock
alarmControlScreenButtons["backToClock"] = dragButton(Rect(  0,  0,800, 75))  
alarmControlScreenButtons["backToClock"].addDragCallback("up", 20, gotoClockMode)


alarmControlScreenButtons["exitHelp"] = Rect (0,0,0, 0)        #Exit Help screen
for i in range(7):
	alarmControlScreenButtons["alarmSched" + str(i)] = clickButton(Rect(40 + (i *50), 390, 50, 53), selectAlarm, i)  #Alarm Day X button


###### Done Buttons #######

###### Labels #############

alarmControlScreenLabels = {}

#AM/PM Switch label
alarmControlScreenLabels["ampmSwitch"] = textLabel(Rect(520, 190, 150, 70), "AM/PM")
alarmControlScreenLabels["ampmSwitch"].setEnableCondition("ci_config.preferences[\"militaryTime\"]", 0)

##Alarm MP3 File chooser label
alarmControlScreenLabels["fileChooser"] = textLabel(Rect(512, 282, 150, 67), "Sound")
alarmControlScreenLabels["fileLabel"] = textLabel(Rect(512, 328, 150, 67), "", "os.path.basename(ci_config.alarms[currentAlarmNum][\"sound\"])")
alarmControlScreenLabels["fileLabel"].setFont(ci.flipFonts["small"])

#Alarm Day of the Week Label
alarmControlScreenLabels["dayLabel"] = textLabel(Rect(222, 330, 90, 30), "", "ci.daysList[ci_config.alarms[currentAlarmNum][\"alarm_day\"]]")
alarmControlScreenLabels["dayLabel"].setFont(ci.flipFonts["small"])

#alarm Day X Indicators
for i in range(7):
	alarmControlScreenLabels["alarmSched" + str(i)] = imageLabel(Rect(46 + (i *50), 390, 50, 61), {0:ci.alarmIcons["off"], 1:ci.alarmIcons["on"]})  #Alarm Day X button
	alarmControlScreenLabels["alarmSched" + str(i)].setDefaultCondition("ci_config.alarms[" + str(i) + "][\"enabled\"]");
	
	##And image to cover/overlay to show which alarm is selected
	alarmControlScreenLabels["alarmSel" + str(i)] = imageLabel(Rect(39 + (i *50), 387, 48, 65), {0:ci.alarmIcons["nonSelected"], 1:ci.alarmIcons["selected"]}, 1)  #Alarm Selection Indicator
	alarmControlScreenLabels["alarmSel" + str(i)].setDefaultCondition("int(" + str(i) + ") == currentAlarmNum");


###### Done Labels ########


############ Done Alarm Screen #################


############ Window Mode Screen #################

###### Buttons ########
windowModeScreenButtons = {}
#Click to return to clock mode...
windowModeScreenButtons["backToClock"] = clickButton(Rect(  0,    0,400,320), gotoClockMode) 

#Alarm switch co-ordinates, as specified in ci_init 
#windowModeScreenButtons["alarmSwitch"] = slideButton(Rect(*ci.al_switch_coords[1:5]), setMilitaryTime, ci_config.preferences["militaryTime"], ci.switch_images["1224"], ci.switch_masks["alDark"])    

#Switch for military time
windowModeScreenButtons["mtSwitch"] = slideButton(Rect(ci.mt_switch_coords[0] - 80, ci.mt_switch_coords[1] - 59, ci.mt_switch_coords[2], ci.mt_switch_coords[3]), setMilitaryTime, "ci_config.preferences[\"militaryTime\"]", ci.onoff_switch[2], ci.onoff_switch[0])

windowModeScreenButtons["about"] = Rect (500-80,280-60,300, 85)       #About Button

windowModeScreenButtons["mood"] = Rect (707-80,385-60,80, 80)         #Mood selector thing

###### Done Buttons #######

###### Labels #############


###### Done Labels ########

############ Done Window Mode Screen #################


########### Generic Labels ###########################
# (apply to all or multiple screens )
######################################################

#labels for when the clock is busy
busyLabels = {}	
busyLabels["waitScreen"] = imageLabel(Rect(0,0,800,480), {1:ci.buttonImages["waitScreen"]}, 1)
busyLabels["waitScreen"].setDefaultCondition("ci.clockBusy")


########### Done Generic Labels ######################


############ Overall screen container element ###########
screens = {}
screens[ci.FCMODE_CLOCK] = {}
screens[ci.FCMODE_CLOCK]["title"] = "Main Clock Screen"
screens[ci.FCMODE_CLOCK]["buttons"] = clockScreenButtons
screens[ci.FCMODE_CLOCK]["labels"] = clockScreenLabels

screens[ci.FCMODE_NIGHT] = {}
screens[ci.FCMODE_NIGHT]["title"] = "Night Clock Screen"
screens[ci.FCMODE_NIGHT]["buttons"] = clockScreenButtons

screens[ci.FCMODE_ALARM_CONTROL] = {}
screens[ci.FCMODE_ALARM_CONTROL]["title"] = "Alarm Control Screen"
screens[ci.FCMODE_ALARM_CONTROL]["background"] = ci.al_bground
screens[ci.FCMODE_ALARM_CONTROL]["buttons"] = alarmControlScreenButtons
screens[ci.FCMODE_ALARM_CONTROL]["labels"] = alarmControlScreenLabels
screens[ci.FCMODE_ALARM_CONTROL]["stateLabels"] = busyLabels

screens[ci.FCMODE_WINDOW] = {}
screens[ci.FCMODE_WINDOW]["title"] = "Window Mode Screen"
screens[ci.FCMODE_WINDOW]["buttons"] = windowModeScreenButtons 



############# DONE dict Screen Definitions ########################################


######################## Event Driver/Handlers ####################################
#
# This is the last part of the equation, that ties all of the buttons defined for
# which ever screen is active to the actual event callbacks. 
# (i.e. from ci_eventHandlers, the tap_down, tap_release, or tap_drag functions
# are called, which then check to see which screen we're on,and pass the event
# along to each button that's setup there)
#


############## initializeScreen #########################
#
# This method handles the initial setup of the given screen and buttons/etc
#
#########################################################

def initializeScreen():
	#is there a screen definition for the current screen
	if (screens.has_key(ci.fcmode)):
		#setup the temp buffer to draw on
		myScreen = pygame.display.get_surface()

	
		#Draw background
		if (screens[ci.fcmode].has_key("background")):
			
			myScreen.blit(screens[ci.fcmode]["background"], (0,0))

		#okay, check to see if buttons are defined
		if (screens[ci.fcmode].has_key("buttons")):
			#okay buttons are defined, so loop over them and initialize them
			for buttonName, buttonVal in screens[ci.fcmode]["buttons"].items():
				#setup default
				try:
					buttonVal.setDefault()
				except:
					pass
				#Set the initial value
				try:
					buttonVal.handleInit(myScreen)
				except:
					pass
				#render the button
				try:
					buttonVal.drawButton(myScreen)
				except:
					pass
		
		#next, check to see if labels are defined
		if (screens[ci.fcmode].has_key("labels")):

			#okay labels are defined, so loop over them and initialize them
			theseLabels = copy.copy(screens[ci.fcmode]["labels"])
			
			i = 0
			while len(theseLabels) > 0:
				for labelName, nullVal in theseLabels.items():
					print labelName
					labelVal = screens[ci.fcmode]["labels"][labelName]
					#print labelVal
					#print labelVal.zIndex 
					#Render based on z-Index
					if (labelVal.zIndex == i):
						#setup default
						try:
							labelVal.setDefault()
						except:
							pass
						#label was drawn, so purge from list
						del theseLabels[labelName]	
				i = i+ 1
							
				


		#Now that all has been done, swap buffers
		pygame.display.flip()


############## runScreenEvents ##########################
# This method is used to forward the specified event
# along to all assigned buttons/listeners.
# 
# It takes a single argument, eventType, that can currently be
# either "press", "release", or "drag"
#########################################################

def runScreenEvents(eventType):
	#is there a screen definition for the current screen
	if (screens.has_key(ci.fcmode)):
		#okay, check to see if buttons are defined
		if (screens[ci.fcmode].has_key("buttons")):
			#okay buttons are defined, so loop over them and issue the appropriate message
			for buttonName, buttonVal in screens[ci.fcmode]["buttons"].items():
				if (eventType == "setDefaults"):
					#set the default values for any buttons that have "live defaults"
					try:
						buttonVal.setDefault()
					except:
						pass								
				if (eventType == "press"):
					#dispatch the mouse press event to anyone listening
					try:
						buttonVal.handlePress()
					except:
						pass
				elif (eventType == "release"):
					#dispatch mouse release event
					try:
						buttonVal.handleRelease()
					except:
						pass
				elif (eventType == "drag"):
					#dispatch mouse drag event to anyone listening
					try:
						buttonVal.handleDrag()
					except:
						pass
	


############# runScreenState ##########################
#
# Update overlays/etc based on a general state of affairs (busy, active, etc)
#######################################################

def runScreenState(state):
	if (state == "setBusy"):
		#clock is going into busy mode
		ci.clockBusy = 1
	

		#is there a screen definition for the current screen
		if (screens.has_key(ci.fcmode)):
			#setup the temp buffer to draw on
			myScreen = pygame.display.get_surface()
		
			#okay, check to see if buttons are defined
			if (screens[ci.fcmode].has_key("stateLabels")):
				#okay buttons are defined, so loop over them and issue the appropriate message
				for labelName, labelVal in screens[ci.fcmode]["stateLabels"].items():
					
					if (state == "setBusy"):
						#setup default
						try:
							labelVal.setDefault()
						except:
							pass
						#render the label
						try:
							labelVal.drawLabel(myScreen)
							
						except:
							pass
				
			#Now that all has been done, swap buffers
			pygame.display.flip()
	elif (state == "clearBusy"):
		#clock leaving busy mode
		ci.clockBusy = 0
		initializeScreen()


############## tap_down #################################
# This method is called from the main event loop whenever
# a pygame MOUSEDOWN event is detected.
# It then dispatches the event to the buttons for the current screen
#########################################################

def tap_down():
	runScreenEvents("setDefaults")
	runScreenEvents("press")
	
############## tap_down #################################
# This method is called from the main event loop whenever
# a pygame MOUSEUP event is detected.
# It then dispatches the event to the buttons for the current screen
#########################################################

def tap_release():
	runScreenEvents("release")


############## tap_drag #################################
# This method is called from the main event loop whenever
# a pygame MOUSEMOTION event is detected.
# It then dispatches the event to the buttons for the current screen
#########################################################

def tap_drag():
	runScreenEvents("drag")


#Done
	



######################## Done Event Driver/Handlers #############################

########################!!!!!!!!!!!!!!!!!!!!!!!!!!!!#############################
########### Everything below this point is obsolete now #########################
########################!!!!!!!!!!!!!!!!!!!!!!!!!!!!#############################


#################################################################################
# getdata
#   Args - area : a list of rects that you want to check against
#        - position : an [x,y] list position indicating the position you want to check
#
#  Loops over all rects in the "area" list, and checks to see if any of them were hit by "position".
#  The condition of each index is then added to a new status list that can be passed to checkdata
# 
#  eeee... this could use some overhauling... 
#
#################################################################################

def getdata(area,position):               #*********GET  DATA BUTTONS**********
    status=[]
    a=0
    while True:
      try:
        status.append(area[a].collidepoint(position[0],position[1]))
        if status[a]:
          if ci.sw_led==1:
            ci.r,ci.g,ci.b= ci.mr,ci.mg,ci.mb
          ci_alarm.led()
      except:
        break
      a=a+1
    return status

#################################################################################
# checkdata
#   Args - screenname : the "screen" name?
#        - press : a list of indecies representing all the button co-ordinates that the mouse was over when pressed
#        - release : a list of indecies representing all of the button co-ordinates that the mouse was over when released
#
#  Compares the two lists of indecies to decide if a button was pressed and released upon by the user.
# If so, then uses the exec call to call the function "screenname" + the index. I.e. press and release on
# cl_area for night, means index 1 is valid, so tries to call "clockbutton1" since "clockbutton" was passed as the screenname
#
# Wow, that's confusing...
##################################################################################

def checkdata(screenname,press,release):  #*********CHECK DATA BUTTONS*********
  if press == release <>0:       
    a = 0
    while True:
      try:
        if press[a] == release[a] == 1:
          bt=a
      except:
        break
      a = a +1
    try:
      exec "%s%d()" % (screenname, bt)
    except:  
      pass
  #return bt


def drag(switch,slide,posx,posy,x,y):
  x0,y0=pospress
  while True:
    event = pygame.event.wait()
    if event.type == MOUSEBUTTONUP:
      tap_release()
      break
    x,y=pygame.mouse.get_pos()
    #      print x
    spostamento=x-x0
    if ci.sw_config[switch]==0:
      if spostamento<0: spostamento=0
      if spostamento>70: spostamento=70
      ci.al_screen.blit(ci.onoff_switch[1+slide],(posx-76+ spostamento,posy+1))
    elif ci.sw_config[switch]==1:
      if spostamento>0: spostamento=0
      if spostamento<-70: spostamento=-70
      ci.al_screen.blit(ci.onoff_switch[1+slide],(posx-6 + spostamento,posy+1))
    ci.al_screen.blit(ci.onoff_switch[0],(posx,posy))
    area = Rect(posx,posy,x,y)
    pygame.display.update(ci.sw_coords[slide])    


#**************************************PRESS DOWN **********************************************
def tap_down2():
  global cl_area, cl_pressdown, cl_release
  global al_area, al_pressdown, al_release
  global ab_area, ab_pressdown, ab_release
  global wi_area, wi_pressdown, wi_release 
  global pospress
  pospress=pygame.mouse.get_pos()
  if ci.fcmode==0:      #sono in CLOCK MODE*****************************
    cl_pressdown=getdata (cl_area,pospress)
  elif ci.fcmode==1:    #sono in ALARM MODE*****************************
    al_pressdown=getdata (al_area,pospress)
    if al_area[4].collidepoint(pospress[0],pospress[1]):            #Alarm SWITCH
      posx, posy ,x ,y = ci.sw_coords[0]
      drag(0, 0, posx, posy, x, y)     
    if al_area[6].collidepoint(pospress[0],pospress[1]):            #MTime SWITCH
      posx, posy ,x ,y = ci.sw_coords[1]
      drag(1, 1, posx,posy,x,y)        
  elif ci.fcmode==2:    #sono in ABOUT MODE*****************************
    pass
  elif ci.fcmode==3:    #sono in WINDOW MODE*****************************
    wi_pressdown=getdata (wi_area,pospress)
    if wi_area[1].collidepoint(pospress[0],pospress[1]):            #Alarm SWITCH
      posx, posy ,x ,y = ci.sw_coords[2]
      drag(0, 0, posx, posy, x, y)          
    if wi_area[2].collidepoint(pospress[0],pospress[1]):            #MTime SWITCH
      posx, posy ,x ,y = ci.sw_coords[3]
      drag(1, 1, posx, posy, x, y)     
  if ci.fcmode==4:      #sono in NIGHT MODE*****************************
    cl_pressdown=getdata (cl_area,pospress)
  return 


#**************************************RELEASE**************************************************
def tap_release2():     
  global cl_area, cl_pressdown, cl_release
  global al_area, al_pressdown, al_release
  global ab_area, ab_pressdown, ab_release
  global pospress,posrelease
  posrelease=pygame.mouse.get_pos()
  if ci.sw_led==1:
    ci.r,ci.g,ci.b=0,0,0
    ci_alarm.led()
  ###bt=0
  if ci.fcmode==0:        #*******************CLOCK MODE********************
    cl_release=getdata (cl_area,posrelease)
    bt=checkdata("clockbutton",cl_pressdown,cl_release)
	
  elif ci.fcmode==1:      #*******************ALARM MODE********************    
    al_release = getdata (al_area,posrelease)      
    if al_pressdown[8] > al_release[8]:
      button8()
    if al_pressdown[4]: 						            #Alarm Switch
      ci.sw_config[0]=slide(ci.sw_config[0])    #
      ci_clock.clock()  
    if al_pressdown[6]:                         #Military time switch
		################################ UPDATED BY ROB #######################
		#change between 12 and 24 hour modes
		ci.sw_config[1]=slide(ci.sw_config[1])    #
		ci_config.preferences["militaryTime"] = ci.sw_config[1]
		
		#Save the updated configuration
		ci_config.savePrefs();  
		################################ DONE UPDATED BY ROB ##################
		ci_clock.clock()  
    
	#Run the event handler associated with this position
    bt=checkdata("button",al_pressdown,al_release)
  elif ci.fcmode==2:      #*******************ABOUT MODE********************
    aboutbutton()
  elif ci.fcmode==3:      #*******************WINDOW MODE*******************
    wi_release=getdata (wi_area,posrelease) 
    if wi_pressdown[1]: 
      ci.sw_config[0]=slide(ci.sw_config[0])
      ci_clock.clock()  
    if wi_pressdown[2]:
      ci.sw_config[1]=slide(ci.sw_config[1])
      ################################ UPDATED BY ROB #######################
      ci_config.preferences["militaryTime"] = ci.sw_config[1]

      #Save the updated configuration
      ci_config.savePrefs(); 
      ################################ DONE UPDATED BY ROB ##################
      ci_clock.clock()      
    bt=checkdata("windobutton",wi_pressdown,wi_release)
  elif ci.fcmode==4:      #*******************NIGHT MODE********************
    cl_release=getdata (cl_area,posrelease)
    bt=checkdata("clockbutton",cl_pressdown,cl_release)
  return
  
  
#******************************CLOCK Buttons actions ********************
################### General Clock Mode Button ###########################
# Slide up to change to Window Mode, slide down to go to Alarm settings
#

def clockbutton0():
	if cl_pressdown and cl_release:
		if pospress[1]-20>posrelease[1]:       #slide up to set the alarm
			ci.fcmode = 1
			ca=ci.alarms[ci.al_set]
			ci.al_edi =[int(ca[0]),int(ca[1]),int(ca[3]),int(ca[4])]
			#print "conversizone:",int(curala[0]),curala[1],curala[3],curala[4]
			ci_clock.clock()

		if pospress[1]+20<posrelease[1]:       #slide down switch fulls/window
			ci.fcmode = 3
			ci_clock.clock()
			ci.pygame.display.toggle_fullscreen()      
			
################### Done General Clock Mode Button ######################


################### Button handler to toggle "Night Mode" ###############
def clockbutton1():                         #NIGHT TIME
  if ci.fcmode == 4:
    #Night mode already, so switch to Regular Mode and redraw
    ci.fcmode = 0
    ci_clock.clock()
	
  elif ci.fcmode == 0:
    #Regular mode, so switch to Night Mode and redraw
    ci.fcmode = 4
    ci_clock.clock()
	
################### DONE Button handler to toggle "Night Mode" ##########

################### Button handler to Quit ###############
def clockbutton2():                         #Asta La vista, ciao, arrivederci
	################################ UPDATED BY ROB #######################
	#uhh no! just dispatch the quit event!
	ci.pygame.event.post(pygame.event.Event(pygame.QUIT))
	
	# ci.event=QUIT  
	#ci.pygame.display.quit 
	#ci.pygame.quit()
	#sys.exit(0)
	################################ DONE UPDATED BY ROB ##################

################### Done Button handler to Quit ###############

  
#****************************** ABOUT Buttons actions ********************
def aboutbutton():
  ci.fcmode=1
  ci_clock.clock()

#****************************** WINDOW Buttons actions ********************
def windobutton0():                 #FULL SCREEN (slide up)
  if cl_pressdown and cl_release:
    if pospress[1]-20>posrelease[1]:    #FULL SCREEN (slide up)
      ci.fcmode=0
      ci_clock.clock()
      ci.pygame.display.toggle_fullscreen()      

def windobutton1():                 #ALLARME ON / OFF
  pass  

def windobutton3():                     #Playsound
  if ci.tablet==1:  ci.hildon.hildon_play_system_sound(ci.path+ci.alarmsound)

def windobutton4():                     #HELP
  if ci.moodc<5:
    ci.moodc=ci.moodc+1
  else:
    ci.moodc=0
  if ci.moodc ==0:
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,  0,     0,  0,  0
  elif ci.moodc ==1:    #Yello
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,125,  0,   250,125,  0
  elif ci.moodc ==2:    #blue
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,250,     0,  0,250
  elif ci.moodc ==3:    #red
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,  0,   250,  0,  0    
  elif ci.moodc ==4:    #porpora
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,125,   250,  0,125    
  elif ci.moodc ==5:    #Green
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,250,  0,     0,250,250    
  if ci.fcmode==1:  
    ci_clock.clock()
  elif ci.fcmode==0:
    ci_clock.clock()
  elif ci.fcmode==3:
    ci_clock.clock()
  elif ci.fcmode==4:
    ci_gfx.drawmood()
  ci_gfx.gfx_refresh() 
  
     
#****************************** ALARM buttons actions **************** 
def button0():                            #H1*********************
  if pospress[1] > posrelease[1] :         #direzione giu incremento (sliding up)
    ci.al_edi[0]=ci.al_edi[0]-1
    if ci.al_edi[0]==-1:
      ci.al_edi[0]=0
    else:
      soundrelease()
  elif  pospress[1]<posrelease[1] :     #direzione su decremento (sliding down)
    ci.al_edi[0]=ci.al_edi[0]+1
    if ci.al_edi[0]==2 and ci.al_edi[1] > 4:
      ci.al_edi[0]=1
    elif ci.al_edi[0]==3  and ci.al_edi[1] < 5:
      ci.al_edi[0]=2
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  
  ci_clock.clock()
def button1():                            #H2*********************
  if pospress[1]>posrelease[1]:           #direzione su decremento
    ci.al_edi[1]=ci.al_edi[1]-1
    if ci.al_edi[1]==-1:
      ci.al_edi[1]=0
    else:
      soundrelease()
  elif pospress[1]<posrelease[1]:         #direzione giu incremento
    ci.al_edi[1]=ci.al_edi[1]+1
    if ci.al_edi[1]==4 and ci.al_edi[0]>1:
      ci.al_edi[1]=3      
    elif ci.al_edi[1]>9:
      ci.al_edi[1]=9
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  ci_clock.clock()
def button2():                            #M1*********************
  if pospress[1]>posrelease[1]:
    ci.al_edi[2]=ci.al_edi[2]-1
    if ci.al_edi[2]==-1:
      ci.al_edi[2]=0
    else:
      soundrelease()
  elif pospress[1]<posrelease[1]:
    ci.al_edi[2]=ci.al_edi[2]+1
    if ci.al_edi[2]>5:
      ci.al_edi[2]=5
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  ci_clock.clock()
def button3():                            #M2
  if pospress[1]>posrelease[1]:
    ci.al_edi[3]=ci.al_edi[3]-1
    if ci.al_edi[3]<0:
      ci.al_edi[3]=0
    else:
      soundrelease()
  elif pospress[1]<posrelease[1]:
    ci.al_edi[3]=ci.al_edi[3]+1
    if ci.al_edi[3]>9:
      ci.al_edi[3]=9
    else:
      soundrelease()
  al = "%d%d:%d%d" %(ci.al_edi[0],ci.al_edi[1],ci.al_edi[2],ci.al_edi[3])
  ci.alarms[ci.bt_aledit] = al
  ci_clock.clock()

def slide(value):
  x0,y0=0,0
  x,y=posrelease
  x0,y0=pospress
  if value==0:
    if x-x0>35:
      value=1
  elif value==1:
    if x-x0<-35:
      value=0
  return value

######################## Alarm On/Off SELECTOR? ######################
def button4():                          #ALLARME ON / OFF...?...
  pass
######################## DONE Alarm On/Off SELECTOR ##################


########################## MOOD Selector ############################
def button5():            #
  if ci.moodc<5:
    ci.moodc=ci.moodc+1
  else:
    ci.moodc=0
  if ci.moodc ==0:
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,  0,     0,  0,  0
  elif ci.moodc ==1:    #Yello
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,125,  0,   250,125,  0
  elif ci.moodc ==2:    #blue
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,  0,250,     0,  0,250
  elif ci.moodc ==3:    #red
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,  0,   250,  0,  0    
  elif ci.moodc ==4:    #porpora
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=250,  0,125,   250,  0,125    
  elif ci.moodc ==5:    #Green
    ci.r,ci.g,ci.b,ci.mr,ci.mg,ci.mb=  0,25