#!/usr/bin/env python2.5
# -*- coding: utf-8 -*-

"""
 *
 *  Copyright (C) 2007 Christoph Würstle
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *
"""

import gobject
import time

import gtk
import hildon
import osso
import sys
import logging

version = "0.4"
settings_file_name = ".eggtimer"
app_name = "eggtimer"

		
def eggtimer():
	global app
	if app == None:
		app = eggtimerclass() 
		app.main() 
	return app
	

class eggtimerclass(hildon.Program):
        """This is an Hello World GTK application"""

	def __init__(self):
		print "0: ",time.clock() 
		
		hildon.Program.__init__(self)
		
		#Set the Glade file
		#<widget class="HildonWindow" id="mainwindow">
		gtk.rc_parse('/usr/share/eggtimer/eggtimer.gtkrc')
		print "1: ",time.clock()
                
		self.window = hildon.Window()
		self.add_window(self.window)

                if (self.window):
			self.window.connect("delete_event", self.delete_event)
			self.window.connect("destroy", self.destroy)
			print "destroy connected"

		self.window.connect("key-press-event", self.on_key_press) 
		self.window.connect("window-state-event", self.on_window_state_change) 
 		self.window_in_fullscreen = False #The window isn't in full screen mode initially.
		
		table = gtk.Table(rows=4, columns=5)
		
		vbox=gtk.VBox(homogeneous=False, spacing=3)
		
		button=gtk.Label(" ")
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		button=gtk.Button("+3")
		button.connect("clicked",self.add_time,3)
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		button=gtk.Button("+5")
		button.connect("clicked",self.add_time,5)
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		button=gtk.Button("+10")
		button.connect("clicked",self.add_time,10)
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		button=gtk.Button("+15")
		button.connect("clicked",self.add_time,15)
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		button=gtk.Button("+20")
		button.connect("clicked",self.add_time,20)
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		button=gtk.Button("+30")
		button.connect("clicked",self.add_time,30)
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		button=gtk.Button("+60")
		button.connect("clicked",self.add_time,60)
		vbox.pack_start(button, expand=False, fill=True, padding=3)
		
		table.attach(vbox, left_attach=0, right_attach=1, top_attach=1, bottom_attach=3, xoptions=gtk.FILL, yoptions=gtk.EXPAND, xpadding=3, ypadding=0)
		
		label=gtk.Label("Hours")
		table.attach(label, left_attach=1, right_attach=2, top_attach=0, bottom_attach=1, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=0)
		
		label=gtk.Label("Minutes")
		table.attach(label,left_attach=2, right_attach=3, top_attach=0, bottom_attach=1, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=0)
		
		label=gtk.Label("Seconds")
		table.attach(label,left_attach=3, right_attach=4, top_attach=0, bottom_attach=1, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=0)
		
		self.minusbutton=gtk.Button("-1 min")
		self.minusbutton.set_name("minusbutton")
		self.minusbutton.connect("clicked",self.on_button_clicked)
		table.attach(self.minusbutton, left_attach=3, right_attach=4, top_attach=3, bottom_attach=4, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=0)
		
		self.plusbutton=gtk.Button("+1 min")
		self.plusbutton.set_name("plusbutton")
		self.plusbutton.connect("clicked",self.on_button_clicked)
		table.attach(self.plusbutton,left_attach=2, right_attach=3, top_attach=3, bottom_attach=4, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=0)
		
		self.clearbutton=gtk.Button("clear")
		self.clearbutton.set_name("clearbutton")
		self.clearbutton.connect("clicked",self.on_button_clicked)
		table.attach(self.clearbutton, left_attach=1, right_attach=2, top_attach=3, bottom_attach=4, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=0)
		
		self.secscale=gtk.VScale(gtk.Adjustment(0,0,60,1,0,0))
		self.secscale.connect("value_changed",self.on_scale_value_changed)
		table.attach(self.secscale, left_attach=3, right_attach=4, top_attach=1, bottom_attach=3, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=10)
		
		self.minscale=gtk.VScale(gtk.Adjustment(0,0,60,1,0,0))
		self.minscale.connect("value_changed",self.on_scale_value_changed)
		table.attach(self.minscale, left_attach=2, right_attach=3, top_attach=1, bottom_attach=3, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=10)
		
		self.hourscale=gtk.VScale(gtk.Adjustment(0,0,24,1,0,0))
		self.hourscale.connect("value_changed",self.on_scale_value_changed)
		table.attach(self.hourscale, left_attach=1, right_attach=2, top_attach=1, bottom_attach=3, xoptions=gtk.FILL, yoptions=gtk.FILL, xpadding=0, ypadding=10)
		
		self.labelTime = gtk.Label()
		table.attach(self.labelTime, left_attach=4, right_attach=5, top_attach=1, bottom_attach=3, xoptions=gtk.EXPAND, yoptions=gtk.EXPAND, xpadding=0, ypadding=0)
		self.labelTime.set_markup('<span size="xx-large" weight="bold">00:00:00</span>')
		self.timer_id = None

		#print "4: ",time.clock()
		
		self.loadPreferences()
		self.timer_id = gobject.timeout_add(1000, self.secelapsed)
		self.osso_c = osso.Context(app_name, version, False)
		
		#print "5: ",time.clock()
		
		#menu = gtk.Menu() 
		#for child in self.wTree.get_widget("menubar1").get_children():
		#	child.reparent(menu) 
		#self.window.set_menu(menu)
		#self.wTree.get_widget("menubar1").destroy()
		
		prefmenu = gtk.Menu()
		
		menu_items = gtk.MenuItem("Set alarmsound")
		prefmenu.append(menu_items)
		menu_items.connect("activate", self.on_alarmsound_activate)
		
		menu_items = gtk.MenuItem("Set font")
		prefmenu.append(menu_items)
		menu_items.connect("activate", self.on_set_font1_activate)
		
		pref_menu = gtk.MenuItem("Preferences")
		pref_menu.show()
		pref_menu.set_submenu(prefmenu)
		
		
		hilfemenu = gtk.Menu()
		menu_items = gtk.MenuItem("About")
		hilfemenu.append(menu_items)
		menu_items.connect("activate", self.on_info1_activate)
		
		hilfe_menu = gtk.MenuItem("Hilfe")
		hilfe_menu.show()
		hilfe_menu.set_submenu(hilfemenu)
		
		quit_menu = gtk.MenuItem("Quit")
		quit_menu.connect("activate", self.on_beenden1_activate)
		quit_menu.show()
		
		
		menu_bar = gtk.MenuBar()
		menu_bar.show()
		menu_bar.append (pref_menu)
		menu_bar.append (hilfe_menu)
		menu_bar.append (quit_menu)
		
		
		menu = gtk.Menu() 
		for child in menu_bar.get_children():
			child.reparent(menu) 
		self.window.set_menu(menu)
		menu_bar.destroy()
		
		
		self.window.add(table)
		self.window.show_all()
		
		print "6: ",time.clock()
			
	def main(self):
		gtk.main()
		
	def destroy(self, widget, data=None):
		gtk.main_quit()
		
	def delete_event(self, widget, event, data=None):
		print "delete event occurred"
		return False
	
	def dlg_delete(self,widget,event,data=None):
		return False

	def on_window_state_change(self, widget, event, *args): 
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN: 
			self.window_in_fullscreen = True 
 		else: 
 			self.window_in_fullscreen = False 

	def on_key_press(self, widget, event, *args):
		#Hildon Fullscreen Modus
		if event.keyval == gtk.keysyms.F6: 
 			# The "Full screen" hardware key has been pressed 
 			if self.window_in_fullscreen: 
 				self.window.unfullscreen () 
 			else: 
 				self.window.fullscreen () 



	def timefinished(self):
		print 'finished'
		#print time.clock(  )
                self.loadPreferences()
		#print time.clock(  )
		
		try:
			if (self.aboutdialog!=None):
				self.aboutdialog.destroy()
		except:
			pass
		
		self.labelTime.set_markup('<span size="xx-large" weight="bold">time over</span>')
  
    		print 'Playing:', self.preferences['filename']
		
		import dbus
		import dbus.glib

		devstat = osso.DeviceState(self.osso_c)
		devstat.display_state_on()
		
		osso_rpc = osso.Rpc(self.osso_c)
		try:
			#osso_rpc.rpc_run("com.nokia.osso_media_server","/com/nokia/osso_media_server","com.nokia.osso_media_server.music", "stop")
			osso_rpc.rpc_run("com.nokia.osso_media_server","/com/nokia/osso_media_server","com.nokia.osso_media_server.music", "play_media",("file://"+(self.preferences['filename']),))
		except:
			print 'rpc_run exception'
		
		
		self.window.present()

        	btns = ( gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE )
        	flags = gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT
        	self._diag = gtk.Dialog( title=( "Finished"),
                                 parent=self.window,
                                 flags=flags, buttons=btns )
		self._diag.connect("delete_event", self.dlg_delete)
		self._diag.set_border_width(2)
		self._diag.set_size_request(200,200)
		self._diag.set_position(gtk.WIN_POS_CENTER)
		label = gtk.Label("Time ran out...")
		self._diag.vbox.add(label)
		self._diag.show_all()
		self._diag.run()
		self._diag.hide()
		#sysnote = osso.SystemNote(self.osso_c)
		#sysnote.system_note_dialog("Time is over.", type = 'notice')

    		print 'Played'
		#os.system('run-standalone.sh dbus-send --dest=com.nokia.osso_media_server --print-reply /com/nokia/osso_media_server com.nokia.osso_media_server.music.stop &')
		try:
			osso_rpc.rpc_run("com.nokia.osso_media_server","/com/nokia/osso_media_server","com.nokia.osso_media_server.music", "stop")
		except:
			print 'rpc_run exception'
		
	
		#self.player.set_state(gst.STATE_NULL)
		
		#self.osso_c.system_note_dialog("Time is over.", type = 'notice')

	def show_about(self, widget):
        	self.aboutdialog = gtk.AboutDialog()
        	self.aboutdialog.set_position(gtk.WIN_POS_CENTER)
        	self.aboutdialog.set_name(app_name)
        	self.aboutdialog.set_version(version)
        	self.aboutdialog.set_copyright("")
		self.aboutdialog.set_website("http://axique.de/n800")
        	comments = "%s is a small egg-timer program\nDistributed under terms and conditions of GNU Public License\nSee http://www.gnu.org/licenses/gpl.txt for details" % app_name
        	self.aboutdialog.set_comments(comments)
        	self.aboutdialog.run()
        	self.aboutdialog.destroy()
	
	def on_info1_activate(self,menuitem):
		self.show_about(menuitem)
				
		
	def on_set_font1_activate(self,menuitem):
		print "fontdialog"
		fontDialog = hildon.FontSelectionDialog(self.window, "Choose a font...")
		fontDialog.set_preview_text ("00:12:34")
		fontDialog.run()
		fontDialog.hide()
		
		self.loadPreferences()

		if fontDialog.get_property("family-set"):
        		self.preferences['family'] = fontDialog.get_property("family")

		if fontDialog.get_property("size-set"):
        		self.preferences['size'] = fontDialog.get_property("size")

		if fontDialog.get_property("color-set"):
			self.preferences['gdk_color'] = fontDialog.get_property("color")
        		#color = "(R:%s, G:%s, B:%s)" % (gdk_color.red, gdk_color.green, gdk_color.blue)

    		if fontDialog.get_property("bold-set"):
        		self.preferences['bold'] = fontDialog.get_property("bold")
		
		if fontDialog.get_property("italic-set"):
        		self.preferences['italic'] = fontDialog.get_property("italic")
			
		self.savePreferences()
		print self.preferences
		self.loadPreferences()

		#if fontDialog.get_property("underline-set"):
        		#underline = fontDialog.get_property("underline")

		#if fontDialog.get_property("strikethrough-set"):
			#strikethrough = fontDialog.get_property("strikethrough")

		#if fontDialog.get_property("position-set"):
        		#position = fontDialog.get_property("position")

	


	def on_alarmsound_activate(self,menuitem):
        	fileChooser = self.create_file_chooser_dlg()
        	fileChooser.set_title("Select sound file")
        	if fileChooser.run() == gtk.RESPONSE_OK:
			fileName = fileChooser.get_filename()
			self.preferences['filename']=fileName
			self.savePreferences()
        	fileChooser.destroy()
 
 	def on_beenden1_activate(self,widget):
		self.destroy(self.window)
 
	def create_file_chooser_dlg(self):
        	dlg = gtk.FileChooserDialog(parent = self.window, action = gtk.FILE_CHOOSER_ACTION_OPEN)
        	dlg.add_button( gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
        	dlg.add_button( gtk.STOCK_OK, gtk.RESPONSE_OK)
        	if self.preferences.has_key('filename'):
			dlg.set_filename(self.preferences['filename'])
		return dlg
		
		
		
	def savePreferences(self):
		import pickle
		import os
		import os.path
		home_dir = os.path.expanduser('~')
		settings = os.path.join(home_dir, settings_file_name) 
		settings_file = file(settings, "w")
		pickle.dump(self.preferences, settings_file)
		
	def loadPreferences(self):
		import pickle
		import os
		import os.path
		self.preferences= {}
		home_dir = os.path.expanduser('~')
		settings = os.path.join(home_dir, settings_file_name) 
		if os.path.exists(settings):
			settings_file = file(settings, "r")
			self.preferences = pickle.load(settings_file)
			
		if (self.preferences.has_key('filename')==False): self.preferences['filename']="/usr/share/eggtimer/ring1.mp3"
		
		self.style=""
		if self.preferences.has_key('family'):
			self.style=self.style+' font_family="'+str(self.preferences['family'])+'" '
			
		if self.preferences.has_key('size'):
			self.style=self.style+' size="'+str(self.preferences['size']*2000)+'" '
			
		if self.preferences.has_key('gdk_color'):
			self.style=self.style+' foreground="'+str(self.preferences['gdk_color'])+'" '
			
		if self.preferences.has_key('bold'):
			if self.preferences['bold']:
				self.style=self.style+' weight="bold" '
			
		if self.preferences.has_key('italic'):
			if self.preferences['italic']:
				self.style=self.style+' style="italic" '
			
		print "Fontattributes (PangoML):"+self.style

		
	def on_scale_value_changed(self,range):
		if (range):
			range.set_value(int(range.get_value()))
			
	def add_time(self, widget=None, time=None):
		if (time==None):
			return
		time=int(time)
		if (int(self.minscale.get_value())+time<59):
			self.minscale.set_value(int(self.minscale.get_value()+time))
		else:
			self.minscale.set_value(int(self.minscale.get_value())+time-60)
			self.hourscale.set_value(int(self.hourscale.get_value()+1))
		
			
	def on_button_clicked(self,button):
		if (button.get_name()=="plusbutton"):
			if (int(self.minscale.get_value())<59):
				self.minscale.set_value(int(self.minscale.get_value()+1))
			else:
				self.minscale.set_value(0)
				self.hourscale.set_value(int(self.hourscale.get_value()+1))
			
		if (button.get_name()=="minusbutton"):
			if (int(self.minscale.get_value())>0):
				self.minscale.set_value(int(self.minscale.get_value()-1))
			elif (int(self.hourscale.get_value())>0):
				self.hourscale.set_value(int(self.hourscale.get_value()-1))
				self.minscale.set_value(59)
		if (button.get_name()=="clearbutton"):
			self.secscale.set_value(0)
			self.minscale.set_value(0)
			self.hourscale.set_value(0)
		
	def secelapsed(self):
		def toStr(timestr):
			tmp=str(timestr)
			if len(tmp)==0:
				tmp="0"+tmp
			if len(tmp)==1:
				tmp="0"+tmp
			return tmp
				
    		#print "hello, world"
		if (self.secscale):
			#print 'hello'
			svalue=int(self.secscale.get_value())
			mvalue=int(self.minscale.get_value())
			hvalue=int(self.hourscale.get_value())
			

			self.labelTime.set_markup('<span '+self.style+'>'+toStr(hvalue)+":"+toStr(mvalue)+":"+toStr(svalue)+"</span>")
			if ((svalue==0)and(mvalue==0)and(hvalue==0)): return True
			svalue-=1
			if (svalue<0):
				svalue=0
				if ((mvalue>0)or(hvalue>0)): svalue=59
				mvalue-=1
				if (mvalue<0):
					mvalue=0
					if (hvalue>0): mvalue=59
					hvalue-=1
					if (hvalue<1):
						hvalue=0
						
			if ((svalue==0)and(mvalue==0)and(hvalue==0)): self.timefinished()
						
			
			self.hourscale.set_value(hvalue)
			self.minscale.set_value(mvalue)	
			self.secscale.set_value(svalue)
		return True # run again in one second
			


if __name__ == "__main__":
	#print dir(eggtimerclasses)
	app = eggtimerclass() 
	app.main() 