from easy import ui
from easy import e_mail

def login(app, button):
    try:
        e_mail.connect(app['user'],app['password'],app['smtp_server'])
        app['status'] = 'Connected!'
        app['email_tab'].active = True
        app['contacts_tab'].active = True
        app['login'].active = False
    except:
        pass

def logout(app, button):
    if e_mail._connected:
        e_mail.disconnect()
    app.emails = ""
    app['user'] = ""
    app['password'] = ""
    app['to'] = ""
    app['attach'] = ""
    app['subject'] = ""
    app['text'] = ""
    app['email_tab'].active = False
    app['login'].active = True
    app['status'] = 'Not Connected'

def open_file(app, button, value):
    app['attach'] = value

def send_email(app, button):
    email = e_mail.create_email()
    email.to = app['to']
    email.subject = app['subject']
    email.message = app['text']
    
    if app['attach']:
        email.add_attachment(app['attach'])
    
    e_mail.send_mail(email)
    app['to'] = ""
    app['attach'] = ""
    app['subject'] = ""
    app['text'] = ""

def to_callback(app, widget, value):
    app.emails = value

login_widgets = (

    ui.Group( id="login_group",
                 border=False,
                 children=( ui.Entry( id="user",
                                         label="User",
                                         value="qualquerumserve",
                                         ),
                            ui.Password( id="password",
                                            label="Password",
                                            persistent=True,
                                            value="todas123",
                                            ),
                            ui.Entry( id="smtp_server",
                                         label="Smtp Server",
                                         value="smtp.gmail.com"
                                         ),
                            ui.HSeparator(),
                            ui.Button( id="login",
                                          label="Login",
                                          callback=login,
                                          ),
                            ui.Button( id="logout",
                                          label="Logout",
                                          callback=logout,
                                          ),
                            ui.Label( id="status",
                                         label="Not Connected",
                                         ),
                            ),
                    ),
        )

email_widgets = (

     ui.Group( id="message_group",
                   border=False,
        
                   children=( ui.Entry( id="to",
                                           label="To",
                                           callback=to_callback
                                           ),
                              
                              ui.Group( id="attach_group",
                                           horizontal=True,
                                           children=( ui.Entry( id="attach",
                                                                   label="Attach",
                                                                   ),
                                                      ui.OpenFileButton( id="open",
                                                                            callback=open_file,
                                                                            ),
                                                        ),
                                     ),
                              ui.Entry( id="subject",
                                           label="Subject",
                                           ),
                              ui.Group( id="s_group",
                                           horizontal=True,
                                           children=( ui.Entry( id="text",
                                                                   label="Message",
                                                                   multiline=True,
                                                                   ),
                                                      ui.Button( id="send_email",
                                                                    label="Send Email",
                                                                    callback=send_email,
                                                                    ),
                                                    ),
                                            ),
                             ),
                    )
     )

app = ui.App(title='Email with contact', 
                center=ui.Tabs( id="tabs",
                                   children=(ui.Tabs.Page( id="login_tab",
                                                              label="Enter",
                                                              active=True,
                                                              children=login_widgets,
                                                              ),
 
                                             ui.Tabs.Page( id="email_tab",
                                                              label="Email",
                                                              active=False,
                                                              children=email_widgets,
                                                              ),
                                            ),
                                    )
                )

app.emails = ""

ui.run()