#
# gps.py 
# Easy API - gpsbt module.
#
# Copyright (C) 2005-2006 INdT - Instituto Nokia de Tecnologia
#
# Contact: Luciano Miguel Wolf <luciano.wolf@indt.org.br>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

""" Gps_bt module is composed  of bluetooth's device manipulation. This module
uses Python-GPSbt, a binding based on libgpsbt, that provides access to GPS
data through osso-gpsd. It depends on a Bluetooth GPS device already paired.
"""
import gpsbt as gps_bt

__all__ = ["calendar", "gps", "gpsdata", "gpsfix", "gpstimings", "isnan",
           "isotime", "os", "satellite", "socket", "start", "stop", "sys", 
           "thread", "time"]

calendar = gps_bt.calendar
gps = gps_bt.gps
gpsdata = gps_bt.gpsdata
gpsfix = gps_bt.gpsfix
gpstimings = gps_bt.gpstimings
isnan = gps_bt.isnan
isotime = gps_bt.isotime
os = gps_bt.os
satellite = gps_bt.satellite
socket = gps_bt.socket
start = gps_bt.start
stop = gps_bt.stop
sys = gps_bt.sys
thread = gps_bt.thread
time = gps_bt.time