from easy import eagle
import os
import osso

class EasyFileManager(object):
    def __init__(self):
        self._current_dir = os.getcwd()
        self._current_file_index = 0
        self._file_list = []
        
        osso_c = osso.Context("easy_file_manager", "0.0.1", False)
        self._mime = osso.Mime(osso_c)
        
    def update_data(self):        
        self._change_folder()
        
    def _update_folder_label(self):
        app["folder_label"] = "Current folder: " + self._current_dir
    
    def _update_file_table(self):
        app["file_table"].clear()
        for row in self._file_list:
            app["file_table"].append(row)
        
        app["file_table"].select(self._current_file_index)
    
    def _change_folder(self):        
        list = [(".", "", 0)]
        if self._current_dir != "/":
            list.append(("..", "", 0))
        for file in os.listdir(self._current_dir):
            if not file.startswith("."):
                if self._current_dir != "/":
                    fullname = "/" + file
                fullname = self._current_dir + fullname
                if os.path.isdir(fullname):
                    list.append((file, "Folder", 0))
                else:
                    list.append((file, os.path.splitext(file)[1] + " File", os.path.getsize(fullname)/1000))
                
        self._file_list = list
        self._current_file_index = 0
        self._update_folder_label()
        self._update_file_table()
        
    def remove(self, app, button):
        filename = self._get_selected_file()
        
        if filename:
            if not os.path.isdir(filename):
                os.remove(filename)
                self.update_data()
        
    def refresh(self, app, button):
        self.update_data()
        
    def open(self, app, button):
        filename = self._get_selected_file()
        
        if filename:
            if os.path.isdir(filename):
                self._current_dir = os.path.realpath(filename)
                self._change_folder()
            else:
                self._mime.open_file("file://" + filename)
    
    def _get_selected_file(self):
        rows = app['file_table'].selected()
        if rows:
            row = rows[0]
            file = self._file_list[row[0]]
            filename = file[0]
            if self._current_dir != "/":
                filename = "/" + filename
            folder = self._current_dir + filename
            return folder
        return None

efm = EasyFileManager()

app = eagle.App( title="Easy File Manager",
         top = eagle.Label(id='folder_label'),
         center = eagle.Table(id='file_table', label=None, 
                   headers=("Name", "Type", "Size (KB)"), types=(str, str, int)),
         bottom = (eagle.Button("open_button", "Open", callback=efm.open), 
                   eagle.Button("remove_button", "Remove", callback=efm.remove), 
                   eagle.Button("refresh_button", "Refresh", callback=efm.refresh))
         )

efm.update_data()

eagle.run()



