from easy import eagle
from easy import e_mail

def login(app, button):
    try:
        e_mail.connect(app['user'],app['password'],app['smtp_server'])
        app['status'] = 'Connected!'
        app['email_tab'].active = True
        app['contacts_tab'].active = True
        app['login'].active = False
    except:
        pass

def logout(app, button):
    if e_mail._connected:
        e_mail.disconnect()
    app.emails = ""
    app['user'] = ""
    app['password'] = ""
    app['to'] = ""
    app['attach'] = ""
    app['subject'] = ""
    app['text'] = ""
    app['email_tab'].active = False
    app['login'].active = True
    app['status'] = 'Not Connected'

def open_file(app, button, value):
    app['attach'] = value

def send_email(app, button):
    email = e_mail.create_email()
    email.to = app['to']
    email.subject = app['subject']
    email.message = app['text']
    
    if app['attach']:
        email.add_attachment(app['attach'])
    
    e_mail.send_mail(email)
    app['to'] = ""
    app['attach'] = ""
    app['subject'] = ""
    app['text'] = ""

def to_callback(app, widget, value):
    app.emails = value

login_widgets = (

    eagle.Group( id="login_group",
                 border=False,
                 children=( eagle.Entry( id="user",
                                         label="User",
                                         value="qualquerumserve",
                                         ),
                            eagle.Password( id="password",
                                            label="Password",
                                            persistent=True,
                                            value="todas123",
                                            ),
                            eagle.Entry( id="smtp_server",
                                         label="Smtp Server",
                                         value="smtp.gmail.com"
                                         ),
                            eagle.HSeparator(),
                            eagle.Button( id="login",
                                          label="Login",
                                          callback=login,
                                          ),
                            eagle.Button( id="logout",
                                          label="Logout",
                                          callback=logout,
                                          ),
                            eagle.Label( id="status",
                                         label="Not Connected",
                                         ),
                            ),
                    ),
        )

email_widgets = (

     eagle.Group( id="message_group",
                   border=False,
        
                   children=( eagle.Entry( id="to",
                                           label="To",
                                           callback=to_callback
                                           ),
                              
                              eagle.Group( id="attach_group",
                                           horizontal=True,
                                           children=( eagle.Entry( id="attach",
                                                                   label="Attach",
                                                                   ),
                                                      eagle.OpenFileButton( id="open",
                                                                            callback=open_file,
                                                                            ),
                                                        ),
                                     ),
                              eagle.Entry( id="subject",
                                           label="Subject",
                                           ),
                              eagle.Group( id="s_group",
                                           horizontal=True,
                                           children=( eagle.Entry( id="text",
                                                                   label="Message",
                                                                   multiline=True,
                                                                   ),
                                                      eagle.Button( id="send_email",
                                                                    label="Send Email",
                                                                    callback=send_email,
                                                                    ),
                                                    ),
                                            ),
                             ),
                    )
     )

app = eagle.App(title='Email with contact', 
                center=eagle.Tabs( id="tabs",
                                   children=(eagle.Tabs.Page( id="login_tab",
                                                              label="Enter",
                                                              active=True,
                                                              children=login_widgets,
                                                              ),
 
                                             eagle.Tabs.Page( id="email_tab",
                                                              label="Email",
                                                              active=False,
                                                              children=email_widgets,
                                                              ),
                                            ),
                                    )
                )

app.emails = ""

eagle.run()